/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.RoomStandaloneSetup;
import org.eclipse.etrice.core.genmodel.SetupGenmodel;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.scoping.IModelLocator;
import org.eclipse.etrice.core.scoping.ModelLocator;
import org.eclipse.etrice.core.scoping.ModelLocatorUriResolver;
import org.eclipse.etrice.core.scoping.StandardModelLocator;
import org.eclipse.etrice.generator.base.DetailCodeTranslator;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.base.ILineOutput;
import org.eclipse.etrice.generator.base.ILineOutputLogger;
import org.eclipse.etrice.generator.base.ITranslationProvider;
import org.eclipse.etrice.generator.base.IncrementalGenerationFileIo;
import org.eclipse.etrice.generator.base.ModelLoader;
import org.eclipse.etrice.generator.base.StdLineOutput;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public abstract class AbstractGenerator {
    public static final String OPTION_LIB = "-lib";
    public static final String OPTION_NOEXIT = "-noexit";
    public static final String OPTION_DOCUMENTATION = "-genDocu";
    public static final String OPTION_SAVE_GEN_MODEL = "-saveGenModel";
    public static final String OPTION_GEN_INCREMENTAL = "-inc";
    public static final String OPTION_GEN_DIR = "-genDir";
    public static final String OPTION_GEN_INFO_DIR = "-genInfoDir";
    public static final String OPTION_GEN_DOC_DIR = "-genDocDir";
    public static final String OPTION_MSC = "-msc_instr";
    public static final String OPTION_VERBOSE_RT = "-gen_as_verbose";
    public static final String OPTION_DEBUG = "-debug";
    public static final int GENERATOR_OK = 0;
    public static final int GENERATOR_ERROR = 1;
    private static boolean terminateOnError = true;
    private static AbstractGenerator instance = null;
    protected static ILineOutput output = new StdLineOutput();
    private static Injector injector;
    private HashMap<DetailCode, String> detailcode2string = new HashMap();
    @Inject
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected ILineOutputLogger logger;
    @Inject
    protected IDiagnostician diagnostician;
    @Inject
    protected JavaIoFileSystemAccess fileAccess;
    @Inject
    protected ModelLocatorUriResolver uriResolver;
    private StandardModelLocator modelLocator = null;
    @Inject
    protected ITranslationProvider translationProvider;
    @Inject
    protected GlobalGeneratorSettings generatorSettings;
    @Inject
    private ModelLoader modelLoader;
    protected IResourceValidator validator;

    public static void setTerminateOnError(boolean terminateOnError) {
        AbstractGenerator.terminateOnError = terminateOnError;
    }

    public static boolean isTerminateOnError() {
        return terminateOnError;
    }

    public static void setOutput(ILineOutput out) {
        if (out != null) {
            output = out;
        }
    }

    public static AbstractGenerator getInstance() {
        return instance;
    }

    protected AbstractGenerator() {
        instance = this;
    }

    protected static int createAndRunGenerator(Module generatorModule, String[] args) {
        injector = Guice.createInjector((Module[])new Module[]{generatorModule});
        AbstractGenerator generator = (AbstractGenerator)injector.getInstance(AbstractGenerator.class);
        generator.logger.setOutput(output);
        if (!generator.parseOptions(args)) {
            return 1;
        }
        return generator.runGenerator();
    }

    protected boolean parseOptions(String[] args) {
        if (args.length == 0) {
            return this.usageError("no arguments!");
        }
        RoomExtensions.setDefaultGenDir();
        RoomExtensions.setDefaultGenInfoDir();
        RoomExtensions.setDefaultGenDocDir();
        IncrementalGenerationFileIo.setGenerateIncremental(false);
        List<String> argList = Arrays.asList(args);
        Iterator<String> it = argList.iterator();
        while (it.hasNext()) {
            if (this.parseOption(it.next(), it)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseOption(String arg, Iterator<String> it) {
        if (arg.equals(OPTION_SAVE_GEN_MODEL)) {
            if (!it.hasNext()) return this.usageError("-saveGenModel needs path");
            this.generatorSettings.setGeneratorModelPath(String.valueOf(it.next()) + "/genmodel.egm");
            return true;
        } else if (arg.equals(OPTION_GEN_DIR)) {
            if (!it.hasNext()) return this.usageError("-genDir needs directory");
            RoomExtensions.setGenDir(it.next());
            return true;
        } else if (arg.equals(OPTION_GEN_INFO_DIR)) {
            if (!it.hasNext()) return this.usageError("-genInfoDir needs directory");
            RoomExtensions.setGenInfoDir(it.next());
            return true;
        } else if (arg.equals(OPTION_GEN_DOC_DIR)) {
            if (!it.hasNext()) return this.usageError("-genDocDir needs directory");
            RoomExtensions.setGenDocDir(it.next());
            return true;
        } else if (arg.equals(OPTION_GEN_INCREMENTAL)) {
            IncrementalGenerationFileIo.setGenerateIncremental(true);
            return true;
        } else if (arg.equals(OPTION_DOCUMENTATION)) {
            this.generatorSettings.setGenerateDocumentation(true);
            return true;
        } else if (arg.equals(OPTION_LIB)) {
            this.generatorSettings.setGenerateAsLibrary(true);
            return true;
        } else if (arg.equals(OPTION_NOEXIT)) {
            AbstractGenerator.setTerminateOnError(false);
            return true;
        } else if (arg.equals(OPTION_MSC)) {
            this.generatorSettings.setGenerateMSCInstrumentation(true);
            return true;
        } else if (arg.equals(OPTION_VERBOSE_RT)) {
            this.generatorSettings.setGenerateWithVerboseOutput(true);
            return true;
        } else if (arg.equals(OPTION_DEBUG)) {
            this.generatorSettings.setDebugMode(true);
            return true;
        } else {
            this.generatorSettings.getInputModelURIs().add(arg);
        }
        return true;
    }

    protected boolean usageError(String text) {
        this.logger.logError(String.valueOf(this.getClass().getName()) + " - aborting: " + text, null);
        this.printUsage();
        return false;
    }

    protected abstract void printUsage();

    protected String getCommonOptions() {
        return " [-saveGenModel <genmodel path>] [-genDocu] [-lib] [-noexit] [-saveGenModel <genmodel path>] [-inc [-genDir <generation directory>] [-genInfoDir <generation info directory>] [-genDocDir <gen documentation directory>] [-debug] [-msc_instr] [-gen_as_verbose]";
    }

    protected String getCommonOptionDescriptions() {
        return "      <list of model file paths>         # model file paths may be specified as\n                                         # e.g. C:\\path\\to\\model\\mymodel.room\n      -genDocu                           # if specified documentation is created\n      -lib                               # if specified all classes are generated and no instances\n      -noexit                            # if specified the JVM is not exited\n      -saveGenModel <genmodel path>      # if specified the generator model will be saved to this location\n      -inc                               # if specified the generation is incremental\n      -genDir <generation directory>     # the directory for generated files\n      -genInfoDir <generation info dir>  # the directory for generated info files\n      -genDocDir <gen documentation dir> # the directory for generated documentation files\n      -debug                             # if specified create debug output\n      -msc_instr                         # generate instrumentation for MSC generation\n      -gen_as_verbose                    # generate instrumentation for verbose console output";
    }

    public static Injector getInjector() {
        return injector;
    }

    protected ResourceSet getResourceSet() {
        return this.modelLoader.getResourceSet();
    }

    protected void setupRoomModel() {
        Injector roomInjector = EMFPlugin.IS_ECLIPSE_RUNNING ? new RoomStandaloneSetup().createInjector() : new RoomStandaloneSetup().createInjectorAndDoEMFRegistration();
        this.validator = (IResourceValidator)roomInjector.getInstance(IResourceValidator.class);
        SetupGenmodel.doSetup();
    }

    protected Root createGeneratorModel(boolean asLibrary, String genModelPath) {
        ArrayList<RoomModel> rml = new ArrayList<RoomModel>();
        for (Resource resource : this.getResourceSet().getResources()) {
            EList contents = resource.getContents();
            if (contents.isEmpty() || !(contents.get(0) instanceof RoomModel)) continue;
            rml.add((RoomModel)contents.get(0));
        }
        if (rml.isEmpty()) {
            this.logger.logError("no ROOM models found", null);
            this.logger.logError("-- terminating", null);
            return null;
        }
        this.logger.logInfo("-- creating generator model");
        GeneratorModelBuilder gmb = new GeneratorModelBuilder((ILogger)this.logger, this.diagnostician);
        Root gmRoot = gmb.createGeneratorModel(rml, asLibrary);
        if (this.diagnostician.isFailed()) {
            this.logger.logError("validation failed during build of generator model", null);
            this.logger.logError("-- terminating", null);
            return null;
        }
        this.translateDetailCodes(gmRoot);
        URI genModelURI = genModelPath != null ? URI.createFileURI((String)genModelPath) : URI.createFileURI((String)"tmp.rim");
        Resource genResource = this.getResourceSet().createResource(genModelURI);
        genResource.getContents().add((Object)gmRoot);
        if (genModelPath != null) {
            try {
                this.logger.logInfo("saving genmodel to " + genModelPath);
                genResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                this.logger.logError(e.getMessage(), null);
                this.logger.logError("-- terminating", null);
                return null;
            }
        }
        return gmRoot;
    }

    protected void activateModelLocator() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.modelLocator = new StandardModelLocator();
            ModelLocator.getInstance().addLocator((IModelLocator)this.modelLocator);
        }
    }

    protected boolean validateModels() {
        this.logger.logInfo("-- validating models");
        int errors = 0;
        int warnings = 0;
        ArrayList resources = new ArrayList(this.getResourceSet().getResources());
        for (Resource resource : resources) {
            List list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            if (list.isEmpty()) continue;
            for (Issue issue : list) {
                if (issue.getSeverity() == Severity.ERROR) {
                    ++errors;
                    this.logger.logError(issue.toString(), null);
                    continue;
                }
                ++warnings;
                this.logger.logInfo(issue.toString());
            }
        }
        this.logger.logInfo("validation finished with " + errors + " errors and " + warnings + " warnings");
        if (errors > 0) {
            this.logger.logError("-- terminating", null);
            return false;
        }
        return true;
    }

    protected boolean loadModels(List<String> uriList) {
        this.logger.logInfo("-- reading models");
        return this.modelLoader.loadModels(uriList, this.logger);
    }

    protected void deactivateModelLocator() {
        if (this.modelLocator != null) {
            ModelLocator.getInstance().removeLocator((IModelLocator)this.modelLocator);
        }
    }

    protected void translateDetailCodes(Root gmRoot) {
        DetailCodeTranslator dct;
        for (ExpandedActorClass xpac : gmRoot.getXpActorClasses()) {
            dct = new DetailCodeTranslator(xpac.getActorClass(), this.translationProvider);
            this.translateDetailCodesOfTree((EObject)xpac.getActorClass(), dct);
            this.translateDetailCodesOfTree((EObject)xpac.getStateMachine(), dct);
        }
        for (DataClass dc : gmRoot.getUsedDataClasses()) {
            dct = new DetailCodeTranslator(dc, this.translationProvider);
            this.translateDetailCodesOfTree((EObject)dc, dct);
        }
        for (ProtocolClass pc : gmRoot.getUsedProtocolClasses()) {
            if (pc.getConjugated() != null) {
                dct = new DetailCodeTranslator(pc.getConjugated(), this.translationProvider);
                this.translateDetailCodesOfTree((EObject)pc.getConjugated(), dct);
            }
            if (pc.getRegular() != null) {
                dct = new DetailCodeTranslator(pc.getRegular(), this.translationProvider);
                this.translateDetailCodesOfTree((EObject)pc.getRegular(), dct);
            }
            dct = new DetailCodeTranslator(pc, this.translationProvider);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode1(), dct);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode2(), dct);
            this.translateDetailCodesOfTree((EObject)pc.getUserCode3(), dct);
        }
    }

    protected void translateDetailCodesOfTree(EObject container, DetailCodeTranslator dct) {
        if (container == null) {
            return;
        }
        if (container instanceof DetailCode) {
            DetailCode dc = (DetailCode)container;
            this.detailcode2string.put(dc, dct.translateDetailCode(dc));
            return;
        }
        TreeIterator it = container.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof DetailCode)) continue;
            DetailCode dc = (DetailCode)obj;
            this.detailcode2string.put(dc, dct.translateDetailCode(dc));
        }
    }

    public String getTranslatedCode(DetailCode dc) {
        String code = this.detailcode2string.get(dc);
        if (code == null) {
            return "";
        }
        return code;
    }

    protected abstract int runGenerator();

    public GlobalGeneratorSettings getGeneratorSettings() {
        return this.generatorSettings;
    }
}

