/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.base.FileSystemHelpers;

public class DependencyManager {
    private HashMap<String, String> refmodel2relpath = new HashMap();

    public void computeProjectDependencies(List<RoomModel> models, URI main) {
        this.computeDependencies(models, main, ".project");
    }

    public void computeDependencies(List<RoomModel> models, URI main, String projectMarker) {
        for (RoomModel model : models) {
            URI uri = FileSystemHelpers.getMarkerFileURI((EObject)model, projectMarker);
            if (uri == null || uri.equals(main)) continue;
            String relativePath = FileSystemHelpers.getRelativePath((URI)main, (URI)uri, (boolean)true);
            if (relativePath != null) {
                this.refmodel2relpath.put(model.getName(), relativePath);
                continue;
            }
            this.refmodel2relpath.put(model.getName(), uri.toFileString());
        }
    }

    public Map<String, String> getReferencedModelToRelPath() {
        return this.refmodel2relpath;
    }

    public Set<String> getReferencedModels() {
        return this.refmodel2relpath.keySet();
    }

    public Collection<String> getReferencedModelRelativePaths() {
        return this.refmodel2relpath.values();
    }

    public String getRelativePath(String refmodel) {
        return this.refmodel2relpath.get(refmodel);
    }
}

