/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.scoping.ModelLocatorUriResolver;
import org.eclipse.etrice.generator.base.NullLogger;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.xml.sax.SAXException;

public class ModelLoader {
    protected ILogger logger;
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected ModelLocatorUriResolver uriResolver;
    private ResourceSet resourceSet;
    private HashSet<URI> modelURIs = new HashSet();
    private HashSet<URI> loadedModelURIs = new HashSet();

    public boolean loadModels(List<String> uriList) {
        return this.loadModels(uriList, null);
    }

    public boolean loadModels(List<String> uriList, ILogger logger) {
        if (logger == null) {
            logger = new NullLogger();
        }
        this.logger = logger;
        this.resourceSet = (ResourceSet)this.resourceSetProvider.get();
        if (this.resourceSet instanceof XtextResourceSet) {
            ((XtextResourceSet)this.resourceSet).setClasspathURIContext((Object)this.getClass().getClassLoader());
        }
        this.modelURIs.clear();
        this.loadedModelURIs.clear();
        for (String uri : uriList) {
            this.addResourceURI(this.uriResolver.resolve(uri, null));
        }
        boolean ok = true;
        while (!this.modelURIs.isEmpty()) {
            URI uri = this.modelURIs.iterator().next();
            try {
                if (this.loadModel(uri)) {
                    Resource resource = (Resource)this.resourceSet.getResources().get(this.resourceSet.getResources().size() - 1);
                    for (EObject root : resource.getContents()) {
                        TreeIterator it = root.eAllContents();
                        while (it.hasNext()) {
                            EObject obj = (EObject)it.next();
                            String importUri = this.uriResolver.resolve(obj);
                            if (importUri == null) continue;
                            this.addResourceURI(importUri);
                        }
                    }
                }
            }
            catch (Exception e) {
                ok = false;
                if (e instanceof FileNotFoundException) {
                    logger.logError("couldn't load '" + uri + "' (file not found)", null);
                }
                if (e instanceof SAXException) {
                    logger.logError("couldn't load '" + uri + "' (maybe unknown or wrong file extension, eTrice file extensions have to be lower case)", null);
                }
                logger.logError(e.getMessage(), null);
            }
            this.modelURIs.remove(uri);
        }
        ArrayList resources = new ArrayList(this.resourceSet.getResources());
        for (Resource res : resources) {
            EcoreUtil2.resolveAll((Resource)res, (CancelIndicator)CancelIndicator.NullImpl);
        }
        return ok;
    }

    private boolean loadModel(URI uri) throws RuntimeException, IOException {
        if (this.loadedModelURIs.contains(uri)) {
            return true;
        }
        if (this.resourceSet.getResource(uri, false) != null) {
            return false;
        }
        this.logger.logInfo("loading model        " + uri);
        this.resourceSet.getResource(uri, true);
        this.loadedModelURIs.add(uri);
        return true;
    }

    private boolean addResourceURI(String uri) {
        URI can = null;
        can = uri.startsWith("platform:/") || uri.startsWith("classpath:/") || uri.startsWith("file:/") ? URI.createURI((String)uri) : URI.createFileURI((String)uri);
        if (this.loadedModelURIs.contains(can)) {
            return false;
        }
        boolean added = this.modelURIs.add(can);
        if (added) {
            if (this.loadedModelURIs.isEmpty()) {
                this.logger.logInfo("added model          " + uri);
            } else {
                this.logger.logInfo("added imported model " + uri);
            }
        }
        return added;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

