/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.Extension;

public class GenericProtocolClassGenerator {
    @Inject
    @Extension
    protected ILanguageExtension _iLanguageExtension;
    @Inject
    @Extension
    protected RoomExtensions _roomExtensions;

    public String genMessageIDs(ProtocolClass pc) {
        int offset = 0;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        String _name = pc.getName();
        String _memberInDeclaration = this._iLanguageExtension.memberInDeclaration(_name, "MSG_MIN");
        String _string = Integer.valueOf(offset).toString();
        Pair _pair = Tuples.pair((Object)_memberInDeclaration, (Object)_string);
        list.add(_pair);
        List _allOutgoingMessages = RoomHelpers.getAllOutgoingMessages((ProtocolClass)pc);
        for (Message msg : _allOutgoingMessages) {
            String _name_1 = pc.getName();
            String _name_2 = msg.getName();
            String _plus = "OUT_" + _name_2;
            String _memberInDeclaration_1 = this._iLanguageExtension.memberInDeclaration(_name_1, _plus);
            String _string_1 = Integer.valueOf(++offset).toString();
            Pair _pair_1 = Tuples.pair((Object)_memberInDeclaration_1, (Object)_string_1);
            list.add(_pair_1);
        }
        List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)pc);
        for (Message msg_1 : _allIncomingMessages) {
            String _name_1 = pc.getName();
            String _name_2 = msg_1.getName();
            String _plus = "IN_" + _name_2;
            String _memberInDeclaration_1 = this._iLanguageExtension.memberInDeclaration(_name_1, _plus);
            String _string_1 = Integer.valueOf(++offset).toString();
            Pair _pair_1 = Tuples.pair((Object)_memberInDeclaration_1, (Object)_string_1);
            list.add((Pair<String, String>)_pair_1);
        }
        String _name_1 = pc.getName();
        String _memberInDeclaration_1 = this._iLanguageExtension.memberInDeclaration(_name_1, "MSG_MAX");
        String _string_1 = Integer.valueOf(++offset).toString();
        Pair _pair_1 = Tuples.pair((Object)_memberInDeclaration_1, (Object)_string_1);
        list.add(_pair_1);
        String _name_2 = pc.getName();
        String _memberInDeclaration_2 = this._iLanguageExtension.memberInDeclaration(_name_2, "msg_ids");
        return this._iLanguageExtension.genEnumeration(_memberInDeclaration_2, list);
    }

    public String getMessageID(MessageFromIf mif) {
        Message _message = mif.getMessage();
        InterfaceItem _from = mif.getFrom();
        return this.getMessageID(_message, _from);
    }

    public String getMessageID(Message msg, InterfaceItem item) {
        if (item instanceof Port) {
            Port p = (Port)item;
            String _xifexpression = null;
            boolean _isConjugated = p.isConjugated();
            _xifexpression = _isConjugated ? "OUT_" : "IN_";
            String direction = _xifexpression;
            GeneralProtocolClass _protocol = p.getProtocol();
            String _name = _protocol.getName();
            String _name_1 = msg.getName();
            String _plus = String.valueOf(direction) + _name_1;
            return this._iLanguageExtension.memberInUse(_name, _plus);
        }
        if (item instanceof SAP) {
            SAP sap = (SAP)item;
            ProtocolClass _protocol_1 = sap.getProtocol();
            String _name_2 = _protocol_1.getName();
            String _name_3 = msg.getName();
            String _plus_1 = "OUT_" + _name_3;
            return this._iLanguageExtension.memberInUse(_name_2, _plus_1);
        }
        if (item instanceof SPP) {
            SPP spp = (SPP)item;
            ProtocolClass _protocol_2 = spp.getProtocol();
            String _name_4 = _protocol_2.getName();
            String _name_5 = msg.getName();
            String _plus_2 = "IN_" + _name_5;
            return this._iLanguageExtension.memberInUse(_name_4, _plus_2);
        }
        return "unknown interface item";
    }
}

