/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class PrepareFileSystem {
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private ILogger logger;

    public void prepareCodeTargetPaths(Resource resource) {
        HashSet<String> pathes = new HashSet<String>();
        EList _contents = resource.getContents();
        for (EObject e : _contents) {
            if (!(e instanceof Root)) continue;
            EList _usedRoomModels = ((Root)e).getUsedRoomModels();
            for (RoomModel mdl : _usedRoomModels) {
                boolean _isEmpty;
                boolean _not;
                boolean _notEquals;
                String tgtpath = this._roomExtensions.getGenerationTargetPath((EObject)mdl);
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal((Object)tgtpath, null);
                _and = !_notEquals ? false : (_not = !(_isEmpty = tgtpath.isEmpty()));
                if (!_and) continue;
                pathes.add(tgtpath);
            }
        }
        this.prepare(pathes);
    }

    public void prepareDocTargetPaths(Resource resource) {
        HashSet<String> pathes = new HashSet<String>();
        EList _contents = resource.getContents();
        for (EObject e : _contents) {
            if (!(e instanceof Root)) continue;
            EList _usedRoomModels = ((Root)e).getUsedRoomModels();
            for (RoomModel mdl : _usedRoomModels) {
                boolean _isEmpty;
                boolean _not;
                boolean _notEquals;
                String tgtpath = this._roomExtensions.getDocGenerationTargetPath((EObject)mdl);
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal((Object)tgtpath, null);
                _and = !_notEquals ? false : (_not = !(_isEmpty = tgtpath.isEmpty()));
                if (!_and) continue;
                pathes.add(tgtpath);
            }
        }
        this.prepare(pathes);
    }

    public void prepare(Collection<String> pathes) {
        for (String path : pathes) {
            this.logger.logInfo("clearing " + path);
            File f = new File(path);
            this.eraseContents(f);
            this.fileAccess.setOutputPath(path);
            CharSequence _readmeText = this.readmeText();
            this.fileAccess.generateFile("readme.txt", _readmeText);
        }
    }

    private void eraseContents(File f) {
        boolean _isDirectory = f.isDirectory();
        if (_isDirectory) {
            File[] children;
            File[] fileArray = children = f.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _not;
                File child = fileArray[n2];
                boolean _and = false;
                boolean _isDirectory_1 = child.isDirectory();
                if (!_isDirectory_1) {
                    _and = false;
                } else {
                    boolean _equals;
                    String _name = child.getName();
                    _and = _equals = _name.equals("images");
                }
                boolean bl = _not = !_and;
                if (_not) {
                    this.eraseContents(child);
                    child.delete();
                }
                ++n2;
            }
        }
    }

    private CharSequence readmeText() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"This directory is an eTrice code generation target.");
        _builder.newLine();
        _builder.append((Object)"It will be erased every time the generator is executed.");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"DO NOT PLACE OTHER FILES HERE!");
        _builder.newLine();
        return _builder;
    }
}

