/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ProcedureHelpers {
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private ILogger logger;

    public CharSequence userCode(DataClass dc, int id) {
        CharSequence _switchResult = null;
        switch (id) {
            case 1: {
                String _deepUserCode1 = RoomHelpers.getDeepUserCode1((DataClass)dc);
                _switchResult = this.userCode(_deepUserCode1);
                break;
            }
            case 2: {
                String _deepUserCode2 = RoomHelpers.getDeepUserCode2((DataClass)dc);
                _switchResult = this.userCode(_deepUserCode2);
                break;
            }
            case 3: {
                String _deepUserCode3 = RoomHelpers.getDeepUserCode3((DataClass)dc);
                _switchResult = this.userCode(_deepUserCode3);
            }
        }
        return _switchResult;
    }

    public CharSequence userCode(ProtocolClass pc, int id) {
        CharSequence _switchResult = null;
        switch (id) {
            case 1: {
                String _deepUserCode1 = RoomHelpers.getDeepUserCode1((ProtocolClass)pc);
                _switchResult = this.userCode(_deepUserCode1);
                break;
            }
            case 2: {
                String _deepUserCode2 = RoomHelpers.getDeepUserCode2((ProtocolClass)pc);
                _switchResult = this.userCode(_deepUserCode2);
                break;
            }
            case 3: {
                String _deepUserCode3 = RoomHelpers.getDeepUserCode3((ProtocolClass)pc);
                _switchResult = this.userCode(_deepUserCode3);
            }
        }
        return _switchResult;
    }

    public CharSequence userCode(ActorContainerClass ac, int id, boolean includeInherited) {
        CharSequence _xifexpression = null;
        if (includeInherited) {
            CharSequence _switchResult = null;
            switch (id) {
                case 1: {
                    String _deepUserCode1 = RoomHelpers.getDeepUserCode1((ActorContainerClass)ac);
                    _switchResult = this.userCode(_deepUserCode1);
                    break;
                }
                case 2: {
                    String _deepUserCode2 = RoomHelpers.getDeepUserCode2((ActorContainerClass)ac);
                    _switchResult = this.userCode(_deepUserCode2);
                    break;
                }
                case 3: {
                    String _deepUserCode3 = RoomHelpers.getDeepUserCode3((ActorContainerClass)ac);
                    _switchResult = this.userCode(_deepUserCode3);
                }
            }
            _xifexpression = _switchResult;
        } else {
            CharSequence _switchResult_1 = null;
            switch (id) {
                case 1: {
                    DetailCode _userCode1 = ac.getUserCode1();
                    _switchResult_1 = this.userCode(_userCode1);
                    break;
                }
                case 2: {
                    DetailCode _userCode2 = ac.getUserCode2();
                    _switchResult_1 = this.userCode(_userCode2);
                    break;
                }
                case 3: {
                    DetailCode _userCode3 = ac.getUserCode3();
                    _switchResult_1 = this.userCode(_userCode3);
                }
            }
            _xifexpression = _switchResult_1;
        }
        return _xifexpression;
    }

    public CharSequence userCode(DetailCode dc) {
        String _detailCode = RoomHelpers.getDetailCode((DetailCode)dc);
        return this.userCode(_detailCode);
    }

    private CharSequence userCode(String code) {
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)code, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = code.isEmpty()));
        if (_and) {
            _builder.append((Object)"/*--------------------- begin user code ---------------------*/");
            _builder.newLine();
            _builder.append((Object)code, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"/*--------------------- end user code ---------------------*/");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence attributes(List<Attribute> EnumTest) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*--------------------- attributes ---------------------*/");
        _builder.newLine();
        for (Attribute attribute : EnumTest) {
            CharSequence _attributeDeclaration = this.attributeDeclaration(attribute);
            _builder.append((Object)_attributeDeclaration, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeDeclaration(Attribute attribute) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        int _size = attribute.getSize();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            RefableType _type = attribute.getType();
            DataType _type_1 = _type.getType();
            String _typeName = this._typeHelpers.typeName(_type_1);
            _builder.append((Object)_typeName, "");
            RefableType _type_2 = attribute.getType();
            boolean _isRef = _type_2.isRef();
            if (_isRef) {
                String _pointerLiteral = this.languageExt.pointerLiteral();
                _builder.append((Object)_pointerLiteral, "");
            }
            _builder.append((Object)" ");
            String _name = attribute.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        } else {
            RefableType _type_3 = attribute.getType();
            DataType _type_4 = _type_3.getType();
            String _typeName_1 = this._typeHelpers.typeName(_type_4);
            int _size_1 = attribute.getSize();
            String _name_1 = attribute.getName();
            RefableType _type_5 = attribute.getType();
            boolean _isRef_1 = _type_5.isRef();
            String _arrayDeclaration = this.languageExt.arrayDeclaration(_typeName_1, _size_1, _name_1, _isRef_1);
            _builder.append((Object)_arrayDeclaration, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String arrayInitializer(Attribute att) {
        boolean _lessThan;
        boolean _notEquals;
        String _xifexpression = null;
        String _defaultValueLiteral = att.getDefaultValueLiteral();
        boolean bl = _notEquals = !Objects.equal((Object)_defaultValueLiteral, null);
        if (_notEquals) {
            _xifexpression = att.getDefaultValueLiteral();
        } else {
            RefableType _type = att.getType();
            DataType _type_1 = _type.getType();
            _xifexpression = this.languageExt.defaultValue(_type_1);
        }
        String dflt = _xifexpression;
        boolean _startsWith = dflt.startsWith("{");
        if (_startsWith) {
            int _size_1;
            boolean _notEquals_1;
            String[] _split = dflt.split(",");
            int _size = ((List)Conversions.doWrapArray((Object)_split)).size();
            boolean bl2 = _notEquals_1 = _size != (_size_1 = att.getSize());
            if (_notEquals_1) {
                String _name = att.getName();
                String _plus = "WARNING: array size determined by initializer differs from attribute size (" + _name;
                String _plus_1 = String.valueOf(_plus) + "[";
                int _size_2 = att.getSize();
                String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_size_2);
                String _plus_3 = String.valueOf(_plus_2) + "] <-> ";
                String _plus_4 = String.valueOf(_plus_3) + dflt;
                String _plus_5 = String.valueOf(_plus_4) + ")";
                this.logger.logInfo(_plus_5);
            }
            return dflt;
        }
        String result = "{";
        int i = 0;
        int _size_3 = att.getSize();
        boolean _while = _lessThan = i < _size_3;
        while (_while) {
            boolean _lessThan_1;
            result = String.valueOf(result) + dflt;
            int _size_4 = att.getSize();
            boolean bl3 = _lessThan_1 = ++i < _size_4;
            if (_lessThan_1) {
                result = String.valueOf(result) + ", ";
            }
            _while = _lessThan_1 = i < (_size_4 = att.getSize());
        }
        return String.valueOf(result) + "}";
    }

    public CharSequence attributeSettersGettersDeclaration(List<Attribute> EnumTest, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* --------------------- attribute setters and getters */");
        _builder.newLine();
        for (Attribute attribute : EnumTest) {
            CharSequence _setterHeader = this.setterHeader(attribute, classname);
            _builder.append((Object)_setterHeader, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            CharSequence _terHeader = this.getterHeader(attribute, classname);
            _builder.append((Object)_terHeader, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeSettersGettersImplementation(List<Attribute> EnumTest, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* --------------------- attribute setters and getters */");
        _builder.newLine();
        for (Attribute attribute : EnumTest) {
            CharSequence _setterHeader = this.setterHeader(attribute, classname);
            _builder.append((Object)_setterHeader, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t ");
            String _memberAccess = this.languageExt.memberAccess();
            _builder.append((Object)_memberAccess, "\t ");
            String _name = attribute.getName();
            _builder.append((Object)_name, "\t ");
            _builder.append((Object)" = ");
            String _name_1 = attribute.getName();
            _builder.append((Object)_name_1, "\t ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            CharSequence _terHeader = this.getterHeader(attribute, classname);
            _builder.append((Object)_terHeader, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _memberAccess_1 = this.languageExt.memberAccess();
            _builder.append((Object)_memberAccess_1, "\t");
            String _name_2 = attribute.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence setterHeader(Attribute attribute, String classname) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        _builder.append((Object)"void set");
        String _name = attribute.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" (");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append((Object)_selfPointer, "");
        RefableType _type = attribute.getType();
        DataType _type_1 = _type.getType();
        String _typeName = this._typeHelpers.typeName(_type_1);
        _builder.append((Object)_typeName, "");
        int _size = attribute.getSize();
        boolean bl = _notEquals = _size != 0;
        if (_notEquals) {
            _builder.append((Object)"[]");
        }
        _builder.append((Object)" ");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)")");
        return _builder;
    }

    private CharSequence getterHeader(Attribute attribute, String classname) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        RefableType _type = attribute.getType();
        DataType _type_1 = _type.getType();
        String _typeName = this._typeHelpers.typeName(_type_1);
        _builder.append((Object)_typeName, "");
        int _size = attribute.getSize();
        boolean bl = _notEquals = _size != 0;
        if (_notEquals) {
            _builder.append((Object)"[]");
        }
        _builder.append((Object)" get");
        String _name = attribute.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" (");
        String _selfPointer = this.languageExt.selfPointer(classname, false);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence argList(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : attributes) {
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            RefableType _type = a.getType();
            DataType _type_1 = _type.getType();
            String _typeName = this._typeHelpers.typeName(_type_1);
            _builder.append((Object)_typeName, "");
            int _size = a.getSize();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append((Object)"[]");
            }
            _builder.append((Object)" ");
            String _name = a.getName();
            _builder.append((Object)_name, "");
        }
        return _builder;
    }

    public CharSequence invokeGetters(Iterable<Attribute> path, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : path) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)".", "");
            }
            String _name = a.getName();
            CharSequence _invokeGetter = this.invokeGetter(_name, classname);
            _builder.append((Object)_invokeGetter, "");
        }
        return _builder;
    }

    public CharSequence getterImplementation(String typeName, String name, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        _builder.append((Object)typeName, "");
        _builder.append((Object)" get");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" (");
        String _selfPointer = this.languageExt.selfPointer(classname, false);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)"){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        String _memberAccess = this.languageExt.memberAccess();
        _builder.append((Object)_memberAccess, "\t");
        _builder.append((Object)name, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence invokeGetter(String name, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence invokeSetter(String name, String classname, String value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _firstUpper = StringExtensions.toFirstUpper((String)name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _selfPointer = this.languageExt.selfPointer(classname, true);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)value, "");
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence operationsDeclaration(List<? extends Operation> operations, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*--------------------- operations ---------------------*/");
        _builder.newLine();
        for (Operation operation : operations) {
            boolean _not;
            boolean _isConstructor;
            boolean _and = false;
            boolean _usesInheritance = this.languageExt.usesInheritance();
            _and = !_usesInheritance ? false : (_isConstructor = RoomHelpers.isConstructor((Operation)operation));
            boolean bl = _not = !_and;
            if (!_not) continue;
            CharSequence _operationSignature = this.operationSignature(operation, classname);
            _builder.append((Object)_operationSignature, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence operationsImplementation(List<? extends Operation> operations, String classname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*--------------------- operations ---------------------*/");
        _builder.newLine();
        for (Operation operation : operations) {
            boolean _not;
            boolean _isConstructor;
            boolean _and = false;
            boolean _usesInheritance = this.languageExt.usesInheritance();
            _and = !_usesInheritance ? false : (_isConstructor = RoomHelpers.isConstructor((Operation)operation));
            boolean bl = _not = !_and;
            if (!_not) continue;
            CharSequence _operationSignature = this.operationSignature(operation, classname);
            _builder.append((Object)_operationSignature, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            AbstractGenerator _instance = AbstractGenerator.getInstance();
            DetailCode _detailCode = operation.getDetailCode();
            String _translatedCode = _instance.getTranslatedCode(_detailCode);
            _builder.append((Object)_translatedCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence operationsImplementation(ActorClass ac) {
        EList _operations = ac.getOperations();
        String _name = ac.getName();
        return this.operationsImplementation((List<? extends Operation>)_operations, _name);
    }

    public String destructorCall(String classname) {
        String _destructorName = this.languageExt.destructorName(classname);
        return String.valueOf(_destructorName) + "()";
    }

    private CharSequence operationSignature(Operation operation, String classname) {
        CharSequence _xifexpression = null;
        boolean _isConstructor = RoomHelpers.isConstructor((Operation)operation);
        if (_isConstructor) {
            String _constructorName = this.languageExt.constructorName(classname);
            String _constructorReturnType = this.languageExt.constructorReturnType();
            _xifexpression = this.classOperationSignature(classname, _constructorName, "", _constructorReturnType);
        } else {
            CharSequence _xifexpression_1 = null;
            boolean _isDestructor = RoomHelpers.isDestructor((Operation)operation);
            if (_isDestructor) {
                String _destructorName = this.languageExt.destructorName(classname);
                String _destructorReturnType = this.languageExt.destructorReturnType();
                _xifexpression_1 = this.classOperationSignature(classname, _destructorName, "", _destructorReturnType);
            } else {
                String _name = operation.getName();
                EList _arguments = operation.getArguments();
                CharSequence _BuildArgumentList = this.BuildArgumentList((EList<VarDecl>)_arguments);
                String _string = _BuildArgumentList.toString();
                RefableType _returnType = operation.getReturnType();
                String _dataTypeToString = this.dataTypeToString(_returnType);
                _xifexpression_1 = this.classOperationSignature(classname, _name, _string, _dataTypeToString);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String dataTypeToString(RefableType type) {
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)type, null);
        if (_equals) {
            _xifexpression = "void";
        } else {
            String _xifexpression_1 = null;
            boolean _isRef = type.isRef();
            if (_isRef) {
                DataType _type = type.getType();
                String _typeName = this._typeHelpers.typeName(_type);
                String _pointerLiteral = this.languageExt.pointerLiteral();
                _xifexpression_1 = String.valueOf(_typeName) + _pointerLiteral;
            } else {
                DataType _type_1 = type.getType();
                _xifexpression_1 = this._typeHelpers.typeName(_type_1);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private CharSequence BuildArgumentList(EList<VarDecl> arguments) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDecl argument : arguments) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            RefableType _refType = argument.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            RefableType _refType_1 = argument.getRefType();
            boolean _isRef = _refType_1.isRef();
            if (_isRef) {
                String _pointerLiteral = this.languageExt.pointerLiteral();
                _builder.append((Object)_pointerLiteral, "");
            }
            _builder.append((Object)" ");
            String _name = argument.getName();
            _builder.append((Object)_name, "");
        }
        return _builder;
    }

    private CharSequence classOperationSignature(String classname, String operationname, String argumentList, String returnType) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessLevelPublic = this.languageExt.accessLevelPublic();
        _builder.append((Object)_accessLevelPublic, "");
        _builder.append((Object)returnType, "");
        _builder.append((Object)" ");
        String _memberInDeclaration = this.languageExt.memberInDeclaration(classname, operationname);
        _builder.append((Object)_memberInDeclaration, "");
        _builder.append((Object)"(");
        boolean _isEmpty = argumentList.isEmpty();
        boolean _not = !_isEmpty;
        String _selfPointer = this.languageExt.selfPointer(classname, _not);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)argumentList, "");
        _builder.append((Object)")");
        return _builder;
    }
}

