/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MemberSelectionDialog
extends FormDialog {
    private ActorClass ac;
    private TableViewer viewer;
    @Inject
    ILabelProvider labelProvider;
    private Object selected;

    public MemberSelectionDialog(Shell shell, ActorClass ac) {
        super(shell);
        this.ac = ac;
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        Form form = mform.getForm().getForm();
        form.setText("Select an Attribute or Operation");
        form.setImage(Activator.getImage("icons/Behavior.gif"));
        toolkit.decorateFormHeading(form);
        Composite body = form.getBody();
        this.viewer = new TableViewer(body, 67840);
        TableColumn col0 = new TableColumn(this.viewer.getTable(), 0);
        col0.setText("type");
        TableColumn col1 = new TableColumn(this.viewer.getTable(), 0);
        col1.setText("name");
        TableColumn col2 = new TableColumn(this.viewer.getTable(), 0);
        col2.setText("parameters");
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new MemberContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MemberLabelProvider());
        this.viewer.setInput((Object)this.ac);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MemberSelectionDialog.this.okPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button ok = MemberSelectionDialog.this.getButton(0);
                if (ok != null && event.getSelection() instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    ok.setEnabled(element instanceof Attribute || element instanceof Operation);
                }
            }
        });
        TableColumnLayout layout = new TableColumnLayout();
        body.setLayout((Layout)layout);
        layout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(20));
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(30));
        layout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(50));
    }

    protected void okPressed() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.selected = ((IStructuredSelection)selection).getFirstElement();
        }
        super.okPressed();
    }

    public Object getSelected() {
        return this.selected;
    }

    private class MemberContentProvider
    implements IStructuredContentProvider {
        private MemberContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            EList attributes = MemberSelectionDialog.this.ac.getAttributes();
            EList operations = MemberSelectionDialog.this.ac.getOperations();
            Object[] elements = new Object[attributes.size() + operations.size()];
            System.arraycopy(attributes.toArray(), 0, elements, 0, attributes.size());
            System.arraycopy(operations.toArray(), 0, elements, attributes.size(), operations.size());
            return elements;
        }
    }

    private class MemberLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MemberLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return MemberSelectionDialog.this.labelProvider.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof Attribute) {
                        return ((Attribute)element).getType().getType().getName();
                    }
                    if (!(element instanceof Operation)) break;
                    return ((Operation)element).getReturnType() == null ? "void" : ((Operation)element).getReturnType().getType().getName();
                }
                case 1: {
                    if (element instanceof Attribute) {
                        int sz = ((Attribute)element).getSize();
                        if (sz > 1) {
                            return String.valueOf(((Attribute)element).getName()) + "[" + sz + "]";
                        }
                        return ((Attribute)element).getName();
                    }
                    if (!(element instanceof Operation)) break;
                    return ((Operation)element).getName();
                }
                case 2: {
                    if (!(element instanceof Operation)) break;
                    return RoomHelpers.getTypedArgumentList((Operation)((Operation)element));
                }
            }
            return null;
        }
    }
}

