/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.common.quickfix.IssueResolution;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class QuickFixDialog
extends SelectionDialog {
    private static final String TITLE = "Quick Fix";
    private static final String MESSAGE_AREA_LABEL = "Quick Fix";
    private static final String ISSUES_LIST_LABEL = "Select a Issue:";
    private static final String RESOLUTIONS_LIST_LABEL = "Select a fix:";
    private static final String DESCRIPTION_AREA_LABEL = "Description";
    private static final String ERROR_IMAGE = "icons/quickfix/error_tsk.gif";
    private static final String WARNING_IMAGE = "icons/quickfix/warn_tsk.gif";
    private static final String INFO_IMAGE = "icons/quickfix/info_tsk.gif";
    private HashMap<FeatureBasedDiagnostic, List<IssueResolution>> issueResolutionsMap;
    private TableViewer issueList;
    private TableViewer resolutionsList;
    private Text resolutionDescription;

    public QuickFixDialog(Shell parent, HashMap<FeatureBasedDiagnostic, List<IssueResolution>> errorResolutionsMap) {
        super(parent);
        this.issueResolutionsMap = errorResolutionsMap;
        this.setTitle("Quick Fix");
        this.setMessage("Quick Fix");
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createLabel(contents, ISSUES_LIST_LABEL);
        this.createIssueList(contents);
        this.createLabel(contents, RESOLUTIONS_LIST_LABEL);
        this.createResolutionList(contents);
        this.createLabel(contents, DESCRIPTION_AREA_LABEL);
        this.createDescritionArea(contents);
        this.issueList.setInput((Object)this);
        this.resolutionsList.setInput((Object)this);
        this.issueList.setSelection((ISelection)new StructuredSelection(this.issueList.getElementAt(0)), true);
        return contents;
    }

    private void createIssueList(Composite control) {
        this.issueList = new TableViewer(control, 2564);
        GridData gd = new GridData(4, 1, true, false);
        gd.heightHint = 60;
        this.issueList.getControl().setLayoutData((Object)gd);
        this.issueList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return QuickFixDialog.this.issueResolutionsMap.keySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.issueList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((FeatureBasedDiagnostic)element).getMessage();
            }

            public Image getImage(Object element) {
                switch (((Diagnostic)element).getSeverity()) {
                    case 4: {
                        return Activator.getImage(QuickFixDialog.ERROR_IMAGE);
                    }
                    case 2: {
                        return Activator.getImage(QuickFixDialog.WARNING_IMAGE);
                    }
                    case 1: {
                        return Activator.getImage(QuickFixDialog.INFO_IMAGE);
                    }
                }
                return null;
            }
        });
        this.issueList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((FeatureBasedDiagnostic)e1).getMessage().compareTo(((FeatureBasedDiagnostic)e2).getMessage());
            }
        });
        this.issueList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QuickFixDialog.this.resolutionsList.refresh();
                if (QuickFixDialog.this.resolutionsList.getElementAt(0) != null) {
                    QuickFixDialog.this.resolutionsList.setSelection((ISelection)new StructuredSelection(QuickFixDialog.this.resolutionsList.getElementAt(0)), true);
                }
                QuickFixDialog.this.updateOkState();
            }
        });
    }

    private void createResolutionList(Composite control) {
        this.resolutionsList = new TableViewer(control, 2564);
        GridData gd = new GridData(4, 1, true, false);
        gd.heightHint = 60;
        this.resolutionsList.getControl().setLayoutData((Object)gd);
        this.resolutionsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                FeatureBasedDiagnostic selected = QuickFixDialog.this.getSelectedIssue();
                if (selected == null) {
                    return new Object[0];
                }
                return ((List)QuickFixDialog.this.issueResolutionsMap.get(selected)).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.resolutionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IssueResolution)element).getLabel();
            }

            public Image getImage(Object element) {
                return Activator.getImage(((IssueResolution)element).getImage());
            }
        });
        this.resolutionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IssueResolution resolution = QuickFixDialog.this.getSelectedResolution();
                String description = "";
                if (resolution != null) {
                    description = resolution.getDescription();
                }
                QuickFixDialog.this.resolutionDescription.setText(description);
                QuickFixDialog.this.updateOkState();
            }
        });
    }

    private Label createLabel(Composite parent, String name) {
        if (name == null) {
            return null;
        }
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setFont(parent.getFont());
        return label;
    }

    private Text createDescritionArea(Composite composite) {
        Text text = new Text(composite, 2818);
        GridData gd = new GridData(4, 1, true, false);
        gd.heightHint = 60;
        gd.widthHint = 130;
        text.setLayoutData((Object)gd);
        text.setEditable(false);
        this.resolutionDescription = text;
        return text;
    }

    private FeatureBasedDiagnostic getSelectedIssue() {
        ISelection selection = this.issueList.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)selection).getFirstElement();
        return (FeatureBasedDiagnostic)first;
    }

    private IssueResolution getSelectedResolution() {
        ISelection selection = this.resolutionsList.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)selection).getFirstElement();
        return (IssueResolution)first;
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        Object[] results = new Object[]{this.getSelectedResolution()};
        this.setResult(Arrays.asList(results));
        super.okPressed();
    }

    private void updateOkState() {
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(this.getSelectedResolution() != null);
        }
    }
}

