/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.ui.behavior.DiagramAccess;
import org.eclipse.etrice.ui.behavior.commands.StateGraphContext;
import org.eclipse.etrice.ui.behavior.support.IPositionProvider;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public class DefaultPositionProvider
implements IPositionProvider {
    private HashMap<String, Position> obj2pos = new HashMap();
    private HashMap<String, ArrayList<Position>> trans2points = new HashMap();
    private HashMap<String, StateGraph> initialPointObj = new HashMap();
    private HashMap<String, IPositionProvider.PosAndSize> sg2sz = new HashMap();
    private double scaleX;
    private double scaleY;
    private int posX;
    private int posY;

    public DefaultPositionProvider(ActorClass ac) {
        this.mapPositions(ac.getBase());
    }

    @Override
    public void setScale(double sx, double sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Override
    public void setPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    @Override
    public IPositionProvider.PosAndSize getPosition(StateGraphNode node) {
        Position pos = this.obj2pos.get(RoomNameProvider.getFullPath((StateGraphItem)node));
        if (pos == null) {
            return null;
        }
        int margin = this.getMargin(node);
        IPositionProvider.PosAndSize pt = new IPositionProvider.PosAndSize((int)(pos.x * this.scaleX) + margin, (int)(pos.y * this.scaleY) + margin, (int)(pos.sx * this.scaleX), (int)(pos.sy * this.scaleY));
        return pt;
    }

    @Override
    public IPositionProvider.PosAndSize getPosition(StateGraph graph) {
        Position pos;
        EObject container = graph.eContainer();
        String path = "#init";
        if (container instanceof StateGraphNode) {
            path = String.valueOf(RoomNameProvider.getFullPath((StateGraphItem)((StateGraphNode)container))) + path;
        }
        if ((pos = this.obj2pos.get(path)) == null) {
            return null;
        }
        int margin = this.getMargin(graph);
        IPositionProvider.PosAndSize pt = new IPositionProvider.PosAndSize((int)(pos.x * this.scaleX) + margin, (int)(pos.y * this.scaleY) + margin, (int)(pos.sx * this.scaleX), (int)(pos.sy * this.scaleY));
        return pt;
    }

    @Override
    public List<IPositionProvider.Pos> getPoints(Transition trans) {
        ArrayList<IPositionProvider.Pos> result = new ArrayList<IPositionProvider.Pos>();
        ArrayList<Position> list = this.trans2points.get(RoomNameProvider.getFullPath((StateGraphItem)trans));
        if (list != null) {
            int i = 0;
            for (Position p : list) {
                IPositionProvider.Pos pos = new IPositionProvider.Pos((int)(p.x * this.scaleX) + (i == 0 ? 0 : this.posX), (int)(p.y * this.scaleY) + (i == 0 ? 0 : this.posY));
                result.add(pos);
                ++i;
            }
        }
        return result;
    }

    @Override
    public <T extends StateGraphNode> List<IPositionProvider.PosAndSize> getPositions(List<T> nodes) {
        int delta;
        ArrayList<IPositionProvider.PosAndSize> result = new ArrayList<IPositionProvider.PosAndSize>(nodes.size());
        if (nodes.isEmpty()) {
            return result;
        }
        int n = 0;
        for (StateGraphNode node : nodes) {
            IPositionProvider.PosAndSize pt = this.getPosition(node);
            result.add(pt);
            if (pt != null) continue;
            ++n;
        }
        int pos = delta = (int)(this.scaleX / (double)(n + 1));
        int h = 40;
        if (nodes.get(0) instanceof State) {
            h = 165;
        } else if (nodes.get(0) instanceof ChoicePoint) {
            h = 290;
        } else if (nodes.get(0) instanceof TrPoint) {
            h = 40;
        } else assert (false) : "unexpected sub type";
        int i = 0;
        while (i < nodes.size()) {
            if (result.get(i) == null) {
                IPositionProvider.PosAndSize pt = new IPositionProvider.PosAndSize(pos, h, 0, 0);
                result.set(i, pt);
                pos += delta;
            }
            ++i;
        }
        return result;
    }

    private void mapPositions(ActorClass ac) {
        EObject obj;
        if (ac == null) {
            return;
        }
        Diagram diagram = new DiagramAccess().getDiagram((StructureClass)ac);
        if (diagram == null) {
            return;
        }
        StateGraphContext tree = StateGraphContext.createContextTree(SupportUtil.getActorClass(diagram));
        ILinkService linkService = Graphiti.getLinkService();
        for (Shape sgShape : diagram.getChildren()) {
            if (!(sgShape instanceof ContainerShape)) continue;
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)sgShape);
            GraphicsAlgorithm borderRect = (GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            double width = borderRect.getWidth();
            double height = borderRect.getHeight();
            IPositionProvider.PosAndSize sz = new IPositionProvider.PosAndSize(sgShape.getGraphicsAlgorithm().getX(), sgShape.getGraphicsAlgorithm().getY(), borderRect.getWidth(), borderRect.getHeight());
            this.sg2sz.put(RoomNameProvider.getFullPath((StateGraph)((StateGraph)obj)), sz);
            for (Shape sgItemShape : ((ContainerShape)sgShape).getChildren()) {
                obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)sgItemShape);
                GraphicsAlgorithm ga = sgItemShape.getGraphicsAlgorithm();
                if (ga == null) continue;
                int margin = 0;
                String path = null;
                if (obj instanceof StateGraphNode) {
                    StateGraphNode node = (StateGraphNode)obj;
                    margin = this.getMargin(node);
                    path = RoomNameProvider.getFullPath((StateGraphItem)((StateGraphItem)obj));
                } else if (obj instanceof StateGraph) {
                    StateGraph graph = (StateGraph)obj;
                    margin = this.getMargin(graph);
                    EObject container = graph.eContainer();
                    path = "#init";
                    if (container instanceof StateGraphNode) {
                        path = String.valueOf(RoomNameProvider.getFullPath((StateGraphItem)((StateGraphNode)container))) + path;
                    }
                    this.initialPointObj.put(path, graph);
                }
                if (path == null) continue;
                Position pos = new Position();
                pos.x = (double)ga.getX() / width;
                pos.y = (double)ga.getY() / height;
                pos.sx = (double)(ga.getWidth() - 2 * margin) / width;
                pos.sy = (double)(ga.getHeight() - 2 * margin) / height;
                this.obj2pos.put(path, pos);
            }
        }
        for (Connection conn : diagram.getConnections()) {
            ConnectionDecorator cd;
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)conn);
            if (!(obj instanceof Transition) || !((cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text)) continue;
            Transition trans = (Transition)obj;
            StateGraph sg = tree.getContext((StateGraphItem)trans).getStateGraph();
            IPositionProvider.PosAndSize sz = this.sg2sz.get(RoomNameProvider.getFullPath((StateGraph)sg));
            ArrayList<Position> points = new ArrayList<Position>();
            this.trans2points.put(RoomNameProvider.getFullPath((StateGraphItem)((Transition)obj)), points);
            Position pos = new Position();
            pos.x = (double)cd.getGraphicsAlgorithm().getX() / (double)sz.getWidth();
            pos.y = (double)cd.getGraphicsAlgorithm().getY() / (double)sz.getHeight();
            points.add(pos);
            if (!(conn instanceof FreeFormConnection)) continue;
            for (Point bp : ((FreeFormConnection)conn).getBendpoints()) {
                pos = new Position();
                pos.x = (double)(bp.getX() - sz.getX()) / (double)sz.getWidth();
                pos.y = (double)(bp.getY() - sz.getY()) / (double)sz.getHeight();
                points.add(pos);
            }
        }
        this.mapPositions(ac.getBase());
    }

    private int getMargin(StateGraphNode node) {
        if (node instanceof State) {
            return 30;
        }
        if (node instanceof TrPoint) {
            return 40;
        }
        return 0;
    }

    private int getMargin(StateGraph graph) {
        return 0;
    }

    @Override
    public StateGraph getInitialPoint(StateGraph graph) {
        EObject container = graph.eContainer();
        String path = "#init";
        if (container instanceof StateGraphNode) {
            path = String.valueOf(RoomNameProvider.getFullPath((StateGraphItem)((StateGraphNode)container))) + path;
        }
        return this.initialPointObj.get(path);
    }

    @Override
    public IPositionProvider.PosAndSize getGraphPosAndSize(StateGraph sg) {
        return this.sg2sz.get(RoomNameProvider.getFullPath((StateGraph)sg));
    }

    private static class Position {
        double x;
        double y;
        double sx;
        double sy;

        private Position() {
        }
    }
}

