/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.IDataObject;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.ILayoutData;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutOptionData<T>
implements ILayoutData,
IProperty<T>,
Comparable<IProperty<?>> {
    public static final String BOOLEAN_LITERAL = "boolean";
    public static final String INT_LITERAL = "int";
    public static final String STRING_LITERAL = "string";
    public static final String FLOAT_LITERAL = "float";
    public static final String ENUM_LITERAL = "enum";
    public static final String OBJECT_LITERAL = "object";
    public static final String REMOTEENUM_LITERAL = "remoteenum";
    public static final String DEFAULT_OPTION_NAME = "<Unnamed Option>";
    private String id = "";
    private T defaultValue;
    private Type type = Type.UNDEFINED;
    private String name = "";
    private String description = "";
    private Set<Target> targets = Collections.emptySet();
    private List<Pair<LayoutOptionData<?>, Object>> dependencies = Lists.newLinkedList();
    private Class<?> clazz;
    private String[] choices;
    private boolean advanced;
    private T lowerBound;
    private T upperBound;
    private float variance = 1.0f;
    public static final String[] BOOLEAN_CHOICES = new String[]{"false", "true"};

    private void checkEnumClass() {
        if (this.clazz == null || !this.clazz.isEnum()) {
            throw new IllegalStateException("Enumeration class expected for layout option " + this.id);
        }
    }

    private void checkRemoteEnumoptions() {
        if (this.choices == null || this.choices.length == 0) {
            throw new IllegalStateException("Remote enumeration values have not been initialized correctly for layout option with id " + this.id);
        }
    }

    private IDataObject createDataInstance() {
        if (!IDataObject.class.isAssignableFrom(this.clazz)) {
            throw new IllegalStateException("IDataType class expected for layout option " + this.id);
        }
        try {
            return (IDataObject)this.clazz.newInstance();
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("The data object for layout option " + this.id + " cannot be instantiated.", exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("The data object for layout option " + this.id + " cannot be accessed.", exception);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutOptionData) {
            return this.id.equals(((LayoutOptionData)obj).id);
        }
        if (obj instanceof IProperty) {
            return this.id.equals(((IProperty)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(IProperty<?> other) {
        return this.id.compareTo(other.getId());
    }

    public String toString() {
        if (this.name != null && this.name.length() > 0) {
            return this.name;
        }
        return this.id;
    }

    public void setType(String typeLiteral) {
        if (BOOLEAN_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.BOOLEAN;
        } else if (INT_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.INT;
        } else if (STRING_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.STRING;
        } else if (FLOAT_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.FLOAT;
        } else if (ENUM_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.ENUM;
        } else if (OBJECT_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.OBJECT;
        } else if (REMOTEENUM_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.REMOTE_ENUM;
        } else {
            throw new IllegalArgumentException("The given type literal is invalid.");
        }
    }

    public T parseValue(String valueString) {
        if (valueString == null || valueString.length() == 0 || valueString.equals("null")) {
            return null;
        }
        switch (this.type) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(valueString);
            }
            case INT: {
                try {
                    return (T)Integer.valueOf(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case STRING: {
                return (T)valueString;
            }
            case FLOAT: {
                try {
                    return (T)Float.valueOf(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case ENUM: {
                try {
                    this.checkEnumClass();
                    Object value = Enum.valueOf(this.clazz, valueString);
                    return (T)value;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        int index = Integer.parseInt(valueString);
                        ?[] constants = this.clazz.getEnumConstants();
                        if (index >= 0 && index < constants.length) {
                            return (T)constants[index];
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    return null;
                }
            }
            case OBJECT: {
                try {
                    IDataObject value = this.createDataInstance();
                    value.parse(valueString);
                    return (T)value;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            case REMOTE_ENUM: {
                this.checkRemoteEnumoptions();
                int i = 0;
                while (i < this.choices.length) {
                    if (this.choices[i].equals(valueString)) {
                        return (T)valueString;
                    }
                    ++i;
                }
                return null;
            }
        }
        throw new IllegalStateException("Invalid type set for this layout option.");
    }

    public void parseRemoteEnumValues(String valueString) {
        Vector<String> tmp = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(valueString, " ");
        while (tokenizer.hasMoreTokens()) {
            tmp.add(tokenizer.nextToken());
        }
        this.choices = tmp.toArray(new String[0]);
    }

    public T getDefaultDefault() {
        switch (this.type) {
            case STRING: {
                return (T)"";
            }
            case BOOLEAN: {
                return (T)Boolean.FALSE;
            }
            case INT: {
                return (T)Integer.valueOf(0);
            }
            case FLOAT: {
                return (T)Float.valueOf(0.0f);
            }
            case ENUM: {
                this.checkEnumClass();
                Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                return (T)enums[0];
            }
            case OBJECT: {
                return null;
            }
            case REMOTE_ENUM: {
                this.checkRemoteEnumoptions();
                return (T)this.choices[0];
            }
        }
        throw new IllegalStateException("Invalid type set for this layout option.");
    }

    public String[] getChoices() {
        if (this.choices == null) {
            switch (this.type) {
                case ENUM: {
                    this.checkEnumClass();
                    Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                    this.choices = new String[enums.length];
                    int i = 0;
                    while (i < enums.length) {
                        this.choices[i] = enums[i].toString();
                        ++i;
                    }
                    break;
                }
                case BOOLEAN: {
                    this.choices = BOOLEAN_CHOICES;
                    break;
                }
                case REMOTE_ENUM: {
                    this.checkRemoteEnumoptions();
                    return this.choices;
                }
                default: {
                    this.choices = new String[0];
                }
            }
        }
        return this.choices;
    }

    public Enum<?> getEnumValue(int intValue) {
        switch (this.type) {
            case ENUM: {
                this.checkEnumClass();
                Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                return enums[intValue];
            }
        }
        return null;
    }

    public void setTargets(String targetsString) {
        this.targets = EnumSet.noneOf(Target.class);
        if (targetsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(targetsString, ", \t");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equalsIgnoreCase(Target.PARENTS.toString())) {
                    this.targets.add(Target.PARENTS);
                    continue;
                }
                if (token.equalsIgnoreCase(Target.NODES.toString())) {
                    this.targets.add(Target.NODES);
                    continue;
                }
                if (token.equalsIgnoreCase(Target.EDGES.toString())) {
                    this.targets.add(Target.EDGES);
                    continue;
                }
                if (token.equalsIgnoreCase(Target.PORTS.toString())) {
                    this.targets.add(Target.PORTS);
                    continue;
                }
                if (!token.equalsIgnoreCase(Target.LABELS.toString())) continue;
                this.targets.add(Target.LABELS);
            }
        }
    }

    public Set<Target> getTargets() {
        return this.targets;
    }

    public String getTargetsDescription() {
        StringBuilder descriptionBuf = new StringBuilder();
        int count = this.targets.size();
        int index = 0;
        for (Target target : this.targets) {
            switch (target) {
                case PARENTS: {
                    descriptionBuf.append("Parents");
                    break;
                }
                case NODES: {
                    descriptionBuf.append("Nodes");
                    break;
                }
                case EDGES: {
                    descriptionBuf.append("Edges");
                    break;
                }
                case PORTS: {
                    descriptionBuf.append("Ports");
                    break;
                }
                case LABELS: {
                    descriptionBuf.append("Labels");
                }
            }
            if (count - ++index >= 2) {
                descriptionBuf.append(", ");
                continue;
            }
            if (count - index != 1) continue;
            descriptionBuf.append(" and ");
        }
        return descriptionBuf.toString();
    }

    public List<Pair<LayoutOptionData<?>, Object>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setId(String theid) {
        assert (theid != null);
        this.id = theid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setType(Type thetype) {
        this.type = thetype;
        switch (thetype) {
            case STRING: {
                this.clazz = String.class;
                break;
            }
            case BOOLEAN: {
                this.clazz = Boolean.class;
                break;
            }
            case INT: {
                this.clazz = Integer.class;
                break;
            }
            case FLOAT: {
                this.clazz = Float.class;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void setName(String thename) {
        this.name = thename == null || thename.length() == 0 ? DEFAULT_OPTION_NAME : thename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String thedescription) {
        this.description = thedescription == null ? "" : thedescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public Comparable<T> getLowerBound() {
        if (this.lowerBound instanceof Comparable) {
            return (Comparable)this.lowerBound;
        }
        return Property.NEGATIVE_INFINITY;
    }

    public void setLowerBound(T lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Comparable<T> getUpperBound() {
        if (this.upperBound instanceof Comparable) {
            return (Comparable)this.upperBound;
        }
        return Property.POSITIVE_INFINITY;
    }

    public void setUpperBound(T upperBound) {
        this.upperBound = upperBound;
    }

    public void setDefault(T thedefaultValue) {
        this.defaultValue = thedefaultValue;
    }

    public Class<?> getOptionClass() {
        return this.clazz;
    }

    public void setOptionClass(Class<?> theclazz) {
        this.clazz = theclazz;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean theadvanced) {
        this.advanced = theadvanced;
    }

    public float getVariance() {
        return this.variance;
    }

    public void setVariance(float variance) {
        this.variance = variance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        PARENTS,
        NODES,
        EDGES,
        PORTS,
        LABELS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNDEFINED,
        BOOLEAN,
        INT,
        STRING,
        FLOAT,
        ENUM,
        OBJECT,
        REMOTE_ENUM;


        public String literal() {
            switch (this) {
                case BOOLEAN: {
                    return LayoutOptionData.BOOLEAN_LITERAL;
                }
                case INT: {
                    return LayoutOptionData.INT_LITERAL;
                }
                case STRING: {
                    return LayoutOptionData.STRING_LITERAL;
                }
                case FLOAT: {
                    return LayoutOptionData.FLOAT_LITERAL;
                }
                case ENUM: {
                    return LayoutOptionData.ENUM_LITERAL;
                }
                case OBJECT: {
                    return LayoutOptionData.OBJECT_LITERAL;
                }
                case REMOTE_ENUM: {
                    return LayoutOptionData.REMOTEENUM_LITERAL;
                }
            }
            return this.toString();
        }
    }
}

