/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.scoping;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.etrice.core.common.scoping.IModelLocator;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;

public class StandardModelLocator
implements IModelLocator {
    private static final String CLASSPATH = "classpath:/";
    private static final Map<String, String> env = System.getenv();

    @Override
    public String resolve(String resolve, Resource resource) {
        URI baseUri = resource == null ? null : resource.getURI();
        if ((resolve = this.resolve(resolve, baseUri, resource)) == null) {
            return null;
        }
        try {
            URIConverter converter = resource == null ? null : resource.getResourceSet().getURIConverter();
            URI canonical = this.getCanonicalFileURI(resolve, converter);
            if (canonical.isPlatform()) {
                resolve = "platform:/resource" + canonical.toPlatformString(true);
            } else {
                resolve = canonical.toFileString();
                resolve = resolve.replaceAll("\\\\", "/");
                resolve = resolve.replaceAll("//", "/");
                resolve = "file:/" + resolve;
            }
        }
        catch (IOException e) {
            return null;
        }
        return resolve;
    }

    private String resolve(String resolve, URI baseUri, Resource res) {
        resolve = this.substituteEnvVars(resolve);
        resolve = resolve.replaceAll("\\\\", "/");
        resolve = resolve.replaceAll("//", "/");
        if (baseUri != null) {
            resolve = this.resolveUriAgainstBase(resolve, baseUri, res);
        }
        return resolve;
    }

    private String substituteEnvVars(String text) {
        String pattern = "\\$\\{([A-Za-z0-9_]+)\\}";
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(text);
        while (matcher.find()) {
            String envValue = env.get(matcher.group(1));
            envValue = envValue == null ? "" : envValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            text = subexpr.matcher(text).replaceAll(envValue);
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolveUriAgainstBase(String resolve, URI baseUri, Resource res) {
        URI base;
        URI uri;
        block13: {
            if (resolve == null || resolve.trim().isEmpty()) {
                return null;
            }
            uri = URI.createURI((String)resolve);
            if (!uri.isRelative()) return resolve;
            base = baseUri.trimSegments(1);
            if (base.isPlatformResource() && EMFPlugin.IS_ECLIPSE_RUNNING) {
                URI platUri = uri.resolve(baseUri);
                if (!this.existsInPlatform(platUri)) {
                    URI fileUri = this.resolveFileUriFromPlatformBase(uri, baseUri);
                    if (!this.existsInFileSys(fileUri)) {
                        return null;
                    }
                    if (!this.updateURIMapEntry(res, platUri, fileUri)) {
                        return null;
                    }
                    break block13;
                } else {
                    URI fileUri = this.resolveFileUriFromPlatformBase(uri, baseUri);
                    if (!this.existsInFileSys(fileUri)) {
                        return null;
                    }
                    this.removeURIMapEntry(res, platUri);
                    return platUri.toString();
                }
            }
            if (base.isRelative()) {
                base = URI.createFileURI((String)new File(base.toString()).getAbsolutePath());
            }
        }
        base = base.appendSegment("");
        try {
            uri = uri.resolve(base);
        }
        catch (IllegalArgumentException platUri) {
            // empty catch block
        }
        resolve = uri.toString();
        try {
            File file = new File(uri.toFileString());
            if (!file.isDirectory()) return resolve;
            return "path/to/directory";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return resolve;
    }

    private void removeURIMapEntry(Resource res, URI platUri) {
        if (res == null) {
            return;
        }
        Map uriMap = res.getResourceSet().getURIConverter().getURIMap();
        if (uriMap.containsKey(platUri)) {
            uriMap.remove(platUri);
        }
    }

    private boolean updateURIMapEntry(Resource res, URI platUri, URI fileUri) {
        if (res == null) {
            return false;
        }
        Map uriMap = res.getResourceSet().getURIConverter().getURIMap();
        if (uriMap.containsKey(platUri)) {
            if (!((URI)uriMap.get(platUri)).equals(fileUri)) {
                return false;
            }
        } else {
            uriMap.put(platUri, fileUri);
        }
        return true;
    }

    private URI resolveFileUriFromPlatformBase(URI target, URI baseUri) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return null;
        }
        if (!baseUri.isPlatform()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root == null) {
            return null;
        }
        Path extBasePath = new Path(baseUri.toPlatformString(true));
        IFile extBaseFile = root.getFile((IPath)extBasePath);
        URI extBaseURI = URI.createFileURI((String)extBaseFile.getLocationURI().getPath());
        URI fileUri = target.resolve(extBaseURI, true);
        return fileUri;
    }

    private boolean existsInPlatform(URI uri) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return false;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root == null) {
            return false;
        }
        if (!uri.isPlatform()) {
            return false;
        }
        try {
            Path platPath = new Path(uri.toPlatformString(true));
            IFile platFile = root.getFile((IPath)platPath);
            return platFile.exists();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean existsInFileSys(URI uri) {
        if (!uri.isFile()) {
            return false;
        }
        File extFile = new File(uri.toFileString());
        return extFile.exists() && extFile.isFile();
    }

    private URI getCanonicalFileURI(String uriString, URIConverter uriConverter) throws IOException {
        URI uri;
        if (uriString.startsWith(CLASSPATH) || uriString.startsWith("platform:/") || uriString.startsWith("file:/")) {
            uri = URI.createURI((String)uriString);
        } else {
            try {
                uri = URI.createFileURI((String)uriString);
            }
            catch (IllegalArgumentException e) {
                throw new IOException();
            }
        }
        URI normalized = uri;
        if (uriConverter != null) {
            try {
                normalized = uriConverter.normalize(uri);
            }
            catch (IllegalStateException e) {
                throw new IOException();
            }
            catch (ClasspathUriResolutionException e) {
                throw new IOException();
            }
        }
        if (normalized.isFile()) {
            String can = normalized.toFileString();
            File f = new File(can);
            f = this.locateFile(f);
            can = f.getCanonicalPath();
            URI canonical = URI.createFileURI((String)can);
            return canonical;
        }
        return normalized;
    }

    protected File locateFile(File f) {
        return f;
    }
}

