/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.validation;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.AnnotationAttribute;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.base.EnumAnnotationAttribute;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.SimpleAnnotationAttribute;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.common.validation.AbstractBaseJavaValidator;
import org.eclipse.xtext.validation.Check;

public class BaseJavaValidator
extends AbstractBaseJavaValidator {
    public static final String MANDATORY_ATTRIBUTE_MISSING = "BaseJavaValidator.MandatoryAttributeMissing";
    public static final String DUPLICATE_ANNOTATION_TARGETS = "BaseJavaValidator.DuplicateAnnotationTargets";
    public static final String UNDEFINED_ANNOTATION_ATTRIBUTE = "BaseJavaValidator.UndfinedAnnotationAttribute";
    public static final String UNDEFINED_ANNOTATION_ATTRIBUTE_VALUE = "BaseJavaValidator.UndfinedAnnotationAttributeValue";
    public static final String DUPLICATE_ANNOTATION_ATTRIBUTE = "BaseJavaValidator.DuplicateAnnotationAttribute";

    @Check
    public void checkDocumentation(Documentation doc) {
        if (doc.getLines().isEmpty()) {
            this.error("documentation must not be empty", doc, (EStructuralFeature)BasePackage.Literals.DOCUMENTATION__LINES);
        }
    }

    @Check
    public void checkAnnotationTypeTargetsUnique(AnnotationType at) {
        HashSet<String> targets = new HashSet<String>();
        for (String tgt : at.getTargets()) {
            if (targets.add(tgt)) continue;
            this.error("The target " + tgt + " is defined more than once", at, (EStructuralFeature)BasePackage.Literals.ANNOTATION_TYPE__TARGETS, DUPLICATE_ANNOTATION_TARGETS, new String[]{tgt});
        }
    }

    @Check
    public void checkAnnotationAttributeMandatory(Annotation a) {
        for (AnnotationAttribute att : a.getType().getAttributes()) {
            if (att.isOptional()) continue;
            boolean isDefined = false;
            for (KeyValue kv : a.getAttributes()) {
                if (!kv.getKey().equals(att.getName())) continue;
                isDefined = true;
                break;
            }
            if (isDefined) continue;
            this.error("Mandatory attribute " + att.getName() + " is missing", a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__ATTRIBUTES, MANDATORY_ATTRIBUTE_MISSING, new String[]{att.getName()});
        }
    }

    @Check
    public void checkAnnotationAttributeType(Annotation a) {
        HashSet<String> names = new HashSet<String>();
        for (KeyValue kv : a.getAttributes()) {
            int idx = a.getAttributes().indexOf((Object)kv);
            if (!names.add(kv.getKey())) {
                this.error("duplicate attribute " + kv.getKey(), a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__ATTRIBUTES, idx, DUPLICATE_ANNOTATION_ATTRIBUTE, new String[]{kv.getKey()});
            }
            boolean isAllowed = false;
            block7: for (AnnotationAttribute att : a.getType().getAttributes()) {
                if (!att.getName().equals(kv.getKey())) continue;
                isAllowed = true;
                if (kv.getValue() != null) {
                    if (!(att instanceof EnumAnnotationAttribute)) break;
                    EList<String> values = ((EnumAnnotationAttribute)att).getValues();
                    if (kv.getValue() instanceof StringLiteral) {
                        boolean valueAllowed = false;
                        String value = ((StringLiteral)kv.getValue()).getValue();
                        for (String val : values) {
                            if (!val.equals(value)) continue;
                            valueAllowed = true;
                            break;
                        }
                        if (valueAllowed) break;
                        this.error("Choose one of the allowed enum values", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE, UNDEFINED_ANNOTATION_ATTRIBUTE_VALUE, (String[])values.toArray((Object[])new String[values.size()]));
                        break;
                    }
                    this.error("Choose one of the allowed enum values (values has to be a string)", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE, UNDEFINED_ANNOTATION_ATTRIBUTE_VALUE, (String[])values.toArray((Object[])new String[values.size()]));
                    break;
                }
                if (!(att instanceof SimpleAnnotationAttribute)) break;
                switch (((SimpleAnnotationAttribute)att).getType()) {
                    case BOOL: {
                        if (kv.getValue() instanceof BooleanLiteral) break block7;
                        this.error("boolean literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                    case CHAR: {
                        if (kv.getValue() instanceof StringLiteral) break block7;
                        this.error("char/string literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                    case INT: {
                        if (kv.getValue() instanceof IntLiteral) break block7;
                        this.error("integer literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                    case REAL: {
                        if (kv.getValue() instanceof RealLiteral) break block7;
                        this.error("real literal expected", kv, (EStructuralFeature)BasePackage.Literals.KEY_VALUE__VALUE);
                        break;
                    }
                }
                break;
            }
            if (isAllowed) continue;
            this.error("Attribute " + kv.getKey() + " is undefined", a, (EStructuralFeature)BasePackage.Literals.ANNOTATION__ATTRIBUTES, idx, UNDEFINED_ANNOTATION_ATTRIBUTE, new String[]{kv.getKey()});
        }
    }
}

