/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.common.base.NumberLiteral;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.config.ActorClassConfig;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.ConfigModel;
import org.eclipse.etrice.core.config.ConfigPackage;
import org.eclipse.etrice.core.config.ConfigValue;
import org.eclipse.etrice.core.config.EnumConfigValue;
import org.eclipse.etrice.core.config.LiteralConfigValue;
import org.eclipse.etrice.core.config.PortClassConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.config.ProtocolClassConfig;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.converter.ConfigValueConverterService;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.validation.AbstractConfigJavaValidator;
import org.eclipse.xtext.validation.Check;

public class ConfigJavaValidator
extends AbstractConfigJavaValidator {
    @Inject
    private ConfigUtil configUtil;
    private ConfigValueConverterService converter = new ConfigValueConverterService();

    @Check
    public void checkConfigModel(ConfigModel model) {
        HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
        for (ActorClassConfig classConfig : model.getActorClassConfigs()) {
            if (actorClasses.contains(classConfig.getActor())) {
                this.error("duplicate class config", model, (EStructuralFeature)ConfigPackage.Literals.CONFIG_MODEL__CONFIG_ELEMENTS, model.getConfigElements().indexOf((Object)classConfig));
                continue;
            }
            actorClasses.add(classConfig.getActor());
        }
        HashSet<String> actorRefs = new HashSet<String>();
        for (ActorInstanceConfig instanceConfig : model.getActorInstanceConfigs()) {
            String ref = this.configUtil.getPath(instanceConfig);
            if (actorRefs.contains(ref)) {
                this.error("duplicate actor instance config", model, (EStructuralFeature)ConfigPackage.Literals.CONFIG_MODEL__CONFIG_ELEMENTS, model.getConfigElements().indexOf((Object)instanceConfig));
                continue;
            }
            actorRefs.add(ref);
        }
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        for (ProtocolClassConfig protocolConfig : model.getProtocolClassConfigs()) {
            if (protocolClasses.contains(protocolConfig.getProtocol())) {
                this.error("duplicate protocol class config", model, (EStructuralFeature)ConfigPackage.Literals.CONFIG_MODEL__CONFIG_ELEMENTS, model.getConfigElements().indexOf((Object)protocolConfig));
                continue;
            }
            protocolClasses.add(protocolConfig.getProtocol());
        }
    }

    @Check
    public void checkActorClassConfig(ActorClassConfig config) {
        if (config.getActor().isAbstract()) {
            this.error("abstract actor classes not supported", (EStructuralFeature)ConfigPackage.Literals.ACTOR_CLASS_CONFIG__ACTOR);
        }
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.ACTOR_CLASS_CONFIG__ATTRIBUTES);
    }

    @Check
    public void checkActorInstanceConfig(ActorInstanceConfig config) {
        RefPath path;
        SubSystemClass root = config.getSubSystem().getType();
        if (root != null && !root.eIsProxy() && (path = config.getPath()) != null) {
            String invalidSegment = this.configUtil.checkPath((ActorContainerClass)root, path);
            if (invalidSegment != null) {
                this.error("no match for segment '" + invalidSegment + "'", (EStructuralFeature)ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__PATH);
            } else {
                ActorRef aRef = this.configUtil.getLastActorRef((ActorContainerClass)root, path);
                if (aRef == null) {
                    this.error("invalid actor reference", (EStructuralFeature)ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__PATH);
                }
            }
        }
        HashSet<InterfaceItem> items = new HashSet<InterfaceItem>();
        for (PortInstanceConfig portConfig : config.getPorts()) {
            InterfaceItem item = portConfig.getItem();
            if (items.contains(item)) {
                this.error("duplicate port instance config", (EStructuralFeature)ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__PORTS, config.getPorts().indexOf((Object)portConfig));
                continue;
            }
            items.add(item);
        }
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__ATTRIBUTES);
    }

    @Check
    public void checkPortClassConfig(PortClassConfig config) {
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.PORT_CLASS_CONFIG__ATTRIBUTES);
    }

    @Check
    public void checkPortInstanceConfig(PortInstanceConfig config) {
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.PORT_INSTANCE_CONFIG__ATTRIBUTES);
    }

    private void checkDuplicateAttributes(List<? extends AttrConfig> attrConfigs, EReference ref) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (AttrConfig attrConfig : attrConfigs) {
            if (attributes.contains(attrConfig.getAttribute())) {
                this.error("duplicate attribute entry", (EStructuralFeature)ref, attrConfigs.indexOf(attrConfig));
                continue;
            }
            attributes.add(attrConfig.getAttribute());
        }
    }

    @Check
    public void checkAttrConfig(AttrConfig config) {
        Attribute a = config.getAttribute();
        if (a == null) {
            return;
        }
        DataType type = a.getType().getType();
        if (a.getType().isRef()) {
            this.error("reference not supported", (EStructuralFeature)ConfigPackage.Literals.ATTR_CONFIG__ATTRIBUTE);
        } else if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            this.checkAttrConfigValue(primitive, config);
        } else if (type instanceof ComplexType) {
            if (config.getValue() != null) {
                this.error("not available", (EStructuralFeature)ConfigPackage.Literals.ATTR_CONFIG__VALUE);
            }
            if (a.getSize() > 0) {
                this.error("ComplexType arrays not supported", (EStructuralFeature)ConfigPackage.Literals.ATTR_CONFIG__ATTRIBUTE);
            }
        } else if (type instanceof EnumerationType) {
            EnumerationType enumType = (EnumerationType)type;
            this.checkAttrConfigValue(enumType, config);
        } else {
            this.error("Type not supported", (EStructuralFeature)ConfigPackage.Literals.ATTR_CONFIG__ATTRIBUTE);
        }
    }

    @Check
    public void checkAttrClassConfig(AttrClassConfig config) {
        Attribute attr = config.getAttribute();
        if (attr == null) {
            return;
        }
        DataType type = attr.getType().getType();
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            this.checkAttrConfigMin(primitive, config);
            this.checkAttrConfigMax(primitive, config);
        } else {
            if (config.getMin() != null) {
                this.error("min is only allowed for numeric types", (EStructuralFeature)ConfigPackage.Literals.ATTR_CLASS_CONFIG__MIN);
            }
            if (config.getMax() != null) {
                this.error("max is only allowed for numeric types", (EStructuralFeature)ConfigPackage.Literals.ATTR_CLASS_CONFIG__MAX);
            }
        }
    }

    @Check
    public void checkAttrInstanceConfig(AttrInstanceConfig config) {
        Attribute attr = config.getAttribute();
        if (attr == null) {
            return;
        }
        EAttribute feature = ConfigPackage.eINSTANCE.getAttrInstanceConfig_DynConfig();
        if (config.isDynConfig()) {
            if (!(config.eContainer() instanceof ActorInstanceConfig)) {
                this.error("dynamic configuration only at root attributes", (EStructuralFeature)feature);
            }
            if (config.eContainer() instanceof ActorInstanceConfig) {
                ConfigModel model = this.getConfigModel(config);
                SubSystemRef ssRef = ((ActorInstanceConfig)config.eContainer()).getSubSystem();
                boolean found = false;
                for (SubSystemConfig c : model.getSubSystemConfigs()) {
                    if (!c.getSubSystem().equals(ssRef)) continue;
                    if (c.getDynConfig() == null) {
                        this.error("no source for dynamic config in SubSystemConfig", (EStructuralFeature)feature);
                    }
                    found = true;
                }
                if (!found) {
                    this.error("no SubSystemConfig found", (EStructuralFeature)feature);
                }
            }
        }
    }

    private void checkAttrConfigValue(PrimitiveType primitive, AttrConfig config) {
        int attrMult;
        if (config.getValue() == null) {
            return;
        }
        EList<ConfigValue> values = config.getValue().getValues();
        EReference valueRef = ConfigPackage.eINSTANCE.getAttrConfig_Value();
        EReference arrayRef = ConfigPackage.eINSTANCE.getConfigValueArray_Values();
        LiteralType type = primitive.getType();
        Attribute attribute = config.getAttribute();
        int n = attrMult = attribute.getSize() > 0 ? attribute.getSize() : 1;
        if (type != LiteralType.CHAR) {
            if (values.size() > attrMult) {
                this.error("too many values, multiplicity is " + attrMult, (EStructuralFeature)valueRef);
            }
            if (values.size() > 1 && values.size() < attrMult) {
                this.error("not enough values, multiplicity is " + attrMult, (EStructuralFeature)valueRef);
            }
        }
        block6: for (ConfigValue configValue : values) {
            Object value = configValue;
            if (configValue instanceof LiteralConfigValue) {
                value = ((LiteralConfigValue)configValue).getValue();
            }
            switch (type) {
                case BOOL: {
                    if (value instanceof BooleanLiteral) break;
                    this.error("must be boolean value", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(configValue));
                    break;
                }
                case REAL: {
                    if (value instanceof NumberLiteral) break;
                    this.error("must be an integer or real value", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(configValue));
                    break;
                }
                case INT: {
                    if (value instanceof IntLiteral) break;
                    this.error("must be an integer", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(configValue));
                    break;
                }
                case CHAR: {
                    if (!(value instanceof StringLiteral)) {
                        this.error("must be a string", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(configValue));
                        break;
                    }
                    if (values.size() > 1) {
                        this.error("multiplicity must be one", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(configValue));
                    }
                    StringLiteral strValue = (StringLiteral)value;
                    if (attribute.getSize() <= 0 || attrMult >= strValue.getValue().length()) continue block6;
                    this.error("too many characters - maximal length is " + attrMult, config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(configValue));
                }
            }
        }
        ArrayList<NumberLiteral> numberValues = new ArrayList<NumberLiteral>();
        for (ConfigValue value : values) {
            Literal literalValue;
            if (!(value instanceof LiteralConfigValue) || !((literalValue = ((LiteralConfigValue)value).getValue()) instanceof NumberLiteral)) continue;
            numberValues.add((NumberLiteral)literalValue);
        }
        if (type == LiteralType.INT || type == LiteralType.REAL) {
            AttrClassConfig attrClassConfig = null;
            if (config instanceof AttrInstanceConfig) {
                attrClassConfig = this.resolveAttrClassConfig((AttrInstanceConfig)config);
            } else if (config instanceof AttrClassConfig) {
                attrClassConfig = (AttrClassConfig)config;
            }
            if (attrClassConfig != null) {
                NumberLiteral min = attrClassConfig.getMin();
                NumberLiteral max = attrClassConfig.getMax();
                for (NumberLiteral value : numberValues) {
                    if (value instanceof RealLiteral) {
                        double dbValue = ((RealLiteral)value).getValue();
                        if (min instanceof RealLiteral) {
                            double dbMin = ((RealLiteral)min).getValue();
                            if (dbMin > dbValue) {
                                this.error("value is less than minimum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                            }
                        } else if (min != null) {
                            this.warning("could not compare with minimum (incompatible datatypes)", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                        }
                        if (max instanceof RealLiteral) {
                            double dbMax = ((RealLiteral)max).getValue();
                            if (!(dbMax < dbValue)) continue;
                            this.error("value exceeds maximum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                            continue;
                        }
                        if (max == null) continue;
                        this.warning("could not compare with maximum (incompatible datatypes)", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                        continue;
                    }
                    if (!(value instanceof IntLiteral)) continue;
                    long lValue = ((IntLiteral)value).getValue();
                    if (min instanceof IntLiteral) {
                        long lMin = ((IntLiteral)min).getValue();
                        if (lMin > lValue) {
                            this.error("value is less than minimum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                        }
                    } else if (min != null) {
                        this.warning("could not compare with minimum (incompatible datatypes)", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                    }
                    if (max instanceof IntLiteral) {
                        long lMax = ((IntLiteral)max).getValue();
                        if (lMax >= lValue) continue;
                        this.error("value exceeds maximum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                        continue;
                    }
                    if (max == null) continue;
                    this.warning("could not compare with maximum (incompatible datatypes)", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                }
            }
        }
    }

    private void checkAttrConfigValue(EnumerationType enumType, AttrConfig config) {
        int attrMult;
        EList<ConfigValue> values = config.getValue().getValues();
        EReference valueRef = ConfigPackage.eINSTANCE.getAttrConfig_Value();
        EReference arrayRef = ConfigPackage.eINSTANCE.getConfigValueArray_Values();
        Attribute attribute = config.getAttribute();
        int n = attrMult = attribute.getSize() > 0 ? attribute.getSize() : 1;
        if (values.size() > attrMult) {
            this.error("too many values, multiplicity is " + attrMult, (EStructuralFeature)valueRef);
        }
        if (values.size() > 1 && values.size() < attrMult) {
            this.error("not enough values, multiplicity is " + attrMult, (EStructuralFeature)valueRef);
        }
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            ConfigValue configValue;
            ConfigValue value = configValue = (ConfigValue)iterator.next();
            if (configValue instanceof EnumConfigValue) {
                EnumConfigValue enumConfig = (EnumConfigValue)configValue;
                if (enumType != enumConfig.getType()) {
                    this.error("must be of type " + enumType.getName(), enumConfig, (EStructuralFeature)ConfigPackage.Literals.ENUM_CONFIG_VALUE__TYPE);
                }
                value = enumConfig.getValue();
            }
            if (enumType.getLiterals().contains((Object)value)) continue;
            this.error("must be of type " + enumType.getName(), config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
        }
    }

    private void checkAttrConfigMin(PrimitiveType primitive, AttrClassConfig config) {
        NumberLiteral min = config.getMin();
        if (min == null) {
            return;
        }
        EReference minRef = ConfigPackage.eINSTANCE.getAttrClassConfig_Min();
        LiteralType type = primitive.getType();
        if (!(type != LiteralType.INT && type != LiteralType.REAL || primitive.getType() != LiteralType.INT || min instanceof IntLiteral)) {
            this.error("incompatible datatype: maximum is not int", (EStructuralFeature)minRef);
        }
    }

    private void checkAttrConfigMax(PrimitiveType primitive, AttrClassConfig config) {
        NumberLiteral max = config.getMax();
        if (max == null) {
            return;
        }
        EReference maxRef = ConfigPackage.eINSTANCE.getAttrClassConfig_Max();
        LiteralType type = primitive.getType();
        if (!(type != LiteralType.INT && type != LiteralType.REAL || primitive.getType() != LiteralType.INT || max instanceof IntLiteral)) {
            this.error("incompatible datatype: maximum is not int", (EStructuralFeature)maxRef);
        }
    }

    private ConfigModel getConfigModel(EObject object) {
        EObject root = object;
        while (root.eContainer() != null) {
            root = root.eContainer();
        }
        return (ConfigModel)root;
    }

    private AttrClassConfig resolveAttrClassConfig(AttrInstanceConfig config) {
        ArrayList rootClassAttrConfigs;
        ArrayList<Attribute> path;
        block12: {
            ConfigModel model;
            AttrInstanceConfig source;
            block11: {
                path = new ArrayList<Attribute>();
                path.add(config.getAttribute());
                source = config;
                while (source.eContainer() instanceof AttrInstanceConfig) {
                    source = (AttrInstanceConfig)source.eContainer();
                    path.add(source.getAttribute());
                }
                Collections.reverse(path);
                model = this.getConfigModel(source);
                rootClassAttrConfigs = new ArrayList();
                if (!(source.eContainer() instanceof PortInstanceConfig)) break block11;
                PortInstanceConfig portInstanceConfig = (PortInstanceConfig)source.eContainer();
                GeneralProtocolClass generalProtocol = portInstanceConfig.getItem().getGeneralProtocol();
                PortClassConfig portClassConfig = null;
                if (generalProtocol instanceof ProtocolClass) {
                    ProtocolClass protocol = (ProtocolClass)generalProtocol;
                    for (ProtocolClassConfig cf : model.getProtocolClassConfigs()) {
                        if (!cf.getProtocol().equals(protocol)) continue;
                        if (protocol.getRegular().equals(this.configUtil.getPortClass(portInstanceConfig))) {
                            portClassConfig = cf.getRegular();
                            break;
                        }
                        portClassConfig = cf.getConjugated();
                        break;
                    }
                }
                if (portClassConfig == null) break block12;
                rootClassAttrConfigs = portClassConfig.getAttributes();
                break block12;
            }
            if (source.eContainer() instanceof ActorInstanceConfig) {
                ActorInstanceConfig aiConfig = (ActorInstanceConfig)source.eContainer();
                ActorClass actor = this.configUtil.getLastActorRef((ActorContainerClass)aiConfig.getSubSystem().getType(), aiConfig.getPath()).getType();
                for (ActorClassConfig cf : model.getActorClassConfigs()) {
                    if (!cf.getActor().equals(actor)) continue;
                    rootClassAttrConfigs = cf.getAttributes();
                    break;
                }
            }
        }
        AttrClassConfig target = null;
        for (AttrClassConfig c : rootClassAttrConfigs) {
            if (!c.getAttribute().equals(path.get(0))) continue;
            target = c;
        }
        if (target != null) {
            path.remove(0);
            for (Attribute a : path) {
                AttrClassConfig match = null;
                for (AttrClassConfig c : target.getAttributes()) {
                    if (!c.getAttribute().equals(a)) continue;
                    match = c;
                    break;
                }
                if (match == null) {
                    return null;
                }
                target = match;
            }
        }
        return target;
    }
}

