/**
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 		Thomas Schuetz (changed for C code generator)
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class DataClassGen {
  @Inject
  private IGeneratorFileIo fileIO;
  
  @Inject
  @Extension
  private RoomHelpers _roomHelpers;
  
  @Inject
  @Extension
  private CExtensions _cExtensions;
  
  @Inject
  @Extension
  private RoomExtensions _roomExtensions;
  
  @Inject
  @Extension
  private ProcedureHelpers _procedureHelpers;
  
  @Inject
  private ILogger logger;
  
  public void doGenerate(final Root root) {
    EList<DataClass> _usedDataClasses = root.getUsedDataClasses();
    for (final DataClass dc : _usedDataClasses) {
      {
        String _generationTargetPath = this._roomExtensions.getGenerationTargetPath(dc);
        String _path = this._roomExtensions.getPath(dc);
        final String path = (_generationTargetPath + _path);
        String _generationInfoPath = this._roomExtensions.getGenerationInfoPath(dc);
        String _path_1 = this._roomExtensions.getPath(dc);
        final String infopath = (_generationInfoPath + _path_1);
        String file = this._cExtensions.getCHeaderFileName(dc);
        CharSequence _generateHeaderFile = this.generateHeaderFile(root, dc);
        this.fileIO.generateFile("generating DataClass header", path, infopath, file, _generateHeaderFile);
        String _cUtilsFileName = this._cExtensions.getCUtilsFileName(dc);
        file = _cUtilsFileName;
        CharSequence _generateUtilsFile = this.generateUtilsFile(root, dc);
        this.fileIO.generateFile("generating ProtocolClass utils", path, infopath, file, _generateUtilsFile);
        String _cSourceFileName = this._cExtensions.getCSourceFileName(dc);
        file = _cSourceFileName;
        CharSequence _generateSourceFile = this.generateSourceFile(root, dc);
        this.fileIO.generateFile("generating DataClass header", path, infopath, file, _generateSourceFile);
      }
    }
  }
  
  public CharSequence generateHeaderFile(final Root root, final DataClass dc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Header File of DataClass ");
    String _name = dc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(dc);
    _builder.append(_generateIncludeGuardBegin, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"etDatatypes.h\"");
    _builder.newLine();
    _builder.newLine();
    {
      EList<DataClass> _referencedDataClasses = root.getReferencedDataClasses(dc);
      for(final DataClass dataClass : _referencedDataClasses) {
        _builder.append("#include ");
        String _includePath = this._cExtensions.getIncludePath(dataClass);
        _builder.append(_includePath, "");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<EnumerationType> _referencedEnumClasses = root.getReferencedEnumClasses(dc);
      for(final EnumerationType enumClass : _referencedEnumClasses) {
        _builder.append("#include ");
        String _includePath_1 = this._cExtensions.getIncludePath(enumClass);
        _builder.append(_includePath_1, "");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(dc, 1);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("typedef struct {");
    _builder.newLine();
    _builder.append("\t");
    List<Attribute> _allAttributes = this._roomHelpers.getAllAttributes(dc);
    CharSequence _attributes = this._procedureHelpers.attributes(_allAttributes);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("} ");
    String _name_1 = dc.getName();
    _builder.append(_name_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      List<Attribute> _allAttributes_1 = this._roomHelpers.getAllAttributes(dc);
      for(final Attribute a : _allAttributes_1) {
        {
          String _defaultValueLiteral = a.getDefaultValueLiteral();
          boolean _notEquals = (!Objects.equal(_defaultValueLiteral, null));
          if (_notEquals) {
            String _name_2 = dc.getName();
            String _plus = (_name_2 + " ");
            String _name_3 = a.getName();
            String _plus_1 = (_plus + _name_3);
            String _plus_2 = (_plus_1 + ": Attribute initialization not supported in C");
            this.logger.logInfo(_plus_2);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    _builder.newLine();
    EList<StandardOperation> _operations = dc.getOperations();
    String _name_4 = dc.getName();
    CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration(_operations, _name_4);
    _builder.append(_operationsDeclaration, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/* deep copy */");
    _builder.newLine();
    _builder.append("void ");
    String _name_5 = dc.getName();
    _builder.append(_name_5, "");
    _builder.append("_deepCopy(");
    String _name_6 = dc.getName();
    _builder.append(_name_6, "");
    _builder.append("* source, ");
    String _name_7 = dc.getName();
    _builder.append(_name_7, "");
    _builder.append("* target);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _userCode_1 = this._procedureHelpers.userCode(dc, 2);
    _builder.append(_userCode_1, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(dc);
    _builder.append(_generateIncludeGuardEnd, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  private CharSequence generateUtilsFile(final Root root, final DataClass dc) {
    CharSequence _xblockexpression = null;
    {
      EObject _eContainer = dc.eContainer();
      String _name = ((RoomModel) _eContainer).getName();
      String _replaceAll = _name.replaceAll("\\.", "_");
      String _plus = (_replaceAll + "_");
      String _name_1 = dc.getName();
      String _plus_1 = (_plus + _name_1);
      final String filename = (_plus_1 + "_Utils");
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* @author generated by eTrice");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Utils File of DataClass ");
      String _name_2 = dc.getName();
      _builder.append(_name_2, " ");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* ");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.newLine();
      CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(filename);
      _builder.append(_generateIncludeGuardBegin, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("#include ");
      String _includePath = this._cExtensions.getIncludePath(dc);
      _builder.append(_includePath, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* access macros for operations and attributes");
      _builder.newLine();
      _builder.append("*/");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/* operations */");
      _builder.newLine();
      {
        List<StandardOperation> _allOperations = this._roomHelpers.getAllOperations(dc);
        for(final StandardOperation op : _allOperations) {
          final CharSequence args = this.argList(op);
          _builder.newLineIfNotEmpty();
          _builder.append("#define ");
          String _name_3 = op.getName();
          _builder.append(_name_3, "");
          _builder.append("(");
          _builder.append(args, "");
          _builder.append(") ");
          String _name_4 = dc.getName();
          _builder.append(_name_4, "");
          _builder.append("_");
          String _name_5 = op.getName();
          _builder.append(_name_5, "");
          _builder.append("(self");
          {
            EList<VarDecl> _arguments = op.getArguments();
            boolean _isEmpty = _arguments.isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              _builder.append(", ");
              _builder.append(args, "");
            }
          }
          _builder.append(")");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("/* attributes */");
      _builder.newLine();
      {
        List<Attribute> _allAttributes = this._roomHelpers.getAllAttributes(dc);
        for(final Attribute a : _allAttributes) {
          _builder.append("#define ");
          String _name_6 = a.getName();
          _builder.append(_name_6, "");
          _builder.append(" (self->");
          String _name_7 = a.getName();
          _builder.append(_name_7, "");
          _builder.append(")");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(filename);
      _builder.append(_generateIncludeGuardEnd, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private CharSequence argList(final Operation op) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<VarDecl> _arguments = op.getArguments();
      boolean _hasElements = false;
      for(final VarDecl a : _arguments) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _name = a.getName();
        _builder.append(_name, "");
      }
    }
    return _builder;
  }
  
  public CharSequence generateSourceFile(final Root root, final DataClass dc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Source File of DataClass ");
    String _name = dc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <string.h>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _cHeaderFileName = this._cExtensions.getCHeaderFileName(dc);
    _builder.append(_cHeaderFileName, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _cUtilsFileName = this._cExtensions.getCUtilsFileName(dc);
    _builder.append(_cUtilsFileName, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(dc, 3);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    EList<StandardOperation> _operations = dc.getOperations();
    String _name_1 = dc.getName();
    CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(_operations, _name_1);
    _builder.append(_operationsImplementation, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("void ");
    String _name_2 = dc.getName();
    _builder.append(_name_2, "");
    _builder.append("_deepCopy(");
    String _name_3 = dc.getName();
    _builder.append(_name_3, "");
    _builder.append("* source, ");
    String _name_4 = dc.getName();
    _builder.append(_name_4, "");
    _builder.append("* target) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("memcpy(target, source, sizeof(");
    String _name_5 = dc.getName();
    _builder.append(_name_5, "\t");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
}
