/**
 * Copyright (c) 2013 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * @author Henrik Rentz-Reichert
 */
@SuppressWarnings("all")
public class EnumerationTypeGen {
  @Inject
  private IGeneratorFileIo fileIO;
  
  @Inject
  @Extension
  private CExtensions _cExtensions;
  
  @Inject
  @Extension
  private RoomExtensions _roomExtensions;
  
  @Inject
  @Extension
  private TypeHelpers _typeHelpers;
  
  public void doGenerate(final Root root) {
    EList<EnumerationType> _usedEnumClasses = root.getUsedEnumClasses();
    for (final EnumerationType et : _usedEnumClasses) {
      {
        String _generationTargetPath = this._roomExtensions.getGenerationTargetPath(et);
        String _path = this._roomExtensions.getPath(et);
        final String path = (_generationTargetPath + _path);
        String _generationInfoPath = this._roomExtensions.getGenerationInfoPath(et);
        String _path_1 = this._roomExtensions.getPath(et);
        final String infopath = (_generationInfoPath + _path_1);
        String file = this._cExtensions.getCHeaderFileName(et);
        CharSequence _generateHeaderFile = this.generateHeaderFile(root, et);
        this.fileIO.generateFile("generating Enumeration header", path, infopath, file, _generateHeaderFile);
        String _cSourceFileName = this._cExtensions.getCSourceFileName(et);
        file = _cSourceFileName;
        CharSequence _generateSourceFile = this.generateSourceFile(root, et);
        this.fileIO.generateFile("generating Enumeration source", path, infopath, file, _generateSourceFile);
      }
    }
  }
  
  private CharSequence generateHeaderFile(final Root root, final EnumerationType et) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Header File of Enumeration ");
    String _name = et.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(et);
    _builder.append(_generateIncludeGuardBegin, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"etDatatypes.h\"");
    _builder.newLine();
    _builder.newLine();
    {
      PrimitiveType _primitiveType = et.getPrimitiveType();
      boolean _notEquals = (!Objects.equal(_primitiveType, null));
      if (_notEquals) {
        {
          EList<EnumLiteral> _literals = et.getLiterals();
          for(final EnumLiteral lit : _literals) {
            _builder.append("#define ");
            String _name_1 = et.getName();
            _builder.append(_name_1, "");
            _builder.append("_");
            String _name_2 = lit.getName();
            _builder.append(_name_2, "");
            _builder.append(" ");
            String _castedValue = this._cExtensions.getCastedValue(lit);
            _builder.append(_castedValue, "");
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        _builder.append("typedef enum ");
        String _name_3 = et.getName();
        _builder.append(_name_3, "");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        {
          EList<EnumLiteral> _literals_1 = et.getLiterals();
          boolean _hasElements = false;
          for(final EnumLiteral lit_1 : _literals_1) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "\t");
            }
            _builder.append("\t");
            String _name_4 = et.getName();
            _builder.append(_name_4, "\t");
            _builder.append("_");
            String _name_5 = lit_1.getName();
            _builder.append(_name_5, "\t");
            _builder.append(" = ");
            long _literalValue = lit_1.getLiteralValue();
            _builder.append(_literalValue, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
        String _name_6 = et.getName();
        _builder.append(_name_6, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("const char* ");
    String _name_7 = et.getName();
    _builder.append(_name_7, "");
    _builder.append("_getLiteralName(");
    String _typeName = this._typeHelpers.typeName(et);
    _builder.append(_typeName, "");
    _builder.append(" literal);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(et);
    _builder.append(_generateIncludeGuardEnd, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  private CharSequence generateSourceFile(final Root root, final EnumerationType et) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Source File of ProtocolClass ");
    String _name = et.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _cHeaderFileName = this._cExtensions.getCHeaderFileName(et);
    _builder.append(_cHeaderFileName, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("const char* ");
    String _name_1 = et.getName();
    _builder.append(_name_1, "");
    _builder.append("_getLiteralName(");
    String _typeName = this._typeHelpers.typeName(et);
    _builder.append(_typeName, "");
    _builder.append(" literal) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("switch(literal) {");
    _builder.newLine();
    {
      EList<EnumLiteral> _literals = et.getLiterals();
      for(final EnumLiteral lit : _literals) {
        _builder.append("\t\t");
        _builder.append("case ");
        String _name_2 = et.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append("_");
        String _name_3 = lit.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append(": return \"");
        String _name_4 = lit.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return NULL;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
}
