/**
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 		Thomas Schuetz (changed for C code generator)
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class ProtocolClassGen extends GenericProtocolClassGenerator {
  @Inject
  private IGeneratorFileIo fileIO;
  
  @Inject
  @Extension
  private CExtensions _cExtensions;
  
  @Inject
  @Extension
  private RoomExtensions _roomExtensions;
  
  @Inject
  @Extension
  private ProcedureHelpers _procedureHelpers;
  
  @Inject
  @Extension
  private TypeHelpers _typeHelpers;
  
  @Inject
  private ILogger logger;
  
  public void doGenerate(final Root root) {
    EList<ProtocolClass> _usedProtocolClasses = root.getUsedProtocolClasses();
    for (final ProtocolClass pc : _usedProtocolClasses) {
      {
        String _generationTargetPath = this._roomExtensions.getGenerationTargetPath(pc);
        String _path = this._roomExtensions.getPath(pc);
        final String path = (_generationTargetPath + _path);
        String _generationInfoPath = this._roomExtensions.getGenerationInfoPath(pc);
        String _path_1 = this._roomExtensions.getPath(pc);
        final String infopath = (_generationInfoPath + _path_1);
        String file = this._cExtensions.getCHeaderFileName(pc);
        CharSequence _generateHeaderFile = this.generateHeaderFile(root, pc);
        this.fileIO.generateFile("generating ProtocolClass header", path, infopath, file, _generateHeaderFile);
        String _cUtilsFileName = this._cExtensions.getCUtilsFileName(pc);
        file = _cUtilsFileName;
        CharSequence _generateUtilsFile = this.generateUtilsFile(root, pc);
        this.fileIO.generateFile("generating ProtocolClass utils", path, infopath, file, _generateUtilsFile);
        String _cSourceFileName = this._cExtensions.getCSourceFileName(pc);
        file = _cSourceFileName;
        CharSequence _generateSourceFile = this.generateSourceFile(root, pc);
        this.fileIO.generateFile("generating ProtocolClass source", path, infopath, file, _generateSourceFile);
      }
    }
  }
  
  private CharSequence generateHeaderFile(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Header File of ProtocolClass ");
    String _name = pc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(pc);
    _builder.append(_generateIncludeGuardBegin, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"etDatatypes.h\"");
    _builder.newLine();
    _builder.append("#include \"modelbase/etPort.h\"");
    _builder.newLine();
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<ProtocolClass> _referencedProtocolClasses = root.getReferencedProtocolClasses(pc);
      for(final ProtocolClass protocolClass : _referencedProtocolClasses) {
        _builder.append("#include ");
        String _includePath = this._cExtensions.getIncludePath(protocolClass);
        _builder.append(_includePath, "");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<DataClass> _referencedDataClasses = root.getReferencedDataClasses(pc);
      for(final DataClass dataClass : _referencedDataClasses) {
        _builder.append("#include ");
        String _includePath_1 = this._cExtensions.getIncludePath(dataClass);
        _builder.append(_includePath_1, "");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<EnumerationType> _referencedEnumClasses = root.getReferencedEnumClasses(pc);
      for(final EnumerationType enumClass : _referencedEnumClasses) {
        _builder.append("#include ");
        String _includePath_2 = this._cExtensions.getIncludePath(enumClass);
        _builder.append(_includePath_2, "");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      CommunicationType _commType = pc.getCommType();
      boolean _equals = Objects.equal(_commType, CommunicationType.EVENT_DRIVEN);
      if (_equals) {
        _builder.newLine();
        _builder.append("/* message IDs */");
        _builder.newLine();
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append(_genMessageIDs, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*--------------------- port structs and methods */");
        _builder.newLine();
        CharSequence _portClassHeader = this.portClassHeader(pc, Boolean.valueOf(false));
        _builder.append(_portClassHeader, "");
        _builder.newLineIfNotEmpty();
        CharSequence _portClassHeader_1 = this.portClassHeader(pc, Boolean.valueOf(true));
        _builder.append(_portClassHeader_1, "");
        _builder.newLineIfNotEmpty();
      } else {
        CommunicationType _commType_1 = pc.getCommType();
        boolean _equals_1 = Objects.equal(_commType_1, CommunicationType.DATA_DRIVEN);
        if (_equals_1) {
          _builder.append("/*--------------------- port structs and methods */");
          _builder.newLine();
          CharSequence _genDataDrivenPortHeaders = this.genDataDrivenPortHeaders(pc);
          _builder.append(_genDataDrivenPortHeaders, "");
          _builder.newLineIfNotEmpty();
        } else {
          CommunicationType _commType_2 = pc.getCommType();
          boolean _equals_2 = Objects.equal(_commType_2, CommunicationType.SYNCHRONOUS);
          if (_equals_2) {
            _builder.append("#error \"synchronoue protocols not implemented yet\"");
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    {
      GlobalGeneratorSettings _settings = Main.getSettings();
      boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
      if (_isGenerateMSCInstrumentation) {
        _builder.append("/*--------------------- debug helpers */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* get message string for message id */");
        _builder.newLine();
        _builder.append("const char* ");
        String _name_1 = pc.getName();
        _builder.append(_name_1, "");
        _builder.append("_getMessageString(int msg_id);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
    _builder.append(_userCode_1, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(pc);
    _builder.append(_generateIncludeGuardEnd, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  private CharSequence generateUtilsFile(final Root root, final ProtocolClass pc) {
    CharSequence _xblockexpression = null;
    {
      EObject _eContainer = pc.eContainer();
      String _name = ((RoomModel) _eContainer).getName();
      String _replaceAll = _name.replaceAll("\\.", "_");
      String _plus = (_replaceAll + "_");
      String _name_1 = pc.getName();
      String _plus_1 = (_plus + _name_1);
      final String filename = (_plus_1 + "_Utils");
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* @author generated by eTrice");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Utils File of ProtocolClass ");
      String _name_2 = pc.getName();
      _builder.append(_name_2, " ");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* ");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.newLine();
      CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(filename);
      _builder.append(_generateIncludeGuardBegin, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("#include ");
      String _includePath = this._cExtensions.getIncludePath(pc);
      _builder.append(_includePath, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* access macros for operations and attributes");
      _builder.newLine();
      _builder.append("*/");
      _builder.newLine();
      _builder.newLine();
      CharSequence _generateUtilsFile = this.generateUtilsFile(pc, false);
      _builder.append(_generateUtilsFile, "");
      _builder.newLineIfNotEmpty();
      CharSequence _generateUtilsFile_1 = this.generateUtilsFile(pc, true);
      _builder.append(_generateUtilsFile_1, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(filename);
      _builder.append(_generateIncludeGuardEnd, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private CharSequence generateUtilsFile(final ProtocolClass pc, final boolean conj) {
    CharSequence _xblockexpression = null;
    {
      final PortClass portClass = this._roomExtensions.getPortClass(pc, conj);
      final String portClassName = this._roomExtensions.getPortClassName(pc, conj);
      StringConcatenation _builder = new StringConcatenation();
      {
        boolean _notEquals = (!Objects.equal(portClass, null));
        if (_notEquals) {
          _builder.append("/* ");
          {
            if (conj) {
              _builder.append("conjugate");
            } else {
              _builder.append("regular");
            }
          }
          _builder.append(" port class */");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("/* operations */");
          _builder.newLine();
          {
            EList<PortOperation> _operations = portClass.getOperations();
            for(final PortOperation op : _operations) {
              final CharSequence args = this.argList(op);
              _builder.newLineIfNotEmpty();
              _builder.append("#define ");
              String _name = op.getName();
              _builder.append(_name, "");
              _builder.append("(");
              _builder.append(args, "");
              _builder.append(") ");
              _builder.append(portClassName, "");
              _builder.append("_");
              String _name_1 = op.getName();
              _builder.append(_name_1, "");
              _builder.append("(self");
              {
                EList<VarDecl> _arguments = op.getArguments();
                boolean _isEmpty = _arguments.isEmpty();
                boolean _not = (!_isEmpty);
                if (_not) {
                  _builder.append(", ");
                  _builder.append(args, "");
                }
              }
              _builder.append(")");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.newLine();
          _builder.append("/* attributes */");
          _builder.newLine();
          {
            EList<Attribute> _attributes = portClass.getAttributes();
            for(final Attribute a : _attributes) {
              _builder.append("#define ");
              String _name_2 = a.getName();
              _builder.append(_name_2, "");
              _builder.append(" (((");
              _builder.append(portClassName, "");
              _builder.append("_var*)(self->varData))->");
              String _name_3 = a.getName();
              _builder.append(_name_3, "");
              _builder.append(")");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private CharSequence argList(final Operation op) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<VarDecl> _arguments = op.getArguments();
      boolean _hasElements = false;
      for(final VarDecl a : _arguments) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _name = a.getName();
        _builder.append(_name, "");
      }
    }
    return _builder;
  }
  
  private CharSequence generateSourceFile(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Source File of ProtocolClass ");
    String _name = pc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _cHeaderFileName = this._cExtensions.getCHeaderFileName(pc);
    _builder.append(_cHeaderFileName, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"debugging/etMSCLogger.h\"");
    _builder.newLine();
    _builder.append("#include \"");
    String _cUtilsFileName = this._cExtensions.getCUtilsFileName(pc);
    _builder.append(_cUtilsFileName, "");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _userCode = this._procedureHelpers.userCode(pc, 3);
    _builder.append(_userCode, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/*--------------------- port methods */");
    _builder.newLine();
    {
      CommunicationType _commType = pc.getCommType();
      boolean _equals = Objects.equal(_commType, CommunicationType.EVENT_DRIVEN);
      if (_equals) {
        CharSequence _portClassSource = this.portClassSource(pc, Boolean.valueOf(false));
        _builder.append(_portClassSource, "");
        _builder.newLineIfNotEmpty();
        CharSequence _portClassSource_1 = this.portClassSource(pc, Boolean.valueOf(true));
        _builder.append(_portClassSource_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        {
          GlobalGeneratorSettings _settings = Main.getSettings();
          boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
          if (_isGenerateMSCInstrumentation) {
            _builder.append("/*--------------------- debug helpers */");
            _builder.newLine();
            CharSequence _generateDebugHelpersImplementation = this.generateDebugHelpersImplementation(root, pc);
            _builder.append(_generateDebugHelpersImplementation, "");
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        CommunicationType _commType_1 = pc.getCommType();
        boolean _equals_1 = Objects.equal(_commType_1, CommunicationType.DATA_DRIVEN);
        if (_equals_1) {
          CharSequence _genDataDrivenPortSources = this.genDataDrivenPortSources(pc);
          _builder.append(_genDataDrivenPortSources, "");
          _builder.newLineIfNotEmpty();
        } else {
          CommunicationType _commType_2 = pc.getCommType();
          boolean _equals_2 = Objects.equal(_commType_2, CommunicationType.SYNCHRONOUS);
          if (_equals_2) {
            _builder.append("#error \"synchronous protocols not implemented yet\"");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  private CharSequence portClassHeader(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      String portClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue());
      String replPortClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue(), true);
      List<Message> _xifexpression = null;
      if ((conj).booleanValue()) {
        _xifexpression = this._roomHelpers.getAllIncomingMessages(pc);
      } else {
        _xifexpression = this._roomHelpers.getAllOutgoingMessages(pc);
      }
      List<Message> messages = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("typedef etPort ");
      _builder.append(portClassName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("typedef etReplPort ");
      _builder.append(replPortClassName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        PortClass _portClass = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
        boolean _notEquals = (!Objects.equal(_portClass, null));
        if (_notEquals) {
          {
            PortClass _portClass_1 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
            EList<Attribute> _attributes = _portClass_1.getAttributes();
            boolean _isEmpty = _attributes.isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              _builder.append("/* variable part of PortClass (RAM) */");
              _builder.newLine();
              _builder.append("typedef struct ");
              _builder.append(portClassName, "");
              _builder.append("_var ");
              _builder.append(portClassName, "");
              _builder.append("_var; ");
              _builder.newLineIfNotEmpty();
              _builder.append("struct ");
              _builder.append(portClassName, "");
              _builder.append("_var {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              PortClass _portClass_2 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
              EList<Attribute> _attributes_1 = _portClass_2.getAttributes();
              CharSequence _attributes_2 = this._procedureHelpers.attributes(_attributes_1);
              _builder.append(_attributes_2, "\t");
              _builder.newLineIfNotEmpty();
              _builder.append("};");
              _builder.newLine();
              {
                PortClass _portClass_3 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
                EList<Attribute> _attributes_3 = _portClass_3.getAttributes();
                for(final Attribute a : _attributes_3) {
                  {
                    String _defaultValueLiteral = a.getDefaultValueLiteral();
                    boolean _notEquals_1 = (!Objects.equal(_defaultValueLiteral, null));
                    if (_notEquals_1) {
                      String _name = a.getName();
                      String _plus = ((portClassName + " ") + _name);
                      String _plus_1 = (_plus + ": Attribute initialization not supported in C");
                      this.logger.logInfo(_plus_1);
                      _builder.newLineIfNotEmpty();
                    }
                  }
                }
              }
            }
          }
        }
      }
      _builder.newLine();
      {
        for(final Message message : messages) {
          VarDecl _data = message.getData();
          boolean hasData = (!Objects.equal(_data, null));
          _builder.newLineIfNotEmpty();
          String _xifexpression_1 = null;
          if (hasData) {
            VarDecl _data_1 = message.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            _xifexpression_1 = this._typeHelpers.typeName(_type);
          } else {
            _xifexpression_1 = "";
          }
          String typeName = _xifexpression_1;
          _builder.newLineIfNotEmpty();
          String _xifexpression_2 = null;
          boolean _and = false;
          if (!hasData) {
            _and = false;
          } else {
            boolean _or = false;
            VarDecl _data_2 = message.getData();
            RefableType _refType_1 = _data_2.getRefType();
            DataType _type_1 = _refType_1.getType();
            boolean _isEnumerationOrPrimitive = this._typeHelpers.isEnumerationOrPrimitive(_type_1);
            boolean _not_1 = (!_isEnumerationOrPrimitive);
            if (_not_1) {
              _or = true;
            } else {
              VarDecl _data_3 = message.getData();
              RefableType _refType_2 = _data_3.getRefType();
              boolean _isRef = _refType_2.isRef();
              _or = _isRef;
            }
            _and = _or;
          }
          if (_and) {
            _xifexpression_2 = "*";
          } else {
            _xifexpression_2 = "";
          }
          String refp = _xifexpression_2;
          _builder.newLineIfNotEmpty();
          String _xifexpression_3 = null;
          if (hasData) {
            _xifexpression_3 = (((", " + typeName) + refp) + " data");
          } else {
            _xifexpression_3 = "";
          }
          String data = _xifexpression_3;
          _builder.newLineIfNotEmpty();
          String _name_1 = message.getName();
          String _messageSignature = this.messageSignature(portClassName, _name_1, "", data);
          _builder.append(_messageSignature, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          String _name_2 = message.getName();
          String _messageSignature_1 = this.messageSignature(replPortClassName, _name_2, "_broadcast", data);
          _builder.append(_messageSignature_1, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          String _name_3 = message.getName();
          String _messageSignature_2 = this.messageSignature(replPortClassName, _name_3, "", (", int idx" + data));
          _builder.append(_messageSignature_2, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      {
        PortClass _portClass_4 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
        boolean _notEquals_2 = (!Objects.equal(_portClass_4, null));
        if (_notEquals_2) {
          PortClass _portClass_5 = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
          EList<PortOperation> _operations = _portClass_5.getOperations();
          CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration(_operations, portClassName);
          _builder.append(_operationsDeclaration, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      {
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, (conj).booleanValue());
        if (_handlesReceive) {
          {
            List<MessageHandler> _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, (conj).booleanValue());
            for(final MessageHandler h : _receiveHandlers) {
              _builder.append("void ");
              _builder.append(portClassName, "");
              _builder.append("_");
              Message _msg = h.getMsg();
              String _name_4 = _msg.getName();
              _builder.append(_name_4, "");
              _builder.append("_receiveHandler(");
              _builder.append(portClassName, "");
              _builder.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc);");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("etInt32 ");
      _builder.append(replPortClassName, "");
      _builder.append("_getReplication(const ");
      _builder.append(replPortClassName, "");
      _builder.append("* self);");
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private CharSequence genDataDrivenPortHeaders(final ProtocolClass pc) {
    CharSequence _xblockexpression = null;
    {
      List<Message> _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
      final Function1<Message, Boolean> _function = new Function1<Message, Boolean>() {
        public Boolean apply(final Message m) {
          VarDecl _data = m.getData();
          return Boolean.valueOf((!Objects.equal(_data, null)));
        }
      };
      Iterable<Message> sentMsgs = IterableExtensions.<Message>filter(_allIncomingMessages, _function);
      final Function1<Message, Boolean> _function_1 = new Function1<Message, Boolean>() {
        public Boolean apply(final Message m) {
          VarDecl _data = m.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          return Boolean.valueOf(ProtocolClassGen.this._typeHelpers.isEnumeration(_type));
        }
      };
      final Iterable<Message> enumMsgs = IterableExtensions.<Message>filter(sentMsgs, _function_1);
      final Function1<Message, Boolean> _function_2 = new Function1<Message, Boolean>() {
        public Boolean apply(final Message m) {
          VarDecl _data = m.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          return Boolean.valueOf(ProtocolClassGen.this._typeHelpers.isBoolean(_type));
        }
      };
      final Iterable<Message> boolMsgs = IterableExtensions.<Message>filter(sentMsgs, _function_2);
      boolean _and = false;
      GlobalGeneratorSettings _settings = Main.getSettings();
      boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
      if (!_isGenerateMSCInstrumentation) {
        _and = false;
      } else {
        boolean _and_1 = false;
        boolean _isEmpty = IterableExtensions.isEmpty(enumMsgs);
        if (!_isEmpty) {
          _and_1 = false;
        } else {
          boolean _isEmpty_1 = IterableExtensions.isEmpty(boolMsgs);
          _and_1 = _isEmpty_1;
        }
        boolean _not = (!_and_1);
        _and = _not;
      }
      final boolean usesMSC = _and;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/* data driven send port (conjugated) */");
      _builder.newLine();
      _builder.append("typedef struct ");
      String _portClassName = this._roomExtensions.getPortClassName(pc, true);
      _builder.append(_portClassName, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      {
        for(final Message msg : sentMsgs) {
          _builder.append("\t");
          VarDecl _data = msg.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          String typeName = this._typeHelpers.typeName(_type);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _xifexpression = null;
          VarDecl _data_1 = msg.getData();
          RefableType _refType_1 = _data_1.getRefType();
          boolean _isRef = _refType_1.isRef();
          if (_isRef) {
            _xifexpression = "*";
          } else {
            _xifexpression = "";
          }
          String refp = _xifexpression;
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(typeName, "\t");
          _builder.append(refp, "\t");
          _builder.append(" ");
          String _name = msg.getName();
          _builder.append(_name, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        if (usesMSC) {
          _builder.append("\t");
          _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("const char* instName;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("const char** peerNames;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("#endif");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      String _portClassName_1 = this._roomExtensions.getPortClassName(pc, true);
      _builder.append(_portClassName_1, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/* data driven receive port (regular) */");
      _builder.newLine();
      _builder.append("typedef struct ");
      String _portClassName_2 = this._roomExtensions.getPortClassName(pc, false);
      _builder.append(_portClassName_2, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("const ");
      String _portClassName_3 = this._roomExtensions.getPortClassName(pc, true);
      _builder.append(_portClassName_3, "\t");
      _builder.append("* peer;");
      _builder.newLineIfNotEmpty();
      {
        if (usesMSC) {
          _builder.append("\t");
          _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("const char* instName;");
          _builder.newLine();
          {
            for(final Message msg_1 : enumMsgs) {
              _builder.append("\t");
              _builder.append("\t");
              VarDecl _data_2 = msg_1.getData();
              RefableType _refType_2 = _data_2.getRefType();
              DataType _type_1 = _refType_2.getType();
              String typeName_1 = this._typeHelpers.typeName(_type_1);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              String _xifexpression_1 = null;
              VarDecl _data_3 = msg_1.getData();
              RefableType _refType_3 = _data_3.getRefType();
              boolean _isRef_1 = _refType_3.isRef();
              if (_isRef_1) {
                _xifexpression_1 = "*";
              } else {
                _xifexpression_1 = "";
              }
              String refp_1 = _xifexpression_1;
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(typeName_1, "\t\t");
              _builder.append(refp_1, "\t\t");
              _builder.append(" ");
              String _name_1 = msg_1.getName();
              _builder.append(_name_1, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          {
            for(final Message msg_2 : boolMsgs) {
              _builder.append("\t");
              _builder.append("\t");
              VarDecl _data_4 = msg_2.getData();
              RefableType _refType_4 = _data_4.getRefType();
              DataType _type_2 = _refType_4.getType();
              String typeName_2 = this._typeHelpers.typeName(_type_2);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              String _xifexpression_2 = null;
              VarDecl _data_5 = msg_2.getData();
              RefableType _refType_5 = _data_5.getRefType();
              boolean _isRef_2 = _refType_5.isRef();
              if (_isRef_2) {
                _xifexpression_2 = "*";
              } else {
                _xifexpression_2 = "";
              }
              String refp_2 = _xifexpression_2;
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(typeName_2, "\t\t");
              _builder.append(refp_2, "\t\t");
              _builder.append(" ");
              String _name_2 = msg_2.getName();
              _builder.append(_name_2, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("#endif");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      String _portClassName_4 = this._roomExtensions.getPortClassName(pc, false);
      _builder.append(_portClassName_4, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        for(final Message message : sentMsgs) {
          VarDecl _data_6 = message.getData();
          boolean hasData = (!Objects.equal(_data_6, null));
          _builder.newLineIfNotEmpty();
          String _xifexpression_3 = null;
          if (hasData) {
            VarDecl _data_7 = message.getData();
            RefableType _refType_6 = _data_7.getRefType();
            DataType _type_3 = _refType_6.getType();
            _xifexpression_3 = this._typeHelpers.typeName(_type_3);
          } else {
            _xifexpression_3 = "";
          }
          String typeName_3 = _xifexpression_3;
          _builder.newLineIfNotEmpty();
          String _xifexpression_4 = null;
          boolean _and_2 = false;
          if (!hasData) {
            _and_2 = false;
          } else {
            VarDecl _data_8 = message.getData();
            RefableType _refType_7 = _data_8.getRefType();
            DataType _type_4 = _refType_7.getType();
            boolean _isEnumerationOrPrimitive = this._typeHelpers.isEnumerationOrPrimitive(_type_4);
            boolean _not_1 = (!_isEnumerationOrPrimitive);
            _and_2 = _not_1;
          }
          if (_and_2) {
            _xifexpression_4 = "*";
          } else {
            _xifexpression_4 = "";
          }
          String refp_3 = _xifexpression_4;
          _builder.newLineIfNotEmpty();
          String _xifexpression_5 = null;
          if (hasData) {
            _xifexpression_5 = (((", " + typeName_3) + refp_3) + " data");
          } else {
            _xifexpression_5 = "";
          }
          String data = _xifexpression_5;
          _builder.newLineIfNotEmpty();
          String _portClassName_5 = this._roomExtensions.getPortClassName(pc, true);
          String _name_3 = message.getName();
          String _messageSetterSignature = this.messageSetterSignature(_portClassName_5, _name_3, data);
          _builder.append(_messageSetterSignature, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          String _portClassName_6 = this._roomExtensions.getPortClassName(pc, false);
          String _name_4 = message.getName();
          String _messageGetterSignature = this.messageGetterSignature(_portClassName_6, _name_4, typeName_3);
          _builder.append(_messageGetterSignature, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private CharSequence genDataDrivenPortSources(final ProtocolClass pc) {
    CharSequence _xblockexpression = null;
    {
      List<Message> _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
      final Function1<Message, Boolean> _function = new Function1<Message, Boolean>() {
        public Boolean apply(final Message m) {
          VarDecl _data = m.getData();
          return Boolean.valueOf((!Objects.equal(_data, null)));
        }
      };
      Iterable<Message> messages = IterableExtensions.<Message>filter(_allIncomingMessages, _function);
      final Function1<Message, Boolean> _function_1 = new Function1<Message, Boolean>() {
        public Boolean apply(final Message m) {
          VarDecl _data = m.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          return Boolean.valueOf(ProtocolClassGen.this._typeHelpers.isEnumeration(_type));
        }
      };
      final Iterable<Message> enumMsgs = IterableExtensions.<Message>filter(messages, _function_1);
      final Function1<Message, Boolean> _function_2 = new Function1<Message, Boolean>() {
        public Boolean apply(final Message m) {
          VarDecl _data = m.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          return Boolean.valueOf(ProtocolClassGen.this._typeHelpers.isBoolean(_type));
        }
      };
      final Iterable<Message> boolMsgs = IterableExtensions.<Message>filter(messages, _function_2);
      boolean _and = false;
      GlobalGeneratorSettings _settings = Main.getSettings();
      boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
      if (!_isGenerateMSCInstrumentation) {
        _and = false;
      } else {
        boolean _and_1 = false;
        boolean _isEmpty = IterableExtensions.isEmpty(enumMsgs);
        if (!_isEmpty) {
          _and_1 = false;
        } else {
          boolean _isEmpty_1 = IterableExtensions.isEmpty(boolMsgs);
          _and_1 = _isEmpty_1;
        }
        boolean _not = (!_and_1);
        _and = _not;
      }
      final boolean usesMSC = _and;
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final Message message : messages) {
          VarDecl _data = message.getData();
          RefableType _refType = _data.getRefType();
          DataType _type = _refType.getType();
          String typeName = this._typeHelpers.typeName(_type);
          _builder.newLineIfNotEmpty();
          String _xifexpression = null;
          VarDecl _data_1 = message.getData();
          RefableType _refType_1 = _data_1.getRefType();
          DataType _type_1 = _refType_1.getType();
          boolean _isEnumerationOrPrimitive = this._typeHelpers.isEnumerationOrPrimitive(_type_1);
          boolean _not_1 = (!_isEnumerationOrPrimitive);
          if (_not_1) {
            _xifexpression = "*";
          } else {
            _xifexpression = "";
          }
          String refp = _xifexpression;
          _builder.newLineIfNotEmpty();
          String data = (((", " + typeName) + refp) + " data");
          _builder.newLineIfNotEmpty();
          String _portClassName = this._roomExtensions.getPortClassName(pc, true);
          String _name = message.getName();
          String _messageSetterSignature = this.messageSetterSignature(_portClassName, _name, data);
          _builder.append(_messageSetterSignature, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _and_2 = false;
            if (!usesMSC) {
              _and_2 = false;
            } else {
              final Function1<Message, Boolean> _function_3 = new Function1<Message, Boolean>() {
                public Boolean apply(final Message m) {
                  return Boolean.valueOf(Objects.equal(m, message));
                }
              };
              boolean _exists = IterableExtensions.<Message>exists(enumMsgs, _function_3);
              _and_2 = _exists;
            }
            if (_and_2) {
              _builder.append("\t");
              _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("{");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t");
              _builder.append("const char** peerName;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t");
              _builder.append("for (peerName=self->peerNames; *peerName!=NULL; ++peerName) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t\t");
              _builder.append("ET_MSC_LOGGER_ASYNC_OUT(self->instName, ");
              VarDecl _data_2 = message.getData();
              RefableType _refType_2 = _data_2.getRefType();
              DataType _type_2 = _refType_2.getType();
              String _name_1 = _type_2.getName();
              _builder.append(_name_1, "\t\t\t\t");
              _builder.append("_getLiteralName(data), *peerName)");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t\t\t");
              _builder.append("ET_MSC_LOGGER_ASYNC_IN(self->instName, ");
              VarDecl _data_3 = message.getData();
              RefableType _refType_3 = _data_3.getRefType();
              DataType _type_3 = _refType_3.getType();
              String _name_2 = _type_3.getName();
              _builder.append(_name_2, "\t\t\t\t");
              _builder.append("_getLiteralName(data), *peerName)");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("#endif");
              _builder.newLine();
            }
          }
          {
            boolean _and_3 = false;
            if (!usesMSC) {
              _and_3 = false;
            } else {
              final Function1<Message, Boolean> _function_4 = new Function1<Message, Boolean>() {
                public Boolean apply(final Message m) {
                  return Boolean.valueOf(Objects.equal(m, message));
                }
              };
              boolean _exists_1 = IterableExtensions.<Message>exists(boolMsgs, _function_4);
              _and_3 = _exists_1;
            }
            if (_and_3) {
              _builder.append("\t");
              _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("{");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t");
              _builder.append("const char** peerName;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t");
              _builder.append("for (peerName=self->peerNames; *peerName!=NULL; ++peerName) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t\t");
              _builder.append("ET_MSC_LOGGER_ASYNC_OUT(self->instName, data?\"true\":\"false\", *peerName)");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t\t");
              _builder.append("ET_MSC_LOGGER_ASYNC_IN(self->instName, data?\"true\":\"false\", *peerName)");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("#endif");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("self->");
          String _name_3 = message.getName();
          _builder.append(_name_3, "\t");
          _builder.append(" = ");
          _builder.append(refp, "\t");
          _builder.append("data;");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
          String _portClassName_1 = this._roomExtensions.getPortClassName(pc, false);
          String _name_4 = message.getName();
          String _messageGetterSignature = this.messageGetterSignature(_portClassName_1, _name_4, typeName);
          _builder.append(_messageGetterSignature, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("return self->peer->");
          String _name_5 = message.getName();
          _builder.append(_name_5, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private CharSequence portClassSource(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      final PortClass pclass = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
      final String portClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue());
      final String replPortClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue(), true);
      List<Message> _xifexpression = null;
      if ((conj).booleanValue()) {
        _xifexpression = this._roomHelpers.getAllIncomingMessages(pc);
      } else {
        _xifexpression = this._roomHelpers.getAllOutgoingMessages(pc);
      }
      final List<Message> messages = _xifexpression;
      String _xifexpression_1 = null;
      if ((conj).booleanValue()) {
        _xifexpression_1 = "IN_";
      } else {
        _xifexpression_1 = "OUT_";
      }
      final String dir = _xifexpression_1;
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final Message message : messages) {
          VarDecl _data = message.getData();
          boolean hasData = (!Objects.equal(_data, null));
          _builder.newLineIfNotEmpty();
          String _xifexpression_2 = null;
          if (hasData) {
            VarDecl _data_1 = message.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            _xifexpression_2 = this._typeHelpers.typeName(_type);
          } else {
            _xifexpression_2 = "";
          }
          String typeName = _xifexpression_2;
          _builder.newLineIfNotEmpty();
          String _xifexpression_3 = null;
          boolean _and = false;
          if (!hasData) {
            _and = false;
          } else {
            VarDecl _data_2 = message.getData();
            RefableType _refType_1 = _data_2.getRefType();
            boolean _isRef = _refType_1.isRef();
            _and = _isRef;
          }
          if (_and) {
            _xifexpression_3 = "*";
          } else {
            _xifexpression_3 = "";
          }
          String refp = _xifexpression_3;
          _builder.newLineIfNotEmpty();
          String _xifexpression_4 = null;
          boolean _and_1 = false;
          if (!hasData) {
            _and_1 = false;
          } else {
            boolean _or = false;
            VarDecl _data_3 = message.getData();
            RefableType _refType_2 = _data_3.getRefType();
            DataType _type_1 = _refType_2.getType();
            boolean _isEnumerationOrPrimitive = this._typeHelpers.isEnumerationOrPrimitive(_type_1);
            boolean _not = (!_isEnumerationOrPrimitive);
            if (_not) {
              _or = true;
            } else {
              VarDecl _data_4 = message.getData();
              RefableType _refType_3 = _data_4.getRefType();
              boolean _isRef_1 = _refType_3.isRef();
              _or = _isRef_1;
            }
            _and_1 = _or;
          }
          if (_and_1) {
            _xifexpression_4 = "*";
          } else {
            _xifexpression_4 = "";
          }
          String refpd = _xifexpression_4;
          _builder.newLineIfNotEmpty();
          String _xifexpression_5 = null;
          boolean _and_2 = false;
          boolean _and_3 = false;
          if (!hasData) {
            _and_3 = false;
          } else {
            VarDecl _data_5 = message.getData();
            RefableType _refType_4 = _data_5.getRefType();
            DataType _type_2 = _refType_4.getType();
            boolean _isEnumerationOrPrimitive_1 = this._typeHelpers.isEnumerationOrPrimitive(_type_2);
            boolean _not_1 = (!_isEnumerationOrPrimitive_1);
            _and_3 = _not_1;
          }
          if (!_and_3) {
            _and_2 = false;
          } else {
            VarDecl _data_6 = message.getData();
            RefableType _refType_5 = _data_6.getRefType();
            boolean _isRef_2 = _refType_5.isRef();
            boolean _not_2 = (!_isRef_2);
            _and_2 = _not_2;
          }
          if (_and_2) {
            _xifexpression_5 = "";
          } else {
            _xifexpression_5 = "&";
          }
          String refa = _xifexpression_5;
          _builder.newLineIfNotEmpty();
          String _xifexpression_6 = null;
          if (hasData) {
            _xifexpression_6 = (((", " + typeName) + refpd) + " data__et");
          } else {
            _xifexpression_6 = "";
          }
          String data = _xifexpression_6;
          _builder.newLineIfNotEmpty();
          String _xifexpression_7 = null;
          if (hasData) {
            _xifexpression_7 = ", data__et";
          } else {
            _xifexpression_7 = "";
          }
          String dataCall = _xifexpression_7;
          _builder.newLineIfNotEmpty();
          MessageHandler hdlr = this._roomExtensions.getSendHandler(message, (conj).booleanValue());
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          String _name = message.getName();
          String _messageSignature = this.messageSignature(portClassName, _name, "", data);
          _builder.append(_messageSignature, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _notEquals = (!Objects.equal(hdlr, null));
            if (_notEquals) {
              _builder.append("\t");
              AbstractGenerator _instance = AbstractGenerator.getInstance();
              DetailCode _detailCode = hdlr.getDetailCode();
              String _translatedCode = _instance.getTranslatedCode(_detailCode);
              _builder.append(_translatedCode, "\t");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
              _builder.append(portClassName, "\t");
              _builder.append("\", \"");
              String _name_1 = message.getName();
              _builder.append(_name_1, "\t");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              String _name_2 = pc.getName();
              String _name_3 = message.getName();
              String _plus = (dir + _name_3);
              String _memberInUse = this._cExtensions.memberInUse(_name_2, _plus);
              String _sendMessageCall = this.sendMessageCall(hasData, "self", _memberInUse, (typeName + refp), (refa + "data__et"));
              _builder.append(_sendMessageCall, "\t\t");
              _builder.newLineIfNotEmpty();
              {
                GlobalGeneratorSettings _settings = Main.getSettings();
                boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
                if (_isGenerateMSCInstrumentation) {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("ET_MSC_LOGGER_ASYNC_OUT(self->myInstName, \"");
                  String _name_4 = message.getName();
                  _builder.append(_name_4, "\t\t");
                  _builder.append("\", self->peerInstName)");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          String _name_5 = message.getName();
          String _messageSignature_1 = this.messageSignature(replPortClassName, _name_5, "_broadcast", data);
          _builder.append(_messageSignature_1, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _notEquals_1 = (!Objects.equal(hdlr, null));
            if (_notEquals_1) {
              _builder.append("\t");
              _builder.append("int i;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(portClassName, "\t\t");
              _builder.append("_");
              String _name_6 = message.getName();
              _builder.append(_name_6, "\t\t");
              _builder.append("(&((etReplPort*)self)->ports[i].port");
              _builder.append(dataCall, "\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}\t\t\t\t\t");
              _builder.newLine();
            } else {
              _builder.append("\t");
              _builder.append("int i;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
              _builder.append(replPortClassName, "\t");
              _builder.append("\", \"");
              String _name_7 = message.getName();
              _builder.append(_name_7, "\t");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              String _name_8 = pc.getName();
              String _name_9 = message.getName();
              String _plus_1 = (dir + _name_9);
              String _memberInUse_1 = this._cExtensions.memberInUse(_name_8, _plus_1);
              String _sendMessageCall_1 = this.sendMessageCall(hasData, "(&((etReplPort*)self)->ports[i].port)", _memberInUse_1, (typeName + refp), (refa + "data__et"));
              _builder.append(_sendMessageCall_1, "\t\t");
              _builder.newLineIfNotEmpty();
              {
                GlobalGeneratorSettings _settings_1 = Main.getSettings();
                boolean _isGenerateMSCInstrumentation_1 = _settings_1.isGenerateMSCInstrumentation();
                if (_isGenerateMSCInstrumentation_1) {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("ET_MSC_LOGGER_ASYNC_OUT(((etReplPort*)self)->ports[i].port.myInstName, \"");
                  String _name_10 = message.getName();
                  _builder.append(_name_10, "\t\t");
                  _builder.append("\", ((etReplPort*)self)->ports[i].port.peerInstName)");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          String _name_11 = message.getName();
          String _messageSignature_2 = this.messageSignature(replPortClassName, _name_11, "", (", int idx__et" + data));
          _builder.append(_messageSignature_2, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            boolean _notEquals_2 = (!Objects.equal(hdlr, null));
            if (_notEquals_2) {
              _builder.append("\t");
              _builder.append(portClassName, "\t");
              _builder.append("_");
              String _name_12 = message.getName();
              _builder.append(_name_12, "\t");
              _builder.append("(&((etReplPort*)self)->ports[idx__et].port");
              _builder.append(dataCall, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
              _builder.append(replPortClassName, "\t");
              _builder.append("\", \"");
              String _name_13 = message.getName();
              _builder.append(_name_13, "\t");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("if (0<=idx__et && idx__et<((etReplPort*)self)->size) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              String _name_14 = pc.getName();
              String _name_15 = message.getName();
              String _plus_2 = (dir + _name_15);
              String _memberInUse_2 = this._cExtensions.memberInUse(_name_14, _plus_2);
              String _sendMessageCall_2 = this.sendMessageCall(hasData, "(&((etReplPort*)self)->ports[idx__et].port)", _memberInUse_2, (typeName + refp), (refa + "data__et"));
              _builder.append(_sendMessageCall_2, "\t\t");
              _builder.newLineIfNotEmpty();
              {
                GlobalGeneratorSettings _settings_2 = Main.getSettings();
                boolean _isGenerateMSCInstrumentation_2 = _settings_2.isGenerateMSCInstrumentation();
                if (_isGenerateMSCInstrumentation_2) {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("ET_MSC_LOGGER_ASYNC_OUT(((etReplPort*)self)->ports[idx__et].port.myInstName, \"");
                  String _name_16 = message.getName();
                  _builder.append(_name_16, "\t\t");
                  _builder.append("\", ((etReplPort*)self)->ports[idx__et].port.peerInstName)");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
        }
      }
      {
        boolean _notEquals_3 = (!Objects.equal(pclass, null));
        if (_notEquals_3) {
          _builder.append("/* begin ");
          _builder.append(portClassName, "");
          _builder.append(" specific */");
          _builder.newLineIfNotEmpty();
          DetailCode _userCode = pclass.getUserCode();
          CharSequence _userCode_1 = this._procedureHelpers.userCode(_userCode);
          _builder.append(_userCode_1, "");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          PortClass _portClass = this._roomExtensions.getPortClass(pc, (conj).booleanValue());
          EList<PortOperation> _operations = _portClass.getOperations();
          CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(_operations, portClassName);
          _builder.append(_operationsImplementation, "");
          _builder.newLineIfNotEmpty();
          _builder.append("/* end ");
          _builder.append(portClassName, "");
          _builder.append(" specific */");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
        }
      }
      _builder.append("etInt32 ");
      _builder.append(replPortClassName, "");
      _builder.append("_getReplication(const ");
      _builder.append(replPortClassName, "");
      _builder.append("* self) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("return ((etReplPort*)self)->size;");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      {
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, (conj).booleanValue());
        if (_handlesReceive) {
          CharSequence _genReceiveHandlers = this.genReceiveHandlers(pc, conj);
          _builder.append(_genReceiveHandlers, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private String sendMessageCall(final boolean hasData, final String selfPtr, final String msg, final String typeName, final String data) {
    String _xifexpression = null;
    if (hasData) {
      _xifexpression = (((((((("etPort_sendMessage(" + selfPtr) + ", ") + msg) + ", sizeof(") + typeName) + "), ") + data) + ");");
    } else {
      _xifexpression = (((("etPort_sendMessage(" + selfPtr) + ", ") + msg) + ", 0, NULL);");
    }
    return _xifexpression;
  }
  
  private String messageSignature(final String className, final String messageName, final String methodSuffix, final String data) {
    return ((((((((("void " + className) + "_") + messageName) + methodSuffix) + "(const ") + className) + "* self") + data) + ")");
  }
  
  private String messageSetterSignature(final String className, final String messageName, final String data) {
    return (((((((("void " + className) + "_") + messageName) + "_set(") + className) + "* self") + data) + ")");
  }
  
  private String messageGetterSignature(final String className, final String messageName, final String type) {
    return (((((((type + " ") + className) + "_") + messageName) + "_get(const ") + className) + "* const self)");
  }
  
  private CharSequence genReceiveHandlers(final ProtocolClass pc, final Boolean conj) {
    CharSequence _xblockexpression = null;
    {
      String portClassName = this._roomExtensions.getPortClassName(pc, (conj).booleanValue());
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/* receiver handlers */");
      _builder.newLine();
      {
        List<MessageHandler> _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, (conj).booleanValue());
        for(final MessageHandler h : _receiveHandlers) {
          _builder.append("void ");
          _builder.append(portClassName, "");
          _builder.append("_");
          Message _msg = h.getMsg();
          String _name = _msg.getName();
          _builder.append(_name, "");
          _builder.append("_receiveHandler(");
          _builder.append(portClassName, "");
          _builder.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc){");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          AbstractGenerator _instance = AbstractGenerator.getInstance();
          DetailCode _detailCode = h.getDetailCode();
          String _translatedCode = _instance.getTranslatedCode(_detailCode);
          _builder.append(_translatedCode, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("/* hand over the message to the actor:      */");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/* (*receiveMessageFunc)(actor, self, msg); */");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  private CharSequence generateDebugHelpersImplementation(final Root root, final ProtocolClass pc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("/* message names as strings for debugging (generate MSC) */");
    _builder.newLine();
    _builder.append("static const char* const ");
    String _name = pc.getName();
    _builder.append(_name, "");
    _builder.append("_messageStrings[] = {\"MIN\", ");
    {
      List<Message> _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
      for(final Message m : _allOutgoingMessages) {
        _builder.append("\"");
        String _name_1 = m.getName();
        _builder.append(_name_1, "");
        _builder.append("\",");
      }
    }
    {
      List<Message> _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
      for(final Message m_1 : _allIncomingMessages) {
        _builder.append("\"");
        String _name_2 = m_1.getName();
        _builder.append(_name_2, "");
        _builder.append("\", ");
      }
    }
    _builder.append("\"MAX\"};");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("const char* ");
    String _name_3 = pc.getName();
    _builder.append(_name_3, "");
    _builder.append("_getMessageString(int msg_id) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (msg_id<");
    String _name_4 = pc.getName();
    _builder.append(_name_4, "\t");
    _builder.append("_MSG_MIN || msg_id>");
    String _name_5 = pc.getName();
    _builder.append(_name_5, "\t");
    _builder.append("_MSG_MAX+1){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("/* id out of range */");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return \"Message ID out of range\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("else{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _name_6 = pc.getName();
    _builder.append(_name_6, "\t\t");
    _builder.append("_messageStrings[msg_id];");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
