/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.genmodel.util.RoomCrossReferencer;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.ITranslationProvider;
import org.eclipse.etrice.generator.fsm.base.FSMDetailCodeTranslator;
import org.eclipse.etrice.generator.fsm.base.IFSMTranslationProvider;

public class DetailCodeTranslator
extends FSMDetailCodeTranslator {
    private static final String ATTR_SET = ".set";
    private RoomHelpers roomHelpers = new RoomHelpers();
    private HashMap<String, Attribute> name2attr = new HashMap();
    private HashMap<String, Operation> name2op = new HashMap();

    public DetailCodeTranslator(ActorClass ac, ITranslationProvider provider, boolean doTranslate) {
        this((EObject)ac, provider, doTranslate);
    }

    public DetailCodeTranslator(ProtocolClass pc, ITranslationProvider provider, boolean doTranslate) {
        this((EObject)pc, provider, doTranslate);
    }

    public DetailCodeTranslator(PortClass pc, ITranslationProvider provider, boolean doTranslate) {
        this((EObject)pc, provider, doTranslate);
    }

    public DetailCodeTranslator(DataClass dc, ITranslationProvider provider, boolean doTranslate) {
        this((EObject)dc, provider, doTranslate);
    }

    protected DetailCodeTranslator(EObject container, ITranslationProvider provider, boolean doTranslate) {
        super(container, (IFSMTranslationProvider)provider, doTranslate);
    }

    public String translateDetailCode(DetailCode code) {
        String result = super.translateDetailCode(code);
        if (this.doTranslate && this.provider instanceof ITranslationProvider && ((ITranslationProvider)this.provider).translateEnums()) {
            result = this.translateEnums(result);
        }
        return result;
    }

    protected String translateToken(String text, FSMDetailCodeTranslator.Position curr, int last, String token) {
        ArrayList args;
        Operation operation;
        if (!(this.provider instanceof ITranslationProvider)) {
            return null;
        }
        ITranslationProvider prov = (ITranslationProvider)this.provider;
        String translated = null;
        Attribute attribute = this.name2attr.get(token);
        if (attribute != null) {
            int start = curr.pos;
            String index = this.getArrayIndex(text, curr);
            if (index == null) {
                curr.pos = start;
            }
            int endSet = curr.pos + ATTR_SET.length();
            if (text.length() >= endSet && text.substring(curr.pos, endSet).equals(ATTR_SET)) {
                curr.pos = endSet;
                ArrayList args2 = this.getArgs(text, curr);
                if (args2 != null && args2.size() == 1) {
                    String orig = text.substring(last, curr.pos);
                    String transArg = this.translateText((String)args2.get(0));
                    translated = prov.getAttributeSetter(attribute, index, transArg, orig);
                }
            } else {
                String orig = text.substring(last, curr.pos);
                translated = prov.getAttributeGetter(attribute, index, orig);
            }
        }
        if (translated == null && (operation = this.name2op.get(token)) != null && (operation.eContainer() instanceof ActorClass || operation.eContainer() instanceof DataClass) && (args = this.getArgs(text, curr)) != null && operation.getArguments().size() == args.size()) {
            int i = 0;
            while (i < args.size()) {
                String transArg = this.translateText((String)args.remove(i));
                args.add(i, transArg);
                ++i;
            }
            String orig = text.substring(last, curr.pos);
            translated = prov.getOperationText(operation, args, orig);
        }
        if (translated == null) {
            translated = super.translateToken(text, curr, last, token);
        }
        return translated;
    }

    protected String translateInterfaceItemToken(AbstractInterfaceItem item, String text, FSMDetailCodeTranslator.Position curr, int last, String token) {
        if (!(this.provider instanceof ITranslationProvider)) {
            return null;
        }
        ITranslationProvider prov = (ITranslationProvider)this.provider;
        String translated = null;
        int start = curr.pos;
        EObject msg = this.getMessage(text, curr, item, false);
        if (msg != null && (curr.pos >= text.length() || text.charAt(curr.pos) != '(')) {
            String orig = text.substring(last, curr.pos);
            translated = prov.getInterfaceItemMessageValue((InterfaceItem)item, (Message)msg, orig);
        }
        if (translated == null) {
            ArrayList args;
            PortOperation operation;
            curr.pos = start;
            if (item instanceof InterfaceItem && (operation = this.getPortOperation((InterfaceItem)item, text, curr)) != null && this.argsMatching(operation, (ArrayList<String>)(args = this.getArgs(text, curr)))) {
                int i = 0;
                while (i < args.size()) {
                    String transArg = this.translateText((String)args.remove(i));
                    args.add(i, transArg);
                    ++i;
                }
                String orig = text.substring(last, curr.pos);
                translated = prov.getInterfaceItemOperationText(item, operation, args, orig);
            }
        }
        return translated;
    }

    private PortOperation getPortOperation(InterfaceItem item, String text, FSMDetailCodeTranslator.Position curr) {
        PortClass portClass = this.roomHelpers.getPortClass(item);
        PortOperation operation = null;
        if (portClass != null) {
            this.proceedToToken(text, curr);
            if (curr.pos >= text.length() || text.charAt(curr.pos) != '.') {
                return null;
            }
            ++curr.pos;
            this.proceedToToken(text, curr);
            String token = this.getToken(text, curr);
            for (PortOperation op : portClass.getOperations()) {
                if (!op.getName().equals(token)) continue;
                operation = op;
                break;
            }
        }
        return operation;
    }

    protected String translateEnums(String text) {
        if (!(this.provider instanceof ITranslationProvider)) {
            return text;
        }
        ITranslationProvider prov = (ITranslationProvider)this.provider;
        if (prov.translateEnums()) {
            RoomCrossReferencer crossReferencer = new RoomCrossReferencer();
            Set enumClasses = null;
            if (this.container instanceof ActorClass) {
                enumClasses = crossReferencer.getReferencedEnumClasses((RoomClass)((ActorClass)this.container));
            } else if (this.container instanceof DataClass) {
                enumClasses = crossReferencer.getReferencedEnumClasses((RoomClass)((DataClass)this.container));
            } else if (this.container instanceof PortClass) {
                enumClasses = crossReferencer.getReferencedEnumClasses((PortClass)this.container);
            } else if (this.container instanceof ProtocolClass) {
                enumClasses = crossReferencer.getReferencedEnumClasses((RoomClass)((ProtocolClass)this.container));
            }
            if (enumClasses != null) {
                for (EnumerationType et : enumClasses) {
                    for (EnumLiteral lit : et.getLiterals()) {
                        String pattern = String.valueOf(et.getName()) + "." + lit.getName();
                        if (!text.contains(pattern)) continue;
                        String replacement = prov.getEnumText(lit);
                        text = text.replace(pattern, replacement);
                    }
                }
            }
            return text;
        }
        return text;
    }

    protected boolean argsMatching(EObject amsg, ArrayList<String> args) {
        if (!(amsg instanceof Message)) {
            return super.argsMatching(amsg, args);
        }
        Message msg = (Message)amsg;
        if (msg.getData() == null && args.isEmpty()) {
            return true;
        }
        return msg.getData() != null && args.size() == 1;
    }

    protected boolean argsMatching(PortOperation op, ArrayList<String> args) {
        if (op.getArguments() == null && args.isEmpty()) {
            return true;
        }
        return op.getArguments().size() == args.size();
    }

    protected void prepare() {
        super.prepare();
        List attributes = null;
        if (this.container instanceof ActorClass) {
            attributes = this.roomHelpers.getAllAttributes((ActorClass)this.container);
        } else if (this.container instanceof DataClass) {
            attributes = this.roomHelpers.getAllAttributes((DataClass)this.container);
        } else if (this.container instanceof PortClass) {
            attributes = ((PortClass)this.container).getAttributes();
        }
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                this.name2attr.put(attribute.getName(), attribute);
            }
        }
        List operations = null;
        if (this.container instanceof ActorClass) {
            operations = this.roomHelpers.getAllOperations((ActorClass)this.container);
        } else if (this.container instanceof DataClass) {
            operations = this.roomHelpers.getAllOperations((DataClass)this.container);
        } else if (this.container instanceof PortClass) {
            operations = ((PortClass)this.container).getOperations();
        }
        if (operations != null) {
            for (Operation operation : operations) {
                this.name2op.put(operation.getName(), operation);
            }
        }
    }
}

