/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedRefinedState;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.TransitionChain;
import org.eclipse.etrice.generator.fsm.generic.AbstractStateMachineGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GenericStateMachineGenerator
extends AbstractStateMachineGenerator {
    public CharSequence genStateMachine(ExpandedModelComponent xpmc) {
        return this.genStateMachine(xpmc, true);
    }

    public CharSequence genStateMachine(ExpandedModelComponent xpmc, boolean shallGenerateOneFile) {
        StringConcatenation _builder = new StringConcatenation();
        if (shallGenerateOneFile) {
            _builder.append((Object)"/* state IDs */");
            _builder.newLine();
            String _genStateIdConstants = this.genStateIdConstants(xpmc);
            _builder.append((Object)_genStateIdConstants, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"/* transition chains */");
            _builder.newLine();
            String _genTransitionChainConstants = this.genTransitionChainConstants(xpmc);
            _builder.append((Object)_genTransitionChainConstants, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"/* triggers */");
            _builder.newLine();
            String _genTriggerConstants = this.genTriggerConstants(xpmc);
            _builder.append((Object)_genTriggerConstants, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _genExtra = this.genExtra(xpmc);
        _builder.append((Object)_genExtra, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* Entry and Exit Codes */");
        _builder.newLine();
        _builder.append((Object)"        ");
        String _genEntryAndExitCodes = this.genEntryAndExitCodes(xpmc, true);
        _builder.append((Object)_genEntryAndExitCodes, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* Action Codes */");
        _builder.newLine();
        _builder.append((Object)"        ");
        String _genActionCodes = this.genActionCodes(xpmc, true);
        _builder.append((Object)_genActionCodes, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* State Switch Methods */");
        _builder.newLine();
        String _genStateSwitchMethods = this.genStateSwitchMethods(xpmc, true);
        _builder.append((Object)_genStateSwitchMethods, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String guard(TriggeredTransition tt, final String trigger, final ExpandedModelComponent mc) {
        String _xblockexpression = null;
        EList _triggers = tt.getTriggers();
        Functions.Function1<Trigger, Boolean> _function = new Functions.Function1<Trigger, Boolean>(){

            public Boolean apply(Trigger e) {
                return mc.isMatching(e, trigger);
            }
        };
        Trigger tr = (Trigger)IterableExtensions.findFirst((Iterable)_triggers, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasGuard = this._fSMHelpers.hasGuard(tr);
        if (_hasGuard) {
            _builder.append((Object)"if (");
            Guard _guard = tr.getGuard();
            DetailCode _guard_1 = _guard.getGuard();
            String _translatedCode = this.translator.getTranslatedCode(_guard_1);
            _builder.append((Object)_translatedCode, "");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String guard(GuardedTransition tt, String trigger, ExpandedModelComponent mc) {
        StringConcatenation _builder = new StringConcatenation();
        DetailCode _guard = tt.getGuard();
        String _translatedCode = this.translator.getTranslatedCode(_guard);
        _builder.append((Object)_translatedCode, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String genActionCodeMethod(ExpandedModelComponent xpmc, Transition tr, boolean generateImplementation) {
        boolean _not;
        String _xblockexpression = null;
        EList chain = xpmc.getChains(tr);
        boolean _and = false;
        boolean _isEmpty = chain.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (!_not) {
            _and = false;
        } else {
            boolean _forall;
            Functions.Function1<TransitionChain, Boolean> _function = new Functions.Function1<TransitionChain, Boolean>(){

                public Boolean apply(TransitionChain it) {
                    boolean _and = false;
                    Transition _transition = it.getTransition();
                    _and = !(_transition instanceof NonInitialTransition) ? false : !(it.getTransition() instanceof GuardedTransition);
                    return _and;
                }
            };
            _and = _forall = IterableExtensions.forall((Iterable)chain, (Functions.Function1)_function);
        }
        boolean hasArgs = _and;
        String _className = this.getClassName(xpmc);
        String opScope = this.langExt.operationScope(_className, false);
        String _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        _xifexpression = _usesInheritance ? opScope : "";
        String opScopePriv = _xifexpression;
        String _pointerLiteral = this.langExt.pointerLiteral();
        String ifItemPtr = "InterfaceItemBase" + _pointerLiteral;
        String _xifexpression_1 = null;
        boolean _usesPointers = this.langExt.usesPointers();
        _xifexpression_1 = _usesPointers ? "const " + ifItemPtr : ifItemPtr;
        String constIfItemPtr = _xifexpression_1;
        String _xifexpression_2 = null;
        if (generateImplementation) {
            StringConcatenation _builder = new StringConcatenation();
            String _accessLevelProtected = this.langExt.accessLevelProtected();
            _builder.append((Object)_accessLevelProtected, "");
            _builder.append((Object)"void ");
            _builder.append((Object)opScopePriv, "");
            String _actionCodeOperationName = this._codegenHelpers.getActionCodeOperationName(tr);
            _builder.append((Object)_actionCodeOperationName, "");
            _builder.append((Object)"(");
            String _className_1 = this.getClassName(xpmc);
            String _selfPointer = this.langExt.selfPointer(_className_1, hasArgs);
            _builder.append((Object)_selfPointer, "");
            if (hasArgs) {
                _builder.append((Object)constIfItemPtr, "");
                _builder.append((Object)" ifitem");
                String _generateArgumentList = this.transitionChainGenerator.generateArgumentList(xpmc, tr);
                _builder.append((Object)_generateArgumentList, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            DetailCode _action = tr.getAction();
            String _translatedCode = this.translator.getTranslatedCode(_action);
            _builder.append((Object)_translatedCode, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _xifexpression_2 = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _accessLevelProtected_1 = this.langExt.accessLevelProtected();
            _builder_1.append((Object)_accessLevelProtected_1, "");
            _builder_1.append((Object)"void ");
            String _actionCodeOperationName_1 = this._codegenHelpers.getActionCodeOperationName(tr);
            _builder_1.append((Object)_actionCodeOperationName_1, "");
            _builder_1.append((Object)"(");
            String _className_2 = this.getClassName(xpmc);
            String _selfPointer_1 = this.langExt.selfPointer(_className_2, hasArgs);
            _builder_1.append((Object)_selfPointer_1, "");
            if (hasArgs) {
                _builder_1.append((Object)constIfItemPtr, "");
                _builder_1.append((Object)" ifitem");
                String _generateArgumentList_1 = this.transitionChainGenerator.generateArgumentList(xpmc, tr);
                _builder_1.append((Object)_generateArgumentList_1, "");
            }
            _builder_1.append((Object)");");
            _builder_1.newLineIfNotEmpty();
            _xifexpression_2 = _builder_1.toString();
        }
        _xblockexpression = _xifexpression_2;
        return _xblockexpression;
    }

    public String genActionCodeMethods(ExpandedModelComponent xpmc, State state, boolean generateImplementation) {
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        String _xblockexpression = null;
        ModelComponent mc = xpmc.getModelComponent();
        String _className = this.getClassName(mc);
        String selfPtr = this.langExt.selfPointer(_className, false);
        String _className_1 = this.getClassName(mc);
        String opScope = this.langExt.operationScope(_className_1, false);
        String _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        _xifexpression = _usesInheritance ? opScope : "";
        String opScopePriv = _xifexpression;
        String entryOp = this._codegenHelpers.getEntryCodeOperationName(state);
        String exitOp = this._codegenHelpers.getExitCodeOperationName(state);
        String doOp = this._codegenHelpers.getDoCodeOperationName(state);
        DetailCode _entryCode = state.getEntryCode();
        String entry = this.translator.getTranslatedCode(_entryCode);
        DetailCode _exitCode = state.getExitCode();
        String exit = this.translator.getTranslatedCode(_exitCode);
        DetailCode _doCode = state.getDoCode();
        String docode = this.translator.getTranslatedCode(_doCode);
        if (state instanceof ExpandedRefinedState) {
            ExpandedRefinedState rs = (ExpandedRefinedState)state;
            DetailCode _inheritedEntry = rs.getInheritedEntry();
            String inhEntry = this.translator.getTranslatedCode(_inheritedEntry);
            DetailCode _inheritedExit = rs.getInheritedExit();
            String inhExit = this.translator.getTranslatedCode(_inheritedExit);
            DetailCode _inheritedDo = rs.getInheritedDo();
            String inhDo = this.translator.getTranslatedCode(_inheritedDo);
            boolean _usesInheritance_1 = this.langExt.usesInheritance();
            if (_usesInheritance_1) {
                DetailCode _inheritedDo_1;
                boolean _hasDetailCode_2;
                DetailCode _inheritedExit_1;
                boolean _hasDetailCode_1;
                ModelComponent _base = mc.getBase();
                String baseName = this.getClassName(_base);
                DetailCode _inheritedEntry_1 = rs.getInheritedEntry();
                boolean _hasDetailCode = this._fSMHelpers.hasDetailCode(_inheritedEntry_1);
                if (_hasDetailCode) {
                    String _plus;
                    String _superCall = this.langExt.superCall(baseName, entryOp, "");
                    entry = _plus = String.valueOf(_superCall) + entry;
                }
                if (_hasDetailCode_1 = this._fSMHelpers.hasDetailCode(_inheritedExit_1 = rs.getInheritedExit())) {
                    String _plus_1;
                    String _superCall_1 = this.langExt.superCall(baseName, exitOp, "");
                    exit = _plus_1 = String.valueOf(exit) + _superCall_1;
                }
                if (_hasDetailCode_2 = this._fSMHelpers.hasDetailCode(_inheritedDo_1 = rs.getInheritedDo())) {
                    String _plus_2;
                    String _superCall_2 = this.langExt.superCall(baseName, doOp, "");
                    docode = _plus_2 = String.valueOf(_superCall_2) + docode;
                }
            } else {
                entry = String.valueOf(inhEntry) + entry;
                exit = String.valueOf(exit) + inhExit;
                docode = String.valueOf(inhDo) + docode;
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = entry.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            if (generateImplementation) {
                String _accessLevelProtected = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected, "");
                _builder.append((Object)"void ");
                _builder.append((Object)opScopePriv, "");
                _builder.append((Object)entryOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)entry, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                String _accessLevelProtected_1 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_1, "");
                _builder.append((Object)"void ");
                _builder.append((Object)entryOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = exit.isEmpty());
        if (_not_1) {
            if (generateImplementation) {
                String _accessLevelProtected_2 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_2, "");
                _builder.append((Object)"void ");
                _builder.append((Object)opScopePriv, "");
                _builder.append((Object)exitOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)exit, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                String _accessLevelProtected_3 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_3, "");
                _builder.append((Object)"void ");
                _builder.append((Object)exitOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = docode.isEmpty());
        if (_not_2) {
            if (generateImplementation) {
                String _accessLevelProtected_4 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_4, "");
                _builder.append((Object)" void ");
                _builder.append((Object)opScopePriv, "");
                _builder.append((Object)doOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)docode, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                String _accessLevelProtected_5 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_5, "");
                _builder.append((Object)"void ");
                _builder.append((Object)doOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String constPointer(String classname) {
        return classname;
    }

    public CharSequence genStateMachineMethodDeclarations(ExpandedModelComponent xpmc) {
        StringConcatenation _xblockexpression = null;
        ModelComponent mc = xpmc.getModelComponent();
        ComponentCommunicationType _commType = mc.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        ComponentCommunicationType _commType_1 = mc.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ComponentCommunicationType.EVENT_DRIVEN);
        boolean _or = false;
        _or = async ? true : eventDriven;
        boolean handleEvents = _or;
        String _className = this.getClassName(mc);
        String selfPtr = this.langExt.selfPointer(_className, true);
        boolean usesHdlr = this.usesHandlerTrPoints(xpmc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/* state IDs */");
        _builder.newLine();
        String _genStateIdConstants = this.genStateIdConstants(xpmc);
        _builder.append((Object)_genStateIdConstants, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* transition chains */");
        _builder.newLine();
        String _genTransitionChainConstants = this.genTransitionChainConstants(xpmc);
        _builder.append((Object)_genTransitionChainConstants, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* triggers */");
        _builder.newLine();
        String _genTriggerConstants = this.genTriggerConstants(xpmc);
        _builder.append((Object)_genTriggerConstants, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _genExtraDecl = this.genExtraDecl(xpmc);
        _builder.append((Object)_genExtraDecl, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* Entry and Exit Codes */");
        _builder.newLine();
        _builder.append((Object)"        ");
        String _genEntryAndExitCodes = this.genEntryAndExitCodes(xpmc, false);
        _builder.append((Object)_genEntryAndExitCodes, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* Action Codes */");
        _builder.newLine();
        _builder.append((Object)"        ");
        String _genActionCodes = this.genActionCodes(xpmc, false);
        _builder.append((Object)_genActionCodes, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* calls exit codes while exiting from the current state to one of its");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* parent states while remembering the history");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param current - the current state");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param to - the final parent state");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)"\t ");
            _builder.append((Object)"* @param handler - entry and exit codes are called only if not handler (for handler TransitionPoints)");
            _builder.newLine();
        }
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void exitTo(");
        _builder.append((Object)selfPtr, "\t");
        _builder.append((Object)"int current, int to");
        if (usesHdlr) {
            _builder.append((Object)", ");
            String _boolType = this.boolType();
            _builder.append((Object)_boolType, "\t");
            _builder.append((Object)" handler");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* calls action, entry and exit codes along a transition chain. The generic data are cast to typed data");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* matching the trigger of this chain. The ID of the final state is returned");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param chain - the chain ID");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param generic_data__et - the generic data pointer");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return the ID of the final state");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int executeTransitionChain(");
        _builder.append((Object)selfPtr, "\t");
        _builder.append((Object)"int chain");
        if (handleEvents) {
            _builder.append((Object)", ");
            String _constPointer = this.constPointer("etRuntime::InterfaceItemBase");
            _builder.append((Object)_constPointer, "\t");
            _builder.append((Object)" ifitem, ");
            String _voidPointer = this.langExt.voidPointer();
            _builder.append((Object)_voidPointer, "\t");
            _builder.append((Object)" generic_data__et");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* calls entry codes while entering a state's history. The ID of the final leaf state is returned");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param state - the state which is entered");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)"\t ");
            _builder.append((Object)"* @param handler - entry code is executed if not handler");
            _builder.newLine();
        }
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return - the ID of the final leaf state");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int enterHistory(");
        _builder.append((Object)selfPtr, "\t");
        _builder.append((Object)"int state");
        if (usesHdlr) {
            _builder.append((Object)", ");
            String _boolType_1 = this.boolType();
            _builder.append((Object)_boolType_1, "\t");
            _builder.append((Object)" handler");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void executeInitTransition(");
        String _className_1 = this.getClassName(mc);
        String _selfPointer = this.langExt.selfPointer(_className_1, false);
        _builder.append((Object)_selfPointer, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* receiveEvent contains the main implementation of the FSM */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void receiveEvent(");
        String _className_2 = this.getClassName(mc);
        String _selfPointer_1 = this.langExt.selfPointer(_className_2, handleEvents);
        _builder.append((Object)_selfPointer_1, "\t");
        if (handleEvents) {
            _builder.append((Object)"etRuntime::InterfaceItemBase* ifitem, int evt, ");
            String _voidPointer_1 = this.langExt.voidPointer();
            _builder.append((Object)_voidPointer_1, "\t");
            _builder.append((Object)" generic_data__et");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

