/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.generic.FSMExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class RoomExtensions
extends FSMExtensions {
    private static String genDir = "/src-gen/";
    private static String genInfoDir = "/src-gen-info/";
    private static String genDocDir = "/doc-gen/";
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;

    public static String setDefaultGenDir() {
        genDir = "/src-gen/";
        return "/src-gen/";
    }

    public static String setDefaultGenInfoDir() {
        genInfoDir = "/src-gen-info/";
        return "/src-gen-info/";
    }

    public static String setDefaultGenDocDir() {
        genDocDir = "/doc-gen/";
        return "/doc-gen/";
    }

    public static String setGenDir(String dir) {
        genDir = "/" + dir + "/";
        return genDir;
    }

    public static String setGenInfoDir(String dir) {
        genInfoDir = "/" + dir + "/";
        return genInfoDir;
    }

    public static String setGenDocDir(String dir) {
        genDocDir = "/" + dir + "/";
        return genDocDir;
    }

    public List<Port> punion(Iterable<Port> in1, Iterable<ExternalPort> in2) {
        final ArrayList<Port> ret = new ArrayList<Port>();
        Procedures.Procedure1<ExternalPort> _function = new Procedures.Procedure1<ExternalPort>(){

            public void apply(ExternalPort e) {
                Port _interfacePort = e.getInterfacePort();
                ret.add(_interfacePort);
            }
        };
        IterableExtensions.forEach(in2, (Procedures.Procedure1)_function);
        Iterables.addAll(ret, in1);
        return ret;
    }

    public String getGenerationPathSegment() {
        return genDir;
    }

    public String getGenerationInfoSegment() {
        return genInfoDir;
    }

    public String getDocGenerationPathSegment() {
        return genDocDir;
    }

    public String getModelPath(EObject e) {
        Resource res = e.eResource();
        boolean _equals = Objects.equal((Object)res, null);
        if (_equals) {
            return "";
        }
        URI _uRI = res.getURI();
        return _uRI.toFileString();
    }

    public String getPackage(RoomClass rc) {
        EObject _eContainer = rc.eContainer();
        return ((RoomModel)_eContainer).getName();
    }

    public String getFullyQualifiedName(RoomClass rc) {
        String _package = this.getPackage(rc);
        String _replace = _package.replace(".", "_");
        String _plus = String.valueOf(_replace) + "_";
        String _name = rc.getName();
        return String.valueOf(_plus) + _name;
    }

    public String getPathFromPackage(String packageName) {
        String _replaceAll = packageName.replaceAll("\\.", "/");
        return String.valueOf(_replaceAll) + "/";
    }

    public String getPath(RoomClass rc) {
        String _package = this.getPackage(rc);
        return this.getPathFromPackage(_package);
    }

    public String getProjectPath(EObject e) {
        URI res = FileSystemHelpers.getProjectURI((EObject)e);
        boolean _equals = Objects.equal((Object)res, null);
        if (_equals) {
            return "";
        }
        return res.toFileString();
    }

    public String getGenerationTargetPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _generationPathSegment = this.getGenerationPathSegment();
        return String.valueOf(_projectPath) + _generationPathSegment;
    }

    public String getGenerationInfoPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _generationInfoSegment = this.getGenerationInfoSegment();
        return String.valueOf(_projectPath) + _generationInfoSegment;
    }

    public String getDocGenerationTargetPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _docGenerationPathSegment = this.getDocGenerationPathSegment();
        return String.valueOf(_projectPath) + _docGenerationPathSegment;
    }

    public String getPathName(String path) {
        String _replaceAll = path.replaceAll("/", "_");
        return _replaceAll.replaceAll(":", "_");
    }

    protected String _getPortClassName(Port p) {
        String _xifexpression = null;
        GeneralProtocolClass _protocol = p.getProtocol();
        if (_protocol instanceof ProtocolClass) {
            GeneralProtocolClass _protocol_1 = p.getProtocol();
            boolean _isConjugated = p.isConjugated();
            boolean _isReplicated = p.isReplicated();
            _xifexpression = this.getPortClassName((ProtocolClass)_protocol_1, _isConjugated, _isReplicated);
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    protected String _getPortClassName(ExternalPort p) {
        Port _interfacePort = p.getInterfacePort();
        return this.getPortClassName((EObject)_interfacePort);
    }

    protected String _getPortClassName(SAP sap) {
        ProtocolClass _protocol = sap.getProtocol();
        return this.getPortClassName(_protocol, true);
    }

    protected String _getPortClassName(SPP spp) {
        ProtocolClass _protocol = spp.getProtocol();
        return this.getPortClassName(_protocol, false, true);
    }

    protected String _getPortClassName(ServiceImplementation svc) {
        SPP _spp = svc.getSpp();
        ProtocolClass _protocol = _spp.getProtocol();
        return this.getPortClassName(_protocol, false, true);
    }

    public String getPortClassName(ProtocolClass p, boolean conj) {
        return this.getPortClassName(p, conj, false);
    }

    public String getPortClassName(ProtocolClass p, boolean conj, boolean repl) {
        String _name = p.getName();
        String _xifexpression = null;
        _xifexpression = conj ? "Conj" : "";
        String _plus = String.valueOf(_name) + _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = repl ? "Repl" : "";
        String _plus_1 = String.valueOf(_plus) + _xifexpression_1;
        return String.valueOf(_plus_1) + "Port";
    }

    public PortClass getPortClass(ProtocolClass pc, boolean conj) {
        if (conj) {
            return pc.getConjugated();
        }
        return pc.getRegular();
    }

    public boolean handlesSend(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List _allMessages = this._roomHelpers.getAllMessages(pc, conj);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceive(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List _allMessages = this._roomHelpers.getAllMessages(pc, !conj);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean isConjugated(InterfaceItemInstance iii) {
        if (iii instanceof PortInstance) {
            Port _port = ((PortInstance)iii).getPort();
            return _port.isConjugated();
        }
        if (iii instanceof SAPInstance) {
            return true;
        }
        if (iii instanceof ServiceImplInstance) {
            return false;
        }
        return false;
    }

    public List<MessageHandler> getReceiveHandlers(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return new ArrayList<MessageHandler>();
        }
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List _allMessages = this._roomHelpers.getAllMessages(pc, !conj);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public List<MessageHandler> getSendHandlers(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return new ArrayList<MessageHandler>();
        }
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List _allMessages = this._roomHelpers.getAllMessages(pc, conj);
            boolean _contains = _allMessages.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public MessageHandler getSendHandler(final Message m, boolean conj) {
        EObject _eContainer = m.eContainer();
        List<MessageHandler> _sendHandlers = this.getSendHandlers((ProtocolClass)_eContainer, conj);
        Functions.Function1<MessageHandler, Boolean> _function = new Functions.Function1<MessageHandler, Boolean>(){

            public Boolean apply(MessageHandler e) {
                Message _msg = e.getMsg();
                return Objects.equal((Object)_msg, (Object)m);
            }
        };
        return (MessageHandler)IterableExtensions.findFirst(_sendHandlers, (Functions.Function1)_function);
    }

    public boolean isIncoming(Message m) {
        EObject _eContainer = m.eContainer();
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages((ProtocolClass)_eContainer);
        return _allIncomingMessages.contains(m);
    }

    public String getCodeName(Message m) {
        boolean _isIncoming = this.isIncoming(m);
        if (_isIncoming) {
            String _name = m.getName();
            return "IN_" + _name;
        }
        String _name_1 = m.getName();
        return "OUT_" + _name_1;
    }

    public boolean overridesStop(ActorClass ac) {
        Functions.Function1<StandardOperation, Boolean> _function;
        boolean _or = false;
        EList _operations = ac.getOperations();
        boolean _exists = IterableExtensions.exists((Iterable)_operations, (Functions.Function1)(_function = new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation e) {
                boolean _and = false;
                boolean _and_1 = false;
                String _name = e.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)"stop");
                if (!_equals) {
                    _and_1 = false;
                } else {
                    boolean _isEmpty;
                    EList _arguments = e.getArguments();
                    _and_1 = _isEmpty = _arguments.isEmpty();
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _equals_1;
                    RefableType _returnType = e.getReturnType();
                    _and = _equals_1 = Objects.equal((Object)_returnType, null);
                }
                return _and;
            }
        }));
        if (_exists) {
            _or = true;
        } else {
            boolean _notEquals;
            boolean _and = false;
            ActorClass _actorBase = ac.getActorBase();
            boolean bl = _notEquals = !Objects.equal((Object)_actorBase, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _overridesStop;
                ActorClass _actorBase_1 = ac.getActorBase();
                _and = _overridesStop = this.overridesStop(_actorBase_1);
            }
            _or = _and;
        }
        return _or;
    }

    public BasicEList<AbstractInstance> getAllSubInstances(StructureInstance ssi) {
        BasicEList result = new BasicEList();
        TreeIterator it = ssi.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof AbstractInstance)) continue;
            result.add((Object)((AbstractInstance)obj));
        }
        return result;
    }

    public String getPortClassName(EObject p) {
        if (p instanceof Port) {
            return this._getPortClassName((Port)p);
        }
        if (p instanceof SAP) {
            return this._getPortClassName((SAP)p);
        }
        if (p instanceof SPP) {
            return this._getPortClassName((SPP)p);
        }
        if (p instanceof ExternalPort) {
            return this._getPortClassName((ExternalPort)p);
        }
        if (p instanceof ServiceImplementation) {
            return this._getPortClassName((ServiceImplementation)p);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p).toString());
    }
}

