/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class TypeHelpers {
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private IDataConfiguration dataConfigExt;

    public String typeName(DataType type) {
        if (type instanceof PrimitiveType) {
            return ((PrimitiveType)type).getTargetName();
        }
        if (type instanceof EnumerationType) {
            return this.languageExt.getTargetType((EnumerationType)type);
        }
        if (type instanceof ExternalType) {
            return ((ExternalType)type).getTargetName();
        }
        return type.getName();
    }

    public String getTypeName(RefableType t) {
        DataType _type = t.getType();
        return this.typeName(_type);
    }

    public String getTypeName(Message m) {
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        return this.getTypeName(_refType);
    }

    public String getTypeName(Attribute att) {
        RefableType _type = att.getType();
        return this.getTypeName(_type);
    }

    public String getPrimitiveTypeName(RefableType t) {
        DataType _type = t.getType();
        return _type.getName();
    }

    public String getPrimitiveTypeName(Message m) {
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        return this.getPrimitiveTypeName(_refType);
    }

    public String getPrimitiveTypeName(Attribute att) {
        RefableType _type = att.getType();
        return this.getPrimitiveTypeName(_type);
    }

    public String defaultValue(VarDecl a) {
        RefableType _refType = a.getRefType();
        DataType _type = _refType.getType();
        return this.languageExt.defaultValue(_type);
    }

    public String getArgumentList(VarDecl data) {
        String[] _generateArglistAndTypedData = this.languageExt.generateArglistAndTypedData((EObject)data);
        return _generateArglistAndTypedData[0];
    }

    public String getTypedDataDefinition(VarDecl data) {
        String[] _generateArglistAndTypedData = this.languageExt.generateArglistAndTypedData((EObject)data);
        return _generateArglistAndTypedData[1];
    }

    public String generateTypedArgumentList(VarDecl data) {
        String[] _generateArglistAndTypedData = this.languageExt.generateArglistAndTypedData((EObject)data);
        return _generateArglistAndTypedData[2];
    }

    public boolean isPrimitive(DataType type) {
        return type instanceof PrimitiveType;
    }

    public boolean isBoolean(DataType type) {
        boolean _and = false;
        boolean _isPrimitive = this.isPrimitive(type);
        if (!_isPrimitive) {
            _and = false;
        } else {
            boolean _equals;
            LiteralType _type = ((PrimitiveType)type).getType();
            _and = _equals = Objects.equal((Object)_type, (Object)LiteralType.BOOL);
        }
        return _and;
    }

    public boolean isEnumeration(DataType type) {
        return type instanceof EnumerationType;
    }

    public boolean isEnumerationOrPrimitive(DataType type) {
        boolean _or = false;
        _or = type instanceof EnumerationType ? true : type instanceof PrimitiveType;
        return _or;
    }

    public boolean isDataClass(DataType type) {
        return type instanceof DataClass;
    }

    public boolean isCharacterType(PrimitiveType type) {
        LiteralType _type = type.getType();
        return Objects.equal((Object)_type, (Object)LiteralType.CHAR);
    }

    public boolean isCharacterType(DataType type) {
        boolean _isCharacterType;
        boolean _and = false;
        boolean _isPrimitive = this.isPrimitive(type);
        _and = !_isPrimitive ? false : (_isCharacterType = this.isCharacterType((PrimitiveType)type));
        return _and;
    }

    public String getAttrInstanceConfigValue(List<Attribute> attributePath, InstanceBase instance) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && instance instanceof ActorInstance) {
            _matched = true;
            _switchResult = this.dataConfigExt.getAttrInstanceConfigValue((ActorInstance)instance, attributePath);
        }
        if (!_matched && instance instanceof InterfaceItemInstance) {
            _matched = true;
            _switchResult = this.dataConfigExt.getAttrInstanceConfigValue((InterfaceItemInstance)instance, attributePath);
        }
        return _switchResult;
    }

    public String getAttrClassConfigValue(List<Attribute> attributePath, ActorClass actor, boolean inherite) {
        String result = this.dataConfigExt.getAttrClassConfigValue(actor, attributePath);
        boolean _and = false;
        boolean _equals = Objects.equal((Object)result, null);
        _and = !_equals ? false : inherite;
        if (_and) {
            ActorClass base = actor.getActorBase();
            while (!Objects.equal((Object)base, null) && Objects.equal((Object)result, null)) {
                ActorClass _actorBase;
                String _attrClassConfigValue;
                result = _attrClassConfigValue = this.dataConfigExt.getAttrClassConfigValue(base, attributePath);
                base = _actorBase = base.getActorBase();
            }
        }
        return result;
    }

    public String getAttrClassConfigValue(List<Attribute> attributePath, PortClass port) {
        ProtocolClass pc = this._roomHelpers.getProtocolClass((EObject)port);
        boolean _equals = Objects.equal((Object)pc, null);
        if (_equals) {
            return null;
        }
        PortClass _regular = pc.getRegular();
        boolean _equals_1 = port.equals(_regular);
        return this.dataConfigExt.getAttrClassConfigValue(pc, _equals_1, attributePath);
    }
}

