/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.ISelectionDialog;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PortMessageSelectionDialog
extends FormDialog
implements ISelectionDialog {
    private ActorClass ac;
    private boolean recvOnly;
    private TreeViewer viewer;
    private String selected = null;
    @Inject
    ILabelProvider labelProvider;

    public PortMessageSelectionDialog(Shell shell, ActorClass ac, boolean recvOnly) {
        super(shell);
        this.ac = ac;
        this.recvOnly = recvOnly;
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        Form form = mform.getForm().getForm();
        form.setText("Select a port.message Combination");
        form.setImage(Activator.getImage("icons/Behavior.gif"));
        toolkit.decorateFormHeading(form);
        Composite body = form.getBody();
        this.viewer = new TreeViewer(body, 67840);
        TreeColumn col0 = new TreeColumn(this.viewer.getTree(), 0);
        col0.setText("interface item/msg or op");
        TreeColumn col1 = new TreeColumn(this.viewer.getTree(), 0);
        col1.setText("direction");
        TreeColumn col2 = new TreeColumn(this.viewer.getTree(), 0);
        col2.setText("data");
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new PortMessageContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PortMessageLabelProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setInput((Object)this.ac);
        this.viewer.expandAll();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PortMessageSelectionDialog.this.okPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button ok = PortMessageSelectionDialog.this.getButton(0);
                if (ok != null && event.getSelection() instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    ok.setEnabled(element instanceof MethodItemPair);
                }
            }
        });
        TreeColumnLayout layout = new TreeColumnLayout();
        body.setLayout((Layout)layout);
        layout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(40));
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(20));
        layout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(40));
    }

    protected void okPressed() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            MethodItemPair pair;
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof MsgItemPair) {
                pair = (MsgItemPair)element;
                if (pair.out) {
                    String data = pair.msg.getData() != null ? pair.msg.getData().getName() : "";
                    String index = "";
                    if (pair.item instanceof Port && ((Port)pair.item).getMultiplicity() != 1) {
                        index = "[idx]";
                    }
                    this.selected = String.valueOf(pair.item.getName()) + index + "." + pair.msg.getName() + "(" + data + ")";
                } else {
                    this.selected = String.valueOf(pair.item.getName()) + "." + pair.msg.getName();
                }
            }
            if (element instanceof OperationItemPair) {
                pair = (OperationItemPair)element;
                String arglist = SupportUtil.getInstance().getRoomNameProvider().getArguments((Operation)((OperationItemPair)pair).op);
                this.selected = String.valueOf(((OperationItemPair)pair).item.getName()) + "." + ((OperationItemPair)pair).op.getName() + arglist;
            }
        }
        super.okPressed();
    }

    public String getSelected() {
        return this.selected;
    }

    private static class MethodItemPair {
        InterfaceItem item;

        public MethodItemPair(InterfaceItem item) {
            this.item = item;
        }
    }

    private static class MsgItemPair
    extends MethodItemPair {
        Message msg;
        boolean out;

        public MsgItemPair(InterfaceItem item, Message msg, boolean out) {
            super(item);
            this.msg = msg;
            this.out = out;
        }
    }

    private static class OperationItemPair
    extends MethodItemPair {
        PortOperation op;

        public OperationItemPair(InterfaceItem item, PortOperation op) {
            super(item);
            this.op = op;
        }
    }

    private class PortMessageContentProvider
    implements ITreeContentProvider {
        private HashMap<InterfaceItem, ArrayList<MethodItemPair>> item2pairs;

        private PortMessageContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.item2pairs = new HashMap();
            RoomHelpers roomHelpers = SupportUtil.getInstance().getRoomHelpers();
            List items = roomHelpers.getAllInterfaceItems(PortMessageSelectionDialog.this.ac);
            for (InterfaceItem item : items) {
                PortClass pcls;
                ArrayList<MethodItemPair> pairs = new ArrayList<MethodItemPair>();
                List out = roomHelpers.getMessageListDeep(item, true);
                if (!PortMessageSelectionDialog.this.recvOnly) {
                    for (Message msg : out) {
                        if (msg.isPriv()) continue;
                        pairs.add(new MsgItemPair(item, msg, true));
                    }
                }
                if (roomHelpers.getProtocol(item).getCommType() == CommunicationType.DATA_DRIVEN) {
                    List in = roomHelpers.getMessageListDeep(item, false);
                    for (Message msg : in) {
                        if (msg.isPriv()) continue;
                        pairs.add(new MsgItemPair(item, msg, false));
                    }
                }
                if ((pcls = roomHelpers.getPortClass(item)) != null) {
                    for (PortOperation op : pcls.getOperations()) {
                        if (op.getSendsMsg() == null) continue;
                        pairs.add(new OperationItemPair(item, op));
                    }
                    for (PortOperation op : pcls.getOperations()) {
                        if (op.getSendsMsg() != null) continue;
                        pairs.add(new OperationItemPair(item, op));
                    }
                }
                this.item2pairs.put(item, pairs);
            }
        }

        public Object[] getElements(Object inputElement) {
            return SupportUtil.getInstance().getRoomHelpers().getAllInterfaceItems(PortMessageSelectionDialog.this.ac).toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof InterfaceItem) {
                ArrayList<MethodItemPair> list = this.item2pairs.get(element);
                return list.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof MsgItemPair) {
                return ((MsgItemPair)element).item;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof InterfaceItem) {
                return !this.item2pairs.get(element).isEmpty();
            }
            return false;
        }
    }

    private class PortMessageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PortMessageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof MsgItemPair) {
                    element = ((MsgItemPair)element).msg;
                } else if (element instanceof OperationItemPair) {
                    PortOperation op = ((OperationItemPair)element).op;
                    element = op;
                }
                return PortMessageSelectionDialog.this.labelProvider.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof InterfaceItem) {
                        return ((InterfaceItem)element).getName();
                    }
                    if (element instanceof MsgItemPair) {
                        return ((MsgItemPair)element).msg.getName();
                    }
                    if (!(element instanceof OperationItemPair)) break;
                    PortOperation op = ((OperationItemPair)element).op;
                    String add = "";
                    if (op.getSendsMsg() != null) {
                        add = " sends " + op.getSendsMsg().getName();
                    }
                    return String.valueOf(op.getName()) + add;
                }
                case 1: {
                    if (element instanceof MsgItemPair) {
                        return ((MsgItemPair)element).out ? "send" : "recv";
                    }
                    if (!(element instanceof OperationItemPair)) break;
                    if (((OperationItemPair)element).op.getSendsMsg() != null) {
                        return "send";
                    }
                    return "n/a";
                }
                case 2: {
                    if (element instanceof MsgItemPair) {
                        Message msg = ((MsgItemPair)element).msg;
                        if (msg.getData() == null) break;
                        return String.valueOf(msg.getData().getName()) + " : " + msg.getData().getRefType().getType().getName();
                    }
                    if (!(element instanceof OperationItemPair)) break;
                    String sig = SupportUtil.getInstance().getRoomNameProvider().getTypedArgumentList((Operation)((OperationItemPair)element).op);
                    return sig.substring(1, sig.length() - 1);
                }
            }
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getImage(Object element) {
            return PortMessageSelectionDialog.this.labelProvider.getImage(element);
        }
    }
}

