/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import java.util.EnumSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.detailcode.RuntimeDetailExpressionProvider;
import org.eclipse.etrice.ui.behavior.fsm.actioneditor.IActionCodeEditor;
import org.eclipse.etrice.ui.behavior.fsm.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.AbstractMemberAwarePropertyDialog;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.DetailCodeToString;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IStatePropertyDialog;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.StringToDetailCode;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;

public class StatePropertyDialog
extends AbstractMemberAwarePropertyDialog
implements IStatePropertyDialog {
    private ActorClass ac;
    private State state;
    private boolean inherited;
    private boolean addCode = false;
    private String codeSelectionString = "";
    private EnumSet<Where> where = EnumSet.noneOf(Where.class);
    private String messageToDisplay = "";
    private String messageTitle = "";

    public StatePropertyDialog(Shell shell, ActorClass ac, State s, boolean edit) {
        super(shell, edit ? "Edit State" : "View State", (ModelComponent)ac);
        this.ac = ac;
        this.state = s;
        Activator.getDefault().getInjector().injectMembers((Object)this);
        this.inherited = SupportUtil.getInstance().getRoomHelpers().getActorClass((StateGraphItem)s) != ac;
    }

    protected Image getImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        GridData gd;
        Text entry;
        String code;
        if (this.state instanceof SimpleState && !this.inherited) {
            NameValidator nv = new NameValidator();
            Text name = this.createText(body, "&Name:", (EObject)this.state, FSMPackage.eINSTANCE.getSimpleState_Name(), nv);
            this.configureMemberAwareness((Control)name);
            this.createDecorator((Control)name, "invalid name");
            name.setFocus();
            name.selectAll();
            if (!this.where.isEmpty()) {
                name.setEnabled(false);
            }
        } else {
            this.createFixedText(body, "Name:", this.state.getName(), false);
        }
        DetailCodeToString m2s = new DetailCodeToString();
        StringToDetailCode s2m = new StringToDetailCode();
        RoomHelpers roomHelpers = SupportUtil.getInstance().getRoomHelpers();
        if (this.inherited) {
            code = roomHelpers.getDetailCode(this.state.getEntryCode());
            if (this.state instanceof RefinedState) {
                code = String.valueOf(code) + roomHelpers.getBaseEntryCode((RefinedState)this.state);
            }
            entry = this.createFixedText(body, "Entry Code:", code, true);
            gd = new GridData(1808);
            gd.heightHint = 100;
            entry.setLayoutData((Object)gd);
        } else {
            if (this.state instanceof RefinedState) {
                code = roomHelpers.getBaseEntryCode((RefinedState)this.state);
                entry = this.createFixedText(body, "Base Entry Code:", code, true);
                gd = new GridData(1808);
                gd.heightHint = 100;
                entry.setLayoutData((Object)gd);
                if (this.where.contains((Object)Where.ENTRY)) {
                    if (this.addCode) {
                        entry.append(String.valueOf(this.codeSelectionString) + "();\n");
                    }
                    this.setTextSelectionAndFocus(entry, this.codeSelectionString);
                }
            }
            this.createActionCodeEditor(body, "&Entry Code:", this.state.getEntryCode(), (EStructuralFeature)FSMPackage.eINSTANCE.getState_EntryCode(), s2m, m2s);
        }
        if (this.inherited) {
            code = roomHelpers.getDetailCode(this.state.getExitCode());
            if (this.state instanceof RefinedState) {
                code = String.valueOf(roomHelpers.getBaseExitCode((RefinedState)this.state)) + code;
            }
            entry = this.createFixedText(body, "Exit Code:", code, true);
            gd = new GridData(1808);
            gd.heightHint = 100;
            entry.setLayoutData((Object)gd);
        } else {
            this.createActionCodeEditor(body, "E&xit Code:", this.state.getExitCode(), (EStructuralFeature)FSMPackage.eINSTANCE.getState_ExitCode(), s2m, m2s);
            if (this.state instanceof RefinedState) {
                code = roomHelpers.getBaseExitCode((RefinedState)this.state);
                entry = this.createFixedText(body, "Base Exit Code:", code, true);
                gd = new GridData(1808);
                gd.heightHint = 100;
                entry.setLayoutData((Object)gd);
            }
        }
        ActorClass ac = roomHelpers.getActorClass((StateGraphItem)this.state);
        if (ac.getCommType() != ComponentCommunicationType.EVENT_DRIVEN) {
            this.createActionCodeEditor(body, "&Do Code:", this.state.getDoCode(), (EStructuralFeature)FSMPackage.eINSTANCE.getState_DoCode(), s2m, m2s);
        }
        this.createMembersAndMessagesButtons(body);
        if (!this.messageToDisplay.isEmpty()) {
            this.getShell().getParent().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)StatePropertyDialog.this.getShell(), (String)StatePropertyDialog.this.messageTitle, (String)StatePropertyDialog.this.messageToDisplay);
                }
            });
        }
    }

    private void createActionCodeEditor(Composite parent, String label, DetailCode detailCode, EStructuralFeature feat, StringToDetailCode s2m, DetailCodeToString m2s) {
        Control control;
        IActionCodeEditor entry = super.createActionCodeEditor(parent, label, detailCode, (EObject)this.state, feat, (IConverter)s2m, (IConverter)m2s, (IDetailExpressionProvider)new RuntimeDetailExpressionProvider(this.ac));
        if (entry != null) {
            control = entry.getControl();
        } else {
            Text textEntry = this.createText(parent, label, (EObject)this.state, feat, null, (IConverter)s2m, (IConverter)m2s, true);
            this.configureMemberAwareness((Control)textEntry, true, true);
            control = textEntry;
        }
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        control.setLayoutData((Object)gd);
    }

    public void setAddCode(boolean add) {
        this.addCode = add;
    }

    public void setCodeSelectionString(String selectionString, EnumSet<Where> where) {
        this.where = where;
        this.codeSelectionString = selectionString;
    }

    public void setMessageDialogContents(String message, String title) {
        this.messageToDisplay = message;
        this.messageTitle = title;
    }

    protected String getFeatureContextHelpId() {
        return null;
    }

    class NameValidator
    implements IValidator {
        NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                FSMValidationUtilXtend.Result result = SupportUtil.getInstance().getFSMValidationUtil().isUniqueName((StateGraphItem)StatePropertyDialog.this.state, name);
                if (!result.isOk()) {
                    return ValidationStatus.error((String)result.getMsg());
                }
            }
            return Status.OK_STATUS;
        }
    }

    public static enum Where {
        ENTRY,
        EXIT,
        DO;

    }
}

