/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.genmodel.fsm.base.NullDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.base.NullLogger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.detailcode.GuardDetailExpressionProvider;
import org.eclipse.etrice.ui.behavior.detailcode.RuntimeDetailExpressionProvider;
import org.eclipse.etrice.ui.behavior.fsm.actioneditor.IActionCodeEditor;
import org.eclipse.etrice.ui.behavior.fsm.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.AbstractMemberAwarePropertyDialog;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.DetailCodeToString;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IMemberAwareConfiguration;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.ITransitionPropertyDialog;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.StringToDetailCode;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.TransitionTriggerCompartment;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.base.dialogs.AbstractPropertyDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;

public class TransitionPropertyDialog
extends AbstractMemberAwarePropertyDialog
implements ITransitionPropertyDialog {
    private ActorClass ac;
    private Transition trans;
    private List<AbstractInterfaceItem> interfaceItems = new ArrayList<AbstractInterfaceItem>();
    private DetailCodeToString m2s;
    private StringToDetailCode s2m;
    private StringToDetailCode s2m_not_null;
    private DetailCodeToString m2s_null_empty;
    private boolean triggerError = false;
    private boolean inherited;
    private RefinedTransition refined;
    private String codeSelectionString = "";
    private String messageToDisplay = "";
    private String messageTitle = "";
    private TransitionTriggerCompartment triggerCompartment = null;

    public TransitionPropertyDialog(Shell shell, ActorClass ac, Transition trans) {
        super(shell, "Edit Transition", (ModelComponent)ac);
        this.ac = ac;
        this.trans = trans;
        Activator.getDefault().getInjector().injectMembers((Object)this);
        this.m2s = new DetailCodeToString();
        this.m2s_null_empty = new DetailCodeToString(true);
        this.s2m = new StringToDetailCode();
        this.s2m_not_null = new StringToDetailCode(false);
        RoomHelpers roomHelpers = SupportUtil.getInstance().getRoomHelpers();
        for (InterfaceItem item : roomHelpers.getAllInterfaceItems(ac)) {
            ProtocolClass pc = roomHelpers.getProtocol(item);
            if (pc == null || pc.getCommType() != CommunicationType.EVENT_DRIVEN) continue;
            this.interfaceItems.add((AbstractInterfaceItem)item);
        }
        this.inherited = roomHelpers.getActorClass((StateGraphItem)trans) != ac;
        this.refined = null;
        if (this.inherited && this.getModelComponent().getStateMachine() != null) {
            for (RefinedTransition rt : this.getModelComponent().getStateMachine().getRefinedTransitions()) {
                if (rt.getTarget() != trans) continue;
                this.refined = rt;
                break;
            }
        }
        if (this.inherited && this.refined == null) {
            this.setTitle("View Transition");
        }
    }

    protected Image getImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        String code;
        if (!(this.trans instanceof InitialTransition)) {
            NameValidator nv = new NameValidator(this.trans);
            if (this.inherited) {
                this.createFixedText(body, "&Name:", this.trans.getName(), false);
            } else {
                Text name = this.createText(body, "&Name:", (EObject)this.trans, FSMPackage.eINSTANCE.getTransition_Name(), nv);
                this.configureMemberAwareness((Control)name);
                this.createDecorator((Control)name, "invalid name");
                name.selectAll();
                name.setFocus();
                if (!this.codeSelectionString.isEmpty()) {
                    name.setEnabled(false);
                }
            }
        }
        if (this.trans instanceof TriggeredTransition) {
            this.triggerCompartment = new TransitionTriggerCompartment((AbstractPropertyDialog)this, this.trans, this.interfaceItems, this.inherited, (IMemberAwareConfiguration)this);
            this.triggerCompartment.createTriggerCompartment(body, mform.getToolkit());
            this.triggerError = !this.triggerCompartment.triggersAvailable();
        }
        FSMHelpers fsmHelpers = SupportUtil.getInstance().getFSMHelpers();
        VarDecl transitionEventData = null;
        ExpandedActorClass xpac = new GeneratorModelBuilder((ILogger)new NullLogger(), (IDiagnostician)new NullDiagnostician()).createExpandedActorClass(this.ac);
        if (xpac != null && xpac.getCopy((EObject)this.trans) instanceof Transition) {
            transitionEventData = xpac.getVarDeclData((Transition)xpac.getCopy((EObject)this.trans));
        }
        if (this.trans instanceof GuardedTransition) {
            GuardedTransition guardedTrans = (GuardedTransition)this.trans;
            if (this.inherited) {
                String code2 = fsmHelpers.getDetailCode(guardedTrans.getGuard());
                this.createFixedText(body, "&Guard:", code2, true);
            } else {
                GuardValidator gv = new GuardValidator("guard must not be empty");
                GuardDetailExpressionProvider exprProvider = new GuardDetailExpressionProvider(this.ac);
                exprProvider.setTransitionEventData(transitionEventData);
                this.createActionCodeEditor(body, "&Guard:", guardedTrans.getGuard(), (EObject)this.trans, (EStructuralFeature)FSMPackage.eINSTANCE.getGuardedTransition_Guard(), gv, (IConverter)this.s2m_not_null, (IConverter)this.m2s_null_empty, true, true, true, "empty guard", exprProvider);
            }
        }
        if (this.trans instanceof CPBranchTransition) {
            if (this.inherited) {
                code = fsmHelpers.getDetailCode(((CPBranchTransition)this.trans).getCondition());
                this.createFixedText(body, "&Condition", code, true);
            } else {
                GuardValidator gv = new GuardValidator("condition must not be empty");
                GuardDetailExpressionProvider exprProvider = new GuardDetailExpressionProvider(this.ac);
                exprProvider.setTransitionEventData(transitionEventData);
                this.createActionCodeEditor(body, "&Condition:", this.trans.getAction(), (EObject)this.trans, (EStructuralFeature)FSMPackage.eINSTANCE.getCPBranchTransition_Condition(), gv, (IConverter)this.s2m_not_null, (IConverter)this.m2s_null_empty, true, true, true, "empty condition", exprProvider);
            }
        }
        if ((code = fsmHelpers.getInheritedActionCode(this.trans, this.getModelComponent())) != null) {
            Text baseActionCode = this.createFixedText(body, "Base Action Code:", code, true);
            this.setTextSelectionAndFocus(baseActionCode, this.codeSelectionString);
        }
        RuntimeDetailExpressionProvider exprProvider = new RuntimeDetailExpressionProvider(this.ac);
        exprProvider.setTransitionEventData(transitionEventData);
        if (this.inherited) {
            if (this.refined != null) {
                this.createActionCodeEditor(body, "&Action Code:", this.refined.getAction(), (EObject)this.refined, (EStructuralFeature)FSMPackage.eINSTANCE.getRefinedTransition_Action(), null, (IConverter)this.s2m, (IConverter)this.m2s, true, true, false, null, exprProvider);
            }
        } else {
            this.createActionCodeEditor(body, "&Action Code:", this.trans.getAction(), (EObject)this.trans, (EStructuralFeature)FSMPackage.eINSTANCE.getTransition_Action(), null, (IConverter)this.s2m, (IConverter)this.m2s, true, true, false, null, exprProvider);
        }
        this.createMembersAndMessagesButtons(body);
        if (!this.messageToDisplay.isEmpty()) {
            this.getShell().getParent().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)TransitionPropertyDialog.this.getShell(), (String)TransitionPropertyDialog.this.messageTitle, (String)TransitionPropertyDialog.this.messageToDisplay);
                }
            });
        }
    }

    protected void updateValidationFeedback(boolean ok) {
        if (ok && this.triggerError) {
            ok = false;
            this.setValidationText("no triggers available");
        }
        if (ok && this.inherited && this.refined == null) {
            this.setValidationFeedbackOff();
            return;
        }
        super.updateValidationFeedback(ok);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.inherited || this.triggerCompartment == null || !this.triggerCompartment.triggersAvailable()) {
            this.getButton(0).setEnabled(false);
        }
    }

    public void setCodeSelectionString(String selectionString) {
        this.codeSelectionString = selectionString;
    }

    public void setMessageDialogContents(String message, String title) {
        this.messageToDisplay = message;
        this.messageTitle = title;
    }

    private void createActionCodeEditor(Composite parent, String label, DetailCode detailCode, EObject obj, EStructuralFeature feat, IValidator singleValidator, IConverter s2m, IConverter m2s, boolean useMembers, boolean useMessages, boolean useRecvMessagesOnly, String decoratorString, IDetailExpressionProvider exprProvider) {
        Control control;
        IActionCodeEditor entry = super.createActionCodeEditor(parent, label, detailCode, obj, feat, singleValidator, null, s2m, m2s, useMembers, useMessages, useRecvMessagesOnly, exprProvider);
        if (entry != null) {
            control = entry.getControl();
        } else {
            Text textEntry = this.createText(parent, label, obj, feat, null, s2m, m2s, true);
            this.configureMemberAwareness((Control)textEntry, useMembers, useMessages, useRecvMessagesOnly);
            control = textEntry;
        }
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        control.setLayoutData((Object)gd);
        if (decoratorString != null) {
            this.createDecorator(control, decoratorString);
        }
    }

    protected String getFeatureContextHelpId() {
        return null;
    }

    protected static class GuardValidator
    implements IValidator {
        private String text;

        public GuardValidator(String text) {
            this.text = text;
        }

        public IStatus validate(Object value) {
            String name;
            if (value instanceof String ? (name = (String)value).isEmpty() : value instanceof DetailCode && SupportUtil.getInstance().getFSMHelpers().getDetailCode((DetailCode)value).trim().isEmpty()) {
                return ValidationStatus.error((String)this.text);
            }
            return Status.OK_STATUS;
        }
    }

    protected static class NameValidator
    implements IValidator {
        private Transition trans;

        public NameValidator(Transition trans) {
            this.trans = trans;
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                FSMValidationUtilXtend.Result result = SupportUtil.getInstance().getFSMValidationUtil().isUniqueName((StateGraphItem)this.trans, name);
                if (!result.isOk()) {
                    return ValidationStatus.error((String)result.getMsg());
                }
            }
            return Status.OK_STATUS;
        }
    }
}

