/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.ui.Activator;
import org.eclipse.etrice.generator.ui.wizard.EmptyProjectConfigPage;
import org.eclipse.etrice.generator.ui.wizard.ProjectCreator;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class EmptyProjectWizard
extends Wizard
implements INewWizard {
    static final String MODEL_NAME = "TemplateModel";
    static final String PROJECT_CONTENT_ZIP = "/content/org.eclipse.etrice.template.java.zip";
    static final String ROOM_EDITOR_ID = "org.eclipse.etrice.core.Room";
    static final String MODELLIB_WIZARD_ID = "org.eclipse.etrice.ui.runtime.NewJavaModelLibWizard";
    protected IWorkbench workbench;
    protected IPath projectLocation;
    protected IPath sourcePath;
    protected IPath sourceGenPath;
    protected IProject project;
    protected IProject runtimeProject;
    protected IProject modellibProject;
    protected String initialProjectName;
    private EmptyProjectConfigPage config;
    private static final String[] additionalLaunchConfigLines = new String[]{"<stringAttribute key=\"org.eclipse.debug.core.ATTR_REFRESH_SCOPE\" value=\"${workspace}\"/>"};
    protected static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setDefaultPageImageDescriptor(ProjectCreator.getImageDescriptor("icons/NewETriceProjectWizban.gif"));
        this.setWindowTitle("eTrice Java Template Project");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.runtimeProject = workspace.getRoot().getProject("org.eclipse.etrice.runtime.java");
        this.modellibProject = workspace.getRoot().getProject("org.eclipse.etrice.modellib.java");
    }

    public void addPages() {
        WizardNewProjectCreationPage newProjectCreationPage = new WizardNewProjectCreationPage("NewProjectCreationPage"){

            protected boolean validatePage() {
                if (super.validatePage()) {
                    IPath locationPath = this.getLocationPath();
                    EmptyProjectWizard.this.projectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationPath;
                    IPath projectPath = this.getProjectHandle().getFullPath();
                    EmptyProjectWizard.this.sourcePath = projectPath.append("src");
                    EmptyProjectWizard.this.sourceGenPath = projectPath.append("src-gen");
                    return true;
                }
                return false;
            }
        };
        newProjectCreationPage.setInitialProjectName(this.initialProjectName);
        newProjectCreationPage.setTitle("Template eTrice Project");
        newProjectCreationPage.setDescription("Create the template Java project with eTrice dependencies");
        this.addPage((IWizardPage)newProjectCreationPage);
        this.config = new EmptyProjectConfigPage("config");
        this.config.setTitle("Project Configuration");
        this.config.setDescription("Choose a build type for the project");
        this.addPage((IWizardPage)this.config);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ArrayList<IProject> referencedProjects = new ArrayList<IProject>();
                        if (EmptyProjectWizard.this.config.useJDTBuild()) {
                            if (EmptyProjectWizard.this.runtimeProject != null) {
                                referencedProjects.add(EmptyProjectWizard.this.runtimeProject);
                            }
                            if (EmptyProjectWizard.this.modellibProject != null) {
                                referencedProjects.add(EmptyProjectWizard.this.modellibProject);
                            }
                        }
                        ArrayList<String> natures = new ArrayList<String>(ProjectCreator.getCommonNatureIDs());
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            natures.add("org.eclipse.m2e.core.maven2Nature");
                        }
                        ArrayList<String> builders = new ArrayList<String>(ProjectCreator.getCommonBuilderIDs());
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            builders.add("org.eclipse.m2e.core.maven2Builder");
                        }
                        ArrayList<IClasspathEntry> pathEntries = new ArrayList<IClasspathEntry>();
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            IClasspathEntry mvnContainer = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"), (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"maven.pomderived", (String)"true")}, (boolean)false);
                            pathEntries.add(mvnContainer);
                        }
                        URI modelProjectURI = EmptyProjectWizard.this.projectLocation == null ? null : URI.createFileURI((String)EmptyProjectWizard.this.projectLocation.toOSString());
                        EmptyProjectWizard.this.project = ProjectCreator.createETriceProject((IPath)new Path(EmptyProjectWizard.this.sourcePath.toString()), (IPath)new Path(EmptyProjectWizard.this.sourceGenPath.toString()), modelProjectURI, referencedProjects, natures, builders, pathEntries, BasicMonitor.toMonitor((IProgressMonitor)progressMonitor));
                        String projectName = EmptyProjectWizard.this.project.getName();
                        URI projectURI = URI.createPlatformResourceURI((String)projectName, (boolean)true);
                        String modelName = EmptyProjectWizard.MODEL_NAME;
                        ProjectCreator.createBuildProperties(projectURI.appendSegment("build.properties"), modelName);
                        ProjectCreator.createLaunchGeneratorConfig(projectURI.appendSegment("generate_Template.launch"), "java", "/" + projectName + "/model", "Mapping", "main", additionalLaunchConfigLines);
                        ProjectCreator.createLaunchJavaApplicationConfig(projectURI.appendSegment("run_Template.launch"), projectName, EmptyProjectWizard.MODEL_NAME, "Node_node_subSystemRefRunner");
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            ProjectCreator.createMavenPOM(projectURI.appendSegment("pom.xml"), projectName, EmptyProjectWizard.MODEL_NAME, "Node_node_subSystemRefRunner");
                            ProjectCreator.createMavenBuilder(projectURI.appendSegment("build_" + modelName + ".launch"), projectName);
                            ProjectCreator.createMavenLauncher(projectURI.appendSegment("runjar_" + modelName + ".launch"), projectName, EmptyProjectWizard.MODEL_NAME);
                        }
                        EmptyProjectWizard.this.importContent(EmptyProjectWizard.this.project, progressMonitor);
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage(), (Throwable)e);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if (this.config.useJDTBuild()) {
            this.invokeLibraryWizard();
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IFile roomFile = this.project.getFile("/model/TemplateModel.room");
        if (roomFile != null && roomFile.exists()) {
            BasicNewProjectResourceWizard.selectAndReveal((IResource)roomFile, (IWorkbenchWindow)activeWindow);
            try {
                activeWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(roomFile), ROOM_EDITOR_ID, true, 2);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return true;
    }

    public void setInitialProjectName(String value) {
        this.initialProjectName = value;
    }

    private void invokeLibraryWizard() {
        if (this.runtimeProject != null && this.runtimeProject.exists() && this.modellibProject != null && this.modellibProject.exists()) {
            return;
        }
        IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(MODELLIB_WIZARD_ID);
        if (descriptor == null) {
            return;
        }
        try {
            IWorkbenchWizard wizard = descriptor.createWizard();
            WizardDialog wd = new WizardDialog(this.getShell(), (IWizard)wizard);
            wd.setTitle(wizard.getWindowTitle());
            wd.open();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void importContent(IProject project, IProgressMonitor progressMonitor) {
        block14: {
            URL contentURL = Activator.getInstance().getBundle().getEntry(PROJECT_CONTENT_ZIP);
            ZipFile zipFile = null;
            try {
                try {
                    ImportOperation importOperation = null;
                    URL resolvedURL = FileLocator.toFileURL((URL)contentURL);
                    java.net.URI resolvedURI = new java.net.URI(resolvedURL.getProtocol(), resolvedURL.getPath(), null);
                    File file = new File(resolvedURI);
                    if (file.isFile() && file.canRead() && (zipFile = new ZipFile(file)) != null) {
                        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
                        importOperation = new ImportOperation(project.getFullPath(), (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, OVERWRITE_ALL_QUERY);
                    }
                    if (importOperation != null) {
                        importOperation.setContext(this.getShell());
                        importOperation.run((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                }
                catch (Exception e) {
                    DiagnosticDialog.open((Shell)this.getShell(), (String)"EmptyProjectWizardError", (String)contentURL.toString(), (Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)e));
                    if (zipFile == null) break block14;
                    try {
                        zipFile.close();
                    }
                    catch (IOException e2) {
                        DiagnosticDialog.open((Shell)this.getShell(), (String)"EmptyProjectWizardError", (String)"debug", (Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)e2));
                    }
                }
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        DiagnosticDialog.open((Shell)this.getShell(), (String)"EmptyProjectWizardError", (String)"debug", (Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)e));
                    }
                }
            }
        }
    }
}

