/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.etrice.core.ui.RoomUiActivator;
import org.eclipse.etrice.generator.ui.wizard.ProjectFileFragments;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProjectCreator {
    private static final String[] commonNatureIDs = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.xtext.ui.shared.xtextNature"};
    private static final String[] commonBuilderIDs = new String[]{"org.eclipse.xtext.ui.shared.xtextBuilder"};

    public static List<String> getCommonNatureIDs() {
        return Arrays.asList(commonNatureIDs);
    }

    public static List<String> getCommonBuilderIDs() {
        return Arrays.asList(commonBuilderIDs);
    }

    public static IProject createETriceProject(IPath javaSource, IPath javaSourceGen, URI projectLocationURI, List<IProject> referencedProjects, List<String> naturesToAdd, List<String> buildersToAdd, List<IClasspathEntry> pathEntries, Monitor monitor) {
        IProgressMonitor progressMonitor = BasicMonitor.toIProgressMonitor((Monitor)monitor);
        String projectName = javaSource.segment(0);
        IProject project = null;
        try {
            try {
                UniqueEList classpathEntries = new UniqueEList();
                progressMonitor.beginTask("", 10);
                progressMonitor.subTask("Creating eTrice project " + projectName + " (" + (projectLocationURI != null ? projectLocationURI.toString() : projectName) + ")");
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                project = workspace.getRoot().getProject(projectName);
                if (!project.exists()) {
                    File projectFile;
                    URI location = projectLocationURI;
                    if (location == null) {
                        location = URI.createFileURI((String)workspace.getRoot().getLocation().append(projectName).toOSString());
                    }
                    if ((projectFile = new File((location = location.appendSegment(".project")).toString())).exists()) {
                        projectFile.renameTo(new File(String.valueOf(location.toString()) + ".old"));
                    }
                }
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IProjectDescription projectDescription = null;
                if (!project.exists()) {
                    projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                    if (projectLocationURI != null) {
                        projectDescription.setLocationURI(new java.net.URI(projectLocationURI.toString()));
                    }
                    project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    projectDescription = project.getDescription();
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
                    }
                }
                boolean isInitiallyEmpty = classpathEntries.isEmpty();
                if (!referencedProjects.isEmpty()) {
                    projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                    for (IProject referencedProject : referencedProjects) {
                        IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                        classpathEntries.add(referencedProjectClasspathEntry);
                    }
                }
                ProjectCreator.addNatures(projectDescription, naturesToAdd);
                ProjectCreator.addBuilders(projectDescription, buildersToAdd);
                project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                ProjectCreator.createSrcFolder(progressMonitor, project, (List<IClasspathEntry>)classpathEntries, javaSource);
                ProjectCreator.createSrcFolder(progressMonitor, project, (List<IClasspathEntry>)classpathEntries, javaSourceGen);
                if (isInitiallyEmpty) {
                    IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                    Iterator i = classpathEntries.iterator();
                    while (i.hasNext()) {
                        IClasspathEntry classpathEntry = (IClasspathEntry)i.next();
                        if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                        i.remove();
                    }
                    String jreContainer = JavaRuntime.JRE_CONTAINER;
                    jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6";
                    classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(jreContainer)));
                }
                for (IClasspathEntry pathEntry : pathEntries) {
                    classpathEntries.add(pathEntry);
                }
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                if (isInitiallyEmpty) {
                    javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                if (isInitiallyEmpty) {
                    javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
            }
            catch (Exception e) {
                Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return project;
    }

    private static void addNatures(IProjectDescription desc, List<String> naturesToAdd) {
        HashSet<String> natures = new HashSet<String>();
        String[] ids = desc.getNatureIds();
        if (ids != null) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                natures.add(id);
                ++n2;
            }
        }
        natures.addAll(naturesToAdd);
        ids = new String[natures.size()];
        ids = natures.toArray(ids);
        desc.setNatureIds(ids);
    }

    private static void addBuilders(IProjectDescription desc, List<String> buildersToAdd) {
        ICommand[] buildSpecs;
        HashMap<String, ICommand> builders = new HashMap<String, ICommand>();
        ICommand[] iCommandArray = buildSpecs = desc.getBuildSpec();
        int n = buildSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand spec = iCommandArray[n2];
            builders.put(spec.getBuilderName(), spec);
            ++n2;
        }
        for (String builder : buildersToAdd) {
            if (builders.containsKey(builder)) continue;
            ICommand cmd = desc.newCommand();
            cmd.setBuilderName(builder);
            builders.put(builder, cmd);
        }
        buildSpecs = new ICommand[builders.size()];
        buildSpecs = builders.values().toArray(buildSpecs);
        desc.setBuildSpec(buildSpecs);
    }

    private static void createSrcFolder(IProgressMonitor progressMonitor, IProject project, List<IClasspathEntry> classpathEntries, IPath src) throws CoreException {
        if (src.segmentCount() > 1) {
            IPath sourceContainerPath = src.removeFirstSegments(1).makeAbsolute();
            IFolder sourceContainer = project.getFolder(sourceContainerPath);
            if (!sourceContainer.exists()) {
                int i = sourceContainerPath.segmentCount() - 1;
                while (i >= 0) {
                    sourceContainer = project.getFolder(sourceContainerPath.removeLastSegments(i));
                    if (!sourceContainer.exists()) {
                        sourceContainer.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    --i;
                }
            }
            IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)src);
            Iterator<IClasspathEntry> i = classpathEntries.iterator();
            while (i.hasNext()) {
                IClasspathEntry classpathEntry = i.next();
                if (!classpathEntry.getPath().isPrefixOf(src)) continue;
                i.remove();
            }
            classpathEntries.add(0, sourceClasspathEntry);
        }
    }

    protected static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IPath localLocation, IProgressMonitor progressMonitor) throws CoreException {
        String projectName = path.segment(0);
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        projectDescription.setLocation(localLocation);
        return ProjectCreator.findOrCreateContainer(path, forceRefresh, projectDescription, progressMonitor);
    }

    protected static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IProjectDescription projectDescription, IProgressMonitor progressMonitor) throws CoreException {
        try {
            String projectName = path.segment(0);
            progressMonitor.beginTask("", path.segmentCount() + 3);
            progressMonitor.subTask("examine new project " + projectName);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(path.segment(0));
            if (forceRefresh) {
                project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                progressMonitor.worked(1);
            }
            if (!project.exists()) {
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 2));
            }
            IProject container = project;
            int i = 1;
            int length = path.segmentCount();
            while (i < length) {
                IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                if (!folder.exists()) {
                    folder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    progressMonitor.worked(1);
                }
                container = folder;
                ++i;
            }
            IProject iProject = container;
            return iProject;
        }
        finally {
            progressMonitor.done();
        }
    }

    public static void createModel(URI uri, String baseName) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getBasicRoomModel(baseName));
    }

    public static void createPhysicalModel(URI uri, String baseName) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getBasicPhysicalModel(baseName));
    }

    public static void createMappingModel(URI uri, String baseName) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getBasicMappingModel(baseName));
    }

    public static void createBuildProperties(URI uri, String baseName) {
        try {
            PrintStream prop = new PrintStream(URIConverter.INSTANCE.createOutputStream(uri, null), false, "UTF-8");
            prop.println("source.. = src/,\\");
            prop.println("src-gen/");
            prop.close();
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void createLaunchGeneratorConfig(URI uri, String targetLanguage, String modelPath, String baseName, String mainMethodName, String[] addLines) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getGeneratorLaunchConfig(targetLanguage, modelPath, baseName, mainMethodName, addLines));
    }

    public static void createLaunchJavaApplicationConfig(URI uri, String project, String mdlName, String mainClass) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getLaunchJavaApplicationConfig(project, mdlName, mainClass));
    }

    public static void createLaunchCApplicationConfig(URI uri, String project) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getLaunchCApplicationConfig(project));
    }

    public static void createRunAndLaunchConfigurations(String baseName, IProject project, String mdlPath, String mainMethodName, String[] additionalLaunchConfigLines) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            ProjectCreator.createLaunchGeneratorConfig(URI.createPlatformResourceURI((String)("/" + project.getName() + "/gen_" + baseName + ".launch"), (boolean)true), "java", mdlPath, baseName, mainMethodName, additionalLaunchConfigLines);
            ProjectCreator.createLaunchJavaApplicationConfig(URI.createPlatformResourceURI((String)("/" + project.getName() + "/run_" + baseName + ".launch"), (boolean)true), project.getName(), baseName, "Node_nodeRef1_mainRunner");
        } else if (project.hasNature("org.eclipse.cdt.core.cnature")) {
            ProjectCreator.createLaunchGeneratorConfig(URI.createPlatformResourceURI((String)("/" + project.getName() + "/gen_" + baseName + ".launch"), (boolean)true), "c", mdlPath, baseName, mainMethodName, additionalLaunchConfigLines);
            ProjectCreator.createLaunchCApplicationConfig(URI.createPlatformResourceURI((String)("/" + project.getName() + "/run_" + baseName + ".launch"), (boolean)true), project.getName());
        }
    }

    public static void createMavenPOM(URI uri, String project, String mdlName, String mainClass) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getMavenPOM(project, mdlName, mainClass));
    }

    public static void createMavenBuilder(URI uri, String project) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getMavenBuilder(project));
    }

    public static void createMavenLauncher(URI uri, String project, String mdlName) {
        ProjectCreator.writeFile(uri, ProjectFileFragments.getMavenLauncher(project, mdlName));
    }

    public static void addXtextNature(IProject project, IProgressMonitor progressMonitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ProjectCreator.addNatures(description, Collections.singletonList("org.eclipse.xtext.ui.shared.xtextNature"));
        ProjectCreator.addBuilders(description, Collections.singletonList("org.eclipse.xtext.ui.shared.xtextBuilder"));
        project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor desc = RoomUiActivator.getDefault().getImageRegistry().getDescriptor(path);
        if (desc == null) {
            desc = RoomUiActivator.imageDescriptorFromPlugin((String)"org.eclipse.etrice.core.room.ui", (String)path);
            if (desc == null) {
                System.err.println("image not found: " + path);
            } else {
                RoomUiActivator.getDefault().getImageRegistry().put(path, desc);
                RoomUiActivator.getDefault().getImageRegistry().get(path);
            }
        }
        return desc;
    }

    private static void writeFile(URI uri, String contents) {
        try {
            PrintStream model = new PrintStream(URIConverter.INSTANCE.createOutputStream(uri, null), false, "UTF-8");
            model.print(contents);
            model.close();
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

