/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard.deprecated;

import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.ui.wizard.deprecated.MappingCreationPage;
import org.eclipse.etrice.generator.ui.wizard.deprecated.SaveMappingPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectRoomPage
extends WizardPage
implements SelectionListener {
    private Text roomFileText;
    private TreeViewer roomContentTree;
    private ILabelProvider roomLabelProvider;
    private IResource resourceSelection = null;
    private RoomModel selectedRoomModel = null;

    public SelectRoomPage(IStructuredSelection initialSelection, Injector roomInjector) {
        super("select_room_page");
        this.roomLabelProvider = (ILabelProvider)roomInjector.getInstance(ILabelProvider.class);
        if (initialSelection != null && initialSelection.getFirstElement() instanceof IResource) {
            this.resourceSelection = (IResource)initialSelection.getFirstElement();
        }
    }

    public RoomModel getSelectedRoomModel() {
        return this.selectedRoomModel;
    }

    public IFile getSelectedRoomResource() {
        if (this.selectedRoomModel != null) {
            return (IFile)this.resourceSelection;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout gl_topLevel = new GridLayout();
        gl_topLevel.marginHeight = 0;
        topLevel.setLayout((Layout)gl_topLevel);
        topLevel.setLayoutData((Object)new GridData(4, 4, true, true));
        topLevel.setFont(parent.getFont());
        Composite firstComp = new Composite(topLevel, 0);
        firstComp.setLayout((Layout)new GridLayout(3, false));
        firstComp.setLayoutData((Object)new GridData(4, 1, true, false));
        Label roomFileLabel = new Label(firstComp, 0);
        roomFileLabel.setText(".room file: ");
        this.roomFileText = new Text(firstComp, 2048);
        this.roomFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.roomFileText.setEditable(false);
        Button roomFileBrowse = new Button(firstComp, 8);
        roomFileBrowse.setText("Browse");
        roomFileBrowse.addSelectionListener((SelectionListener)this);
        Label separator = new Label(topLevel, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.roomContentTree = new TreeViewer(topLevel, 2560);
        this.roomContentTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.roomContentTree.setLabelProvider((IBaseLabelProvider)this.roomLabelProvider);
        this.roomContentTree.setContentProvider((IContentProvider)new ContenProvider());
        this.roomContentTree.getTree().setEnabled(false);
        this.roomContentTree.setAutoExpandLevel(-1);
        this.setControl((Control)topLevel);
        this.setUserInput(this.resourceSelection);
        this.setPageComplete();
    }

    public void widgetSelected(SelectionEvent e) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Select a .room file");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IResource && !(element instanceof IFile) || ((IFile)element).getName().endsWith(".room");
            }
        });
        if (this.resourceSelection != null) {
            dialog.setInitialSelection((Object)this.resourceSelection);
            if (dialog.getFirstResult() == null) {
                dialog.setInitialSelection((Object)this.resourceSelection.getParent());
            }
        }
        if (dialog.open() != 0 || dialog.getFirstResult() == null) {
            return;
        }
        this.setUserInput((IResource)dialog.getFirstResult());
        this.setPageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void setUserInput(IResource resource) {
        RoomModel model;
        this.resourceSelection = resource;
        this.roomContentTree.setInput(null);
        this.selectedRoomModel = null;
        if (this.resourceSelection == null) {
            this.roomFileText.setText("");
            return;
        }
        String path = resource.getFullPath().toString();
        this.roomFileText.setText(resource.getFullPath().removeFirstSegments(1).toString());
        if (!(resource instanceof IFile)) {
            this.setErrorMessage("Selected path must be a file.");
            return;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)path, (boolean)false);
        Resource roomRes = rs.getResource(uri, true);
        if (roomRes != null && !roomRes.getContents().isEmpty() && roomRes.getContents().iterator().next() instanceof RoomModel) {
            this.roomContentTree.setInput((Object)roomRes);
            model = (RoomModel)roomRes.getContents().iterator().next();
            if (model.getSystems().isEmpty()) {
                this.setErrorMessage("Room model must contain at least one logical system");
                return;
            }
            if (!roomRes.getErrors().isEmpty()) {
                this.setErrorMessage("Room model has validation erros");
                return;
            }
        } else {
            this.setErrorMessage("Selected file does not contain a ROOM model.");
            return;
        }
        this.selectedRoomModel = model;
        this.setErrorMessage(null);
    }

    protected void setPageComplete() {
        this.setPageComplete(this.selectedRoomModel != null);
        if (this.isPageComplete()) {
            MappingCreationPage page2 = (MappingCreationPage)this.getWizard().getPages()[1];
            page2.createMapping(this.selectedRoomModel);
            SaveMappingPage page3 = (SaveMappingPage)this.getWizard().getPages()[2];
            page3.setModelPath((IFile)this.resourceSelection);
        }
    }

    private class ContenProvider
    implements ITreeContentProvider {
        private ContenProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.getControl().setEnabled(newInput != null);
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Resource) {
                return new Object[]{((Resource)inputElement).getContents().iterator().next()};
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList objects = new ArrayList();
            if (parentElement instanceof RoomModel) {
                RoomModel model = (RoomModel)parentElement;
                objects.addAll(model.getSystems());
            } else if (parentElement instanceof LogicalSystem) {
                objects.addAll(((LogicalSystem)parentElement).getSubSystems());
            }
            return objects.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof RoomModel || element instanceof LogicalSystem;
        }
    }
}

