/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.etrice.generator.ui.wizard.WizardHelpers;
import org.eclipse.etrice.generator.ui.wizard.internal.IProjectPathProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class COptionsPage
extends WizardPage {
    private IProjectPathProvider projectPathProvider;
    private Button copyRuntimeButton = null;
    private Combo platformCombo = null;
    private Text mainMethodName = null;

    public COptionsPage(String title, IProjectPathProvider projectPathProvider) {
        super(title);
        this.projectPathProvider = projectPathProvider;
    }

    public void createControl(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridData gd = new GridData(130);
        buttonComposite.setLayoutData((Object)gd);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.copyRuntimeButton = new Button(buttonComposite, 32);
        this.copyRuntimeButton.setText("&Copy C-Runtime into project");
        this.copyRuntimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.copyRuntimeButton.setLayoutData((Object)gd);
        Label l = new Label(buttonComposite, 0);
        l.setText("Select active platform:");
        l.setLayoutData((Object)new GridData(0));
        this.platformCombo = new Combo(buttonComposite, 8);
        gd = new GridData(256);
        gd.widthHint = 200;
        this.platformCombo.setLayoutData((Object)gd);
        this.platformCombo.setVisibleItemCount(10);
        l = new Label(buttonComposite, 0);
        l.setText("Main method name:");
        l.setLayoutData((Object)new GridData(0));
        this.mainMethodName = new Text(buttonComposite, 2052);
        this.mainMethodName.setLayoutData((Object)new GridData(768));
        this.mainMethodName.setText("main");
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)buttonComposite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refresh();
        }
    }

    private void refresh() {
        this.copyRuntimeButton.setEnabled(false);
        this.platformCombo.setEnabled(false);
        this.platformCombo.removeAll();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath chosenPath = this.projectPathProvider.getPath();
        IProject project = chosenPath.segmentCount() == 1 ? workspace.getRoot().getProject(chosenPath.lastSegment()) : workspace.getRoot().getFolder(chosenPath).getProject();
        try {
            if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                this.copyRuntimeButton.setEnabled(true);
                this.platformCombo.setEnabled(true);
                List<String> platformNames = this.getPlatformNames();
                for (String name : platformNames) {
                    this.platformCombo.add(name);
                }
                this.platformCombo.select(0);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private List<String> getPlatformNames() {
        ArrayList<String> result = new ArrayList<String>();
        ZipFile zipFile = WizardHelpers.getCRuntimeZip();
        if (zipFile != null) {
            ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
            List children = structureProvider.getChildren((Object)structureProvider.getRoot());
            ZipEntry current = null;
            for (Object child : children) {
                if (!(child instanceof ZipEntry) || !((ZipEntry)child).getName().equals("src/")) continue;
                current = (ZipEntry)child;
                break;
            }
            if (current != null) {
                children = structureProvider.getChildren(current);
                current = null;
                for (Object child : children) {
                    if (!(child instanceof ZipEntry) || !((ZipEntry)child).getName().equals("src/platforms/")) continue;
                    current = (ZipEntry)child;
                    break;
                }
            }
            if (current != null) {
                children = structureProvider.getChildren(current);
                for (Object child : children) {
                    String name;
                    if (!(child instanceof ZipEntry) || !(name = ((ZipEntry)child).getName()).endsWith("/")) continue;
                    String[] split = name.split("/");
                    result.add(split[split.length - 1]);
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getCopyRuntime() {
        if (this.copyRuntimeButton != null && !this.copyRuntimeButton.isDisposed()) {
            return this.copyRuntimeButton.getSelection();
        }
        return false;
    }

    public String getPlatform() {
        if (this.platformCombo != null && !this.platformCombo.isDisposed() && this.platformCombo.getSelectionIndex() >= 0) {
            return this.platformCombo.getText();
        }
        return "";
    }

    public String getMainMethodName() {
        if (this.mainMethodName != null && !this.mainMethodName.isDisposed()) {
            return this.mainMethodName.getText();
        }
        return "main";
    }
}

