/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.etunit.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.etrice.etunit.converter.Etunit.DocumentRoot;
import org.eclipse.etrice.etunit.converter.Etunit.EtunitFactory;
import org.eclipse.etrice.etunit.converter.Etunit.EtunitPackage;
import org.eclipse.etrice.etunit.converter.Etunit.FailureType;
import org.eclipse.etrice.etunit.converter.Etunit.TestcaseType;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuiteType;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuitesType;
import org.eclipse.etrice.etunit.converter.Etunit.util.EtunitResourceFactoryImpl;

public class EtUnitReportConverter {
    private static final String TC_END = "tc end";
    private static final String TC_FAIL = "tc fail";
    private static final String TC_START = "tc start";
    private static final String TS_START = "ts start: ";
    public static final String ETU_EXTENSION = ".etu";
    public static final String OPTION_COMBINED = "-combined";
    public static final String OPTION_ONLY_COMBINED = "-only_combined";
    public static final String OPTION_SUITE_NAME = "-suite";

    protected void printUsage() {
        System.err.println("usage: EtUnitReportConverter [(-combined|-only_combined) <combined file>] [-suite <name>] <*.etu files>\n    -combined <combined file>: also save a combined result for all tests to the specified file\n    -only_combined <combined file>: don't create reports for every single test, only combined one to the specified file\n    -suite <name>: replace the suite name in the result\n");
    }

    public static void main(String[] args) {
        new EtUnitReportConverter().run(args);
    }

    protected void run(String[] args) {
        Options options = this.parseOptions(args);
        if (options == null) {
            System.exit(1);
        }
        this.doEMFRegistration();
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new EtunitResourceFactoryImpl());
        boolean success = this.saveReports(options, (ResourceSet)rs);
        if (!this.saveCombinedReport(options, (ResourceSet)rs)) {
            success = false;
        }
        if (!success) {
            System.exit(2);
        }
    }

    protected Options parseOptions(String[] args) {
        Options options = new Options();
        if (!options.parseOptions(args)) {
            this.printUsage();
            return null;
        }
        return options;
    }

    protected boolean saveCombinedReport(Options options, ResourceSet rs) {
        if (options.needCombined()) {
            DocumentRoot root = EtunitFactory.eINSTANCE.createDocumentRoot();
            TestsuitesType testsuites = EtunitFactory.eINSTANCE.createTestsuitesType();
            root.setTestsuites(testsuites);
            for (Resource res : rs.getResources()) {
                DocumentRoot r = (DocumentRoot)res.getContents().get(0);
                testsuites.getTestsuite().addAll(r.getTestsuites().getTestsuite());
            }
            this.computeAndSetInfo(testsuites);
            return this.saveCombined(root, options, rs);
        }
        return true;
    }

    protected boolean saveCombined(DocumentRoot root, Options options, ResourceSet rs) {
        if (options.isCombinedResults()) {
            File report = new File(options.getCombinedFile());
            return this.saveJUnitReport(root, report, rs, true);
        }
        return true;
    }

    protected boolean saveReports(Options options, ResourceSet rs) {
        boolean success = true;
        for (String file : options.getFiles()) {
            File report = new File(file);
            if (report.exists()) {
                DocumentRoot root = this.createParseTree(report);
                if (root != null && options.isReplaceSuiteName() && root.getTestsuites() != null) {
                    if (root.getTestsuites().getTestsuite().size() == 1) {
                        ((TestsuiteType)root.getTestsuites().getTestsuite().get(0)).setName(options.getSuiteName());
                    } else {
                        int i = 0;
                        for (TestsuiteType suite : root.getTestsuites().getTestsuite()) {
                            suite.setName(String.valueOf(options.getSuiteName()) + i);
                            ++i;
                        }
                    }
                }
                if (root == null || this.saveJUnitReport(root, report, rs, !options.isCombinedResults())) continue;
                success = false;
                continue;
            }
            System.err.println("Error: report " + file + " does not exist");
            success = false;
        }
        return success;
    }

    private void computeAndSetInfo(TestsuitesType testsuites) {
        for (TestsuiteType ts : testsuites.getTestsuite()) {
            int failures = 0;
            BigDecimal time = new BigDecimal(0);
            for (TestcaseType tc : ts.getTestcase()) {
                if (tc.getTime() != null) {
                    time = time.add(tc.getTime());
                }
                if (tc.getFailure() == null) continue;
                ++failures;
            }
            ts.setTests(ts.getTestcase().size());
            ts.setFailures(failures);
            ts.setTime(time);
        }
    }

    private boolean saveJUnitReport(DocumentRoot root, File report, ResourceSet rs, boolean save) {
        URI uri = URI.createFileURI((String)report.toString());
        uri = uri.trimFileExtension();
        uri = uri.appendFileExtension("xml");
        Resource resource = rs.createResource(uri);
        resource.getContents().add((Object)root);
        if (save) {
            try {
                resource.save(Collections.EMPTY_MAP);
                System.out.println("saved " + uri);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Error: file " + uri + " could not be saved (" + e.getMessage() + ")");
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DocumentRoot createParseTree(File report) {
        int count = 0;
        try {
            FileReader input = new FileReader(report.toString());
            BufferedReader bufRead = new BufferedReader(input);
            HashMap<Integer, TestcaseType> id2case = new HashMap<Integer, TestcaseType>();
            TestsuiteType currentSuite = null;
            String line = bufRead.readLine();
            ++count;
            if (line == null) {
                System.err.println("Error: file " + report + ", is empty - no etunit file");
                bufRead.close();
                input.close();
                return null;
            }
            if (!line.equals("etUnit report")) {
                System.err.println("Error: file " + report + ", line " + line + " is missing header line - no etunit file");
                bufRead.close();
                input.close();
                return null;
            }
            DocumentRoot root = EtunitFactory.eINSTANCE.createDocumentRoot();
            TestsuitesType testsuites = EtunitFactory.eINSTANCE.createTestsuitesType();
            root.setTestsuites(testsuites);
            line = bufRead.readLine();
            ++count;
            while (true) {
                int id;
                int pos;
                if (line == null) {
                    bufRead.close();
                    this.computeAndSetInfo(testsuites);
                    return root;
                }
                if (line.startsWith(TS_START)) {
                    currentSuite = EtunitFactory.eINSTANCE.createTestsuiteType();
                    currentSuite.setName(line.substring(TS_START.length(), line.length()));
                    testsuites.getTestsuite().add((Object)currentSuite);
                } else if (line.startsWith(TC_START)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(9, pos));
                    TestcaseType tc = EtunitFactory.eINSTANCE.createTestcaseType();
                    tc.setName(line.substring(pos + 2));
                    id2case.put(id, tc);
                    currentSuite.getTestcase().add((Object)tc);
                } else if (line.startsWith(TC_FAIL)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(8, pos));
                    TestcaseType tc = (TestcaseType)id2case.get(id);
                    if (tc == null) {
                        System.err.println("Error: in file " + report + ", line " + count + " - unknown test case id");
                        bufRead.close();
                        input.close();
                        return null;
                    }
                    FailureType fail = EtunitFactory.eINSTANCE.createFailureType();
                    pos = line.indexOf(35) + 1;
                    int end = line.indexOf(35, pos);
                    if (end > pos) {
                        fail.setExpected(line.substring(pos, end));
                    }
                    if ((end = line.indexOf(35, pos = end + 1)) > pos) {
                        fail.setActual(line.substring(pos, end));
                    }
                    String loc = (end = line.indexOf(35, pos = end + 1)) > pos ? line.substring(pos, end) : null;
                    pos = line.lastIndexOf(35);
                    String trace = line.substring(pos + 1);
                    if (loc != null) {
                        trace = String.valueOf(trace) + "\n at " + loc;
                    }
                    FeatureMapUtil.addText((FeatureMap)fail.getMixed(), (String)trace);
                    tc.setFailure(fail);
                } else if (line.startsWith(TC_END)) {
                    pos = line.indexOf(58);
                    id = Integer.parseInt(line.substring(7, pos));
                    int time = Integer.parseInt(line.substring(pos + 2));
                    TestcaseType tc = (TestcaseType)id2case.get(id);
                    if (tc == null) {
                        System.err.println("Error: in file " + report + ", line " + count + " - unknown test case id");
                        bufRead.close();
                        input.close();
                        return null;
                    }
                    tc.setTime(BigDecimal.valueOf(time));
                }
                line = bufRead.readLine();
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("Error: file " + report + " could not be read (" + e.getMessage() + ")");
            return null;
        }
        catch (IOException e) {
            System.err.println("Error: file " + report + " could not be read (" + e.getMessage() + ")");
            e.printStackTrace();
            return null;
        }
        catch (NumberFormatException e) {
            System.err.println("Error: in file " + report + ", line " + count + " - could not read number");
        }
        return null;
    }

    private void doEMFRegistration() {
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"platform:/resource/org.eclipse.etrice.etunit.converter/model/etunit.xsd")) {
            EPackage.Registry.INSTANCE.put((Object)"platform:/resource/org.eclipse.etrice.etunit.converter/model/etunit.xsd", (Object)EtunitPackage.eINSTANCE);
        }
    }

    protected static class Options {
        private boolean combinedResults = false;
        private boolean replaceSuiteName = false;
        private boolean onlyCombinedResults = false;
        private String combinedFile = null;
        private String suiteName = null;
        private ArrayList<String> files = new ArrayList();

        protected Options() {
        }

        public boolean isCombinedResults() {
            return this.combinedResults;
        }

        public void setCombinedResults(boolean combinedResults) {
            this.combinedResults = combinedResults;
        }

        public boolean isReplaceSuiteName() {
            return this.replaceSuiteName;
        }

        public void setReplaceSuiteName(boolean replaceSuiteName) {
            this.replaceSuiteName = replaceSuiteName;
        }

        public boolean isOnlyCombinedResults() {
            return this.onlyCombinedResults;
        }

        public void setOnlyCombinedResults(boolean onlyCombinedResults) {
            this.onlyCombinedResults = onlyCombinedResults;
        }

        public String getCombinedFile() {
            return this.combinedFile;
        }

        public void setCombinedFile(String combinedFile) {
            this.combinedFile = combinedFile;
        }

        public String getSuiteName() {
            return this.suiteName;
        }

        public void setSuiteName(String suiteName) {
            this.suiteName = suiteName;
        }

        public ArrayList<String> getFiles() {
            return this.files;
        }

        public void setFiles(ArrayList<String> files) {
            this.files = files;
        }

        public boolean needCombined() {
            return this.combinedResults;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean parseOptions(String[] args) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(EtUnitReportConverter.OPTION_COMBINED)) {
                    this.setCombinedResults(true);
                    if (++i >= args.length) {
                        System.err.println("Error: -combined must be followed by filename");
                        return false;
                    }
                    this.setCombinedFile(args[i]);
                } else if (args[i].equals(EtUnitReportConverter.OPTION_SUITE_NAME)) {
                    this.setReplaceSuiteName(true);
                    if (++i >= args.length) {
                        System.err.println("Error: -suite must be followed by a suite name");
                        return false;
                    }
                    this.setSuiteName(args[i]);
                } else if (args[i].equals(EtUnitReportConverter.OPTION_ONLY_COMBINED)) {
                    this.setCombinedResults(true);
                    this.setOnlyCombinedResults(true);
                    if (++i >= args.length) {
                        System.err.println("Error: -only_combined must be followed by filename");
                        return false;
                    }
                    this.setCombinedFile(args[i]);
                } else if (args[i].startsWith("-")) {
                    int nextOption = this.parseOption(args, i);
                    if (nextOption < 0) {
                        System.err.println("Error: unknown option " + args[i]);
                        return false;
                    }
                    i = nextOption;
                } else {
                    if (!args[i].endsWith(EtUnitReportConverter.ETU_EXTENSION)) {
                        System.err.println("Error: invalid file name '" + args[i] + "' (only *" + EtUnitReportConverter.ETU_EXTENSION + " files allowed)");
                        return false;
                    }
                    this.getFiles().add(args[i]);
                }
                ++i;
            }
            if (this.getFiles().isEmpty()) {
                System.err.println("Error: no reports specified");
                return false;
            }
            return true;
        }

        protected int parseOption(String[] args, int i) {
            return -1;
        }
    }
}

