/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.TransitionChain;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.util.FsmGenUtil;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.etrice.generator.fsm.generic.FSMExtensions;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.fsm.generic.IIfItemIdGenerator;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.fsm.generic.IMessageIdGenerator;
import org.eclipse.etrice.generator.fsm.generic.TransitionChainGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractStateMachineGenerator {
    @Inject
    @Extension
    public FSMHelpers _fSMHelpers;
    @Inject
    @Extension
    public FsmGenUtil _fsmGenUtil;
    @Inject
    @Extension
    public CodegenHelpers _codegenHelpers;
    @Inject
    @Extension
    public FSMExtensions _fSMExtensions;
    @Inject
    public ILanguageExtensionBase langExt;
    @Inject
    public IMessageIdGenerator msgIdGen;
    @Inject
    public IIfItemIdGenerator itemIdGen;
    @Inject
    public TransitionChainGenerator transitionChainGenerator;
    @Inject
    public IDetailCodeTranslator translator;

    public String genTriggerConstants(ExpandedModelComponent xpmc) {
        boolean _usesInheritance = this.langExt.usesInheritance();
        return this.genTriggerConstants(xpmc, _usesInheritance);
    }

    public String genTriggerConstants(ExpandedModelComponent xpmc, boolean omitBase) {
        List _xifexpression = null;
        if (omitBase) {
            ModelComponent _modelComponent = xpmc.getModelComponent();
            _xifexpression = this._fSMHelpers.getOwnMessagesFromInterfaces(_modelComponent);
        } else {
            ModelComponent _modelComponent_1 = xpmc.getModelComponent();
            _xifexpression = this._fSMHelpers.getAllMessagesFromInterfaces(_modelComponent_1);
        }
        List triggers = _xifexpression;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        Pair _pair = Tuples.pair((Object)"POLLING", (Object)"0");
        list.add(_pair);
        for (MessageFromIf mif : triggers) {
            AbstractInterfaceItem _from = mif.getFrom();
            boolean _isEventDriven = _from.isEventDriven();
            if (!_isEventDriven) continue;
            String _triggerCodeName = xpmc.getTriggerCodeName(mif);
            AbstractInterfaceItem _from_1 = mif.getFrom();
            String _ifItemId = this.itemIdGen.getIfItemId(_from_1);
            String _plus = String.valueOf(_ifItemId) + " + EVT_SHIFT*";
            String _messageID = this.msgIdGen.getMessageID(mif);
            String _plus_1 = String.valueOf(_plus) + _messageID;
            Pair _pair_1 = Tuples.pair((Object)_triggerCodeName, (Object)_plus_1);
            list.add((Pair<String, String>)_pair_1);
        }
        return this.langExt.genEnumeration("triggers", list);
    }

    public String genStateIdConstants(ExpandedModelComponent xpmc) {
        boolean _usesInheritance = this.langExt.usesInheritance();
        return this.genStateIdConstants(xpmc, _usesInheritance);
    }

    public String genStateIdConstants(ExpandedModelComponent xpmc, boolean omitBase) {
        List<State> _leafStatesLast;
        ModelComponent mc = xpmc.getModelComponent();
        int _xifexpression = 0;
        _xifexpression = omitBase ? this._fSMExtensions.getNumberOfInheritedBaseStates(mc) : 0;
        int offset = 2 + _xifexpression;
        List<State> _xifexpression_1 = null;
        if (omitBase) {
            StateGraph _stateMachine = mc.getStateMachine();
            _xifexpression_1 = this._fSMHelpers.getBaseStateList(_stateMachine);
        } else {
            StateGraph _stateMachine_1 = xpmc.getStateMachine();
            _xifexpression_1 = this._fSMHelpers.getBaseStateList(_stateMachine_1);
        }
        List<State> baseStates = _xifexpression_1;
        baseStates = _leafStatesLast = this._fSMExtensions.getLeafStatesLast(baseStates);
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        if (!omitBase) {
            Pair _pair = Tuples.pair((Object)"NO_STATE", (Object)"0");
            list.add(_pair);
            Pair _pair_1 = Tuples.pair((Object)"STATE_TOP", (Object)"1");
            list.add(_pair_1);
        }
        for (State state : baseStates) {
            String _genStateId = this._codegenHelpers.getGenStateId(state);
            String _string = Integer.valueOf(offset).toString();
            Pair _pair_2 = Tuples.pair((Object)_genStateId, (Object)_string);
            list.add((Pair<String, String>)_pair_2);
            ++offset;
        }
        String _string = Integer.valueOf(offset).toString();
        Pair _pair_2 = Tuples.pair((Object)"STATE_MAX", (Object)_string);
        list.add(_pair_2);
        return this.langExt.genEnumeration("state_ids", list);
    }

    public String genTransitionChainConstants(ExpandedModelComponent xpmc) {
        return this.genTransitionChainConstants(xpmc, false);
    }

    public String genTransitionChainConstants(ExpandedModelComponent xpmc, boolean omitBase) {
        EList _xifexpression = null;
        _xifexpression = omitBase ? xpmc.getOwnTransitionChains() : xpmc.getTransitionChains();
        EList chains = _xifexpression;
        int _xifexpression_1 = 0;
        if (omitBase) {
            EList _transitionChains = xpmc.getTransitionChains();
            int _size = _transitionChains.size();
            int _size_1 = chains.size();
            _xifexpression_1 = _size - _size_1;
        } else {
            _xifexpression_1 = 0;
        }
        int offset = _xifexpression_1;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (TransitionChain chain : chains) {
            String _genChainId = this._codegenHelpers.getGenChainId(chain);
            String _string = Integer.valueOf(++offset).toString();
            Pair _pair = Tuples.pair((Object)_genChainId, (Object)_string);
            list.add((Pair<String, String>)_pair);
        }
        return this.langExt.genEnumeration("ChainIDs", list);
    }

    public String genEntryAndExitCodes(ExpandedModelComponent xpmc, boolean generateImplementation) {
        boolean _usesInheritance = this.langExt.usesInheritance();
        return this.genEntryAndExitCodes(xpmc, generateImplementation, _usesInheritance);
    }

    public String genEntryAndExitCodes(ExpandedModelComponent xpmc, boolean generateImplementation, boolean omitBase) {
        StringConcatenation _builder = new StringConcatenation();
        StateGraph _stateMachine = xpmc.getStateMachine();
        List _stateList = this._fSMHelpers.getStateList(_stateMachine);
        for (State state : _stateList) {
            if (omitBase && !xpmc.isOwnObject((StateGraphItem)state)) continue;
            String _genActionCodeMethods = this.genActionCodeMethods(xpmc, state, generateImplementation);
            _builder.append((Object)_genActionCodeMethods, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String genActionCodes(ExpandedModelComponent xpmc, boolean generateImplementation) {
        boolean _usesInheritance = this.langExt.usesInheritance();
        return this.genActionCodes(xpmc, generateImplementation, _usesInheritance);
    }

    public String genActionCodes(ExpandedModelComponent xpmc, boolean generateImplementation, boolean omitBase) {
        StringConcatenation _builder = new StringConcatenation();
        StateGraph _stateMachine = xpmc.getStateMachine();
        List _allTransitionsRecursive = this._fSMHelpers.getAllTransitionsRecursive(_stateMachine);
        for (Transition tr : _allTransitionsRecursive) {
            if (omitBase && !xpmc.isOwnObject((StateGraphItem)tr) || !this._fSMHelpers.hasDetailCode(tr.getAction())) continue;
            String _genActionCodeMethod = this.genActionCodeMethod(xpmc, tr, generateImplementation);
            _builder.append((Object)_genActionCodeMethod, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String genStateSwitchMethods(ExpandedModelComponent xpmc, boolean generateImplementation) {
        String _xblockexpression = null;
        ModelComponent mc = xpmc.getModelComponent();
        ComponentCommunicationType _commType = mc.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        ComponentCommunicationType _commType_1 = mc.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ComponentCommunicationType.EVENT_DRIVEN);
        String _interfaceItemType = this.interfaceItemType();
        String _pointerLiteral = this.langExt.pointerLiteral();
        String ifItemPtr = String.valueOf(_interfaceItemType) + _pointerLiteral;
        boolean handleEvents = async || eventDriven;
        String _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        if (_usesInheritance) {
            String _className = this.getClassName(mc);
            String _scopeSeparator = this.langExt.scopeSeparator();
            _xifexpression = String.valueOf(_className) + _scopeSeparator;
        } else {
            _xifexpression = "";
        }
        String chainIDScope = _xifexpression;
        String _className_1 = this.getClassName(mc);
        String opScope = this.langExt.operationScope(_className_1, !generateImplementation);
        String _xifexpression_1 = null;
        boolean _usesInheritance_1 = this.langExt.usesInheritance();
        _xifexpression_1 = _usesInheritance_1 ? opScope : "";
        String opScopePriv = _xifexpression_1;
        String _xifexpression_2 = null;
        boolean _usesInheritance_2 = this.langExt.usesInheritance();
        _xifexpression_2 = _usesInheritance_2 ? this.langExt.accessLevelPublic() : this.langExt.accessLevelPrivate();
        String publicIf = _xifexpression_2;
        String privAccess = this.langExt.accessLevelPrivate();
        String _className_2 = this.getClassName(mc);
        String selfPtr = this.langExt.selfPointer(_className_2, true);
        String _className_3 = this.getClassName(mc);
        String selfOnly = this.langExt.selfPointer(_className_3, false);
        String _xifexpression_3 = null;
        boolean _usesInheritance_3 = this.langExt.usesInheritance();
        if (_usesInheritance_3) {
            String _xifexpression_4 = null;
            boolean _usesPointers = this.langExt.usesPointers();
            _xifexpression_4 = _usesPointers ? "->getLocalId()" : ".getLocalId()";
            _xifexpression_3 = _xifexpression_4;
        } else {
            _xifexpression_3 = "->localId";
        }
        String getLocalId = _xifexpression_3;
        String _xifexpression_5 = null;
        boolean _usesPointers_1 = this.langExt.usesPointers();
        _xifexpression_5 = _usesPointers_1 ? "const " + ifItemPtr : ifItemPtr;
        String constIfItemPtr = _xifexpression_5;
        boolean usesHdlr = this.usesHandlerTrPoints(xpmc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls exit codes while exiting from the current state to one of its");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* parent states while remembering the history");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param current__et - the current state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param to - the final parent state");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)"* @param handler__et - entry and exit codes are called only if not handler (for handler TransitionPoints)");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        if (generateImplementation) {
            _builder.append((Object)privAccess, "");
            _builder.append((Object)"void ");
            _builder.append((Object)opScopePriv, "");
            _builder.append((Object)"exitTo(");
            _builder.append((Object)selfPtr, "");
            String _stateType = this.stateType();
            _builder.append((Object)_stateType, "");
            _builder.append((Object)" current__et, ");
            String _stateType_1 = this.stateType();
            _builder.append((Object)_stateType_1, "");
            _builder.append((Object)" to");
            if (usesHdlr) {
                _builder.append((Object)", ");
                String _boolType = this.boolType();
                _builder.append((Object)_boolType, "");
                _builder.append((Object)" handler__et");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"while (current__et!=to) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"switch (current__et) {");
            _builder.newLine();
            StateGraph _stateMachine = xpmc.getStateMachine();
            List _baseStateList = this._fSMHelpers.getBaseStateList(_stateMachine);
            Iterator iterator = _baseStateList.iterator();
            while (iterator.hasNext()) {
                State state = (State)iterator.next();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"case ");
                String _genStateId = this._codegenHelpers.getGenStateId(state);
                _builder.append((Object)_genStateId, "\t\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                boolean _hasExitCode = this._fSMHelpers.hasExitCode(state, true);
                if (_hasExitCode) {
                    if (usesHdlr) {
                        _builder.append((Object)"if (!handler__et) ");
                    }
                    String _exitCodeOperationName = this._codegenHelpers.getExitCodeOperationName(state);
                    _builder.append((Object)_exitCodeOperationName, "\t\t\t\t");
                    _builder.append((Object)"(");
                    String _selfPointer = this.langExt.selfPointer(false);
                    _builder.append((Object)_selfPointer, "\t\t\t\t");
                    _builder.append((Object)");");
                }
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                String _parentStateId = this._codegenHelpers.getParentStateId(state);
                String _genStateId_1 = this._codegenHelpers.getGenStateId(state);
                String _setHistory = this.setHistory(_parentStateId, _genStateId_1);
                _builder.append((Object)_setHistory, "\t\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"current__et = ");
                String _parentStateId_1 = this._codegenHelpers.getParentStateId(state);
                _builder.append((Object)_parentStateId_1, "\t\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"/* should not occur */");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"void exitTo(");
            _builder.append((Object)selfPtr, "");
            String _stateType_2 = this.stateType();
            _builder.append((Object)_stateType_2, "");
            _builder.append((Object)" current__et, ");
            String _stateType_3 = this.stateType();
            _builder.append((Object)_stateType_3, "");
            _builder.append((Object)" to");
            if (usesHdlr) {
                _builder.append((Object)", ");
                String _boolType_1 = this.boolType();
                _builder.append((Object)_boolType_1, "");
                _builder.append((Object)" handler__et");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls action, entry and exit codes along a transition chain. The generic data are cast to typed data");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* matching the trigger of this chain. The ID of the final state is returned");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param chain__et - the chain ID");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param generic_data__et - the generic data pointer");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the +/- ID of the final state either with a positive sign, that indicates to execute the state's entry code, or a negative sign vice versa");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        if (generateImplementation) {
            _builder.append((Object)privAccess, "");
            String _stateType_4 = this.stateType();
            _builder.append((Object)_stateType_4, "");
            _builder.append((Object)" ");
            _builder.append((Object)opScopePriv, "");
            _builder.append((Object)"executeTransitionChain(");
            _builder.append((Object)selfPtr, "");
            _builder.append((Object)"int chain__et");
            if (handleEvents) {
                _builder.append((Object)", ");
                _builder.append((Object)constIfItemPtr, "");
                _builder.append((Object)" ifitem, ");
                String _voidPointer = this.langExt.voidPointer();
                _builder.append((Object)_voidPointer, "");
                _builder.append((Object)" generic_data__et");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"switch (chain__et) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            EList allchains = xpmc.getTransitionChains();
            _builder.newLineIfNotEmpty();
            for (TransitionChain tc : allchains) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"case ");
                _builder.append((Object)chainIDScope, "\t\t");
                String _genChainId = this._codegenHelpers.getGenChainId(tc);
                _builder.append((Object)_genChainId, "\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                String _generateExecuteChain = this.transitionChainGenerator.generateExecuteChain(xpmc, tc);
                _builder.append((Object)_generateExecuteChain, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"/* should not occur */");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return NO_STATE;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            String _stateType_5 = this.stateType();
            _builder.append((Object)_stateType_5, "");
            _builder.append((Object)" executeTransitionChain(");
            _builder.append((Object)selfPtr, "");
            _builder.append((Object)"int chain__et");
            if (handleEvents) {
                _builder.append((Object)", ");
                _builder.append((Object)constIfItemPtr, "");
                _builder.append((Object)" ifitem, ");
                String _voidPointer_1 = this.langExt.voidPointer();
                _builder.append((Object)_voidPointer_1, "");
                _builder.append((Object)" generic_data__et");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls entry codes while entering a state's history. The ID of the final leaf state is returned");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param state__et - the state which is entered");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)"* @param handler__et - entry code is executed if not handler");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* @return - the ID of the final leaf state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        if (generateImplementation) {
            boolean _not;
            _builder.append((Object)privAccess, "");
            String _stateType_6 = this.stateType();
            _builder.append((Object)_stateType_6, "");
            _builder.append((Object)" ");
            _builder.append((Object)opScopePriv, "");
            _builder.append((Object)"enterHistory(");
            _builder.append((Object)selfPtr, "");
            String _stateType_7 = this.stateType();
            _builder.append((Object)_stateType_7, "");
            _builder.append((Object)" state__et");
            if (usesHdlr) {
                _builder.append((Object)", ");
                String _boolType_2 = this.boolType();
                _builder.append((Object)_boolType_2, "");
                _builder.append((Object)" handler__et");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            StateGraph _stateMachine_1 = xpmc.getStateMachine();
            List baseStateList = this._fSMHelpers.getBaseStateList(_stateMachine_1);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State s) {
                    return AbstractStateMachineGenerator.this._fSMHelpers.hasEntryCode(s, true);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)baseStateList, (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            boolean needsSkipVar = !_isEmpty;
            _builder.newLineIfNotEmpty();
            if (needsSkipVar) {
                _builder.append((Object)"\t");
                String _boolType_3 = this.boolType();
                _builder.append((Object)_boolType_3, "\t");
                _builder.append((Object)" skip_entry__et = ");
                String _booleanConstant = this.langExt.booleanConstant(false);
                _builder.append((Object)_booleanConstant, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"if (state__et >= STATE_MAX) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"state__et = ");
            boolean _usesInheritance_4 = this.langExt.usesInheritance();
            boolean bl = _not = !_usesInheritance_4;
            if (_not) {
                _builder.append((Object)"(");
                String _stateType_8 = this.stateType();
                _builder.append((Object)_stateType_8, "\t\t");
                _builder.append((Object)")");
            }
            _builder.append((Object)" (state__et - STATE_MAX);");
            _builder.newLineIfNotEmpty();
            if (needsSkipVar) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"skip_entry__et = ");
                String _booleanConstant_1 = this.langExt.booleanConstant(true);
                _builder.append((Object)_booleanConstant_1, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"while (");
            String _booleanConstant_2 = this.langExt.booleanConstant(true);
            _builder.append((Object)_booleanConstant_2, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"switch (state__et) {");
            _builder.newLine();
            for (State state_1 : baseStateList) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"case ");
                String _genStateId_2 = this._codegenHelpers.getGenStateId(state_1);
                _builder.append((Object)_genStateId_2, "\t\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                boolean _hasEntryCode = this._fSMHelpers.hasEntryCode(state_1, true);
                if (_hasEntryCode) {
                    _builder.append((Object)"if (!(skip_entry__et");
                    if (usesHdlr) {
                        _builder.append((Object)" || handler__et");
                    }
                    _builder.append((Object)")) ");
                    String _entryCodeOperationName = this._codegenHelpers.getEntryCodeOperationName(state_1);
                    _builder.append((Object)_entryCodeOperationName, "\t\t\t\t");
                    _builder.append((Object)"(");
                    String _selfPointer_1 = this.langExt.selfPointer(false);
                    _builder.append((Object)_selfPointer_1, "\t\t\t\t");
                    _builder.append((Object)");");
                }
                _builder.newLineIfNotEmpty();
                boolean _isLeaf = this._fSMHelpers.isLeaf(state_1);
                if (_isLeaf) {
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"/* in leaf state: return state id */");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return ");
                    String _genStateId_3 = this._codegenHelpers.getGenStateId(state_1);
                    _builder.append((Object)_genStateId_3, "\t\t\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"/* state has a sub graph */");
                _builder.newLine();
                StateGraph _subgraph = state_1.getSubgraph();
                boolean _hasInitTransition = this._fSMHelpers.hasInitTransition(_subgraph);
                if (_hasInitTransition) {
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"/* with init transition */");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (");
                    String _genStateId_4 = this._codegenHelpers.getGenStateId(state_1);
                    String _history = this.getHistory(_genStateId_4);
                    _builder.append((Object)_history, "\t\t\t\t");
                    _builder.append((Object)"==NO_STATE) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    StateGraph _subgraph_1 = state_1.getSubgraph();
                    Transition sub_initt = this._fSMHelpers.getInitTransition(_subgraph_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"state__et = executeTransitionChain(");
                    String _selfPointer_2 = this.langExt.selfPointer(true);
                    _builder.append((Object)_selfPointer_2, "\t\t\t\t\t");
                    _builder.append((Object)chainIDScope, "\t\t\t\t\t");
                    TransitionChain _chain = xpmc.getChain(sub_initt);
                    String _genChainId_1 = this._codegenHelpers.getGenChainId(_chain);
                    _builder.append((Object)_genChainId_1, "\t\t\t\t\t");
                    if (handleEvents) {
                        _builder.append((Object)", ");
                        String _nullPointer = this.langExt.nullPointer();
                        _builder.append((Object)_nullPointer, "\t\t\t\t\t");
                        _builder.append((Object)", ");
                        String _nullPointer_1 = this.langExt.nullPointer();
                        _builder.append((Object)_nullPointer_1, "\t\t\t\t\t");
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"state__et = ");
                    String _genStateId_5 = this._codegenHelpers.getGenStateId(state_1);
                    String _history_1 = this.getHistory(_genStateId_5);
                    _builder.append((Object)_history_1, "\t\t\t\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"/* without init transition */");
                    _builder.newLine();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"state__et = ");
                    String _genStateId_6 = this._codegenHelpers.getGenStateId(state_1);
                    String _history_2 = this.getHistory(_genStateId_6);
                    _builder.append((Object)_history_2, "\t\t\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"case STATE_TOP:");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"state__et = ");
            String _history_3 = this.getHistory("STATE_TOP");
            _builder.append((Object)_history_3, "\t\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"/* should not occur */");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            if (needsSkipVar) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"skip_entry__et = ");
                String _booleanConstant_3 = this.langExt.booleanConstant(false);
                _builder.append((Object)_booleanConstant_3, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _unreachableReturn = this.unreachableReturn();
            _builder.append((Object)_unreachableReturn, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            String _stateType_9 = this.stateType();
            _builder.append((Object)_stateType_9, "");
            _builder.append((Object)" enterHistory(");
            _builder.append((Object)selfPtr, "");
            String _stateType_10 = this.stateType();
            _builder.append((Object)_stateType_10, "");
            _builder.append((Object)" state__et");
            if (usesHdlr) {
                _builder.append((Object)", ");
                String _boolType_4 = this.boolType();
                _builder.append((Object)_boolType_4, "");
                _builder.append((Object)" handler__et");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (generateImplementation) {
            _builder.append((Object)publicIf, "");
            _builder.append((Object)"void ");
            _builder.append((Object)opScope, "");
            _builder.append((Object)"executeInitTransition(");
            _builder.append((Object)selfOnly, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            StateGraph _stateMachine_2 = xpmc.getStateMachine();
            Transition initt = this._fSMHelpers.getInitTransition(_stateMachine_2);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"int chain__et = ");
            _builder.append((Object)chainIDScope, "\t");
            TransitionChain _chain_1 = xpmc.getChain(initt);
            String _genChainId_2 = this._codegenHelpers.getGenChainId(_chain_1);
            _builder.append((Object)_genChainId_2, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _stateType_11 = this.stateType();
            _builder.append((Object)_stateType_11, "\t");
            _builder.append((Object)" next__et = ");
            _builder.append((Object)opScopePriv, "\t");
            _builder.append((Object)"executeTransitionChain(");
            String _selfPointer_3 = this.langExt.selfPointer(true);
            _builder.append((Object)_selfPointer_3, "\t");
            _builder.append((Object)"chain__et");
            if (handleEvents) {
                _builder.append((Object)", ");
                String _nullPointer_2 = this.langExt.nullPointer();
                _builder.append((Object)_nullPointer_2, "\t");
                _builder.append((Object)", ");
                String _nullPointer_3 = this.langExt.nullPointer();
                _builder.append((Object)_nullPointer_3, "\t");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"next__et = ");
            _builder.append((Object)opScopePriv, "\t");
            _builder.append((Object)"enterHistory(");
            String _selfPointer_4 = this.langExt.selfPointer(true);
            _builder.append((Object)_selfPointer_4, "\t");
            _builder.append((Object)"next__et");
            if (usesHdlr) {
                _builder.append((Object)", ");
                String _booleanConstant_4 = this.langExt.booleanConstant(false);
                _builder.append((Object)_booleanConstant_4, "\t");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"setState(");
            String _selfPointer_5 = this.langExt.selfPointer(true);
            _builder.append((Object)_selfPointer_5, "\t");
            _builder.append((Object)"next__et);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"void ");
            _builder.append((Object)opScope, "");
            _builder.append((Object)"executeInitTransition(");
            _builder.append((Object)selfOnly, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* receiveEvent contains the main implementation of the FSM */");
        _builder.newLine();
        if (generateImplementation) {
            _builder.append((Object)publicIf, "");
            _builder.append((Object)"void ");
            _builder.append((Object)opScope, "");
            _builder.append((Object)"receiveEventInternal(");
            String _className_4 = this.getClassName(mc);
            String _selfPointer_6 = this.langExt.selfPointer(_className_4, handleEvents);
            _builder.append((Object)_selfPointer_6, "");
            if (handleEvents) {
                _builder.append((Object)ifItemPtr, "");
                _builder.append((Object)" ifitem, int localId, int evt, ");
                String _voidPointer_2 = this.langExt.voidPointer();
                _builder.append((Object)_voidPointer_2, "");
                _builder.append((Object)" generic_data__et");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            if (async) {
                _builder.append((Object)"\t");
                _builder.append((Object)"int trigger__et = (ifitem==");
                String _nullPointer_4 = this.langExt.nullPointer();
                _builder.append((Object)_nullPointer_4, "\t");
                _builder.append((Object)")? POLLING : localId + EVT_SHIFT*evt;");
                _builder.newLineIfNotEmpty();
            } else if (eventDriven) {
                _builder.append((Object)"\t");
                _builder.append((Object)"int trigger__et = localId + EVT_SHIFT*evt;");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"int chain__et = NOT_CAUGHT;");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _stateType_12 = this.stateType();
            _builder.append((Object)_stateType_12, "\t");
            _builder.append((Object)" catching_state__et = NO_STATE;");
            _builder.newLineIfNotEmpty();
            if (usesHdlr) {
                _builder.append((Object)"\t");
                String _boolType_5 = this.boolType();
                _builder.append((Object)_boolType_5, "\t");
                _builder.append((Object)" is_handler__et = ");
                String _booleanConstant_5 = this.langExt.booleanConstant(false);
                _builder.append((Object)_booleanConstant_5, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            if (async || eventDriven) {
                _builder.append((Object)"\t");
                CharSequence _markVariableUsed = this.markVariableUsed("trigger__et");
                _builder.append((Object)_markVariableUsed, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            if (handleEvents) {
                _builder.append((Object)"\t");
                _builder.append((Object)"if (!handleSystemEvent(ifitem, evt, generic_data__et)) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _genStateSwitch = this.genStateSwitch(xpmc, usesHdlr);
                _builder.append((Object)_genStateSwitch, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t");
                CharSequence _genStateSwitch_1 = this.genStateSwitch(xpmc, usesHdlr);
                _builder.append((Object)_genStateSwitch_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"if (chain__et != NOT_CAUGHT) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)opScopePriv, "\t\t");
            _builder.append((Object)"exitTo(");
            String _selfPointer_7 = this.langExt.selfPointer(true);
            _builder.append((Object)_selfPointer_7, "\t\t");
            _builder.append((Object)"getState(");
            String _selfPointer_8 = this.langExt.selfPointer(false);
            _builder.append((Object)_selfPointer_8, "\t\t");
            _builder.append((Object)"), catching_state__et");
            if (usesHdlr) {
                _builder.append((Object)", is_handler__et");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            String _stateType_13 = this.stateType();
            _builder.append((Object)_stateType_13, "\t\t\t");
            _builder.append((Object)" next__et = ");
            _builder.append((Object)opScopePriv, "\t\t\t");
            _builder.append((Object)"executeTransitionChain(");
            String _selfPointer_9 = this.langExt.selfPointer(true);
            _builder.append((Object)_selfPointer_9, "\t\t\t");
            _builder.append((Object)"chain__et");
            if (handleEvents) {
                _builder.append((Object)", ifitem, generic_data__et");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"next__et = ");
            _builder.append((Object)opScopePriv, "\t\t\t");
            _builder.append((Object)"enterHistory(");
            String _selfPointer_10 = this.langExt.selfPointer(true);
            _builder.append((Object)_selfPointer_10, "\t\t\t");
            _builder.append((Object)"next__et");
            if (usesHdlr) {
                _builder.append((Object)", is_handler__et");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"setState(");
            String _selfPointer_11 = this.langExt.selfPointer(true);
            _builder.append((Object)_selfPointer_11, "\t\t\t");
            _builder.append((Object)"next__et);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            CharSequence _finalAction = this.finalAction();
            _builder.append((Object)_finalAction, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"void ");
            _builder.append((Object)opScope, "");
            _builder.append((Object)"receiveEventInternal(");
            String _className_5 = this.getClassName(mc);
            String _selfPointer_12 = this.langExt.selfPointer(_className_5, handleEvents);
            _builder.append((Object)_selfPointer_12, "");
            if (handleEvents) {
                _builder.append((Object)ifItemPtr, "");
                _builder.append((Object)" ifitem, int localId, int evt, ");
                String _voidPointer_3 = this.langExt.voidPointer();
                _builder.append((Object)_voidPointer_3, "");
                _builder.append((Object)" generic_data__et");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        if (handleEvents) {
            if (generateImplementation) {
                _builder.append((Object)publicIf, "");
                _builder.append((Object)"void ");
                _builder.append((Object)opScope, "");
                _builder.append((Object)"receiveEvent(");
                String _className_6 = this.getClassName(mc);
                String _selfPointer_13 = this.langExt.selfPointer(_className_6, true);
                _builder.append((Object)_selfPointer_13, "");
                _builder.append((Object)ifItemPtr, "");
                _builder.append((Object)" ifitem, int evt, ");
                String _voidPointer_4 = this.langExt.voidPointer();
                _builder.append((Object)_voidPointer_4, "");
                _builder.append((Object)" generic_data__et) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"int localId = (ifitem==");
                String _nullPointer_5 = this.langExt.nullPointer();
                _builder.append((Object)_nullPointer_5, "\t");
                _builder.append((Object)")? 0 : ifitem");
                _builder.append((Object)getLocalId, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)opScope, "\t");
                _builder.append((Object)"receiveEventInternal(");
                String _selfPointer_14 = this.langExt.selfPointer(true);
                _builder.append((Object)_selfPointer_14, "\t");
                _builder.append((Object)"ifitem, localId, evt, generic_data__et);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                _builder.append((Object)"void ");
                _builder.append((Object)opScope, "");
                _builder.append((Object)"receiveEvent(");
                String _selfPointer_15 = this.langExt.selfPointer(true);
                _builder.append((Object)_selfPointer_15, "");
                _builder.append((Object)ifItemPtr, "");
                _builder.append((Object)" ifitem, int evt, ");
                String _voidPointer_5 = this.langExt.voidPointer();
                _builder.append((Object)_voidPointer_5, "");
                _builder.append((Object)" generic_data__et);");
                _builder.newLineIfNotEmpty();
            }
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String genDoCodes(State state) {
        EObject _eContainer;
        EObject _eContainer_1;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasDoCode = this._fSMHelpers.hasDoCode(state, true);
        if (_hasDoCode) {
            String _doCodeOperationName = this._codegenHelpers.getDoCodeOperationName(state);
            _builder.append((Object)_doCodeOperationName, "");
            _builder.append((Object)"(");
            String _selfPointer = this.langExt.selfPointer(false);
            _builder.append((Object)_selfPointer, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        if ((_eContainer_1 = (_eContainer = state.eContainer()).eContainer()) instanceof State) {
            EObject _eContainer_2 = state.eContainer();
            EObject _eContainer_3 = _eContainer_2.eContainer();
            String _genDoCodes = this.genDoCodes((State)_eContainer_3);
            _builder.append((Object)_genDoCodes, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public CharSequence genStateSwitch(ExpandedModelComponent xpmc, boolean usesHdlr) {
        StringConcatenation _xblockexpression = null;
        ModelComponent _modelComponent = xpmc.getModelComponent();
        ComponentCommunicationType _commType = _modelComponent.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        ModelComponent _modelComponent_1 = xpmc.getModelComponent();
        ComponentCommunicationType _commType_1 = _modelComponent_1.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ComponentCommunicationType.EVENT_DRIVEN);
        ModelComponent _modelComponent_2 = xpmc.getModelComponent();
        ComponentCommunicationType _commType_2 = _modelComponent_2.getCommType();
        boolean dataDriven = Objects.equal((Object)_commType_2, (Object)ComponentCommunicationType.DATA_DRIVEN);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"switch (getState(");
        String _selfPointer = this.langExt.selfPointer(false);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)")) {");
        _builder.newLineIfNotEmpty();
        StateGraph _stateMachine = xpmc.getStateMachine();
        List _leafStateList = this._fSMHelpers.getLeafStateList(_stateMachine);
        for (State state : _leafStateList) {
            _builder.append((Object)"    ");
            _builder.append((Object)"case ");
            String _genStateId = this._codegenHelpers.getGenStateId(state);
            _builder.append((Object)_genStateId, "    ");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            if (async) {
                boolean _not;
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                EList atlist = xpmc.getActiveTriggers(state);
                _builder.newLineIfNotEmpty();
                boolean _isEmpty = atlist.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"switch(trigger__et) {");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"case POLLING:");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"        ");
                    CharSequence _genDataDrivenTriggers = this.genDataDrivenTriggers(xpmc, state, usesHdlr);
                    _builder.append((Object)_genDataDrivenTriggers, "                ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"        ");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    CharSequence _genEventDrivenTriggers = this.genEventDrivenTriggers(xpmc, state, (List<ActiveTrigger>)atlist, usesHdlr);
                    _builder.append((Object)_genEventDrivenTriggers, "            ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    CharSequence _genDataDrivenTriggers_1 = this.genDataDrivenTriggers(xpmc, state, usesHdlr);
                    _builder.append((Object)_genDataDrivenTriggers_1, "        ");
                    _builder.newLineIfNotEmpty();
                }
            } else if (dataDriven) {
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                CharSequence _genDataDrivenTriggers_2 = this.genDataDrivenTriggers(xpmc, state, usesHdlr);
                _builder.append((Object)_genDataDrivenTriggers_2, "        ");
                _builder.newLineIfNotEmpty();
            } else if (eventDriven) {
                boolean _not_1;
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                EList atlist_1 = xpmc.getActiveTriggers(state);
                _builder.newLineIfNotEmpty();
                boolean _isEmpty_1 = atlist_1.isEmpty();
                boolean bl = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"switch(trigger__et) {");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"        ");
                    CharSequence _genEventDrivenTriggers_1 = this.genEventDrivenTriggers(xpmc, state, (List<ActiveTrigger>)atlist_1, usesHdlr);
                    _builder.append((Object)_genEventDrivenTriggers_1, "                ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"/* should not occur */");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence genDataDrivenTriggers(ExpandedModelComponent xpmc, State state, boolean usesHdlr) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        if (_usesInheritance) {
            String _className = this.getClassName(xpmc);
            String _scopeSeparator = this.langExt.scopeSeparator();
            _xifexpression = String.valueOf(_className) + _scopeSeparator;
        } else {
            _xifexpression = "";
        }
        String chainIDScope = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        String _genDoCodes = this.genDoCodes(state);
        _builder.append((Object)_genDoCodes, "");
        _builder.newLineIfNotEmpty();
        List<Transition> _outgoingTransitionsHierarchical = this._fSMExtensions.getOutgoingTransitionsHierarchical(xpmc, state);
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition t) {
                return t instanceof GuardedTransition;
            }
        };
        Iterable transitions = IterableExtensions.filter(_outgoingTransitionsHierarchical, (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        for (Transition tr : transitions) {
            boolean _notEquals;
            _builder.append((Object)"if (");
            String _guard = this.guard((GuardedTransition)tr, "", xpmc);
            _builder.append((Object)_guard, "");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"    ");
            TransitionChain chain = xpmc.getChain(tr);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"chain__et = ");
            _builder.append((Object)chainIDScope, "    ");
            String _genChainId = this._codegenHelpers.getGenChainId(chain);
            _builder.append((Object)_genChainId, "    ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"catching_state__et = ");
            State _stateContext = chain.getStateContext();
            String _genStateId = this._codegenHelpers.getGenStateId(_stateContext);
            _builder.append((Object)_genStateId, "    ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            if (chain.isHandler() && usesHdlr) {
                _builder.append((Object)"    ");
                _builder.append((Object)"is_handler__et = TRUE;");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            Transition _last = (Transition)IterableExtensions.last((Iterable)transitions);
            boolean bl = _notEquals = !Objects.equal((Object)tr, (Object)_last);
            if (!_notEquals) continue;
            _builder.append((Object)"else");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence genEventDrivenTriggers(ExpandedModelComponent xpmc, State state, List<ActiveTrigger> atlist, boolean usesHdlr) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        if (_usesInheritance) {
            String _className = this.getClassName(xpmc);
            String _scopeSeparator = this.langExt.scopeSeparator();
            _xifexpression = String.valueOf(_className) + _scopeSeparator;
        } else {
            _xifexpression = "";
        }
        String chainIDScope = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        for (ActiveTrigger at : atlist) {
            _builder.append((Object)"case ");
            String _triggerCodeName = xpmc.getTriggerCodeName(at);
            _builder.append((Object)_triggerCodeName, "");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            boolean needData = this._fsmGenUtil.hasGuard(at);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            if (needData) {
                _builder.append((Object)"{ ");
                EObject _msg = at.getMsg();
                String _typedDataDefinition = this.langExt.getTypedDataDefinition(_msg);
                _builder.append((Object)_typedDataDefinition, "    ");
            }
            _builder.newLineIfNotEmpty();
            EList _transitions = at.getTransitions();
            boolean _hasElements = false;
            for (TriggeredTransition tt : _transitions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "    ");
                }
                _builder.append((Object)"    ");
                TransitionChain chain = xpmc.getChain((Transition)tt);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                Transition _transition = chain.getTransition();
                String _trigger = at.getTrigger();
                String _guard = this.guard((TriggeredTransition)_transition, _trigger, xpmc);
                _builder.append((Object)_guard, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"chain__et = ");
                _builder.append((Object)chainIDScope, "        ");
                String _genChainId = this._codegenHelpers.getGenChainId(chain);
                _builder.append((Object)_genChainId, "        ");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"    ");
                _builder.append((Object)"catching_state__et = ");
                State _stateContext = chain.getStateContext();
                String _genStateId = this._codegenHelpers.getGenStateId(_stateContext);
                _builder.append((Object)_genStateId, "        ");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                if (chain.isHandler() && usesHdlr) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"    ");
                    _builder.append((Object)"is_handler__et = ");
                    String _booleanConstant = this.langExt.booleanConstant(true);
                    _builder.append((Object)_booleanConstant, "        ");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"    ");
            if (needData) {
                _builder.append((Object)"}");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/* should not occur */");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"break;");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String getClassName(ExpandedModelComponent xpmc) {
        ModelComponent _modelComponent = xpmc.getModelComponent();
        return this.getClassName(_modelComponent);
    }

    public String getClassName(ModelComponent mc) {
        return mc.getComponentName();
    }

    public String getHistory(String state) {
        String _memberAccess = this.langExt.memberAccess();
        String _plus = String.valueOf(_memberAccess) + "history[";
        String _plus_1 = String.valueOf(_plus) + state;
        return String.valueOf(_plus_1) + "]";
    }

    public String setHistory(String state, String historyState) {
        String _memberAccess = this.langExt.memberAccess();
        String _plus = String.valueOf(_memberAccess) + "history[";
        String _plus_1 = String.valueOf(_plus) + state;
        String _plus_2 = String.valueOf(_plus_1) + "] = ";
        return String.valueOf(_plus_2) + historyState;
    }

    public String stateType() {
        return "int";
    }

    public String unreachableReturn() {
        return "/* return NO_STATE; // required by CDT but detected as unreachable by JDT because of while (true) */";
    }

    public String boolType() {
        return "boolean";
    }

    public CharSequence finalAction() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public String interfaceItemType() {
        return "InterfaceItemBase";
    }

    public CharSequence markVariableUsed(String varname) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public boolean usesHandlerTrPoints(ExpandedModelComponent xpmc) {
        Functions.Function1<TrPoint, Boolean> _function;
        boolean _xblockexpression = false;
        StateGraph _stateMachine = xpmc.getStateMachine();
        boolean _isEmpty = this._fSMHelpers.isEmpty(_stateMachine);
        if (_isEmpty) {
            return false;
        }
        StateGraph _stateMachine_1 = xpmc.getStateMachine();
        List _allTrPointsRecursive = this._fSMHelpers.getAllTrPointsRecursive(_stateMachine_1);
        Iterable _filter = IterableExtensions.filter((Iterable)_allTrPointsRecursive, (Functions.Function1)(_function = new Functions.Function1<TrPoint, Boolean>(){

            public Boolean apply(TrPoint t) {
                return t instanceof TransitionPoint && ((TransitionPoint)t).isHandler();
            }
        }));
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_filter);
        _xblockexpression = !_isEmpty_1;
        return _xblockexpression;
    }

    public abstract String guard(TriggeredTransition var1, String var2, ExpandedModelComponent var3);

    public abstract String guard(GuardedTransition var1, String var2, ExpandedModelComponent var3);

    public abstract String genActionCodeMethod(ExpandedModelComponent var1, Transition var2, boolean var3);

    public abstract String genActionCodeMethods(ExpandedModelComponent var1, State var2, boolean var3);
}

