/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class GeneratorConfigTab
extends AbstractLaunchConfigurationTab {
    public static final String GEN_INSTANCE_DIAGRAM = "GenInstanceDiagram";
    public static final String GEN_DOCUMENTATION = "GenDocumentation";
    public static final String GEN_MODEL_PATH = "GenModelPath";
    public static final String SAVE_GEN_MODEL = "SaveGenModel";
    public static final String MAIN_METHOD_NAME = "MainMethodName";
    public static final String LIB = "Lib";
    public static final String DEBUG = "Debug";
    public static final String MSC_INSTR = "MSC";
    public static final String DATA_INSTR = "DataLogging";
    public static final String VERBOSE = "Verbose";
    public static final String USE_TRAANSLATION = "UseTranslation";
    public static final String OVERRIDE_DIRECTORIES = "OverrideDirectories";
    public static final String SRCGEN_PATH = "SrcgenPath";
    public static final String INFO_PATH = "InfoPath";
    public static final String DOC_PATH = "DocPath";
    private Button libButton;
    private Button documentationButton;
    private Button saveGenModel;
    private Text genModelPath;
    private Button browsePath;
    private Button debugButton;
    private Button mscButton;
    private Button verboseButton;
    private Button useTranslationButton;
    private Button overrideDirectories;
    private Text srcgenPath;
    private Text infoPath;
    private Text docPath;
    protected Button dataButton;
    private Text mainMethodName;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        mainComposite.setLayout((Layout)layout);
        this.libButton = this.createCheckButton(mainComposite, "generate all classes as library");
        this.libButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.libButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.saveGenModel = this.createCheckButton(mainComposite, "save generator model");
        this.saveGenModel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.saveGenModel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handleSaveGenModelSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handleSaveGenModelSelected();
            }
        });
        this.genModelPath = new Text(mainComposite, 2052);
        this.genModelPath.setLayoutData((Object)new GridData(768));
        this.genModelPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorConfigTab.this.validate();
                GeneratorConfigTab.this.setDirty(true);
                GeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.browsePath = this.createPushButton(mainComposite, "Browse...", null);
        this.browsePath.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handlePathButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handlePathButtonSelected();
            }
        });
        this.documentationButton = this.createCheckButton(mainComposite, "generate documentation");
        this.documentationButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.documentationButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.useTranslationButton = this.createCheckButton(mainComposite, "perform code translation");
        this.useTranslationButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.useTranslationButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.debugButton = this.createCheckButton(mainComposite, "generate debug output");
        this.debugButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.debugButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.mscButton = this.createCheckButton(mainComposite, "generate instrumentation for MSC logging");
        this.mscButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.mscButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.dataButton = this.createCheckButton(mainComposite, "generate instrumentation for data logging");
        this.dataButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.dataButton.addSelectionListener((SelectionListener)new UpdateConfig());
        this.verboseButton = this.createCheckButton(mainComposite, "generate instrumentation for verbose output");
        this.verboseButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.verboseButton.addSelectionListener((SelectionListener)new UpdateConfig());
        Label label = new Label(mainComposite, 0);
        label.setText("The main method name:");
        this.mainMethodName = new Text(mainComposite, 2052);
        this.mainMethodName.setLayoutData((Object)new GridData(768));
        this.mainMethodName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorConfigTab.this.validate();
                GeneratorConfigTab.this.setDirty(true);
                GeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createSeparator(mainComposite, 2);
        this.overrideDirectories = this.createCheckButton(mainComposite, "override generation directories");
        this.overrideDirectories.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.overrideDirectories.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handleOverrideDirectories();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GeneratorConfigTab.this.handleOverrideDirectories();
            }
        });
        label = new Label(mainComposite, 0);
        label.setText("The directory for &generated code:");
        this.srcgenPath = new Text(mainComposite, 2052);
        this.srcgenPath.setLayoutData((Object)new GridData(768));
        this.srcgenPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorConfigTab.this.validate();
                GeneratorConfigTab.this.setDirty(true);
                GeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(mainComposite, 0);
        label.setText("The directory for i&nformation about generated code:");
        this.infoPath = new Text(mainComposite, 2052);
        this.infoPath.setLayoutData((Object)new GridData(768));
        this.infoPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorConfigTab.this.validate();
                GeneratorConfigTab.this.setDirty(true);
                GeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(mainComposite, 0);
        label.setText("The directory for generated &documentation:");
        this.docPath = new Text(mainComposite, 2052);
        this.docPath.setLayoutData((Object)new GridData(768));
        this.docPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorConfigTab.this.validate();
                GeneratorConfigTab.this.setDirty(true);
                GeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.addFurtherControls(mainComposite);
    }

    protected void addFurtherControls(Composite mainComposite) {
    }

    protected void handleSaveGenModelSelected() {
        boolean save = this.saveGenModel.getSelection();
        this.genModelPath.setEnabled(save);
        this.browsePath.setEnabled(save);
        this.validate();
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void handleOverrideDirectories() {
        boolean override = this.overrideDirectories.getSelection();
        this.srcgenPath.setEnabled(override);
        this.infoPath.setEnabled(override);
        this.docPath.setEnabled(override);
        if (!override) {
            ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.etrice.generator.ui");
            this.srcgenPath.setText(prefStore.getString("GenerationDirectory"));
            this.infoPath.setText(prefStore.getString("GenerationInfoDirectory"));
            this.docPath.setText(prefStore.getString("GeneratedDocuDirectory"));
        }
        this.validate();
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void validate() {
        if (this.saveGenModel.getSelection() && this.genModelPath.getText().trim().isEmpty()) {
            this.setErrorMessage("generator model path must not be empty");
            return;
        }
        this.setErrorMessage(null);
    }

    protected void handlePathButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "select a container for the generator model");
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String fname = path.toString();
            fname = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", fname);
            this.genModelPath.setText(fname);
            this.setErrorMessage(null);
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.libButton.setSelection(configuration.getAttribute(LIB, false));
            boolean save = configuration.getAttribute(SAVE_GEN_MODEL, false);
            this.saveGenModel.setSelection(save);
            this.genModelPath.setEnabled(save);
            this.browsePath.setEnabled(save);
            this.genModelPath.setText(configuration.getAttribute(GEN_MODEL_PATH, ""));
            this.mainMethodName.setText(configuration.getAttribute(MAIN_METHOD_NAME, "main"));
            boolean genDocu = configuration.getAttribute(GEN_DOCUMENTATION, false);
            if (configuration.getAttribute(GEN_INSTANCE_DIAGRAM, false)) {
                genDocu = true;
            }
            this.documentationButton.setSelection(genDocu);
            this.debugButton.setSelection(configuration.getAttribute(DEBUG, false));
            this.mscButton.setSelection(configuration.getAttribute(MSC_INSTR, false));
            this.dataButton.setSelection(configuration.getAttribute(DATA_INSTR, false));
            this.verboseButton.setSelection(configuration.getAttribute(VERBOSE, false));
            ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.etrice.generator.ui");
            boolean useTranslation = prefStore.getBoolean("GenerateUsingTranslation");
            this.useTranslationButton.setSelection(configuration.getAttribute(USE_TRAANSLATION, useTranslation));
            boolean override = configuration.getAttribute(OVERRIDE_DIRECTORIES, false);
            String srcgenDir = prefStore.getString("GenerationDirectory");
            String infoDir = prefStore.getString("GenerationInfoDirectory");
            String docDir = prefStore.getString("GeneratedDocuDirectory");
            this.overrideDirectories.setSelection(override);
            this.srcgenPath.setEnabled(override);
            this.infoPath.setEnabled(override);
            this.docPath.setEnabled(override);
            if (override) {
                this.srcgenPath.setText(configuration.getAttribute(SRCGEN_PATH, srcgenDir));
                this.infoPath.setText(configuration.getAttribute(INFO_PATH, infoDir));
                this.docPath.setText(configuration.getAttribute(DOC_PATH, docDir));
            } else {
                this.srcgenPath.setText(srcgenDir);
                this.infoPath.setText(infoDir);
                this.docPath.setText(docDir);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(LIB, this.libButton.getSelection());
        configuration.setAttribute(SAVE_GEN_MODEL, this.saveGenModel.getSelection());
        configuration.setAttribute(GEN_MODEL_PATH, this.genModelPath.getText());
        configuration.setAttribute(MAIN_METHOD_NAME, this.mainMethodName.getText());
        configuration.setAttribute(GEN_INSTANCE_DIAGRAM, this.documentationButton.getSelection());
        configuration.setAttribute(GEN_DOCUMENTATION, this.documentationButton.getSelection());
        configuration.setAttribute(DEBUG, this.debugButton.getSelection());
        configuration.setAttribute(MSC_INSTR, this.mscButton.getSelection());
        configuration.setAttribute(DATA_INSTR, this.dataButton.getSelection());
        configuration.setAttribute(VERBOSE, this.verboseButton.getSelection());
        configuration.setAttribute(USE_TRAANSLATION, this.useTranslationButton.getSelection());
        boolean override = this.overrideDirectories.getSelection();
        configuration.setAttribute(OVERRIDE_DIRECTORIES, override);
        if (override) {
            configuration.setAttribute(SRCGEN_PATH, this.srcgenPath.getText());
            configuration.setAttribute(INFO_PATH, this.infoPath.getText());
            configuration.setAttribute(DOC_PATH, this.docPath.getText());
        }
    }

    public boolean canSave() {
        if (this.saveGenModel.getSelection()) {
            return !this.genModelPath.getText().trim().isEmpty();
        }
        return true;
    }

    protected class UpdateConfig
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            GeneratorConfigTab.this.validate();
            GeneratorConfigTab.this.setDirty(true);
            GeneratorConfigTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

