/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.commands;

import com.google.inject.Injector;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.ui.behavior.fsm.commands.StateGraphContext;
import org.eclipse.etrice.ui.behavior.fsm.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.fsm.support.FSMSupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class PopulateDiagramCommand
extends RecordingCommand {
    private ModelComponent mc;
    private Diagram diagram;
    private IFeatureProvider fp;
    private Injector injector;

    public PopulateDiagramCommand(String providerId, Diagram diag, ModelComponent mc, Injector injector, TransactionalEditingDomain domain) {
        super(domain);
        this.diagram = diag;
        this.mc = mc;
        this.injector = injector;
        IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(this.diagram, providerId);
        this.fp = dtp.getFeatureProvider();
    }

    protected void doExecute() {
        this.fp.link((PictogramElement)this.diagram, (Object)this.mc);
        StateGraphContext tree = StateGraphContext.createContextTree(this.mc, this.injector);
        FSMSupportUtil.getInstance().addStateGraph(tree, this.diagram, this.fp);
        ContextSwitcher.switchTop(this.diagram);
    }
}

