/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.editor;

import com.google.inject.Inject;
import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMEditor;
import org.eclipse.etrice.ui.behavior.fsm.support.FSMSupportUtil;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.etrice.ui.common.base.editor.DiagramExporter;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class BehaviorExporter {
    private static final String SUFFIX = "_behavior";
    @Inject
    private DiagramAccessBase da;

    public void export(ModelComponent mc, String folder) {
        boolean wasOpen = false;
        AbstractFSMEditor editor = (AbstractFSMEditor)this.da.findDiagramEditor((EObject)mc);
        if (editor != null) {
            wasOpen = true;
        } else {
            editor = (AbstractFSMEditor)this.da.openDiagramEditor((EObject)mc);
        }
        if (editor != null) {
            String filename = String.valueOf(folder) + File.separatorChar + mc.getComponentName() + SUFFIX;
            DiagramExporter.export((DiagramEditorBase)editor, (String)filename);
            this.exportSubGraphsRecursively(mc.getStateMachine(), editor, String.valueOf(folder) + File.separatorChar + mc.getComponentName());
            if (!wasOpen) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    private void exportSubGraphsRecursively(StateGraph sg, AbstractFSMEditor editor, String basename) {
        if (sg == null) {
            return;
        }
        for (State state : sg.getStates()) {
            if (!FSMSupportUtil.getInstance().getFSMHelpers().hasDirectSubStructure(state)) continue;
            if (editor.showStateGraph(state.getSubgraph())) {
                String filename = String.valueOf(basename) + "_" + FSMSupportUtil.getInstance().getFSMNameProvider().getStatePathName(state) + SUFFIX;
                DiagramExporter.export((DiagramEditorBase)editor, (String)filename);
            }
            this.exportSubGraphsRecursively(state.getSubgraph(), editor, basename);
        }
    }
}

