/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.cpp.gen.StateMachineGen;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    protected IGeneratorFileIo fileIO;
    @Inject
    @Extension
    protected CppExtensions _cppExtensions;
    @Inject
    @Extension
    protected RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected ProcedureHelpers _procedureHelpers;
    @Inject
    protected Initialization initHelper;
    @Inject
    @Extension
    protected StateMachineGen _stateMachineGen;
    @Inject
    @Extension
    protected FileSystemHelpers _fileSystemHelpers;

    public void doGenerate(Root root) {
        final HashMap ac2wired = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        EList _wiredInstances = root.getWiredInstances();
        Iterable _filter = Iterables.filter((Iterable)_wiredInstances, WiredActorClass.class);
        Procedures.Procedure1<WiredActorClass> _function = new Procedures.Procedure1<WiredActorClass>(){

            public void apply(WiredActorClass it) {
                ActorClass _actorClass = it.getActorClass();
                ac2wired.put(_actorClass, it);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function);
        EList _xpActorClasses = root.getXpActorClasses();
        Functions.Function1<ExpandedActorClass, Boolean> _function_1 = new Functions.Function1<ExpandedActorClass, Boolean>(){

            public Boolean apply(ExpandedActorClass cl) {
                ActorClass _actorClass = cl.getActorClass();
                return ActorClassGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)_actorClass);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_xpActorClasses, (Functions.Function1)_function_1);
        for (ExpandedActorClass xpac : _filter_1) {
            ActorClass _actorClass = xpac.getActorClass();
            WiredActorClass wired = (WiredActorClass)ac2wired.get(_actorClass);
            ActorClass _actorClass_1 = xpac.getActorClass();
            boolean manualBehavior = this._roomHelpers.isBehaviorAnnotationPresent(_actorClass_1, "BehaviorManual");
            ActorClass _actorClass_2 = xpac.getActorClass();
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_actorClass_2);
            ActorClass _actorClass_3 = xpac.getActorClass();
            String _path = this._roomExtensions.getPath((RoomClass)_actorClass_3);
            String path = String.valueOf(_generationTargetPath) + _path;
            ActorClass _actorClass_4 = xpac.getActorClass();
            String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)_actorClass_4);
            ActorClass _actorClass_5 = xpac.getActorClass();
            String _path_1 = this._roomExtensions.getPath((RoomClass)_actorClass_5);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            String _xifexpression = null;
            _xifexpression = manualBehavior ? "Abstract" : "";
            String file = _xifexpression;
            ActorClass _actorClass_6 = xpac.getActorClass();
            String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName((RoomClass)_actorClass_6);
            String _plus = String.valueOf(file) + _cppHeaderFileName;
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, xpac, wired, manualBehavior);
            this.fileIO.generateFile("generating ActorClass declaration", path, infopath, _plus, _generateHeaderFile);
            ActorClass _actorClass_7 = xpac.getActorClass();
            String _cppSourceFileName = this._cppExtensions.getCppSourceFileName((RoomClass)_actorClass_7);
            String _plus_1 = String.valueOf(file) + _cppSourceFileName;
            CharSequence _generateSourceFile = this.generateSourceFile(root, xpac, wired, manualBehavior);
            this.fileIO.generateFile("generating ActorClass implementation", path, infopath, _plus_1, _generateSourceFile);
        }
    }

    protected CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac, WiredActorClass wired, boolean manualBehavior) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        String _xifexpression = null;
        if (manualBehavior) {
            String _name = ac.getName();
            _xifexpression = "Abstract" + _name;
        } else {
            _xifexpression = ac.getName();
        }
        final String clsname = _xifexpression;
        String _elvis = null;
        ActorClass _actorBase = ac.getActorBase();
        String _name_1 = null;
        if (_actorBase != null) {
            _name_1 = _actorBase.getName();
        }
        _elvis = _name_1 != null ? _name_1 : "etRuntime::ActorClassBase";
        String rtBaseClassName = _elvis;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of ActorClass ");
        _builder.append((Object)clsname, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin((RoomClass)ac, "");
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/IRTObject.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/PortBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/ReplicatedActorClassBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/SubSystemClassBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/Address.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/IMessageReceiver.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.newLine();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : _referencedProtocolClasses) {
            _builder.append((Object)"#include \"");
            String _path = this._roomExtensions.getPath((RoomClass)pc);
            _builder.append((Object)_path, "");
            String _name_2 = pc.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)ac);
        for (DataClass dc : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _path_1 = this._roomExtensions.getPath((RoomClass)dc);
            _builder.append((Object)_path_1, "");
            String _name_3 = dc.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        ActorClass _actorBase_1 = ac.getActorBase();
        boolean _equals = Objects.equal((Object)_actorBase_1, null);
        if (_equals) {
            _builder.append((Object)"#include \"common/modelbase/ActorClassBase.h\"");
            _builder.newLine();
        } else {
            _builder.append((Object)"#include \"");
            ActorClass _actorBase_2 = ac.getActorBase();
            String _path_2 = this._roomExtensions.getPath((RoomClass)_actorBase_2);
            _builder.append((Object)_path_2, "");
            ActorClass _actorBase_3 = ac.getActorBase();
            String _name_4 = _actorBase_3.getName();
            _builder.append((Object)_name_4, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _actorRefs = ac.getActorRefs();
        for (ActorRef ar : _actorRefs) {
            _builder.append((Object)"#include \"");
            ActorClass _type = ar.getType();
            String _actorIncludePath = this._cppExtensions.getActorIncludePath(_type);
            _builder.append((Object)_actorIncludePath, "");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        DetailCode _userCode1 = ac.getUserCode1();
        CharSequence _userCode = this._procedureHelpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)ac);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" : public ");
        _builder.append((Object)rtBaseClassName, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- ports");
        _builder.newLine();
        List _endPorts = this._roomHelpers.getEndPorts(ac);
        for (Port ep : _endPorts) {
            _builder.append((Object)"\t\t");
            String _portClassName = this._roomExtensions.getPortClassName((EObject)ep);
            _builder.append((Object)_portClassName, "\t\t");
            _builder.append((Object)" ");
            String _name_5 = ep.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- sub actors");
        _builder.newLine();
        EList _actorRefs_1 = ac.getActorRefs();
        for (ActorRef sub : _actorRefs_1) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl = _greaterThan = _multiplicity > 1;
            if (_greaterThan) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Replicated");
                ActorClass _type_1 = sub.getType();
                String _implementationClassName = this._cppExtensions.getImplementationClassName(_type_1);
                _builder.append((Object)_implementationClassName, "\t\t");
                _builder.append((Object)" ");
                String _name_6 = sub.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            ActorClass _type_2 = sub.getType();
            String _implementationClassName_1 = this._cppExtensions.getImplementationClassName(_type_2);
            _builder.append((Object)_implementationClassName_1, "\t\t");
            _builder.append((Object)" ");
            String _name_7 = sub.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- saps");
        _builder.newLine();
        EList _serviceAccessPoints = ac.getServiceAccessPoints();
        for (SAP sap : _serviceAccessPoints) {
            _builder.append((Object)"\t\t");
            String _portClassName_1 = this._roomExtensions.getPortClassName((EObject)sap);
            _builder.append((Object)_portClassName_1, "\t\t");
            _builder.append((Object)" ");
            String _name_8 = sap.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- services");
        _builder.newLine();
        EList _serviceImplementations = ac.getServiceImplementations();
        for (ServiceImplementation svc : _serviceImplementations) {
            _builder.append((Object)"\t\t");
            String _portClassName_2 = this._roomExtensions.getPortClassName((EObject)svc);
            _builder.append((Object)_portClassName_2, "\t\t");
            _builder.append((Object)" ");
            SPP _spp = svc.getSpp();
            String _name_9 = _spp.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- interface item IDs");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _genInterfaceItemConstants = this.genInterfaceItemConstants(xpac);
        _builder.append((Object)_genInterfaceItemConstants, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _attributes = ac.getAttributes();
        CharSequence _attributes_1 = this._procedureHelpers.attributes((List)_attributes);
        _builder.append((Object)_attributes_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _operations = ac.getOperations();
        String _name_10 = ac.getName();
        CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration((List)_operations, _name_10);
        _builder.append((Object)_operationsDeclaration, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- construction");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _name_11 = ac.getName();
        _builder.append((Object)_name_11, "\t\t");
        _builder.append((Object)"(etRuntime::IRTObject* parent, const String& name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"void initialize(void);");
        _builder.newLine();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"void setProbesActive(bool recursive, bool active);");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- port getters");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        List _endPorts_1 = this._roomHelpers.getEndPorts(ac);
        Functions.Function1<Port, CharSequence> _function = new Functions.Function1<Port, CharSequence>(){

            public CharSequence apply(Port it) {
                String _portClassName = ActorClassGen.this._roomExtensions.getPortClassName((EObject)it);
                String _plus = String.valueOf(_portClassName) + "&";
                String _name = it.getName();
                return ActorClassGen.this._procedureHelpers.getterImplementation(_plus, _name, clsname);
            }
        };
        List _map = ListExtensions.map((List)_endPorts_1, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)this._roomExtensions.NEWLINE);
        _builder.append((Object)_join, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _serviceAccessPoints_1 = ac.getServiceAccessPoints();
        Functions.Function1<SAP, CharSequence> _function_1 = new Functions.Function1<SAP, CharSequence>(){

            public CharSequence apply(SAP it) {
                String _portClassName = ActorClassGen.this._roomExtensions.getPortClassName((EObject)it);
                String _plus = String.valueOf(_portClassName) + "&";
                String _name = it.getName();
                return ActorClassGen.this._procedureHelpers.getterImplementation(_plus, _name, clsname);
            }
        };
        List _map_1 = ListExtensions.map((List)_serviceAccessPoints_1, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)this._roomExtensions.NEWLINE);
        _builder.append((Object)_join_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _serviceImplementations_1 = ac.getServiceImplementations();
        Functions.Function1<ServiceImplementation, CharSequence> _function_2 = new Functions.Function1<ServiceImplementation, CharSequence>(){

            public CharSequence apply(ServiceImplementation it) {
                String _portClassName = ActorClassGen.this._roomExtensions.getPortClassName((EObject)it);
                String _plus = String.valueOf(_portClassName) + "&";
                SPP _spp = it.getSpp();
                String _name = _spp.getName();
                return ActorClassGen.this._procedureHelpers.getterImplementation(_plus, _name, clsname);
            }
        };
        List _map_2 = ListExtensions.map((List)_serviceImplementations_1, (Functions.Function1)_function_2);
        String _join_2 = IterableExtensions.join((Iterable)_map_2, (CharSequence)this._roomExtensions.NEWLINE);
        _builder.append((Object)_join_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//--------------------- lifecycle functions");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual void destroy();");
        _builder.newLine();
        _builder.newLine();
        boolean _hasNonEmptyStateMachine = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (_hasNonEmptyStateMachine) {
            _builder.append((Object)"\t\t");
            CharSequence _genStateMachineConstants = this._stateMachineGen.genStateMachineConstants((ExpandedModelComponent)xpac);
            _builder.append((Object)_genStateMachineConstants, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"\t\t");
            CharSequence _genStateMachineMethods = this._stateMachineGen.genStateMachineMethods((ExpandedModelComponent)xpac, false);
            _builder.append((Object)_genStateMachineMethods, "\t\t");
            _builder.newLineIfNotEmpty();
            ComponentCommunicationType _commType = ac.getCommType();
            boolean _equals_1 = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.DATA_DRIVEN);
            if (_equals_1) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* generic_data);");
                _builder.newLine();
            }
            if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"virtual void receive(const etRuntime::Message* msg);");
                _builder.newLine();
            }
        } else {
            StateGraph _stateMachine = xpac.getStateMachine();
            boolean _isEmpty = this._roomHelpers.isEmpty(_stateMachine);
            if (_isEmpty) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"//--------------------- no state machine");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"virtual void executeInitTransition() {}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        DetailCode _userCode2 = ac.getUserCode2();
        CharSequence _userCode_1 = this._procedureHelpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"class Replicated");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" : public ReplicatedActorClassBase {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Replicated");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"(IRTObject* parent, const String& name) :");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ReplicatedActorClassBase(parent, name) {}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"protected:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ActorClassBase* createActor(IRTObject* parent, const String& name) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new ");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)"(parent, name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)ac);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd((RoomClass)ac, "");
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateConstructorInitalizerList(ActorClass ac) {
        CharSequence _xblockexpression = null;
        final Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        StringConcatenation _builder = new StringConcatenation();
        String _elvis = null;
        ActorClass _actorBase = ac.getActorBase();
        String _name = null;
        if (_actorBase != null) {
            _name = _actorBase.getName();
        }
        _elvis = _name != null ? _name : "ActorClassBase";
        _builder.append((Object)_elvis, "");
        _builder.append((Object)"(parent, name)");
        initList.add(_builder.toString());
        List _endPorts = this._roomHelpers.getEndPorts(ac);
        Functions.Function1<Port, String> _function = new Functions.Function1<Port, String>(){

            public String apply(Port it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(this, \"");
                String _name_1 = it.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)"\", IFITEM_");
                String _name_2 = it.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)")");
                return _builder.toString();
            }
        };
        List _map = ListExtensions.map((List)_endPorts, (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        EList _actorRefs = ac.getActorRefs();
        Functions.Function1<ActorRef, String> _function_1 = new Functions.Function1<ActorRef, String>(){

            public String apply(ActorRef it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(this, \"");
                String _name_1 = it.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)"\")");
                return _builder.toString();
            }
        };
        List _map_1 = ListExtensions.map((List)_actorRefs, (Functions.Function1)_function_1);
        Iterables.addAll((Collection)initList, (Iterable)_map_1);
        EList _serviceAccessPoints = ac.getServiceAccessPoints();
        Functions.Function1<SAP, String> _function_2 = new Functions.Function1<SAP, String>(){

            public String apply(SAP it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(this, \"");
                String _name_1 = it.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)"\", IFITEM_");
                String _name_2 = it.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)")");
                return _builder.toString();
            }
        };
        List _map_2 = ListExtensions.map((List)_serviceAccessPoints, (Functions.Function1)_function_2);
        Iterables.addAll((Collection)initList, (Iterable)_map_2);
        EList _serviceImplementations = ac.getServiceImplementations();
        Functions.Function1<ServiceImplementation, String> _function_3 = new Functions.Function1<ServiceImplementation, String>(){

            public String apply(ServiceImplementation it) {
                StringConcatenation _builder = new StringConcatenation();
                SPP _spp = it.getSpp();
                String _name = _spp.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(this, \"");
                SPP _spp_1 = it.getSpp();
                String _name_1 = _spp_1.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)"\", IFITEM_");
                SPP _spp_2 = it.getSpp();
                String _name_2 = _spp_2.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)")");
                return _builder.toString();
            }
        };
        List _map_3 = ListExtensions.map((List)_serviceImplementations, (Functions.Function1)_function_3);
        Iterables.addAll((Collection)initList, (Iterable)_map_3);
        EList _attributes = ac.getAttributes();
        Functions.Function1<Attribute, String> _function_4 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(");
                String _initializerListValue = initHelper.getInitializerListValue(it);
                _builder.append((Object)_initializerListValue, "");
                _builder.append((Object)")");
                return _builder.toString();
            }
        };
        List _map_4 = ListExtensions.map((List)_attributes, (Functions.Function1)_function_4);
        Iterables.addAll((Collection)initList, (Iterable)_map_4);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    protected CharSequence generateSourceFile(Root root, ExpandedActorClass xpac, WiredActorClass wired, boolean manualBehavior) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        String _xifexpression = null;
        if (manualBehavior) {
            String _name = ac.getName();
            _xifexpression = "Abstract" + _name;
        } else {
            _xifexpression = ac.getName();
        }
        String clsname = _xifexpression;
        String _elvis = null;
        ActorClass _actorBase = ac.getActorBase();
        String _name_1 = null;
        if (_actorBase != null) {
            _name_1 = _actorBase.getName();
        }
        _elvis = _name_1 != null ? _name_1 : "ActorClassBase";
        String rtBaseClassName = _elvis;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of ActorClass ");
        String _name_2 = ac.getName();
        _builder.append((Object)_name_2, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName((RoomClass)ac);
        _builder.append((Object)_cppHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/RTObject.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/RTServices.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/debugging/MSCFunctionObject.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)ac);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DetailCode _userCode3 = ac.getUserCode3();
        CharSequence _userCode = this._procedureHelpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"(etRuntime::IRTObject* parent, const String& name)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        CharSequence _generateConstructorInitalizerList = this.generateConstructorInitalizerList(ac);
        _builder.append((Object)_generateConstructorInitalizerList, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder.append((Object)"\t");
            _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Constructor\");");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        boolean _hasNonEmptyStateMachine = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (_hasNonEmptyStateMachine) {
            _builder.append((Object)"\t");
            _builder.append((Object)"for (int i = 0; i < s_numberOfStates; i++) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"history[i] = NO_STATE;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"setClassName(\"");
        String _name_3 = ac.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// sub actors");
        _builder.newLine();
        EList _actorRefs = ac.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl = _greaterThan = _multiplicity > 1;
            if (!_greaterThan) continue;
            _builder.append((Object)"\t");
            String _name_4 = sub.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)".createSubActors(");
            int _multiplicity_1 = sub.getMultiplicity();
            _builder.append((Object)_multiplicity_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes = ac.getAttributes();
        CharSequence _genExtraInitializers = this.initHelper.genExtraInitializers((Iterable<Attribute>)_attributes);
        _builder.append((Object)_genExtraInitializers, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _userStructorBody = this._procedureHelpers.userStructorBody((RoomClass)ac, true);
        _builder.append((Object)_userStructorBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_5 = ac.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)"::initialize() {");
        _builder.newLineIfNotEmpty();
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_1 = _settings_1.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"initialize()\");");
            _builder.newLine();
            EList _actorRefs_1 = ac.getActorRefs();
            for (ActorRef sub_1 : _actorRefs_1) {
                boolean _greaterThan_1;
                int _multiplicity_2 = sub_1.getMultiplicity();
                boolean bl = _greaterThan_1 = _multiplicity_2 > 1;
                if (_greaterThan_1) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for (int i=0; i<");
                    int _multiplicity_3 = sub_1.getMultiplicity();
                    _builder.append((Object)_multiplicity_3, "\t");
                    _builder.append((Object)"; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"DebuggingService::getInstance().addMessageActorCreate(*this, ");
                    String _name_6 = sub_1.getName();
                    _builder.append((Object)_name_6, "\t\t");
                    _builder.append((Object)".getSubActor(i)->getName());");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService::getInstance().addMessageActorCreate(*this, \"");
                String _name_7 = sub_1.getName();
                _builder.append((Object)_name_7, "\t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ActorClassBase::initialize();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _actorRefs_2 = ac.getActorRefs();
        for (ActorRef sub_2 : _actorRefs_2) {
            _builder.append((Object)"\t");
            String _name_8 = sub_2.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)".initialize();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// wiring");
        _builder.newLine();
        EList _wires = wired.getWires();
        for (Wire wire : _wires) {
            _builder.append((Object)"\t");
            String _xifexpression_1 = null;
            boolean _isDataDriven = wire.isDataDriven();
            _xifexpression_1 = _isDataDriven ? "DataPortBase" : "InterfaceItemBase";
            _builder.append((Object)_xifexpression_1, "\t");
            _builder.append((Object)"::connect(this, \"");
            EList _path1 = wire.getPath1();
            String _join = IterableExtensions.join((Iterable)_path1, (CharSequence)"/");
            _builder.append((Object)_join, "\t");
            _builder.append((Object)"\", \"");
            EList _path2 = wire.getPath2();
            String _join_1 = IterableExtensions.join((Iterable)_path2, (CharSequence)"/");
            _builder.append((Object)_join_1, "\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// activate polling for data-driven communication");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"RTServices::getInstance().getMsgSvcCtrl().getMsgSvc(getThread())->addPollingMessageReceiver(*this);");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        GlobalGeneratorSettings _settings_2 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_2 = _settings_2.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_2) {
            boolean _greaterThan_2;
            _builder.append((Object)"void ");
            String _name_9 = ac.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)"::setProbesActive(bool recursive, bool active) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService::getInstance().addPortInstance(m_RTSystemPort);");
            _builder.newLine();
            EList _actorRefs_3 = ac.getActorRefs();
            int _size = _actorRefs_3.size();
            boolean bl = _greaterThan_2 = _size > 0;
            if (_greaterThan_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"if(recursive) {");
                _builder.newLine();
                EList _actorRefs_4 = ac.getActorRefs();
                for (ActorRef sub_3 : _actorRefs_4) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    String _name_10 = sub_3.getName();
                    _builder.append((Object)_name_10, "\t\t");
                    _builder.append((Object)".setProbesActive(recursive, active);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            List _endPorts = this._roomHelpers.getEndPorts(ac);
            for (Port ep : _endPorts) {
                boolean _not;
                boolean _isDataDriven_1 = this._roomHelpers.isDataDriven((InterfaceItem)ep);
                boolean bl2 = _not = !_isDataDriven_1;
                if (!_not) continue;
                boolean _isReplicated = ep.isReplicated();
                if (_isReplicated) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for(int i = 0; i < ");
                    String _name_11 = ep.getName();
                    _builder.append((Object)_name_11, "\t");
                    _builder.append((Object)".getNInterfaceItems(); i++)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"DebuggingService::getInstance().addPortInstance(*(");
                    String _name_12 = ep.getName();
                    _builder.append((Object)_name_12, "\t\t");
                    _builder.append((Object)".getInterfaceItem(i)));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService::getInstance().addPortInstance(");
                String _name_13 = ep.getName();
                _builder.append((Object)_name_13, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            EList _serviceAccessPoints = ac.getServiceAccessPoints();
            for (SAP sap : _serviceAccessPoints) {
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService::getInstance().addPortInstance(");
                String _name_14 = sap.getName();
                _builder.append((Object)_name_14, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            EList _serviceProvisionPoints = ac.getServiceProvisionPoints();
            for (SPP spp : _serviceProvisionPoints) {
                _builder.append((Object)"\t");
                _builder.append((Object)"for(int i = 0; i < ");
                String _name_15 = spp.getName();
                _builder.append((Object)_name_15, "\t");
                _builder.append((Object)".getNInterfaceItems(); i++)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"DebuggingService::getInstance().addPortInstance(*(");
                String _name_16 = spp.getName();
                _builder.append((Object)_name_16, "\t\t\t");
                _builder.append((Object)".getInterfaceItem(i)));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_17 = ac.getName();
        _builder.append((Object)_name_17, "");
        _builder.append((Object)"::destroy(){");
        _builder.newLineIfNotEmpty();
        GlobalGeneratorSettings _settings_3 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_3 = _settings_3.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_3) {
            _builder.append((Object)"\t");
            _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"destroy()\");");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _userStructorBody_1 = this._procedureHelpers.userStructorBody((RoomClass)ac, false);
        _builder.append((Object)_userStructorBody_1, "\t");
        _builder.newLineIfNotEmpty();
        GlobalGeneratorSettings _settings_4 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_4 = _settings_4.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_4) {
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService::getInstance().addMessageActorDestroy(*this);");
            _builder.newLine();
        }
        if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
            _builder.append((Object)"\t");
            _builder.append((Object)"RTServices::getInstance().getMsgSvcCtrl().getMsgSvc(getThread())->removePollingMessageReceiver(*this);");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)rtBaseClassName, "\t");
        _builder.append((Object)"::destroy();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList _operations = ac.getOperations();
        String _name_18 = ac.getName();
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)_operations, _name_18);
        _builder.append((Object)_operationsImplementation, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasNonEmptyStateMachine_1 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (_hasNonEmptyStateMachine_1) {
            CharSequence _genStateMachineMethods = this._stateMachineGen.genStateMachineMethods((ExpandedModelComponent)xpac, true);
            _builder.append((Object)_genStateMachineMethods, "");
            _builder.newLineIfNotEmpty();
            ComponentCommunicationType _commType = ac.getCommType();
            boolean _equals = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.DATA_DRIVEN);
            if (_equals) {
                _builder.append((Object)"void ");
                String _name_19 = ac.getName();
                _builder.append((Object)_name_19, "");
                _builder.append((Object)"::receiveEvent(InterfaceItemBase* ifitem, int evt, void* generic_data) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"handleSystemEvent(ifitem, evt, generic_data);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
            if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
                _builder.append((Object)"void ");
                String _name_20 = ac.getName();
                _builder.append((Object)_name_20, "");
                _builder.append((Object)"::receive(const Message* msg) {");
                _builder.newLineIfNotEmpty();
                ComponentCommunicationType _commType_1 = ac.getCommType();
                boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)ComponentCommunicationType.ASYNCHRONOUS);
                if (_equals_1) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"receiveEvent(0, -1, 0);");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"receiveEventInternal();");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        } else {
            StateGraph _stateMachine = xpac.getStateMachine();
            boolean _isEmpty = this._roomHelpers.isEmpty(_stateMachine);
            if (_isEmpty) {
                _builder.append((Object)"//--------------------- no state machine");
                _builder.newLine();
                _builder.append((Object)"void ");
                String _name_21 = ac.getName();
                _builder.append((Object)_name_21, "");
                _builder.append((Object)"::receiveEvent(InterfaceItemBase* ifitem, int evt, void* data) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"handleSystemEvent(ifitem, evt, data);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)ac);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

