/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class CppExtensions
implements ILanguageExtension {
    @Inject
    private IDiagnostician diagnostician;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public String getTypedDataDefinition(EObject msg) {
        VarDecl _data = ((Message)msg).getData();
        String[] _generateArglistAndTypedData = this.generateArglistAndTypedData((EObject)_data);
        return _generateArglistAndTypedData[1];
    }

    public String getCppHeaderFileName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + ".h";
    }

    public String getCppSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        return String.valueOf(_name) + ".cpp";
    }

    public String getCppClassName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = "Node_" + _name;
        String _plus_1 = String.valueOf(_plus) + "_";
        String _name_1 = ssi.getName();
        return String.valueOf(_plus_1) + _name_1;
    }

    public String getCppHeaderFileName(NodeRef nr, SubSystemInstance ssi) {
        String _cppClassName = this.getCppClassName(nr, ssi);
        return String.valueOf(_cppClassName) + ".h";
    }

    public String getCppSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String _cppClassName = this.getCppClassName(nr, ssi);
        return String.valueOf(_cppClassName) + ".cpp";
    }

    public String accessLevelPrivate() {
        return "";
    }

    public String accessLevelProtected() {
        return "";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "this->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String scopeSeparator() {
        return "::";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        String _xifexpression = null;
        _xifexpression = isDeclaration ? "" : String.valueOf(classname) + "::";
        return _xifexpression;
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        return String.valueOf(namespace) + "." + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        String _xblockexpression = null;
        boolean _isEmpty = entries.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef enum {");
        _builder.newLine();
        boolean _hasElements = false;
        for (Pair<String, String> entry : entries) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            String _first = (String)entry.getFirst();
            _builder.append((Object)_first, "\t");
            _builder.append((Object)" = ");
            String _second = (String)entry.getSecond();
            _builder.append((Object)_second, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"} ");
        _builder.append((Object)name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String booleanConstant(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "0";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayType(String type, int size, boolean isRef) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"StaticArray<");
        _builder.append((Object)type, "");
        if (isRef) {
            _builder.append((Object)"*");
        }
        _builder.append((Object)", ");
        _builder.append((Object)size, "");
        _builder.append((Object)">");
        return _builder.toString();
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        String _arrayType = this.arrayType(type, size, isRef);
        String _plus = String.valueOf(_arrayType) + " ";
        return String.valueOf(_plus) + name;
    }

    public String getIncludeGuardString(RoomClass roomClass, String appendSegments) {
        String _package = this._roomExtensions.getPackage(roomClass);
        String[] _split = _package.split("\\.");
        String _name = roomClass.getName();
        Iterable _plus = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name})));
        String[] _split_1 = appendSegments.split("\\.");
        Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)((Iterable)Conversions.doWrapArray((Object)_split_1)));
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isEmpty = it.isEmpty();
                return !_isEmpty;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_plus_1, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_filter, (CharSequence)"_");
        String _upperCase = _join.toUpperCase();
        String _plus_2 = "_" + _upperCase;
        return String.valueOf(_plus_2) + "_H_";
    }

    public CharSequence generateIncludeGuardBegin(RoomClass roomClass, String appendSegments) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#ifndef ");
        String _includeGuardString = this.getIncludeGuardString(roomClass, appendSegments);
        _builder.append((Object)_includeGuardString, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define ");
        String _includeGuardString_1 = this.getIncludeGuardString(roomClass, appendSegments);
        _builder.append((Object)_includeGuardString_1, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateIncludeGuardEnd(RoomClass roomClass, String appendSegments) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#endif /* ");
        String _includeGuardString = this.getIncludeGuardString(roomClass, appendSegments);
        _builder.append((Object)_includeGuardString, "");
        _builder.append((Object)" */");
        return _builder;
    }

    public String generateNamespaceBegin(RoomClass roomClass) {
        return "";
    }

    public String generateNamespaceEnd(RoomClass roomClass) {
        return "";
    }

    public String superCall(String baseClassName, String method, String arguments) {
        return String.valueOf(baseClassName) + "::" + method + "(" + arguments + ");";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        throw new UnsupportedOperationException("TODO Config for Cpp");
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        throw new UnsupportedOperationException("TODO Config for Cpp");
    }

    public String defaultValue(DataType dt) {
        String _switchResult = null;
        DataType it = dt;
        boolean _matched = false;
        if (it instanceof PrimitiveType) {
            _matched = true;
            _switchResult = ((PrimitiveType)it).getDefaultValueLiteral();
        }
        if (!_matched && it instanceof EnumerationType) {
            _matched = true;
            String _xblockexpression = null;
            this.diagnostician.error("Enumeration not supported", (EObject)dt, null);
            _switchResult = _xblockexpression = "/* TODO */";
        }
        if (!_matched && it instanceof ExternalType) {
            _matched = true;
            _switchResult = ((ExternalType)it).getDefaultValueLiteral();
        }
        return _switchResult;
    }

    public String getDefaultValue(EnumerationType type) {
        String _xifexpression = null;
        EList _literals = type.getLiterals();
        boolean _isEmpty = _literals.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            EList _literals_1 = type.getLiterals();
            EnumLiteral _get = (EnumLiteral)_literals_1.get(0);
            _xifexpression = this.getCastedValue(_get);
        }
        return _xifexpression;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        String _xifexpression = null;
        if (size > 1) {
            String _xblockexpression_1 = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = String.valueOf(res) + dv;
                if (++i >= size) continue;
                res = String.valueOf(res) + ",";
            }
            _xifexpression = _xblockexpression_1 = String.valueOf(res) + "}";
        } else {
            _xifexpression = dv;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        DataType _type_2;
        boolean _isPrimitive;
        RefableType _refType_2;
        DataType _type;
        if (Objects.equal((Object)d, null) || !(d instanceof VarDecl)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        VarDecl data = (VarDecl)d;
        String _switchResult = null;
        RefableType _refType = data.getRefType();
        DataType it = _type = _refType.getType();
        boolean _matched = false;
        if (it instanceof PrimitiveType) {
            boolean _not;
            String _castName = ((PrimitiveType)it).getCastName();
            boolean _isEmpty = Strings.isEmpty((String)_castName);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _matched = true;
                _switchResult = ((PrimitiveType)it).getCastName();
            }
        }
        if (!_matched && it instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getCastType((EnumerationType)it);
        }
        if (!_matched) {
            _switchResult = this._typeHelpers.typeName(it);
        }
        String castExpr = String.valueOf(_switchResult) + "*";
        RefableType _refType_1 = data.getRefType();
        DataType _type_1 = _refType_1.getType();
        String _typeName = this._typeHelpers.typeName(_type_1);
        String _switchResult_1 = null;
        RefableType it_1 = _refType_2 = data.getRefType();
        boolean _matched_1 = false;
        boolean _isRef = it_1.isRef();
        if (_isRef) {
            _matched_1 = true;
            _switchResult_1 = "*";
        }
        if (!_matched_1 && (_isPrimitive = this._typeHelpers.isPrimitive(_type_2 = it_1.getType()))) {
            _matched_1 = true;
            _switchResult_1 = "";
        }
        if (!_matched_1) {
            _switchResult_1 = "&";
        }
        String typeExpr = String.valueOf(_typeName) + _switchResult_1;
        String _xifexpression = null;
        RefableType _refType_3 = data.getRefType();
        boolean _isRef_1 = _refType_3.isRef();
        boolean _not = !_isRef_1;
        _xifexpression = _not ? "*" : "";
        String deRef = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)typeExpr, "");
        _builder.append((Object)" ");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" = ");
        _builder.append((Object)deRef, "");
        _builder.append((Object)"(static_cast<");
        _builder.append((Object)castExpr, "");
        _builder.append((Object)">(generic_data__et));");
        String typedData = String.valueOf(_builder.toString()) + this._roomExtensions.NEWLINE;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)", ");
        String _name_1 = data.getName();
        _builder_1.append((Object)_name_1, "");
        String dataArg = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)", ");
        _builder_2.append((Object)typeExpr, "");
        _builder_2.append((Object)" ");
        String _name_2 = data.getName();
        _builder_2.append((Object)_name_2, "");
        String typedArgList = _builder_2.toString();
        return new String[]{dataArg, typedData, typedArgList};
    }

    public String getTargetType(EnumerationType type) {
        boolean _notEquals;
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _notEquals = !Objects.equal((Object)_primitiveType, null);
        if (_notEquals) {
            PrimitiveType _primitiveType_1 = type.getPrimitiveType();
            _xifexpression = _primitiveType_1.getTargetName();
        } else {
            _xifexpression = type.getName();
        }
        return _xifexpression;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean _notEquals;
        String _xblockexpression = null;
        EObject _eContainer = literal.eContainer();
        EnumerationType type = (EnumerationType)_eContainer;
        String cast = this.getTargetType(type);
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _notEquals = !Objects.equal((Object)_primitiveType, null);
        if (_notEquals) {
            long _literalValue = literal.getLiteralValue();
            _xifexpression = Long.toString(_literalValue);
        } else {
            long _literalValue_1 = literal.getLiteralValue();
            String _string = Long.toString(_literalValue_1);
            String _plus = "((" + cast + ")" + _string;
            _xifexpression = String.valueOf(_plus) + ")";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getCastType(EnumerationType type) {
        boolean _notEquals;
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _notEquals = !Objects.equal((Object)_primitiveType, null);
        if (_notEquals) {
            PrimitiveType _primitiveType_1 = type.getPrimitiveType();
            _xifexpression = _primitiveType_1.getCastName();
        } else {
            _xifexpression = type.getName();
        }
        return _xifexpression;
    }

    public String makeOverridable() {
        return "virtual ";
    }

    public String getImplementationClassName(ActorClass ac) {
        String _xblockexpression = null;
        List attributes = this._roomHelpers.getAttributes(ac, "ImplementationSubclass");
        String _xifexpression = null;
        boolean _isEmpty = attributes.isEmpty();
        if (_isEmpty) {
            _xifexpression = ac.getName();
        } else {
            Functions.Function1<KeyValue, Boolean> _function = new Functions.Function1<KeyValue, Boolean>(){

                public Boolean apply(KeyValue it) {
                    String _key = it.getKey();
                    return Objects.equal((Object)_key, (Object)"fqnClassName");
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)attributes, (Functions.Function1)_function);
            KeyValue _head = (KeyValue)IterableExtensions.head((Iterable)_filter);
            Literal _value = _head.getValue();
            _xifexpression = this._roomHelpers.literalToString(_value);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getActorIncludePath(ActorClass ac) {
        String _xblockexpression = null;
        List attributes = this._roomHelpers.getAttributes(ac, "ImplementationSubclass");
        String _xifexpression = null;
        boolean _isEmpty = attributes.isEmpty();
        if (_isEmpty) {
            String _path = this._roomExtensions.getPath((RoomClass)ac);
            String _name = ac.getName();
            String _plus = String.valueOf(_path) + _name;
            _xifexpression = String.valueOf(_plus) + ".h";
        } else {
            String _xblockexpression_1 = null;
            Functions.Function1<KeyValue, Boolean> _function = new Functions.Function1<KeyValue, Boolean>(){

                public Boolean apply(KeyValue it) {
                    String _key = it.getKey();
                    return Objects.equal((Object)_key, (Object)"includePath");
                }
            };
            Iterable path = IterableExtensions.filter((Iterable)attributes, (Functions.Function1)_function);
            String _xifexpression_1 = null;
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)path);
            if (_isEmpty_1) {
                String _xblockexpression_2 = null;
                Functions.Function1<KeyValue, Boolean> _function_1 = new Functions.Function1<KeyValue, Boolean>(){

                    public Boolean apply(KeyValue it) {
                        String _key = it.getKey();
                        return Objects.equal((Object)_key, (Object)"fqnClassName");
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)attributes, (Functions.Function1)_function_1);
                KeyValue _head = (KeyValue)IterableExtensions.head((Iterable)_filter);
                Literal _value = _head.getValue();
                String _literalToString = this._roomHelpers.literalToString(_value);
                String[] _split = _literalToString.split("::");
                String baseName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
                _xifexpression_1 = _xblockexpression_2 = String.valueOf(baseName) + ".h";
            } else {
                KeyValue _head = (KeyValue)IterableExtensions.head((Iterable)path);
                Literal _value = _head.getValue();
                _xifexpression_1 = this._roomHelpers.literalToString(_value);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

