/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.CppProcedureHelpers;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DataClassGen {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private CppProcedureHelpers helpers;
    @Inject
    private Initialization initHelper;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        this.logger.logInfo("generating code");
        EList _usedDataClasses = root.getUsedDataClasses();
        for (DataClass dc : _usedDataClasses) {
            String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)dc);
            String _path = this.roomExt.getPath((RoomClass)dc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)dc);
            String _plus = "generating DataClass header '" + _cppHeaderFileName;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            String _cppHeaderFileName_1 = this.stdExt.getCppHeaderFileName((RoomClass)dc);
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, dc);
            this.fileAccess.generateFile(_cppHeaderFileName_1, _generateHeaderFile);
            String _cppSourceFileName = this.stdExt.getCppSourceFileName((RoomClass)dc);
            String _plus_4 = "generating DataClass source '" + _cppSourceFileName;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            String _cppSourceFileName_1 = this.stdExt.getCppSourceFileName((RoomClass)dc);
            CharSequence _generateSourceFile = this.generateSourceFile(root, dc);
            this.fileAccess.generateFile(_cppSourceFileName_1, _generateSourceFile);
        }
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        boolean _not;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin((RoomClass)dc, "");
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        DataClass _base = dc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            _builder.append((Object)"#include \"");
            DataClass _base_1 = dc.getBase();
            String _path = this.roomExt.getPath((RoomClass)_base_1);
            _builder.append((Object)_path, "");
            DataClass _base_2 = dc.getBase();
            String _name = _base_2.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".h\"");
        }
        _builder.newLineIfNotEmpty();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)dc);
        for (DataClass classes : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _path_1 = this.roomExt.getPath((RoomClass)classes);
            _builder.append((Object)_path_1, "");
            String _name_1 = classes.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _referencedModels = root.getReferencedModels((RoomClass)dc);
        for (RoomModel model : _referencedModels) {
            EList _dataClasses = model.getDataClasses();
            for (DataClass classes_1 : _dataClasses) {
                _builder.append((Object)"#include \"");
                String _path_2 = this.roomExt.getPath((RoomClass)classes_1);
                _builder.append((Object)_path_2, "");
                String _name_2 = classes_1.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)".h\"");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        DetailCode _userCode1 = dc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime; // TODO JH remove");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_3 = dc.getName();
        _builder.append((Object)_name_3, "");
        DataClass _base_3 = dc.getBase();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_base_3, null);
        if (_notEquals_1) {
            _builder.append((Object)" : public ");
            DataClass _base_4 = dc.getBase();
            String _name_4 = _base_4.getName();
            _builder.append((Object)_name_4, "");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t");
        DetailCode _userCode2 = dc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes = dc.getAttributes();
        CharSequence _attributes_1 = this.helpers.attributes((List)_attributes);
        _builder.append((Object)_attributes_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes_2 = dc.getAttributes();
        String _name_5 = dc.getName();
        CharSequence _attributeSettersGettersImplementation = this.helpers.attributeSettersGettersImplementation((List)_attributes_2, _name_5);
        _builder.append((Object)_attributeSettersGettersImplementation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _operations = dc.getOperations();
        String _name_6 = dc.getName();
        CharSequence _operationsDeclaration = this.helpers.operationsDeclaration((List)_operations, _name_6);
        _builder.append((Object)_operationsDeclaration, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// default constructor, copy constructor and assignment operator");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_7 = dc.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _name_8 = dc.getName();
        _builder.append((Object)_name_8, "\t");
        _builder.append((Object)"(const ");
        String _name_9 = dc.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append((Object)"& rhs);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// constructor using fields");
        _builder.newLine();
        _builder.append((Object)"\t");
        List _allAttributes = this._roomHelpers.getAllAttributes(dc);
        boolean _isEmpty = _allAttributes.isEmpty();
        boolean bl3 = _not = !_isEmpty;
        if (_not) {
            String _name_10 = dc.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)"(");
            List _allAttributes_1 = this._roomHelpers.getAllAttributes(dc);
            String _constArgList = this.helpers.constArgList(_allAttributes_1);
            _builder.append((Object)_constArgList, "\t");
            _builder.append((Object)");");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_11 = dc.getName();
        _builder.append((Object)_name_11, "\t");
        _builder.append((Object)"& operator=(const ");
        String _name_12 = dc.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)"& rhs);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd((RoomClass)dc, "");
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of DataClass ");
        String _name = dc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)dc);
        _builder.append((Object)_cppHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"etUnit/etUnit.h\"");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DetailCode _userCode3 = dc.getUserCode3();
        CharSequence _userCode = this.helpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"// default constructor");
        _builder.newLine();
        String _name_1 = dc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"::");
        String _name_2 = dc.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"()");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateDefaultInitalizerList = this.generateDefaultInitalizerList(dc);
        _builder.append((Object)_generateDefaultInitalizerList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _attributes = dc.getAttributes();
        CharSequence _genExtraInitializers = this.initHelper.genExtraInitializers((Iterable<Attribute>)_attributes);
        _builder.append((Object)_genExtraInitializers, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _userStructorBody = this.helpers.userStructorBody((RoomClass)dc, true);
        _builder.append((Object)_userStructorBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// copy constructor");
        _builder.newLine();
        String _name_3 = dc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"::");
        String _name_4 = dc.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"(const ");
        String _name_5 = dc.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)"& rhs)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateCopyInitalizerList = this.generateCopyInitalizerList(dc);
        _builder.append((Object)_generateCopyInitalizerList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// constructor using fields");
        _builder.newLine();
        _builder.append((Object)"// TODO");
        _builder.newLine();
        List _allAttributes = this._roomHelpers.getAllAttributes(dc);
        boolean _isEmpty = _allAttributes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _name_6 = dc.getName();
            _builder.append((Object)_name_6, "");
            _builder.append((Object)"::");
            String _name_7 = dc.getName();
            _builder.append((Object)_name_7, "");
            _builder.append((Object)"(");
            List _allAttributes_1 = this._roomHelpers.getAllAttributes(dc);
            String _constArgList = this.helpers.constArgList(_allAttributes_1);
            _builder.append((Object)_constArgList, "");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _generateFieldInitializerList = this.generateFieldInitializerList(dc);
            _builder.append((Object)_generateFieldInitializerList, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"// assignment operator");
        _builder.newLine();
        String _name_8 = dc.getName();
        _builder.append((Object)_name_8, "");
        _builder.append((Object)"& ");
        String _name_9 = dc.getName();
        _builder.append((Object)_name_9, "");
        _builder.append((Object)"::operator=(const ");
        String _name_10 = dc.getName();
        _builder.append((Object)_name_10, "");
        _builder.append((Object)"& rhs)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (this == &rhs) { return *this; };");
        _builder.newLine();
        _builder.append((Object)"\t");
        DataClass _base = dc.getBase();
        boolean bl2 = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            DataClass _base_1 = dc.getBase();
            String _name_11 = _base_1.getName();
            _builder.append((Object)_name_11, "\t");
            _builder.append((Object)"::operator=(rhs);");
        }
        _builder.newLineIfNotEmpty();
        EList _attributes_1 = dc.getAttributes();
        for (Attribute attr : _attributes_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"this->");
            String _name_12 = attr.getName();
            _builder.append((Object)_name_12, "\t");
            _builder.append((Object)" = rhs.");
            String _name_13 = attr.getName();
            _builder.append((Object)_name_13, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return *this;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList _operations = dc.getOperations();
        String _name_14 = dc.getName();
        CharSequence _operationsImplementation = this.helpers.operationsImplementation((List)_operations, _name_14);
        _builder.append((Object)_operationsImplementation, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateDefaultInitalizerList(DataClass dataClass) {
        boolean _notEquals;
        CharSequence _xblockexpression = null;
        final Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        DataClass _base = dataClass.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            DataClass _base_1 = dataClass.getBase();
            String _name = _base_1.getName();
            String _plus = String.valueOf(_name) + "()";
            initList.add(_plus);
        }
        EList _attributes = dataClass.getAttributes();
        Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(");
                String _initializerListValue = initHelper.getInitializerListValue(it);
                _builder.append((Object)_initializerListValue, "");
                _builder.append((Object)")");
                return _builder.toString();
            }
        };
        List _map = ListExtensions.map((List)_attributes, (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    private CharSequence generateCopyInitalizerList(DataClass dataClass) {
        boolean _notEquals;
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        DataClass _base = dataClass.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            DataClass _base_1 = dataClass.getBase();
            String _name = _base_1.getName();
            String _plus = String.valueOf(_name) + "(rhs)";
            initList.add(_plus);
        }
        EList _attributes = dataClass.getAttributes();
        Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(rhs.");
                String _name_1 = it.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)")");
                return _builder.toString();
            }
        };
        List _map = ListExtensions.map((List)_attributes, (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    private CharSequence generateFieldInitializerList(DataClass dataClass) {
        boolean _notEquals;
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        DataClass _base = dataClass.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            DataClass _base_1 = dataClass.getBase();
            String _name = _base_1.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"(");
            DataClass _base_2 = dataClass.getBase();
            List _allAttributes = this._roomHelpers.getAllAttributes(_base_2);
            Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

                public String apply(Attribute it) {
                    return it.getName();
                }
            };
            List _map = ListExtensions.map((List)_allAttributes, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
            _builder.append((Object)_join, "");
            _builder.append((Object)")");
            initList.add(_builder.toString());
        }
        EList _attributes = dataClass.getAttributes();
        Functions.Function1<Attribute, String> _function_1 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(");
                String _name_1 = it.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)")");
                return _builder.toString();
            }
        };
        List _map_1 = ListExtensions.map((List)_attributes, (Functions.Function1)_function_1);
        Iterables.addAll((Collection)initList, (Iterable)_map_1);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    public String deepCopy(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (!Objects.equal((Object)dc, null)) {
            DataClass _base;
            String _plus;
            EList _attributes = dc.getAttributes();
            CharSequence _deepCopy = this.deepCopy((List<Attribute>)_attributes);
            String _string = _deepCopy.toString();
            result = _plus = String.valueOf(_string) + result;
            dc = _base = dc.getBase();
        }
        return result;
    }

    public CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        for (Attribute a : attributes) {
            boolean _equals_1;
            RefableType _type = a.getType();
            DataType _type_1 = _type.getType();
            if (_type_1 instanceof ComplexType) {
                boolean _equals;
                _builder.append((Object)"if (");
                String _name = a.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"!=null) {");
                _builder.newLineIfNotEmpty();
                int _size = a.getSize();
                boolean bl = _equals = _size == 0;
                if (_equals) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"copy.");
                    String _name_1 = a.getName();
                    _builder.append((Object)_name_1, "\t");
                    _builder.append((Object)" = ");
                    String _name_2 = a.getName();
                    _builder.append((Object)_name_2, "\t");
                    _builder.append((Object)".deepCopy();");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for (int i=0;i<");
                    String _name_3 = a.getName();
                    _builder.append((Object)_name_3, "\t");
                    _builder.append((Object)".length;i++){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"copy.");
                    String _name_4 = a.getName();
                    _builder.append((Object)_name_4, "\t\t");
                    _builder.append((Object)"[i] = ");
                    String _name_5 = a.getName();
                    _builder.append((Object)_name_5, "\t\t");
                    _builder.append((Object)"[i].deepCopy();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
                continue;
            }
            int _size_1 = a.getSize();
            boolean bl = _equals_1 = _size_1 == 0;
            if (_equals_1) {
                _builder.append((Object)"copy.");
                String _name_6 = a.getName();
                _builder.append((Object)_name_6, "");
                _builder.append((Object)" = ");
                String _name_7 = a.getName();
                _builder.append((Object)_name_7, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"for (int i=0;i<");
            String _name_8 = a.getName();
            _builder.append((Object)_name_8, "");
            _builder.append((Object)".length;i++){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"copy.");
            String _name_9 = a.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)"[i] = ");
            String _name_10 = a.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)"[i];");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }
}

