/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.converter.TimeConverter;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeClass;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredSubSystemClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.fsm.base.Indexed;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    private Initialization initHelper;

    public void doGenerate(Root root) {
        final HashMap sscc2wired = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        EList _wiredInstances = root.getWiredInstances();
        Iterable _filter = Iterables.filter((Iterable)_wiredInstances, WiredSubSystemClass.class);
        Procedures.Procedure1<WiredSubSystemClass> _function = new Procedures.Procedure1<WiredSubSystemClass>(){

            public void apply(WiredSubSystemClass it) {
                SubSystemClass _subSystemClass = it.getSubSystemClass();
                sscc2wired.put(_subSystemClass, it);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function);
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (Objects.equal((Object)ssi, null) || !this._fileSystemHelpers.isValidGenerationLocation((EObject)ssi.getSubSystemClass())) continue;
                SubSystemClass _subSystemClass = ssi.getSubSystemClass();
                WiredSubSystemClass wired = (WiredSubSystemClass)sscc2wired.get(_subSystemClass);
                SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
                String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass_1);
                SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
                String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_2);
                String path = String.valueOf(_generationTargetPath) + _path;
                SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
                String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)_subSystemClass_3);
                SubSystemClass _subSystemClass_4 = ssi.getSubSystemClass();
                String _path_1 = this._roomExtensions.getPath((RoomClass)_subSystemClass_4);
                String infopath = String.valueOf(_generationInfoPath) + _path_1;
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName(nr, ssi);
                CharSequence _generateHeaderFile = this.generateHeaderFile(root, ssi, wired, usedThreads);
                this.fileIO.generateFile("generating Node declaration", path, infopath, _cppHeaderFileName, _generateHeaderFile);
                String _cppSourceFileName = this._cppExtensions.getCppSourceFileName(nr, ssi);
                CharSequence _generateSourceFile = this.generateSourceFile(root, ssi, wired, usedThreads);
                this.fileIO.generateFile("generating Node implementation", path, infopath, _cppSourceFileName, _generateSourceFile);
            }
        }
    }

    public CharSequence generateHeaderFile(Root root, SubSystemInstance comp, WiredSubSystemClass wired, final Collection<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = comp.getSubSystemClass();
        EList models = root.getReferencedModels((RoomClass)cc);
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._cppExtensions.getCppClassName(nr, comp);
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of SubSystemClass ");
        _builder.append((Object)clsname, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin((RoomClass)cc, "");
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/IMessageService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/SubSystemClassBase.h\"");
        _builder.newLine();
        EList _actorInstances = comp.getActorInstances();
        for (ActorInstance ai : _actorInstances) {
            _builder.append((Object)"#include \"");
            ActorClass _actorClass = ai.getActorClass();
            String _actorIncludePath = this._cppExtensions.getActorIncludePath(_actorClass);
            _builder.append((Object)_actorIncludePath, "");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        DetailCode _userCode1 = cc.getUserCode1();
        CharSequence _userCode = this._procedureHelpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" : public etRuntime::SubSystemClassBase{");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        DetailCode _userCode2 = cc.getUserCode2();
        CharSequence _userCode_1 = this._procedureHelpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public:");
        _builder.newLine();
        Iterable _indexed = Indexed.indexed((Iterable)threads);
        for (Indexed thread : _indexed) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"static const int ");
            PhysicalThread _value = (PhysicalThread)thread.getValue();
            String _threadId = this.getThreadId(_value);
            _builder.append((Object)_threadId, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// sub actors");
        _builder.newLine();
        EList _actorRefs = cc.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl = _greaterThan = _multiplicity > 1;
            if (_greaterThan) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Replicated");
                ActorClass _type_1 = sub.getType();
                String _implementationClassName = this._cppExtensions.getImplementationClassName(_type_1);
                _builder.append((Object)_implementationClassName, "\t\t");
                _builder.append((Object)" ");
                String _name = sub.getName();
                _builder.append((Object)_name, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            ActorClass _type_2 = sub.getType();
            String _implementationClassName_1 = this._cppExtensions.getImplementationClassName(_type_2);
            _builder.append((Object)_implementationClassName_1, "\t\t");
            _builder.append((Object)" ");
            String _name_1 = sub.getName();
            _builder.append((Object)_name_1, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)"(IRTObject* parent, const String& name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"~");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual void instantiateMessageServices();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual void mapThreads(void);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual void initialize(void);");
        _builder.newLine();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"virtual void setProbesActive(bool recursive, bool active);");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual void init();");
        _builder.newLine();
        _builder.newLine();
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_1 = _settings_1.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"etBool hasGeneratedMSCInstrumentation() const { return true; }");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"virtual void destroy();");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// MessageServices");
        _builder.newLine();
        for (PhysicalThread thread_1 : threads) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"IMessageService* msgSvc_");
            String _name_2 = thread_1.getName();
            _builder.append((Object)_name_2, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)"(");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)" const&);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)"& operator=(");
        _builder.append((Object)clsname, "\t\t");
        _builder.append((Object)" const&);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd((RoomClass)cc, "");
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getThreadId(PhysicalThread thread) {
        String _name = thread.getName();
        String _upperCase = _name.toUpperCase();
        return "THREAD_" + _upperCase;
    }

    private CharSequence generateConstructorInitalizerList(SubSystemClass cc) {
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"SubSystemClassBase(parent, name)");
        initList.add(_builder.toString());
        EList _actorRefs = cc.getActorRefs();
        Functions.Function1<ActorRef, String> _function = new Functions.Function1<ActorRef, String>(){

            public String apply(ActorRef it) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = it.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"(this, \"");
                String _name_1 = it.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)"\")");
                return _builder.toString();
            }
        };
        List _map = ListExtensions.map((List)_actorRefs, (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance comp, WiredSubSystemClass wired, final Collection<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = comp.getSubSystemClass();
        EList models = root.getReferencedModels((RoomClass)cc);
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._cppExtensions.getCppClassName(nr, comp);
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of SubsystemClass ");
        _builder.append((Object)clsname, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName(nr, comp);
        _builder.append((Object)_cppHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/debugging/MSCFunctionObject.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/IMessageService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/MessageService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/MessageServiceController.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/RTServices.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/StaticMessageMemory.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Iterable _indexed = Indexed.indexed((Iterable)threads);
        for (Indexed thread : _indexed) {
            _builder.append((Object)"const int ");
            _builder.append((Object)clsname, "");
            _builder.append((Object)"::");
            PhysicalThread _value = (PhysicalThread)thread.getValue();
            String _threadId = this.getThreadId(_value);
            _builder.append((Object)_threadId, "");
            _builder.append((Object)" = ");
            int _index0 = thread.getIndex0();
            _builder.append((Object)_index0, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"(IRTObject* parent, const String& name)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        CharSequence _generateConstructorInitalizerList = this.generateConstructorInitalizerList(cc);
        _builder.append((Object)_generateConstructorInitalizerList, "\t\t");
        _builder.newLineIfNotEmpty();
        for (PhysicalThread thread_1 : threads) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)", msgSvc_");
            String _name = thread_1.getName();
            _builder.append((Object)_name, "\t\t");
            _builder.append((Object)"(NULL)");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"{");
        _builder.newLine();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder.append((Object)"\t");
            _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Constructor\");");
            _builder.newLine();
        }
        EList _actorRefs = cc.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl = _greaterThan = _multiplicity > 1;
            if (!_greaterThan) continue;
            _builder.append((Object)"\t");
            String _name_1 = sub.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)".createSubActors(");
            int _multiplicity_1 = sub.getMultiplicity();
            _builder.append((Object)_multiplicity_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::~");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_1 = _settings_1.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Destructor\");");
            _builder.newLine();
        }
        for (PhysicalThread thread_2 : threads) {
            _builder.append((Object)"\t");
            _builder.append((Object)"delete msgSvc_");
            String _name_2 = thread_2.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::receiveEvent(InterfaceItemBase* ifitem, int evt, void* data){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::instantiateMessageServices(){");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        GlobalGeneratorSettings _settings_2 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_2 = _settings_2.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"instantiateMessageServices()\");");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"IMessageMemory* msgMemory;");
        _builder.newLine();
        Functions.Function1<PhysicalThread, Long> _function_1 = new Functions.Function1<PhysicalThread, Long>(){

            public Long apply(PhysicalThread it) {
                long _prio = it.getPrio();
                return -_prio;
            }
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)_function_1);
        for (Object thread_3 : _sortBy) {
            _builder.append((Object)"\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"msgMemory = new StaticMessageMemory(this, \"MessageMemory_");
            String _name_3 = thread_3.getName();
            _builder.append((Object)_name_3, "\t\t");
            _builder.append((Object)"\", ");
            int _msgblocksize = thread_3.getMsgblocksize();
            _builder.append((Object)_msgblocksize, "\t\t");
            _builder.append((Object)", ");
            int _msgpoolsize = thread_3.getMsgpoolsize();
            _builder.append((Object)_msgpoolsize, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            if (Objects.equal((Object)thread_3.getExecmode(), (Object)ExecMode.POLLED) || Objects.equal((Object)thread_3.getExecmode(), (Object)ExecMode.MIXED)) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"etTime interval;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"interval.sec = ");
                long _time = thread_3.getTime();
                long _split = TimeConverter.split((long)_time, (String)"s", (boolean)true);
                _builder.append((Object)_split, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"interval.nSec = ");
                long _time_1 = thread_3.getTime();
                long _split_1 = TimeConverter.split((long)_time_1, (String)"ms", (boolean)false);
                _builder.append((Object)_split_1, "\t\t");
                _builder.append((Object)"L;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"msgSvc_");
                String _name_4 = thread_3.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)" = new MessageService(this, IMessageService::");
                ExecMode _execmode = thread_3.getExecmode();
                String _name_5 = _execmode.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)", interval, 0, ");
                String _threadId_1 = this.getThreadId((PhysicalThread)thread_3);
                _builder.append((Object)_threadId_1, "\t\t");
                _builder.append((Object)", \"MessageService_");
                String _name_6 = thread_3.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)"\", msgMemory, ");
                long _prio = thread_3.getPrio();
                _builder.append((Object)_prio, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"msgSvc_");
                String _name_7 = thread_3.getName();
                _builder.append((Object)_name_7, "\t\t");
                _builder.append((Object)" = new MessageService(this, IMessageService::");
                ExecMode _execmode_1 = thread_3.getExecmode();
                String _name_8 = _execmode_1.getName();
                _builder.append((Object)_name_8, "\t\t");
                _builder.append((Object)", 0, ");
                String _threadId_2 = this.getThreadId((PhysicalThread)thread_3);
                _builder.append((Object)_threadId_2, "\t\t");
                _builder.append((Object)", \"MessageService_");
                String _name_9 = thread_3.getName();
                _builder.append((Object)_name_9, "\t\t");
                _builder.append((Object)"\", msgMemory, ");
                long _prio_1 = thread_3.getPrio();
                _builder.append((Object)_prio_1, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"RTServices::getInstance().getMsgSvcCtrl().addMsgSvc(*msgSvc_");
            String _name_10 = thread_3.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::mapThreads() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// thread mappings");
        _builder.newLine();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            boolean _not;
            _builder.append((Object)"\t");
            ETMapUtil.MappedThread mapped = ETMapUtil.getMappedThread((AbstractInstance)ai);
            _builder.newLineIfNotEmpty();
            boolean bl = _not = !mapped.isImplicit() && !mapped.isAsParent();
            if (!_not) continue;
            _builder.append((Object)"\t");
            _builder.append((Object)"addPathToThread(\"");
            String _path = ai.getPath();
            _builder.append((Object)_path, "\t");
            _builder.append((Object)"\", ");
            PhysicalThread _thread = mapped.getThread();
            String _threadId_3 = this.getThreadId(_thread);
            _builder.append((Object)_threadId_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::initialize() {");
        _builder.newLineIfNotEmpty();
        GlobalGeneratorSettings _settings_3 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_3 = _settings_3.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_3) {
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService::getInstance().getSyncLogger().addVisibleComment(\"starting initialization\");");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"initialize()\");");
            _builder.newLine();
            EList _actorRefs_1 = cc.getActorRefs();
            Iterator _not = _actorRefs_1.iterator();
            while (_not.hasNext()) {
                boolean _greaterThan_1;
                ActorRef sub_1 = (ActorRef)_not.next();
                int _multiplicity_2 = sub_1.getMultiplicity();
                boolean bl = _greaterThan_1 = _multiplicity_2 > 1;
                if (_greaterThan_1) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for (int i=0; i<");
                    int _multiplicity_3 = sub_1.getMultiplicity();
                    _builder.append((Object)_multiplicity_3, "\t");
                    _builder.append((Object)"; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"DebuggingService::getInstance().addMessageActorCreate(*this, ");
                    String _name_11 = sub_1.getName();
                    _builder.append((Object)_name_11, "\t\t");
                    _builder.append((Object)".getSubActor(i)->getName());");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService::getInstance().addMessageActorCreate(*this, \"");
                String _name_12 = sub_1.getName();
                _builder.append((Object)_name_12, "\t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// wiring");
        _builder.newLine();
        EList _wires = wired.getWires();
        for (Wire wire : _wires) {
            _builder.append((Object)"\t");
            String _xifexpression = null;
            boolean _isDataDriven = wire.isDataDriven();
            _xifexpression = _isDataDriven ? "DataPortBase" : "InterfaceItemBase";
            _builder.append((Object)_xifexpression, "\t");
            _builder.append((Object)"::connect(this, \"");
            EList _path1 = wire.getPath1();
            String _join = IterableExtensions.join((Iterable)_path1, (CharSequence)"/");
            _builder.append((Object)_join, "\t");
            _builder.append((Object)"\", \"");
            EList _path2 = wire.getPath2();
            String _join_1 = IterableExtensions.join((Iterable)_path2, (CharSequence)"/");
            _builder.append((Object)_join_1, "\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// call initialize of sub actors");
        _builder.newLine();
        EList _actorRefs_2 = cc.getActorRefs();
        for (ActorRef sub_2 : _actorRefs_2) {
            _builder.append((Object)"\t");
            String _name_13 = sub_2.getName();
            _builder.append((Object)_name_13, "\t");
            _builder.append((Object)".initialize();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        GlobalGeneratorSettings _settings_4 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_4 = _settings_4.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_4) {
            _builder.append((Object)"void ");
            _builder.append((Object)clsname, "");
            _builder.append((Object)"::setProbesActive(bool recursive, bool active) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"for(int i = 0; i < m_RTSystemPort.getNInterfaceItems(); i++)");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"DebuggingService::getInstance().addPortInstance(*(m_RTSystemPort.getInterfaceItem(i)));");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if(recursive) {");
            _builder.newLine();
            EList _actorRefs_3 = cc.getActorRefs();
            for (ActorRef sub_3 : _actorRefs_3) {
                _builder.append((Object)"\t\t");
                String _name_14 = sub_3.getName();
                _builder.append((Object)_name_14, "\t\t");
                _builder.append((Object)".setProbesActive(recursive, active);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"::init(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"SubSystemClassBase::init();");
        _builder.newLine();
        GlobalGeneratorSettings _settings_5 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_5 = _settings_5.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_5) {
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService::getInstance().addVisibleComment(\"done sub system initialization\");");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        GlobalGeneratorSettings _settings_6 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_6 = _settings_6.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_6) {
            _builder.newLine();
            _builder.append((Object)"void ");
            _builder.append((Object)clsname, "");
            _builder.append((Object)"::destroy() {");
            _builder.newLineIfNotEmpty();
            GlobalGeneratorSettings _settings_7 = Main.getSettings();
            boolean _isGenerateMSCInstrumentation_7 = _settings_7.isGenerateMSCInstrumentation();
            if (_isGenerateMSCInstrumentation_7) {
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService::getInstance().getSyncLogger().addVisibleComment(\"starting destruction\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"MSCFunctionObject mscFunctionObject(getInstancePathName(), \"destroy()\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService::getInstance().addVisibleComment(\"begin sub system destruction\");");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"SubSystemClassBase::destroy();");
            _builder.newLine();
            GlobalGeneratorSettings _settings_8 = Main.getSettings();
            boolean _isGenerateMSCInstrumentation_8 = _settings_8.isGenerateMSCInstrumentation();
            if (_isGenerateMSCInstrumentation_8) {
                _builder.append((Object)"\t");
                _builder.append((Object)"DebuggingService::getInstance().addVisibleComment(\"done sub system destruction\");");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

