/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private IGeneratorFileIo fileIO;

    public void doGenerate(Root root) {
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (Objects.equal((Object)ssi, null) || !this._fileSystemHelpers.isValidGenerationLocation((EObject)ssi.getSubSystemClass())) continue;
                SubSystemClass _subSystemClass = ssi.getSubSystemClass();
                String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)_subSystemClass);
                SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
                String _path = this.roomExt.getPath((RoomClass)_subSystemClass_1);
                String filepath = String.valueOf(_generationTargetPath) + _path;
                SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
                String _generationInfoPath = this.roomExt.getGenerationInfoPath((EObject)_subSystemClass_2);
                SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
                String _path_1 = this.roomExt.getPath((RoomClass)_subSystemClass_3);
                String infopath = String.valueOf(_generationInfoPath) + _path_1;
                String _cppClassName = this._cppExtensions.getCppClassName(nr, ssi);
                String _plus = String.valueOf(_cppClassName) + "Runner.h";
                CharSequence _generateHeaderFile = this.generateHeaderFile(root, ssi);
                this.fileIO.generateFile("generating SubSystemRunner declaration", filepath, infopath, _plus, _generateHeaderFile);
                String _cppClassName_1 = this._cppExtensions.getCppClassName(nr, ssi);
                String _plus_1 = String.valueOf(_cppClassName_1) + "Runner.cpp";
                CharSequence _generateSourceFile = this.generateSourceFile(root, ssi);
                this.fileIO.generateFile("generating SubSystemRunner implementation", filepath, infopath, _plus_1, _generateSourceFile);
            }
        }
    }

    public CharSequence generateHeaderFile(Root root, SubSystemInstance ssc) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._cppExtensions.getCppClassName(nr, ssc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* this class contains the main function running component ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* it instantiates ");
        String _name_1 = ssc.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin((RoomClass)cc, "Runner");
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/SubSystemRunnerBase.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)(String.valueOf(clsname) + "Runner"), "");
        _builder.append((Object)" : public etRuntime::SubSystemRunnerBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd((RoomClass)cc, "Runner");
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssc) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._cppExtensions.getCppClassName(nr, ssc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* this class contains the main function running component ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* it instantiates ");
        String _name_1 = ssc.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"Runner.h\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        _builder.append((Object)clsname, "");
        _builder.append((Object)".h\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#include \"common/modelbase/RTSystem.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/containers/String.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/containers/Vector.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/containers/Set.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/containers/Map.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        GlobalGeneratorSettings _settings = Main.getSettings();
        String _mainMethodName = _settings.getMainMethodName();
        _builder.append((Object)_mainMethodName, " ");
        _builder.append((Object)" function");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* creates components and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"int ");
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        String _mainMethodName_1 = _settings_1.getMainMethodName();
        _builder.append((Object)_mainMethodName_1, "");
        _builder.append((Object)"(int argc, char* argv[]) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// instantiate the main component");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"RTSystem* sys = ");
        EObject _eContainer = ssc.eContainer();
        if (_eContainer instanceof SystemInstance) {
            _builder.append((Object)"new RTSystem(\"");
            EObject _eContainer_1 = ssc.eContainer();
            String _name_2 = ((SystemInstance)_eContainer_1).getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"\")");
        } else {
            _builder.append((Object)"0");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"* main_component = new ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"(sys, \"");
        String _name_3 = ssc.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Runner::run(*main_component, argc, argv);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//delete sys;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"printf(\"String allocations %d and deallocations %d\\n\", etRuntime::String::getNAllocations(), etRuntime::String::getNDeallocations());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"printf(\"String creations %d and destructions %d\\n\", etRuntime::String::getNCreated(), etRuntime::String::getNDestroyed());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"printf(\"Vector allocations %d and deallocations %d\\n\", etRuntime::VectorStats::getNAllocations(), etRuntime::VectorStats::getNDeallocations());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"printf(\"Vector creations %d and destructions %d\\n\", etRuntime::VectorStats::getNCreated(), etRuntime::VectorStats::getNDestroyed());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"printf(\"Set creations %d and destructions %d\\n\", etRuntime::SetStats::getNCreated(), etRuntime::SetStats::getNDestroyed());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"printf(\"Map creations %d and destructions %d\\n\", etRuntime::MapStats::getNCreated(), etRuntime::MapStats::getNDestroyed());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"fflush(stdout);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return 0;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

