/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private Initialization initHelper;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedProtocolClasses = root.getUsedProtocolClasses();
        Functions.Function1<ProtocolClass, Boolean> _function = new Functions.Function1<ProtocolClass, Boolean>(){

            public Boolean apply(ProtocolClass cl) {
                return ProtocolClassGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)cl);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_usedProtocolClasses, (Functions.Function1)_function);
        for (ProtocolClass pc : _filter) {
            String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)pc);
            String _path = this.roomExt.getPath((RoomClass)pc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _generationInfoPath = this.roomExt.getGenerationInfoPath((EObject)pc);
            String _path_1 = this.roomExt.getPath((RoomClass)pc);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            CommunicationType _commType = pc.getCommType();
            if (_commType == null) continue;
            switch (_commType) {
                case EVENT_DRIVEN: {
                    String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
                    CharSequence _generateHeaderFile = this.generateHeaderFile(root, pc);
                    this.fileIO.generateFile("generating ProtocolClass declaration", path, infopath, _cppHeaderFileName, _generateHeaderFile);
                    String _cppSourceFileName = this.stdExt.getCppSourceFileName((RoomClass)pc);
                    CharSequence _generateSourceFile = this.generateSourceFile(root, pc);
                    this.fileIO.generateFile("generating ProtocolClass implementation", path, infopath, _cppSourceFileName, _generateSourceFile);
                    break;
                }
                case DATA_DRIVEN: {
                    String _cppHeaderFileName_1 = this.stdExt.getCppHeaderFileName((RoomClass)pc);
                    CharSequence _generateDataDrivenHeaderFile = this.generateDataDrivenHeaderFile(root, pc);
                    this.fileIO.generateFile("generating ProtocolClass declaration", path, infopath, _cppHeaderFileName_1, _generateDataDrivenHeaderFile);
                    String _cppSourceFileName_1 = this.stdExt.getCppSourceFileName((RoomClass)pc);
                    CharSequence _generateDataDrivenSourceFile = this.generateDataDrivenSourceFile(root, pc);
                    this.fileIO.generateFile("generating ProtocolClass implementation", path, infopath, _cppSourceFileName_1, _generateDataDrivenSourceFile);
                    break;
                }
                case SYNCHRONOUS: {
                    this.logger.logError("synchronous protocols not supported yet", (EObject)pc);
                    break;
                }
            }
        }
    }

    protected CharSequence generateHeaderFile(Root root, ProtocolClass pc) {
        boolean _equals_1;
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/PortBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/ReplicatedInterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/ReplicatedPortBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)pc);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _path = this.roomExt.getPath((RoomClass)dataClass);
            _builder.append((Object)_path, "");
            String _name_1 = dataClass.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        DetailCode _userCode1 = pc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_2 = pc.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"   ");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* message IDs */");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append((Object)_genMessageIDs, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _userCode_1 = this.helpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"static bool isValidEvtID(int evtId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return ((MSG_MIN < evtId) && (evtId < MSG_MAX));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"static bool isValidOutgoingEvtID(int evtId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return ((MSG_MIN < evtId) && (evtId < ");
        EList _incomingMessages = pc.getIncomingMessages();
        int _size = _incomingMessages.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            _builder.append((Object)"MSG_MAX");
        } else {
            _builder.append((Object)"IN_");
            EList _incomingMessages_1 = pc.getIncomingMessages();
            Message _get = (Message)_incomingMessages_1.get(0);
            String _name_3 = _get.getName();
            _builder.append((Object)_name_3, "\t\t\t");
        }
        _builder.append((Object)"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"static bool isValidIncomingEvtID(int evtId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return ((");
        EList _incomingMessages_2 = pc.getIncomingMessages();
        int _size_1 = _incomingMessages_2.size();
        boolean bl2 = _equals_1 = _size_1 == 0;
        if (_equals_1) {
            _builder.append((Object)"MSG_MAX");
        } else {
            _builder.append((Object)"IN_");
            EList _incomingMessages_3 = pc.getIncomingMessages();
            Message _get_1 = (Message)_incomingMessages_3.get(0);
            String _name_4 = _get_1.getName();
            _builder.append((Object)_name_4, "\t\t\t");
        }
        _builder.append((Object)" <= evtId) && (evtId < MSG_MAX));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"static const etRuntime::String& getMessageString(int msg_id);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"static const etRuntime::String s_messageStrings[];");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        CharSequence _portClassDeclaration = this.portClassDeclaration(pc, false);
        _builder.append((Object)_portClassDeclaration, "");
        _builder.newLineIfNotEmpty();
        CharSequence _portClassDeclaration_1 = this.portClassDeclaration(pc, true);
        _builder.append((Object)_portClassDeclaration_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence portClassDeclaration(ProtocolClass pc, boolean conj) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj);
        String portClassName = this.roomExt.getPortClassName(pc, conj);
        String replPortClassName = this.roomExt.getPortClassName(pc, conj, true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)" : public etRuntime::PortBase {");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)pclass, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _userCode = pclass.getUserCode();
            CharSequence _userCode_1 = this.helpers.userCode(_userCode);
            _builder.append((Object)_userCode_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"   ");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)portClassName, "\t ");
        _builder.append((Object)"(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)portClassName, "\t ");
        _builder.append((Object)"(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId, int idx);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder.append((Object)"\t");
            _builder.append((Object)"virtual void destroy();");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"virtual void receive(const etRuntime::Message* m);");
        _builder.newLine();
        _builder.newLine();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pclass, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            EList _attributes = pclass.getAttributes();
            CharSequence _attributes_1 = this.helpers.attributes((List)_attributes);
            _builder.append((Object)_attributes_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList _operations = pclass.getOperations();
            CharSequence _operationsDeclaration = this.helpers.operationsDeclaration((List)_operations, portClassName);
            _builder.append((Object)_operationsDeclaration, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"// sent messages");
        _builder.newLine();
        List _allMessages = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : _allMessages) {
            _builder.append((Object)"\t");
            CharSequence _messageSignature = this.messageSignature(m, false);
            _builder.append((Object)_messageSignature, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _messageSignature_1 = this.messageSignature(m, true);
            _builder.append((Object)_messageSignature_1, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"replicated port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)" : public etRuntime::ReplicatedPortBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)replPortClassName, "\t\t");
        _builder.append((Object)"(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int getReplication() const { return getNInterfaceItems(); }");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int getIndexOf(const etRuntime::InterfaceItemBase& ifitem) const { return ifitem.getIdx(); }");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)portClassName, "\t\t");
        _builder.append((Object)"& get(int idx) const { return *dynamic_cast<");
        _builder.append((Object)portClassName, "\t\t");
        _builder.append((Object)"*>(getInterfaceItem(idx)); }");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (conj) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : _allIncomingMessages) {
                _builder.append((Object)"\t\t");
                CharSequence _messageSignature_2 = this.messageSignature(m_1, false);
                _builder.append((Object)_messageSignature_2, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : _allOutgoingMessages) {
                _builder.append((Object)"\t\t");
                CharSequence _messageSignature_3 = this.messageSignature(m_2, false);
                _builder.append((Object)_messageSignature_3, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual etRuntime::InterfaceItemBase* createInterfaceItem(etRuntime::IInterfaceItemOwner* rcv, const etRuntime::String& name, int lid, int idx) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return new ");
        _builder.append((Object)portClassName, "\t\t\t");
        _builder.append((Object)"(rcv, name, lid, idx);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
        _builder.append((Object)_cppHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/debugging/MSCFunctionObject.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/AbstractMessageReceiver.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/Address.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/Message.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/IEventReceiver.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(pc, 3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* message names as strings for debugging (generate MSC) */");
        _builder.newLine();
        _builder.append((Object)"const String ");
        String _name_1 = pc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"::s_messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append((Object)"\"");
            String _name_2 = m.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)" ");
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append((Object)"\"");
            String _name_3 = m_1.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)"\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"const String& ");
        String _name_4 = pc.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"::getMessageString(int msg_id) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if ((MSG_MIN < msg_id ) && ( msg_id < MSG_MAX )) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return s_messageStrings[msg_id];");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// id out of range");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"static const String errorMsg = \"Message ID out of range\";");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return errorMsg;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _portClassImplementation = this.portClassImplementation(pc, false);
        _builder.append((Object)_portClassImplementation, "");
        _builder.newLineIfNotEmpty();
        CharSequence _portClassImplementation_1 = this.portClassImplementation(pc, true);
        _builder.append((Object)_portClassImplementation_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence portClassImplementation(ProtocolClass pc, boolean conj) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj);
        String portClassName = this.roomExt.getPortClassName(pc, conj);
        String replPortClassName = this.roomExt.getPortClassName(pc, conj, true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"::");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"(IInterfaceItemOwner* actor, const String& name, int localId)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateConstructorInitalizerList = this.generateConstructorInitalizerList(pclass, "0");
        _builder.append((Object)_generateConstructorInitalizerList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"::");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"(IInterfaceItemOwner* actor, const String& name, int localId, int idx)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateConstructorInitalizerList_1 = this.generateConstructorInitalizerList(pclass, "idx");
        _builder.append((Object)_generateConstructorInitalizerList_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        boolean bl = _notEquals = !Objects.equal((Object)pclass, null);
        if (_notEquals) {
            EList _attributes = pclass.getAttributes();
            CharSequence _genExtraInitializers = this.initHelper.genExtraInitializers((Iterable<Attribute>)_attributes);
            _builder.append((Object)_genExtraInitializers, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder.newLine();
            _builder.append((Object)"void ");
            _builder.append((Object)portClassName, "");
            _builder.append((Object)"::destroy() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService::getInstance().removePortInstance(*this);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"PortBase::destroy();");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"::receive(const Message* msg) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// TODO JH further");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (! ");
        String _name = pc.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"::");
        if (conj) {
            _builder.append((Object)"isValidOutgoingEvtID");
        } else {
            _builder.append((Object)"isValidIncomingEvtID");
        }
        _builder.append((Object)"(msg->getEvtId())) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//std::cout << \"unknown\" << std::endl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        boolean _isGenerateMSCInstrumentation_1 = _settings_1.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService::getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), ");
            String _name_1 = pc.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)"::getMessageString(msg->getEvtId()).c_str());");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _handlesReceive = this.roomExt.handlesReceive(pc, conj);
        if (_handlesReceive) {
            _builder.append((Object)"\t");
            _builder.append((Object)"switch (msg->getEvtId()) {");
            _builder.newLine();
            List _receiveHandlers = this.roomExt.getReceiveHandlers(pc, conj);
            for (MessageHandler hdlr : _receiveHandlers) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"case ");
                String _name_2 = pc.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)"::");
                Message _msg = hdlr.getMsg();
                String _codeName = this.roomExt.getCodeName(_msg);
                _builder.append((Object)_codeName, "\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                DetailCode _detailCode = hdlr.getDetailCode();
                EList _lines = _detailCode.getLines();
                for (String command : _lines) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)command, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"default:");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"getActor()->receiveEvent(this, msg->getEvtId(),\tmsg->getData());");
        _builder.newLine();
        boolean _handlesReceive_1 = this.roomExt.handlesReceive(pc, conj);
        if (_handlesReceive_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pclass, null);
        if (_notEquals_1) {
            EList _operations = pclass.getOperations();
            CharSequence _operationsImplementation = this.helpers.operationsImplementation((List)_operations, portClassName);
            _builder.append((Object)_operationsImplementation, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"// sent messages");
        _builder.newLine();
        List _allMessages = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : _allMessages) {
            String _name_3 = pc.getName();
            CharSequence _sendMessage = this.sendMessage(m, _name_3, portClassName, conj);
            _builder.append((Object)_sendMessage, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"replicated port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"::");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"(IInterfaceItemOwner* actor, const String& name, int localId) :");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ReplicatedPortBase(actor, name, localId)");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        if (conj) {
            _builder.append((Object)"// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : _allIncomingMessages) {
                CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m_1, replPortClassName, false);
                _builder.append((Object)_messageSignatureDefinition, "");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (Vector<etRuntime::InterfaceItemBase*>::iterator it = getItems().begin(); it != getItems().end(); ++it) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"(dynamic_cast<");
                _builder.append((Object)portClassName, "\t\t");
                _builder.append((Object)"*>(*it))->");
                CharSequence _messageCall = this.messageCall(m_1, false);
                _builder.append((Object)_messageCall, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        } else {
            _builder.append((Object)"// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : _allOutgoingMessages) {
                CharSequence _messageSignatureDefinition_1 = this.messageSignatureDefinition(m_2, replPortClassName, false);
                _builder.append((Object)_messageSignatureDefinition_1, "");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (Vector<etRuntime::InterfaceItemBase*>::iterator it = getItems().begin(); it != getItems().end(); ++it) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"(dynamic_cast<");
                _builder.append((Object)portClassName, "\t\t");
                _builder.append((Object)"*>(*it))->");
                CharSequence _messageCall_1 = this.messageCall(m_2, false);
                _builder.append((Object)_messageCall_1, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateConstructorInitalizerList(PortClass pc, String index) {
        boolean _notEquals;
        CharSequence _xblockexpression = null;
        final Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"PortBase(actor, name, localId, ");
        _builder.append((Object)index, "");
        _builder.append((Object)")");
        initList.add(_builder.toString());
        boolean bl = _notEquals = !Objects.equal((Object)pc, null);
        if (_notEquals) {
            EList _attributes = pc.getAttributes();
            Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

                public String apply(Attribute it) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _name = it.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)"(");
                    String _initializerListValue = initHelper.getInitializerListValue(it);
                    _builder.append((Object)_initializerListValue, "");
                    _builder.append((Object)")");
                    return _builder.toString();
                }
            };
            List _map = ListExtensions.map((List)_attributes, (Functions.Function1)_function);
            Iterables.addAll((Collection)initList, (Iterable)_map);
        }
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    protected CharSequence messageCall(Message m, boolean impl) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append((Object)_name, "");
        if (impl) {
            _builder.append((Object)"_impl");
        }
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            _builder.append((Object)" ");
            VarDecl _data_1 = m.getData();
            String _name_1 = _data_1.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence messageSignature(Message m, boolean impl) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        if (m.isPriv() || impl) {
            _builder.append((Object)"private:");
        } else {
            _builder.append((Object)"public:");
        }
        _builder.append((Object)" void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        if (impl) {
            _builder.append((Object)"_impl");
        }
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            VarDecl _data_1 = m.getData();
            RefableType _refType = _data_1.getRefType();
            String _signatureString = this.helpers.signatureString(_refType);
            _builder.append((Object)_signatureString, "");
            _builder.append((Object)" ");
            VarDecl _data_2 = m.getData();
            String _name_1 = _data_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence messageSignatureDefinition(Message m, String classPrefix, boolean impl) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"void ");
        _builder.append((Object)classPrefix, "");
        _builder.append((Object)"::");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        if (impl) {
            _builder.append((Object)"_impl");
        }
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            VarDecl _data_1 = m.getData();
            RefableType _refType = _data_1.getRefType();
            String _signatureString = this.helpers.signatureString(_refType);
            _builder.append((Object)_signatureString, "");
            _builder.append((Object)" ");
            VarDecl _data_2 = m.getData();
            String _name_1 = _data_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence sendMessage(Message m, String portClassName, String classPrefix, boolean conj) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = conj ? "IN" : "OUT";
        String dir = _xifexpression;
        MessageHandler hdlr = this.roomExt.getSendHandler(m, conj);
        String _xifexpression_1 = null;
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)", ");
            VarDecl _data_1 = m.getData();
            String _name = _data_1.getName();
            _builder.append((Object)_name, "");
            _xifexpression_1 = _builder.toString();
        }
        String dataArg = _xifexpression_1;
        String _xifexpression_2 = null;
        if (!Objects.equal((Object)m.getData(), null) && !m.getData().getRefType().isRef()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"DataMessage<");
            VarDecl _data_2 = m.getData();
            RefableType _refType = _data_2.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)">");
            _xifexpression_2 = _builder_1.toString();
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"Message");
            _xifexpression_2 = _builder_2.toString();
        }
        String messageType = _xifexpression_2;
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append((Object)"new (buffer) ");
        _builder_3.append((Object)messageType, "");
        _builder_3.append((Object)"(getPeerAddress(), ");
        _builder_3.append((Object)portClassName, "");
        _builder_3.append((Object)"::");
        _builder_3.append((Object)dir, "");
        _builder_3.append((Object)"_");
        String _name_1 = m.getName();
        _builder_3.append((Object)_name_1, "");
        String _elvis = null;
        _elvis = dataArg != null ? dataArg : "";
        _builder_3.append((Object)_elvis, "");
        _builder_3.append((Object)")");
        String message = _builder_3.toString();
        StringConcatenation _builder_4 = new StringConcatenation();
        CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m, classPrefix, false);
        _builder_4.append((Object)_messageSignatureDefinition, "");
        _builder_4.append((Object)" {");
        _builder_4.newLineIfNotEmpty();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)hdlr, null);
        if (_notEquals_1) {
            _builder_4.append((Object)"\t");
            DetailCode _detailCode = hdlr.getDetailCode();
            EList _lines = _detailCode.getLines();
            for (String command : _lines) {
                _builder_4.append((Object)"\t");
                _builder_4.append((Object)command, "\t");
                _builder_4.newLineIfNotEmpty();
            }
        } else {
            _builder_4.append((Object)"\t");
            CharSequence _messageCall = this.messageCall(m, true);
            _builder_4.append((Object)_messageCall, "\t");
            _builder_4.append((Object)";");
            _builder_4.newLineIfNotEmpty();
        }
        _builder_4.append((Object)"}");
        _builder_4.newLine();
        _builder_4.newLine();
        CharSequence _messageSignatureDefinition_1 = this.messageSignatureDefinition(m, classPrefix, true);
        _builder_4.append((Object)_messageSignatureDefinition_1, "");
        _builder_4.append((Object)" {");
        _builder_4.newLineIfNotEmpty();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _isGenerateMSCInstrumentation = _settings.isGenerateMSCInstrumentation();
        if (_isGenerateMSCInstrumentation) {
            _builder_4.append((Object)"\t");
            _builder_4.append((Object)"DebuggingService::getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(),");
            _builder_4.newLine();
            _builder_4.append((Object)"\t");
            _builder_4.append((Object)"\t");
            _builder_4.append((Object)portClassName, "\t\t");
            _builder_4.append((Object)"::getMessageString(");
            _builder_4.append((Object)portClassName, "\t\t");
            _builder_4.append((Object)"::");
            _builder_4.append((Object)dir, "\t\t");
            _builder_4.append((Object)"_");
            String _name_2 = m.getName();
            _builder_4.append((Object)_name_2, "\t\t");
            _builder_4.append((Object)").c_str());");
            _builder_4.newLineIfNotEmpty();
        }
        _builder_4.append((Object)"\t");
        _builder_4.append((Object)"if (getPeerAddress().isValid()) {");
        _builder_4.newLine();
        _builder_4.append((Object)"\t\t");
        _builder_4.append((Object)"Message* buffer = dynamic_cast<IMessageService*>(getPeerMsgReceiver())->getMessageBuffer(sizeof(");
        _builder_4.append((Object)messageType, "\t\t");
        _builder_4.append((Object)"));");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append((Object)"\t\t");
        _builder_4.append((Object)"if (buffer) {");
        _builder_4.newLine();
        _builder_4.append((Object)"\t\t\t");
        _builder_4.append((Object)"getPeerMsgReceiver()->receive(");
        _builder_4.append((Object)message, "\t\t\t");
        _builder_4.append((Object)");");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append((Object)"\t\t");
        _builder_4.append((Object)"}");
        _builder_4.newLine();
        _builder_4.append((Object)"\t");
        _builder_4.append((Object)"}");
        _builder_4.newLine();
        _builder_4.append((Object)"}");
        _builder_4.newLine();
        _xblockexpression = _builder_4;
        return _xblockexpression;
    }

    protected CharSequence generateDataDrivenHeaderFile(Root root, ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                return !Objects.equal((Object)_data, null);
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)_allIncomingMessages, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/DataPort.h\"");
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)pc);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _path = this.roomExt.getPath((RoomClass)dataClass);
            _builder.append((Object)_path, "");
            String _name_1 = dataClass.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        DetailCode _userCode1 = pc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_2 = pc.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        DetailCode _userCode2 = pc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// send port holds data");
        _builder.newLine();
        _builder.append((Object)"class ");
        String _portClassName = this.roomExt.getPortClassName(pc, true);
        _builder.append((Object)_portClassName, "");
        _builder.append((Object)" : public etRuntime::DataSendPort {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _portClassName_1 = this.roomExt.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_1, "\t");
        _builder.append((Object)"(etRuntime::IRTObject* parent, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// getters and setters");
        _builder.newLine();
        for (Message msg : sentMsgs) {
            _builder.append((Object)"\t");
            _builder.append((Object)"void ");
            String _name_3 = msg.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"(");
            VarDecl _data = msg.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "\t");
            _builder.append((Object)" ");
            String _name_4 = msg.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"m_");
            String _name_5 = msg.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)" = ");
            String _name_6 = msg.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            VarDecl _data_1 = msg.getData();
            RefableType _refType_1 = _data_1.getRefType();
            DataType _type_1 = _refType_1.getType();
            String _typeName_1 = this._typeHelpers.typeName(_type_1);
            _builder.append((Object)_typeName_1, "\t");
            _builder.append((Object)" ");
            String _name_7 = msg.getName();
            _builder.append((Object)_name_7, "\t");
            _builder.append((Object)"() const {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return m_");
            String _name_8 = msg.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"private:");
        _builder.newLine();
        for (Message msg_1 : sentMsgs) {
            _builder.append((Object)"\t");
            VarDecl _data_2 = msg_1.getData();
            RefableType _refType_2 = _data_2.getRefType();
            DataType _type_2 = _refType_2.getType();
            String _typeName_2 = this._typeHelpers.typeName(_type_2);
            _builder.append((Object)_typeName_2, "\t");
            _builder.append((Object)" m_");
            String _name_9 = msg_1.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// receive port accesses send port");
        _builder.newLine();
        _builder.append((Object)"class ");
        String _portClassName_2 = this.roomExt.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_2, "");
        _builder.append((Object)" : public etRuntime::DataReceivePort {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _portClassName_3 = this.roomExt.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_3, "\t");
        _builder.append((Object)"(etRuntime::IRTObject* parent, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// getters");
        _builder.newLine();
        for (Message msg_2 : sentMsgs) {
            _builder.append((Object)"\t");
            VarDecl _data_3 = msg_2.getData();
            RefableType _refType_3 = _data_3.getRefType();
            DataType _type_3 = _refType_3.getType();
            String _typeName_3 = this._typeHelpers.typeName(_type_3);
            _builder.append((Object)_typeName_3, "\t");
            _builder.append((Object)" ");
            String _name_10 = msg_2.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)"() const;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"protected:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"virtual void connect(etRuntime::DataSendPort* dataSendPort);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _portClassName_4 = this.roomExt.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_4, "\t");
        _builder.append((Object)"* m_peer;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateDataDrivenSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                return !Objects.equal((Object)_data, null);
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)_allIncomingMessages, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
        _builder.append((Object)_cppHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append((Object)_generateNamespaceBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DetailCode _userCode3 = pc.getUserCode3();
        CharSequence _userCode = this.helpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"// send port holds data");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// constructor");
        _builder.newLine();
        String _portClassName = this.roomExt.getPortClassName(pc, true);
        _builder.append((Object)_portClassName, "");
        _builder.append((Object)"::");
        String _portClassName_1 = this.roomExt.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_1, "");
        _builder.append((Object)"(IRTObject* parent, const String& name, int localId) :");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DataSendPort(parent, name, localId)");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// receive port accesses send port");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// constructor");
        _builder.newLine();
        String _portClassName_2 = this.roomExt.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_2, "");
        _builder.append((Object)"::");
        String _portClassName_3 = this.roomExt.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_3, "");
        _builder.append((Object)"(IRTObject* parent, const String& name, int localId) :");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DataReceivePort(parent, name, localId),");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"m_peer(0)");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// getters");
        _builder.newLine();
        for (Message msg : sentMsgs) {
            VarDecl _data = msg.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _portClassName_4 = this.roomExt.getPortClassName(pc, false);
            _builder.append((Object)_portClassName_4, "");
            _builder.append((Object)"::");
            String _name_1 = msg.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"() const {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"// TODO needs default value");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"//if (m_peer == 0)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/*\treturn ");
            VarDecl _data_1 = msg.getData();
            RefableType _refType_1 = _data_1.getRefType();
            DataType _type_1 = _refType_1.getType();
            String _defaultValue = this.stdExt.defaultValue(_type_1);
            _builder.append((Object)_defaultValue, "\t");
            _builder.append((Object)"; */");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return m_peer->");
            String _name_2 = msg.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"void ");
        String _portClassName_5 = this.roomExt.getPortClassName(pc, false);
        _builder.append((Object)_portClassName_5, "");
        _builder.append((Object)"::connect(DataSendPort* dataSendPort) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _portClassName_6 = this.roomExt.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_6, "\t");
        _builder.append((Object)"* peer = dynamic_cast<");
        String _portClassName_7 = this.roomExt.getPortClassName(pc, true);
        _builder.append((Object)_portClassName_7, "\t");
        _builder.append((Object)"*>(dataSendPort);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (peer != 0)");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"m_peer = peer;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append((Object)_generateNamespaceEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String getMessageID(Message msg, InterfaceItem item) {
        if (item instanceof Port) {
            Port p = (Port)item;
            String _xifexpression = null;
            boolean _isConjugated = p.isConjugated();
            _xifexpression = _isConjugated ? "OUT_" : "IN_";
            String direction = _xifexpression;
            GeneralProtocolClass _protocol = p.getProtocol();
            String _name = _protocol.getName();
            String _name_1 = msg.getName();
            String _plus = String.valueOf(direction) + _name_1;
            return this.enumInUse(_name, _plus);
        }
        if (item instanceof SAP) {
            SAP sap = (SAP)item;
            ProtocolClass _protocol_1 = sap.getProtocol();
            String _name_2 = _protocol_1.getName();
            String _name_3 = msg.getName();
            String _plus_1 = "OUT_" + _name_3;
            return this.enumInUse(_name_2, _plus_1);
        }
        if (item instanceof SPP) {
            SPP spp = (SPP)item;
            ProtocolClass _protocol_2 = spp.getProtocol();
            String _name_4 = _protocol_2.getName();
            String _name_5 = msg.getName();
            String _plus_2 = "IN_" + _name_5;
            return this.enumInUse(_name_4, _plus_2);
        }
        return "unknown interface item";
    }

    protected String enumInUse(String namespace, String member) {
        return String.valueOf(namespace) + "::" + member;
    }
}

