/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import com.google.inject.Injector;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.ui.FSMUiModule;
import org.eclipse.etrice.ui.common.base.editor.CustomDiagramBehavior;
import org.eclipse.etrice.ui.common.base.editor.IInputUriHolder;
import org.eclipse.etrice.ui.common.base.editor.ModificationTrackingEnabler;
import org.eclipse.etrice.ui.common.base.editor.SelectedModelHelpProvider;
import org.eclipse.etrice.ui.common.base.editor.SuperClassListener;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.editor.EditorInputAdapter;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class DiagramEditorBase
extends DiagramEditor
implements IInputUriHolder {
    protected ModificationTrackingEnabler mte = new ModificationTrackingEnabler();
    protected URI inputUri;
    private Object textEditorClass;
    private SuperClassListener superClassListener;

    public DiagramEditorBase(Object textEditorClass) {
        this.textEditorClass = textEditorClass;
        Injector injector = FSMUiModule.getInjector();
        injector.injectMembers((Object)this);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    protected DiagramBehavior createDiagramBehavior() {
        return new CustomDiagramBehavior((IDiagramContainerUI)this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        DiagramEditorInput newInput = EditorInputAdapter.adaptToDiagramEditorInput((IEditorInput)input);
        if (newInput instanceof IDiagramEditorInput) {
            this.inputUri = ((IDiagramEditorInput)newInput).getUri();
        }
        super.init(site, input);
    }

    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
        Map result = EcoreUtil.UnresolvedProxyCrossReferencer.find((ResourceSet)resourceSet);
        if (!result.isEmpty()) {
            System.err.println("ERROR in diagram viewer: could not resolve all proxies!");
        }
        this.mte.setTarget(this.getEditingDomain());
    }

    public void setFocus() {
        Diagram diagram;
        EObject diagramBo;
        boolean dirtyAlready = this.isDirty();
        super.setFocus();
        if (this.superClassListener.isChangeInSuperClass()) {
            this.superClassChanged();
        }
        if (!dirtyAlready && this.isDirty()) {
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        if ((diagramBo = (EObject)(diagram = this.getDiagramTypeProvider().getDiagram()).getLink().getBusinessObjects().iterator().next()) == null || diagramBo.eIsProxy()) {
            this.handleMissingDiagramBo(diagram);
        }
    }

    public ModelComponent getModelComponent() {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram);
        if (bo instanceof ModelComponent) {
            return (ModelComponent)bo;
        }
        return null;
    }

    public void dispose() {
        this.mte.unsetTarget(this.getEditingDomain());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener)this.superClassListener);
        this.superClassListener.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.superClassListener = new SuperClassListener(this, this.textEditorClass);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)this.superClassListener);
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    protected boolean registerSuperClassListener(DiagramEditorBase editor) {
        if (!this.getClass().equals(editor.getClass()) || this.getModelComponent() == null) {
            return false;
        }
        ModelComponent editorSc = editor.getModelComponent();
        if (editorSc != null) {
            URI editorResURI = this.toCurrentPlatformURI(editorSc.eResource().getURI());
            ModelComponent base = this.getModelComponent();
            while ((base = base.getBase()) != null) {
                URI baseResURI = this.toCurrentPlatformURI(base.eResource().getURI());
                if (!editorResURI.equals(baseResURI) || !editorSc.getComponentName().equals(base.getComponentName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean registerSuperClassListener(XtextEditor editor) {
        if (!((Class)this.textEditorClass).isInstance(editor)) {
            return false;
        }
        if (this.getModelComponent() == null) {
            return false;
        }
        return (Boolean)editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource resource) throws Exception {
                URI editorResURI = DiagramEditorBase.this.toCurrentPlatformURI(resource.getURI());
                URI thisScResURI = DiagramEditorBase.this.toCurrentPlatformURI(DiagramEditorBase.this.getModelComponent().eResource().getURI());
                if (thisScResURI.equals(editorResURI)) {
                    return false;
                }
                ModelComponent base = DiagramEditorBase.this.getModelComponent();
                while ((base = base.getBase()) != null) {
                    URI baseResURI = DiagramEditorBase.this.toCurrentPlatformURI(base.eResource().getURI());
                    if (!editorResURI.equals(baseResURI)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private URI toCurrentPlatformURI(URI uri) {
        if (uri.isPlatform()) {
            return uri;
        }
        if (uri.isFile()) {
            IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            String rootString = rootPath.toFile().toString();
            String fileString = uri.toFileString();
            if (fileString.startsWith(rootString)) {
                return URI.createPlatformResourceURI((String)fileString.replace(rootString, ""), (boolean)false);
            }
        }
        return null;
    }

    protected abstract void handleMissingDiagramBo(Diagram var1);

    protected abstract void superClassChanged();

    protected abstract EObject getModel();

    @Override
    public URI getInputUri() {
        return this.inputUri;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContextProvider.class)) {
            return new SelectedModelHelpProvider(this);
        }
        return super.getAdapter(key);
    }
}

