/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.graphiti.ui.internal.fixed.FixedScaledGraphics;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DiagramExporter {
    public static void export(EObject sc, DiagramAccessBase da, String filename) {
        boolean wasOpen = false;
        DiagramEditorBase editor = da.findDiagramEditor(sc);
        if (editor != null) {
            wasOpen = true;
        } else {
            editor = da.openDiagramEditor(sc);
        }
        if (editor != null) {
            DiagramExporter.export(editor, filename);
            if (!wasOpen) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    public static void export(DiagramEditorBase editor, String filename) {
        IPreferenceStore store = UIBaseActivator.getDefault().getPreferenceStore();
        String format = store.getString("ExportDiagramFormat");
        int fmt = 4;
        if (format.equals("bmp")) {
            fmt = 0;
        } else if (format.equals("png")) {
            fmt = 5;
        } else if (format.equals("gif")) {
            fmt = 2;
        }
        final String fname = String.valueOf(filename) + "." + format;
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        Image image = DiagramExporter.createImage(viewer, 1.0, 3000.0);
        if (image != null) {
            try {
                final byte[] imgData = DiagramExporter.convertImageToBytes(image, fmt);
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        FileOutputStream outputStream = null;
                        try {
                            try {
                                outputStream = new FileOutputStream(fname);
                                outputStream.write(imgData);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                try {
                                    outputStream.close();
                                }
                                catch (Exception x) {
                                    x.printStackTrace();
                                }
                            }
                        }
                        finally {
                            try {
                                outputStream.close();
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                    }
                };
                new ProgressMonitorDialog(editor.getEditorSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Image createImage(GraphicalViewer viewer, double scaleFactor, double upperBoundPixels) {
        RootEditPart rootEditPart = viewer.getRootEditPart();
        if (!(rootEditPart instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart graphicalRootEditPart = (GraphicalEditPart)rootEditPart;
        IFigure rootFigure = ((LayerManager)graphicalRootEditPart).getLayer((Object)"Printable Layers");
        if (rootFigure == null) {
            return null;
        }
        if (scaleFactor * (double)rootFigure.getBounds().width > upperBoundPixels || scaleFactor * (double)rootFigure.getBounds().height > upperBoundPixels) {
            scaleFactor = Math.min(upperBoundPixels / (double)rootFigure.getBounds().width, upperBoundPixels / (double)rootFigure.getBounds().height);
        }
        Image scaledImage = new Image((Device)Display.getDefault(), (int)((double)rootFigure.getBounds().width * scaleFactor), (int)(scaleFactor * (double)rootFigure.getBounds().height));
        GC gc = new GC((Drawable)scaledImage);
        FixedScaledGraphics graphics = new FixedScaledGraphics((Graphics)new SWTGraphics(gc));
        graphics.scale(scaleFactor);
        EditPart contents = viewer.getContents();
        if (contents instanceof GraphicalEditPart) {
            IFigure contentsFigure = ((GraphicalEditPart)contents).getFigure();
            Rectangle contentBounds = contentsFigure.getBounds();
            graphics.translate(-contentBounds.x, -contentBounds.y);
        }
        rootFigure.paint((Graphics)graphics);
        return scaledImage;
    }

    private static byte[] convertImageToBytes(Image image, int format) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            try {
                ImageData imDat = null;
                if (format == 2) {
                    imDat = DiagramExporter.create8BitIndexedPaletteImage(image);
                }
                if (imDat == null) {
                    imDat = image.getImageData();
                }
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{imDat};
                try {
                    imageLoader.save((OutputStream)result, format);
                }
                catch (SWTException e) {
                    String error = "Depth: " + Integer.toString(image.getImageData().depth) + "\n" + "X: " + Integer.toString(image.getImageData().x) + "\n" + "Y: " + Integer.toString(image.getImageData().y);
                    throw new IllegalStateException(error, e);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            image.dispose();
        }
        return result.toByteArray();
    }

    private static ImageData create8BitIndexedPaletteImage(Image image) {
        int upperboundWidth = image.getBounds().width;
        int upperboundHeight = image.getBounds().height;
        ImageData imageData = image.getImageData();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        int x = 0;
        while (x < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x, y);
                Integer colorInteger = new Integer(color);
                if (!colors.contains(colorInteger)) {
                    colors.add(colorInteger);
                }
                ++y;
            }
            ++x;
        }
        if (colors.size() > 256) {
            throw new IllegalStateException("Image contains more than 256 colors. \n Automated color reduction is currently not supported.");
        }
        RGB[] rgbs = new RGB[256];
        int i = 0;
        while (i < 256) {
            rgbs[i] = new RGB(255, 255, 255);
            ++i;
        }
        i = 0;
        while (i < colors.size()) {
            int pixelValue = (Integer)colors.get(i);
            int red = (pixelValue & imageData.palette.redMask) >>> Math.abs(imageData.palette.redShift);
            int green = (pixelValue & imageData.palette.greenMask) >>> Math.abs(imageData.palette.greenShift);
            int blue = (pixelValue & imageData.palette.blueMask) >>> Math.abs(imageData.palette.blueShift);
            rgbs[i] = new RGB(red, green, blue);
            ++i;
        }
        PaletteData palette = new PaletteData(rgbs);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, palette);
        int x2 = 0;
        while (x2 < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x2, y);
                newImageData.setPixel(x2, y, colors.indexOf(new Integer(color)));
                ++y;
            }
            ++x2;
        }
        return newImageData;
    }
}

