/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class SaveOnFocusLostListener
implements IPartListener {
    private final IEditorPart editor;
    private final IPreferenceStore store;
    private boolean isActive = true;
    private boolean saveAfterCurrentCommand = false;

    public SaveOnFocusLostListener(IEditorPart editor) {
        this.editor = editor;
        this.store = UIBaseActivator.getDefault().getPreferenceStore();
        editor.getSite().getPage().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part != this.editor) {
            return;
        }
        this.setActive(false);
        part.getSite().getPage().removePartListener((IPartListener)this);
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part != this.editor) {
            return;
        }
        boolean isSaveOnFocus = this.store.getBoolean("SaveDiagOnFocusLost");
        if (this.isActive && isSaveOnFocus && this.editor.isDirty()) {
            this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

