/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.support;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.etrice.core.common.ui.linking.GlobalNonPlatformURIEditorOpener;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public abstract class DiagramAccessBase {
    public static final String DIAGRAMS_FOLDER_NAME = "diagrams";
    @Inject
    private IResourceSetProvider resourceSetProvider;

    public DiagramAccessBase() {
        this.injectMembers();
    }

    public Diagram getDiagram(EObject rootObject) {
        Resource diagRes;
        Resource resource = rootObject.eResource();
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        ResourceSet rs = this.newResourceSet(uri);
        URI diagURI = null;
        boolean exists = false;
        if (uri.isPlatformResource()) {
            uri = uri.trimSegments(1);
            IFolder diagramFolder = null;
            if (uri.segmentCount() == 2) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.lastSegment());
                diagramFolder = project.getFolder(DIAGRAMS_FOLDER_NAME);
            } else {
                IFolder parentFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(uri.toPlatformString(true)));
                diagramFolder = parentFolder.getFolder(DIAGRAMS_FOLDER_NAME);
            }
            IFile diagramFile = diagramFolder.getFile(this.getDigramFileName(rootObject));
            diagURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
            exists = diagramFile.exists();
        } else {
            File diagramFile = new File(uri.toFileString());
            diagramFile = new File(String.valueOf(diagramFile.getParent()) + File.separator + DIAGRAMS_FOLDER_NAME + File.separator + this.getDigramFileName(rootObject));
            diagURI = URI.createFileURI((String)diagramFile.getPath());
            exists = diagramFile.exists();
        }
        if (exists) {
            diagRes = rs.getResource(diagURI, true);
            if (diagRes.getContents().isEmpty()) {
                return null;
            }
            if (diagRes.getContents().get(0) instanceof Diagram) {
                Diagram diagram = (Diagram)diagRes.getContents().get(0);
                this.updateDiagram(diagram, false);
                return diagram;
            }
        } else {
            diagRes = rs.createResource(diagURI);
            IPreferenceStore store = UIBaseActivator.getDefault().getPreferenceStore();
            boolean snap = store.getBoolean("SnapToGrid");
            boolean useGrid = store.getBoolean("UseGrid");
            int horUnit = useGrid ? store.getInt("HorGridUnit") : 0;
            int verUnit = useGrid ? store.getInt("VerGridUnit") : 0;
            Diagram diagram = Graphiti.getPeCreateService().createDiagram(this.getDiagramTypeId(), this.getDiagramName(rootObject), horUnit, verUnit, snap);
            diagRes.getContents().add((Object)diagram);
            this.populateDiagram(rootObject, diagram);
            try {
                diagRes.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return diagram;
        }
        return null;
    }

    private ResourceSet newResourceSet(URI uri) {
        XtextResourceSet rs;
        if (uri.isPlatformResource()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            IProject project = file.getProject();
            rs = this.resourceSetProvider.get(project);
        } else {
            rs = new XtextResourceSet();
        }
        return rs;
    }

    private void populateDiagram(EObject rootObject, Diagram diagram) {
        ResourceSet rs = this.newResourceSet(rootObject.eResource().getURI());
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)rs);
        if (editingDomain == null) {
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(rs);
        }
        URI boUri = EcoreUtil.getURI((EObject)rootObject);
        rootObject = editingDomain.getResourceSet().getEObject(boUri, true);
        editingDomain.getCommandStack().execute(this.getInitialCommand(rootObject, diagram, editingDomain));
        editingDomain.dispose();
    }

    private void updateDiagram(Diagram diagram, boolean doSave) {
        ResourceSet rs = diagram.eResource().getResourceSet();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)rs);
        try {
            Command updateCommand;
            if (editingDomain == null) {
                editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(rs);
                ((TransactionalEditingDomainImpl)editingDomain).startTransaction(false, null);
            }
            if ((updateCommand = this.getUpdateCommand(diagram, editingDomain)) != null) {
                editingDomain.getCommandStack().execute(updateCommand);
                if (doSave) {
                    try {
                        diagram.eResource().save(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        editingDomain.dispose();
    }

    public DiagramEditorBase findDiagramEditor(EObject rootObject) {
        IFileEditorInput input = this.getEditorInput(rootObject);
        return (DiagramEditorBase)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)input);
    }

    public DiagramEditorBase openDiagramEditor(EObject rootObject) {
        IFileEditorInput input = this.getEditorInput(rootObject);
        try {
            return (DiagramEditorBase)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, this.getEditorId());
        }
        catch (PartInitException e) {
            String error = "Error while opening diagram editor";
            System.err.println(error);
            return null;
        }
    }

    private IFileEditorInput getEditorInput(EObject rootObject) {
        Diagram diagram = this.getDiagram(rootObject);
        URI uri = diagram.eResource().getURI();
        String platformString = null;
        if (uri.isPlatform()) {
            platformString = uri.toPlatformString(true);
        } else {
            uri = GlobalNonPlatformURIEditorOpener.getPlatformURI((URI)uri);
            platformString = uri.toPlatformString(true);
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
        FileEditorInput input = new FileEditorInput(file);
        return input;
    }

    public abstract String getDiagramName(EObject var1);

    protected abstract String getDigramFileName(EObject var1);

    protected abstract String getDiagramTypeId();

    protected abstract String getEditorId();

    protected abstract Command getInitialCommand(EObject var1, Diagram var2, TransactionalEditingDomain var3);

    protected abstract Command getUpdateCommand(Diagram var1, TransactionalEditingDomain var2);

    protected abstract void injectMembers();
}

