/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class CppExtensions
implements ILanguageExtension {
    @Inject
    private IDiagnostician diagnostician;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public String getTypedDataDefinition(EObject msg) {
        return this.generateArglistAndTypedData((EObject)((Message)msg).getData())[1];
    }

    public String getCppHeaderFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + ".h";
    }

    public String getCppSourceFileName(RoomClass rc) {
        String string = rc.getName();
        return String.valueOf(string) + ".cpp";
    }

    public String getCppClassName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = "Node_" + string;
        String string3 = String.valueOf(string2) + "_";
        String string4 = ssi.getName();
        return String.valueOf(string3) + string4;
    }

    public String getCppHeaderFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = this.getCppClassName(nr, ssi);
        return String.valueOf(string) + ".h";
    }

    public String getCppSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = this.getCppClassName(nr, ssi);
        return String.valueOf(string) + ".cpp";
    }

    public String accessLevelPrivate() {
        return "";
    }

    public String accessLevelProtected() {
        return "";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "this->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String scopeSeparator() {
        return "::";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        String string = null;
        string = isDeclaration ? "" : String.valueOf(classname) + "::";
        return string;
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        return String.valueOf(namespace) + "." + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        String string = null;
        boolean bl = entries.isEmpty();
        if (bl) {
            return "";
        }
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("typedef enum {");
        stringConcatenation.newLine();
        boolean bl2 = false;
        for (Pair<String, String> entry : entries) {
            if (!bl2) {
                bl2 = true;
            } else {
                stringConcatenation.appendImmediate((Object)",", "\t");
            }
            stringConcatenation.append("\t");
            String string2 = (String)entry.getFirst();
            stringConcatenation.append(string2, "\t");
            stringConcatenation.append(" = ");
            String string3 = (String)entry.getSecond();
            stringConcatenation.append(string3, "\t");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("} ");
        stringConcatenation.append(name);
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        string = stringConcatenation.toString();
        return string;
    }

    public String booleanConstant(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "0";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayType(String type, int size, boolean isRef) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("StaticArray<");
        stringConcatenation.append(type);
        if (isRef) {
            stringConcatenation.append("*");
        }
        stringConcatenation.append(", ");
        stringConcatenation.append((Object)size);
        stringConcatenation.append(">");
        return stringConcatenation.toString();
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        String string = this.arrayType(type, size, isRef);
        String string2 = String.valueOf(string) + " ";
        return String.valueOf(string2) + name;
    }

    public String getIncludeGuardString(RoomClass roomClass, String appendSegments) {
        String[] stringArray = this._roomExtensions.getPackage(roomClass).split("\\.");
        String string = roomClass.getName();
        Iterable iterable = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)stringArray)), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{string})));
        String[] stringArray2 = appendSegments.split("\\.");
        Functions.Function1<String, Boolean> function1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean bl = it.isEmpty();
                return !bl;
            }
        };
        String string2 = IterableExtensions.join((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)iterable, (Iterable)((Iterable)Conversions.doWrapArray((Object)stringArray2))), (Functions.Function1)function1), (CharSequence)"_").toUpperCase();
        String string3 = "_" + string2;
        return String.valueOf(string3) + "_H_";
    }

    public CharSequence generateIncludeGuardBegin(RoomClass roomClass, String appendSegments) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#ifndef ");
        String string = this.getIncludeGuardString(roomClass, appendSegments);
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#define ");
        String string2 = this.getIncludeGuardString(roomClass, appendSegments);
        stringConcatenation.append(string2);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    public CharSequence generateIncludeGuardEnd(RoomClass roomClass, String appendSegments) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("#endif /* ");
        String string = this.getIncludeGuardString(roomClass, appendSegments);
        stringConcatenation.append(string);
        stringConcatenation.append(" */");
        return stringConcatenation;
    }

    public String generateNamespaceBegin(RoomClass roomClass) {
        return "";
    }

    public String generateNamespaceEnd(RoomClass roomClass) {
        return "";
    }

    public String superCall(String baseClassName, String method, String arguments) {
        return String.valueOf(baseClassName) + "::" + method + "(" + arguments + ");";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        throw new UnsupportedOperationException("TODO Config for Cpp");
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        throw new UnsupportedOperationException("TODO Config for Cpp");
    }

    public String defaultValue(DataType dt) {
        String string = null;
        DataType it = dt;
        boolean bl = false;
        if (it instanceof PrimitiveType) {
            bl = true;
            string = ((PrimitiveType)it).getDefaultValueLiteral();
        }
        if (!bl && it instanceof EnumerationType) {
            bl = true;
            String string2 = null;
            this.diagnostician.error("Enumeration not supported", (EObject)dt, null);
            string = string2 = "/* TODO */";
        }
        if (!bl && it instanceof ExternalType) {
            bl = true;
            string = ((ExternalType)it).getDefaultValueLiteral();
        }
        return string;
    }

    public String getDefaultValue(EnumerationType type) {
        String string = null;
        boolean bl = type.getLiterals().isEmpty();
        string = bl ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return string;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String string = null;
        String dv = this.defaultValue(dt);
        String string2 = null;
        if (size > 1) {
            String string3 = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = String.valueOf(res) + dv;
                if (++i >= size) continue;
                res = String.valueOf(res) + ",";
            }
            string2 = string3 = String.valueOf(res) + "}";
        } else {
            string2 = dv;
        }
        string = string2;
        return string;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        boolean bl;
        RefableType refableType;
        DataType dataType;
        if (Objects.equal((Object)d, null) || !(d instanceof VarDecl)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        VarDecl data = (VarDecl)d;
        String string = null;
        DataType it = dataType = data.getRefType().getType();
        boolean bl2 = false;
        if (it instanceof PrimitiveType) {
            boolean bl3;
            boolean bl4 = Strings.isEmpty((String)((PrimitiveType)it).getCastName());
            boolean bl5 = bl3 = !bl4;
            if (bl3) {
                bl2 = true;
                string = ((PrimitiveType)it).getCastName();
            }
        }
        if (!bl2 && it instanceof EnumerationType) {
            bl2 = true;
            string = this.getCastType((EnumerationType)it);
        }
        if (!bl2) {
            string = this._typeHelpers.typeName(it);
        }
        String castExpr = String.valueOf(string) + "*";
        String string2 = this._typeHelpers.typeName(data.getRefType().getType());
        String string3 = null;
        RefableType it_1 = refableType = data.getRefType();
        boolean bl6 = false;
        boolean bl7 = it_1.isRef();
        if (bl7) {
            bl6 = true;
            string3 = "*";
        }
        if (!bl6 && (bl = this._typeHelpers.isPrimitive(it_1.getType()))) {
            bl6 = true;
            string3 = "";
        }
        if (!bl6) {
            string3 = "&";
        }
        String typeExpr = String.valueOf(string2) + string3;
        String string4 = null;
        boolean bl8 = data.getRefType().isRef();
        boolean bl9 = !bl8;
        string4 = bl9 ? "*" : "";
        String deRef = string4;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(typeExpr);
        stringConcatenation.append(" ");
        String string5 = data.getName();
        stringConcatenation.append(string5);
        stringConcatenation.append(" = ");
        stringConcatenation.append(deRef);
        stringConcatenation.append("(static_cast<");
        stringConcatenation.append(castExpr);
        stringConcatenation.append(">(generic_data__et));");
        String typedData = String.valueOf(stringConcatenation.toString()) + this._roomExtensions.NEWLINE;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append(", ");
        String string6 = data.getName();
        stringConcatenation2.append(string6);
        String dataArg = stringConcatenation2.toString();
        StringConcatenation stringConcatenation3 = new StringConcatenation();
        stringConcatenation3.append(", ");
        stringConcatenation3.append(typeExpr);
        stringConcatenation3.append(" ");
        String string7 = data.getName();
        stringConcatenation3.append(string7);
        String typedArgList = stringConcatenation3.toString();
        return new String[]{dataArg, typedData, typedArgList};
    }

    public String getTargetType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = !Objects.equal((Object)primitiveType, null);
        string = bl ? type.getPrimitiveType().getTargetName() : type.getName();
        return string;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean bl;
        String string = null;
        EObject eObject = literal.eContainer();
        EnumerationType type = (EnumerationType)eObject;
        String cast = this.getTargetType(type);
        String string2 = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl2 = bl = !Objects.equal((Object)primitiveType, null);
        if (bl) {
            string2 = Long.toString(literal.getLiteralValue());
        } else {
            String string3 = Long.toString(literal.getLiteralValue());
            String string4 = "((" + cast + ")" + string3;
            string2 = String.valueOf(string4) + ")";
        }
        string = string2;
        return string;
    }

    public String getCastType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = !Objects.equal((Object)primitiveType, null);
        string = bl ? type.getPrimitiveType().getCastName() : type.getName();
        return string;
    }

    public String makeOverridable() {
        return "virtual ";
    }

    public String getImplementationClassName(ActorClass ac) {
        String string = null;
        List attributes = this._roomHelpers.getAttributes(ac, "ImplementationSubclass");
        String string2 = null;
        boolean bl = attributes.isEmpty();
        if (bl) {
            string2 = ac.getName();
        } else {
            Functions.Function1<KeyValue, Boolean> function1 = new Functions.Function1<KeyValue, Boolean>(){

                public Boolean apply(KeyValue it) {
                    String string = it.getKey();
                    return Objects.equal((Object)string, (Object)"fqnClassName");
                }
            };
            string2 = this._roomHelpers.literalToString(((KeyValue)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)attributes, (Functions.Function1)function1))).getValue());
        }
        string = string2;
        return string;
    }

    public String getActorIncludePath(ActorClass ac) {
        String string = null;
        List attributes = this._roomHelpers.getAttributes(ac, "ImplementationSubclass");
        String string2 = null;
        boolean bl = attributes.isEmpty();
        if (bl) {
            String string3 = this._roomExtensions.getPath((RoomClass)ac);
            String string4 = ac.getName();
            String string5 = String.valueOf(string3) + string4;
            string2 = String.valueOf(string5) + ".h";
        } else {
            String string6 = null;
            Functions.Function1<KeyValue, Boolean> function1 = new Functions.Function1<KeyValue, Boolean>(){

                public Boolean apply(KeyValue it) {
                    String string = it.getKey();
                    return Objects.equal((Object)string, (Object)"includePath");
                }
            };
            Iterable path = IterableExtensions.filter((Iterable)attributes, (Functions.Function1)function1);
            String string7 = null;
            boolean bl2 = IterableExtensions.isEmpty((Iterable)path);
            if (bl2) {
                String string8 = null;
                Functions.Function1<KeyValue, Boolean> function12 = new Functions.Function1<KeyValue, Boolean>(){

                    public Boolean apply(KeyValue it) {
                        String string = it.getKey();
                        return Objects.equal((Object)string, (Object)"fqnClassName");
                    }
                };
                String baseName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)this._roomHelpers.literalToString(((KeyValue)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)attributes, (Functions.Function1)function12))).getValue()).split("::"))));
                string7 = string8 = String.valueOf(baseName) + ".h";
            } else {
                string7 = this._roomHelpers.literalToString(((KeyValue)IterableExtensions.head((Iterable)path)).getValue());
            }
            string2 = string6 = string7;
        }
        string = string2;
        return string;
    }
}

