/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.CppProcedureHelpers;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DataClassGen {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private CppProcedureHelpers helpers;
    @Inject
    private Initialization initHelper;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        this.logger.logInfo("generating code");
        EList eList = root.getDataClasses();
        for (DataClass dc : eList) {
            String string = this.roomExt.getGenerationTargetPath((EObject)dc);
            String string2 = this.roomExt.getPath((RoomClass)dc);
            String path = String.valueOf(string) + string2;
            String string3 = this.stdExt.getCppHeaderFileName((RoomClass)dc);
            String string4 = "generating DataClass header '" + string3;
            String string5 = String.valueOf(string4) + "' in '";
            String string6 = String.valueOf(string5) + path;
            String string7 = String.valueOf(string6) + "'";
            this.logger.logInfo(string7);
            this.fileAccess.setOutputPath(path);
            this.fileAccess.generateFile(this.stdExt.getCppHeaderFileName((RoomClass)dc), this.generateHeaderFile(root, dc));
            String string8 = this.stdExt.getCppSourceFileName((RoomClass)dc);
            String string9 = "generating DataClass source '" + string8;
            String string10 = String.valueOf(string9) + "' in '";
            String string11 = String.valueOf(string10) + path;
            String string12 = String.valueOf(string11) + "'";
            this.logger.logInfo(string12);
            this.fileAccess.setOutputPath(path);
            this.fileAccess.generateFile(this.stdExt.getCppSourceFileName((RoomClass)dc), this.generateSourceFile(root, dc));
        }
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        CharSequence charSequence;
        String string;
        boolean bl;
        boolean bl2;
        String string2;
        CharSequence charSequence2;
        Object object;
        CharSequence charSequence3;
        Object object2;
        boolean bl3;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence4 = this.stdExt.generateIncludeGuardBegin((RoomClass)dc, "");
        stringConcatenation.append((Object)charSequence4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/etDatatypesCpp.hpp\"");
        stringConcatenation.newLine();
        Object object3 = dc.getBase();
        boolean bl4 = bl3 = !Objects.equal((Object)object3, null);
        if (bl3) {
            stringConcatenation.append("#include \"");
            object2 = this.roomExt.getPath((RoomClass)dc.getBase());
            stringConcatenation.append((String)object2);
            charSequence3 = dc.getBase().getName();
            stringConcatenation.append(charSequence3);
            stringConcatenation.append(".h\"");
        }
        stringConcatenation.newLineIfNotEmpty();
        object3 = root.getReferencedDataClasses((RoomClass)dc);
        for (DataClass classes : object3) {
            stringConcatenation.append("#include \"");
            charSequence3 = this.roomExt.getPath((RoomClass)classes);
            stringConcatenation.append(charSequence3);
            String string3 = classes.getName();
            stringConcatenation.append(string3);
            stringConcatenation.append(".h\"");
            stringConcatenation.newLineIfNotEmpty();
        }
        object3 = root.getReferencedModels((RoomClass)dc);
        for (RoomModel model : object3) {
            charSequence3 = model.getDataClasses();
            object = charSequence3.iterator();
            while (object.hasNext()) {
                DataClass classes_1 = (DataClass)object.next();
                stringConcatenation.append("#include \"");
                charSequence2 = this.roomExt.getPath((RoomClass)classes_1);
                stringConcatenation.append(charSequence2);
                string2 = classes_1.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(".h\"");
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        stringConcatenation.newLine();
        object3 = this.helpers.userCode(dc.getUserCode1());
        stringConcatenation.append(object3);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("using namespace etRuntime; // TODO JH remove");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        String string4 = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        stringConcatenation.append(string4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("class ");
        object2 = dc.getName();
        stringConcatenation.append((String)object2);
        charSequence3 = dc.getBase();
        boolean bl5 = bl2 = !Objects.equal((Object)charSequence3, null);
        if (bl2) {
            stringConcatenation.append(" : public ");
            object = dc.getBase().getName();
            stringConcatenation.append((String)object);
        }
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("public:");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        charSequence3 = this.helpers.userCode(dc.getUserCode2());
        stringConcatenation.append((Object)charSequence3, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence5 = this.helpers.attributes((List)dc.getAttributes());
        stringConcatenation.append((Object)charSequence5, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        object = this.helpers.attributeSettersGettersImplementation((List)dc.getAttributes(), dc.getName());
        stringConcatenation.append(object, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        charSequence2 = this.helpers.operationsDeclaration((List)dc.getOperations(), dc.getName());
        stringConcatenation.append((Object)charSequence2, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("// default constructor, copy constructor and assignment operator");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        string2 = dc.getName();
        stringConcatenation.append(string2, "\t");
        stringConcatenation.append("();");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        String string5 = dc.getName();
        stringConcatenation.append(string5, "\t");
        stringConcatenation.append("(const ");
        String string6 = dc.getName();
        stringConcatenation.append(string6, "\t");
        stringConcatenation.append("& rhs);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("// constructor using fields");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        boolean bl6 = this._roomHelpers.getAllAttributes(dc).isEmpty();
        boolean bl7 = bl = !bl6;
        if (bl) {
            string = dc.getName();
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("(");
            charSequence = this.helpers.constArgList(this._roomHelpers.getAllAttributes(dc));
            stringConcatenation.append(charSequence, "\t");
            stringConcatenation.append(");");
        }
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        String string7 = dc.getName();
        stringConcatenation.append(string7, "\t");
        stringConcatenation.append("& operator=(const ");
        String string8 = dc.getName();
        stringConcatenation.append(string8, "\t");
        stringConcatenation.append("& rhs);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("};");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        string = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        charSequence = this.stdExt.generateIncludeGuardEnd((RoomClass)dc, "");
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        boolean bl;
        Object object;
        CharSequence charSequence;
        String string;
        boolean bl2;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Source File of DataClass ");
        String string2 = dc.getName();
        stringConcatenation.append(string2, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string3 = this.stdExt.getCppHeaderFileName((RoomClass)dc);
        stringConcatenation.append(string3);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"etUnit/etUnit.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        String string4 = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        stringConcatenation.append(string4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this.helpers.userCode(dc.getUserCode3());
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("// default constructor");
        stringConcatenation.newLine();
        String string5 = dc.getName();
        stringConcatenation.append(string5);
        stringConcatenation.append("::");
        String string6 = dc.getName();
        stringConcatenation.append(string6);
        stringConcatenation.append("()");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        CharSequence charSequence3 = this.generateDefaultInitalizerList(dc);
        stringConcatenation.append((Object)charSequence3, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("{");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence4 = this.initHelper.genExtraInitializers((Iterable<Attribute>)dc.getAttributes());
        stringConcatenation.append((Object)charSequence4, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        String string7 = this.helpers.userStructorBody((RoomClass)dc, true);
        stringConcatenation.append(string7, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("// copy constructor");
        stringConcatenation.newLine();
        String string8 = dc.getName();
        stringConcatenation.append(string8);
        stringConcatenation.append("::");
        String string9 = dc.getName();
        stringConcatenation.append(string9);
        stringConcatenation.append("(const ");
        String string10 = dc.getName();
        stringConcatenation.append(string10);
        stringConcatenation.append("& rhs)");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        CharSequence charSequence5 = this.generateCopyInitalizerList(dc);
        stringConcatenation.append((Object)charSequence5, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("{");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("// constructor using fields");
        stringConcatenation.newLine();
        stringConcatenation.append("// TODO");
        stringConcatenation.newLine();
        boolean bl3 = this._roomHelpers.getAllAttributes(dc).isEmpty();
        boolean bl4 = bl2 = !bl3;
        if (bl2) {
            string = dc.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("::");
            charSequence = dc.getName();
            stringConcatenation.append(charSequence);
            stringConcatenation.append("(");
            String string11 = this.helpers.constArgList(this._roomHelpers.getAllAttributes(dc));
            stringConcatenation.append(string11);
            stringConcatenation.append(")");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            object = this.generateFieldInitializerList(dc);
            stringConcatenation.append(object, "\t");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("{");
            stringConcatenation.newLine();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("// assignment operator");
        stringConcatenation.newLine();
        String string12 = dc.getName();
        stringConcatenation.append(string12);
        stringConcatenation.append("& ");
        String string13 = dc.getName();
        stringConcatenation.append(string13);
        stringConcatenation.append("::operator=(const ");
        string = dc.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("& rhs)");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("{");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("if (this == &rhs) { return *this; };");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        charSequence = dc.getBase();
        boolean bl5 = bl = !Objects.equal((Object)charSequence, null);
        if (bl) {
            object = dc.getBase().getName();
            stringConcatenation.append((String)object, "\t");
            stringConcatenation.append("::operator=(rhs);");
        }
        stringConcatenation.newLineIfNotEmpty();
        charSequence = dc.getAttributes();
        object = charSequence.iterator();
        while (object.hasNext()) {
            Attribute attr = (Attribute)object.next();
            stringConcatenation.append("\t");
            stringConcatenation.append("this->");
            String string14 = attr.getName();
            stringConcatenation.append(string14, "\t");
            stringConcatenation.append(" = rhs.");
            String string15 = attr.getName();
            stringConcatenation.append(string15, "\t");
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("\t");
        stringConcatenation.append("return *this;");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        charSequence = this.helpers.operationsImplementation((List)dc.getOperations(), dc.getName());
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string16 = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        stringConcatenation.append(string16);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private CharSequence generateDefaultInitalizerList(DataClass dataClass) {
        Object object;
        Object object2;
        boolean bl;
        CharSequence charSequence = null;
        final Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        DataClass dataClass2 = dataClass.getBase();
        boolean bl2 = bl = !Objects.equal((Object)dataClass2, null);
        if (bl) {
            object2 = dataClass.getBase().getName();
            object = String.valueOf(object2) + "()";
            initList.add(object);
        }
        object2 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                String string = it.getName();
                stringConcatenation.append(string);
                stringConcatenation.append("(");
                String string2 = initHelper.getInitializerListValue(it);
                stringConcatenation.append(string2);
                stringConcatenation.append(")");
                return stringConcatenation.toString();
            }
        };
        object = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)object2);
        Iterables.addAll((Collection)initList, (Iterable)object);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    private CharSequence generateCopyInitalizerList(DataClass dataClass) {
        Object object;
        Object object2;
        boolean bl;
        CharSequence charSequence = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        DataClass dataClass2 = dataClass.getBase();
        boolean bl2 = bl = !Objects.equal((Object)dataClass2, null);
        if (bl) {
            object2 = dataClass.getBase().getName();
            object = String.valueOf(object2) + "(rhs)";
            initList.add(object);
        }
        object2 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                String string = it.getName();
                stringConcatenation.append(string);
                stringConcatenation.append("(rhs.");
                String string2 = it.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(")");
                return stringConcatenation.toString();
            }
        };
        object = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)object2);
        Iterables.addAll((Collection)initList, (Iterable)object);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    private CharSequence generateFieldInitializerList(DataClass dataClass) {
        Object object;
        Object object2;
        boolean bl;
        CharSequence charSequence = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        DataClass dataClass2 = dataClass.getBase();
        boolean bl2 = bl = !Objects.equal((Object)dataClass2, null);
        if (bl) {
            object2 = new StringConcatenation();
            object = dataClass.getBase().getName();
            object2.append((String)object);
            object2.append("(");
            Functions.Function1<Attribute, String> function1 = new Functions.Function1<Attribute, String>(){

                public String apply(Attribute it) {
                    return it.getName();
                }
            };
            String string = IterableExtensions.join((Iterable)ListExtensions.map((List)this._roomHelpers.getAllAttributes(dataClass.getBase()), (Functions.Function1)function1), (CharSequence)", ");
            object2.append(string);
            object2.append(")");
            initList.add(object2.toString());
        }
        object2 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                String string = it.getName();
                stringConcatenation.append(string);
                stringConcatenation.append("(");
                String string2 = it.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(")");
                return stringConcatenation.toString();
            }
        };
        object = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)object2);
        Iterables.addAll((Collection)initList, (Iterable)object);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    public String deepCopy(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (!Objects.equal((Object)dc, null)) {
            String string;
            String string2 = this.deepCopy((List<Attribute>)dc.getAttributes()).toString();
            result = string = String.valueOf(string2) + result;
            dc = dc.getBase();
        }
        return result;
    }

    public CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Attribute a : attributes) {
            String string;
            String string2;
            int n;
            DataType dataType = a.getType().getType();
            if (dataType instanceof ComplexType) {
                boolean bl;
                stringConcatenation.append("if (");
                String string3 = a.getName();
                stringConcatenation.append(string3);
                stringConcatenation.append("!=null) {");
                stringConcatenation.newLineIfNotEmpty();
                n = a.getSize();
                boolean bl2 = bl = n == 0;
                if (bl) {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("copy.");
                    string2 = a.getName();
                    stringConcatenation.append(string2, "\t");
                    stringConcatenation.append(" = ");
                    string = a.getName();
                    stringConcatenation.append(string, "\t");
                    stringConcatenation.append(".deepCopy();");
                    stringConcatenation.newLineIfNotEmpty();
                } else {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("for (int i=0;i<");
                    string2 = a.getName();
                    stringConcatenation.append(string2, "\t");
                    stringConcatenation.append(".length;i++){");
                    stringConcatenation.newLineIfNotEmpty();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t");
                    stringConcatenation.append("copy.");
                    string = a.getName();
                    stringConcatenation.append(string, "\t\t");
                    stringConcatenation.append("[i] = ");
                    String string4 = a.getName();
                    stringConcatenation.append(string4, "\t\t");
                    stringConcatenation.append("[i].deepCopy();");
                    stringConcatenation.newLineIfNotEmpty();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("}");
                    stringConcatenation.newLine();
                }
                stringConcatenation.append("}");
                stringConcatenation.newLine();
                continue;
            }
            int n2 = a.getSize();
            int n3 = n = n2 == 0 ? 1 : 0;
            if (n != 0) {
                stringConcatenation.append("copy.");
                String string5 = a.getName();
                stringConcatenation.append(string5);
                stringConcatenation.append(" = ");
                string2 = a.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                continue;
            }
            stringConcatenation.append("for (int i=0;i<");
            String string6 = a.getName();
            stringConcatenation.append(string6);
            stringConcatenation.append(".length;i++){");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("copy.");
            string2 = a.getName();
            stringConcatenation.append(string2, "\t");
            stringConcatenation.append("[i] = ");
            string = a.getName();
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("[i];");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }
}

