/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.base.ILogger;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.etrice.generator.fsm.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private FileSystemHelpers _fileSystemHelpers;
    @Inject
    private Initialization initHelper;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        Functions.Function1<ProtocolClass, Boolean> function1 = new Functions.Function1<ProtocolClass, Boolean>(){

            public Boolean apply(ProtocolClass cl) {
                return ProtocolClassGen.this._fileSystemHelpers.isValidGenerationLocation((EObject)cl);
            }
        };
        Iterable iterable = IterableExtensions.filter((Iterable)root.getProtocolClasses(), (Functions.Function1)function1);
        for (ProtocolClass pc : iterable) {
            String string = this.roomExt.getGenerationTargetPath((EObject)pc);
            String string2 = this.roomExt.getPath((RoomClass)pc);
            String path = String.valueOf(string) + string2;
            String string3 = this.roomExt.getGenerationInfoPath((EObject)pc);
            String string4 = this.roomExt.getPath((RoomClass)pc);
            String infopath = String.valueOf(string3) + string4;
            CommunicationType communicationType = pc.getCommType();
            if (communicationType == null) continue;
            switch (communicationType) {
                case EVENT_DRIVEN: {
                    this.fileIO.generateFile("generating ProtocolClass declaration", path, infopath, this.stdExt.getCppHeaderFileName((RoomClass)pc), this.generateHeaderFile(root, pc));
                    this.fileIO.generateFile("generating ProtocolClass implementation", path, infopath, this.stdExt.getCppSourceFileName((RoomClass)pc), this.generateSourceFile(root, pc));
                    break;
                }
                case DATA_DRIVEN: {
                    this.fileIO.generateFile("generating ProtocolClass declaration", path, infopath, this.stdExt.getCppHeaderFileName((RoomClass)pc), this.generateDataDrivenHeaderFile(root, pc));
                    this.fileIO.generateFile("generating ProtocolClass implementation", path, infopath, this.stdExt.getCppSourceFileName((RoomClass)pc), this.generateDataDrivenSourceFile(root, pc));
                    break;
                }
                case SYNCHRONOUS: {
                    this.logger.logError("synchronous protocols not supported yet", (EObject)pc);
                    break;
                }
            }
        }
    }

    protected CharSequence generateHeaderFile(Root root, ProtocolClass pc) {
        String string;
        boolean bl;
        CharSequence charSequence;
        String string2;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Header File of ProtocolClass ");
        String string3 = pc.getName();
        stringConcatenation.append(string3, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this.stdExt.generateIncludeGuardBegin((RoomClass)pc, "");
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/modelbase/InterfaceItemBase.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/modelbase/PortBase.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/modelbase/ReplicatedInterfaceItemBase.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/modelbase/ReplicatedPortBase.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/etDatatypesCpp.hpp\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        Object object = root.getReferencedDataClasses((RoomClass)pc);
        for (DataClass dataClass : object) {
            stringConcatenation.append("#include \"");
            string2 = this.roomExt.getPath((RoomClass)dataClass);
            stringConcatenation.append(string2);
            charSequence = dataClass.getName();
            stringConcatenation.append(charSequence);
            stringConcatenation.append(".h\"");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        object = this.helpers.userCode(pc.getUserCode1());
        stringConcatenation.append(object);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string4 = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        stringConcatenation.append(string4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("class ");
        String string5 = pc.getName();
        stringConcatenation.append(string5);
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("   ");
        stringConcatenation.append("public:");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("/* message IDs */");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        string2 = this.genMessageIDs(pc);
        stringConcatenation.append(string2, "\t\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        charSequence = this.helpers.userCode(pc, 2);
        stringConcatenation.append((Object)charSequence, "\t\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("static bool isValidEvtID(int evtId) {");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t\t");
        stringConcatenation.append("return ((MSG_MIN < evtId) && (evtId < MSG_MAX));");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("static bool isValidOutgoingEvtID(int evtId) {");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t\t");
        stringConcatenation.append("return ((MSG_MIN < evtId) && (evtId < ");
        int n = pc.getIncomingMessages().size();
        boolean bl2 = bl = n == 0;
        if (bl) {
            stringConcatenation.append("MSG_MAX");
        } else {
            stringConcatenation.append("IN_");
            string = ((Message)pc.getIncomingMessages().get(0)).getName();
            stringConcatenation.append(string, "\t\t\t");
        }
        stringConcatenation.append("));");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("static bool isValidIncomingEvtID(int evtId) {");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t\t");
        stringConcatenation.append("return ((");
        n = pc.getIncomingMessages().size();
        boolean bl3 = bl = n == 0;
        if (bl) {
            stringConcatenation.append("MSG_MAX");
        } else {
            stringConcatenation.append("IN_");
            string = ((Message)pc.getIncomingMessages().get(0)).getName();
            stringConcatenation.append(string, "\t\t\t");
        }
        stringConcatenation.append(" <= evtId) && (evtId < MSG_MAX));");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("static const etRuntime::String& getMessageString(int msg_id);");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("private:");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("static const etRuntime::String s_messageStrings[];");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("};");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence3 = this.portClassDeclaration(pc, false);
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        CharSequence charSequence4 = this.portClassDeclaration(pc, true);
        stringConcatenation.append((Object)charSequence4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        string = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence5 = this.stdExt.generateIncludeGuardEnd((RoomClass)pc, "");
        stringConcatenation.append((Object)charSequence5);
        stringConcatenation.newLineIfNotEmpty();
        return stringConcatenation;
    }

    protected CharSequence portClassDeclaration(ProtocolClass pc, boolean conj) {
        CharSequence charSequence;
        CharSequence charSequence2;
        boolean bl;
        StringConcatenation stringConcatenation = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj);
        String portClassName = this.roomExt.getPortClassName(pc, conj);
        String replPortClassName = this.roomExt.getPortClassName(pc, conj, true);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.append("// ");
        if (conj) {
            stringConcatenation2.append("conjugated ");
        }
        stringConcatenation2.append("port class");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append(" : public etRuntime::PortBase {");
        stringConcatenation2.newLineIfNotEmpty();
        boolean bl2 = bl = !Objects.equal((Object)pclass, null);
        if (bl) {
            stringConcatenation2.append("\t");
            charSequence2 = this.helpers.userCode(pclass.getUserCode());
            stringConcatenation2.append((Object)charSequence2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("   ");
        stringConcatenation2.append("public:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t ");
        stringConcatenation2.append(portClassName, "\t ");
        stringConcatenation2.append("(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t ");
        stringConcatenation2.append(portClassName, "\t ");
        stringConcatenation2.append("(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId, int idx);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        bl = Main.getSettings().isGenerateMSCInstrumentation();
        if (bl) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("virtual void destroy();");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t ");
        stringConcatenation2.append("virtual void receive(const etRuntime::Message* m);");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        boolean bl3 = bl = !Objects.equal((Object)pclass, null);
        if (bl) {
            stringConcatenation2.append("\t");
            charSequence2 = this.helpers.attributes((List)pclass.getAttributes());
            stringConcatenation2.append((Object)charSequence2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            Iterator iterator = this.helpers.operationsDeclaration((List)pclass.getOperations(), portClassName);
            stringConcatenation2.append((Object)iterator, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t ");
        stringConcatenation2.append("// sent messages");
        stringConcatenation2.newLine();
        List list = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : list) {
            stringConcatenation2.append("\t");
            charSequence = this.messageSignature(m, false);
            stringConcatenation2.append((Object)charSequence, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            CharSequence charSequence3 = this.messageSignature(m, true);
            stringConcatenation2.append((Object)charSequence3, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.append("// ");
        if (conj) {
            stringConcatenation2.append("conjugated ");
        }
        stringConcatenation2.append("replicated port class");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append(" : public etRuntime::ReplicatedPortBase {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append(replPortClassName, "\t\t");
        stringConcatenation2.append("(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("int getReplication() const { return getNInterfaceItems(); }");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("int getIndexOf(const etRuntime::InterfaceItemBase& ifitem) const { return ifitem.getIdx(); }");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append(portClassName, "\t\t");
        stringConcatenation2.append("& get(int idx) const { return *dynamic_cast<");
        stringConcatenation2.append(portClassName, "\t\t");
        stringConcatenation2.append("*>(getInterfaceItem(idx)); }");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (conj) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("// incoming messages");
            stringConcatenation2.newLine();
            list = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : list) {
                stringConcatenation2.append("\t\t");
                charSequence = this.messageSignature(m_1, false);
                stringConcatenation2.append((Object)charSequence, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
        } else {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("// outgoing messages");
            stringConcatenation2.newLine();
            list = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : list) {
                stringConcatenation2.append("\t\t");
                charSequence = this.messageSignature(m_2, false);
                stringConcatenation2.append((Object)charSequence, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("protected:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("virtual etRuntime::InterfaceItemBase* createInterfaceItem(etRuntime::IInterfaceItemOwner* rcv, const etRuntime::String& name, int lid, int idx) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("return new ");
        stringConcatenation2.append(portClassName, "\t\t\t");
        stringConcatenation2.append("(rcv, name, lid, idx);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    protected CharSequence generateSourceFile(Root root, ProtocolClass pc) {
        String string;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Source File of ProtocolClass ");
        String string2 = pc.getName();
        stringConcatenation.append(string2, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string3 = this.stdExt.getCppHeaderFileName((RoomClass)pc);
        stringConcatenation.append(string3);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/debugging/DebuggingService.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/debugging/MSCFunctionObject.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/messaging/AbstractMessageReceiver.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/messaging/Address.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/messaging/Message.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/modelbase/IEventReceiver.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("using namespace etRuntime;");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        String string4 = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        stringConcatenation.append(string4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence = this.helpers.userCode(pc, 3);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* message names as strings for debugging (generate MSC) */");
        stringConcatenation.newLine();
        stringConcatenation.append("const String ");
        String string5 = pc.getName();
        stringConcatenation.append(string5);
        stringConcatenation.append("::s_messageStrings[] = {\"MIN\", ");
        Object object = this._roomHelpers.getAllOutgoingMessages(pc);
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            Message m = (Message)object2.next();
            stringConcatenation.append("\"");
            string = m.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("\",");
        }
        stringConcatenation.append(" ");
        object = this._roomHelpers.getAllIncomingMessages(pc);
        object2 = object.iterator();
        while (object2.hasNext()) {
            Message m_1 = (Message)object2.next();
            stringConcatenation.append("\"");
            string = m_1.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("\",");
        }
        stringConcatenation.append("\"MAX\"};");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("const String& ");
        object = pc.getName();
        stringConcatenation.append((String)object);
        stringConcatenation.append("::getMessageString(int msg_id) {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("if ((MSG_MIN < msg_id ) && ( msg_id < MSG_MAX )) {");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("return s_messageStrings[msg_id];");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("} else {");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("// id out of range");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("static const String errorMsg = \"Message ID out of range\";");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("return errorMsg;");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this.portClassImplementation(pc, false);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        object2 = this.portClassImplementation(pc, true);
        stringConcatenation.append(object2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        string = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    protected CharSequence portClassImplementation(ProtocolClass pc, boolean conj) {
        CharSequence charSequence;
        Object object;
        Object object2;
        boolean bl;
        StringConcatenation stringConcatenation = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj);
        String portClassName = this.roomExt.getPortClassName(pc, conj);
        String replPortClassName = this.roomExt.getPortClassName(pc, conj, true);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.append("// ");
        if (conj) {
            stringConcatenation2.append("conjugated ");
        }
        stringConcatenation2.append("port class");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append("::");
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append("(IInterfaceItemOwner* actor, const String& name, int localId)");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        CharSequence charSequence2 = this.generateConstructorInitalizerList(pclass, "0");
        stringConcatenation2.append((Object)charSequence2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append("::");
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append("(IInterfaceItemOwner* actor, const String& name, int localId, int idx)");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        CharSequence charSequence3 = this.generateConstructorInitalizerList(pclass, "idx");
        stringConcatenation2.append((Object)charSequence3, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        boolean bl2 = bl = !Objects.equal((Object)pclass, null);
        if (bl) {
            CharSequence charSequence4 = this.initHelper.genExtraInitializers((Iterable<Attribute>)pclass.getAttributes());
            stringConcatenation2.append((Object)charSequence4, "\t");
        }
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        bl = Main.getSettings().isGenerateMSCInstrumentation();
        if (bl) {
            stringConcatenation2.newLine();
            stringConcatenation2.append("void ");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append("::destroy() {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService::getInstance().removePortInstance(*this);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("PortBase::destroy();");
            stringConcatenation2.newLine();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append("::receive(const Message* msg) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// TODO JH further");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("if (! ");
        String string = pc.getName();
        stringConcatenation2.append(string, "\t");
        stringConcatenation2.append("::");
        if (conj) {
            stringConcatenation2.append("isValidOutgoingEvtID");
        } else {
            stringConcatenation2.append("isValidIncomingEvtID");
        }
        stringConcatenation2.append("(msg->getEvtId())) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("//std::cout << \"unknown\" << std::endl;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        boolean bl3 = Main.getSettings().isGenerateMSCInstrumentation();
        if (bl3) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService::getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), ");
            object2 = pc.getName();
            stringConcatenation2.append((String)object2, "\t");
            stringConcatenation2.append("::getMessageString(msg->getEvtId()).c_str());");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        bl3 = this.roomExt.handlesReceive(pc, conj);
        if (bl3) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("switch (msg->getEvtId()) {");
            stringConcatenation2.newLine();
            object2 = this.roomExt.getReceiveHandlers(pc, conj);
            object = object2.iterator();
            while (object.hasNext()) {
                MessageHandler hdlr = (MessageHandler)object.next();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("case ");
                charSequence = pc.getName();
                stringConcatenation2.append(charSequence, "\t\t");
                stringConcatenation2.append("::");
                String string2 = this.roomExt.getCodeName(hdlr.getMsg());
                stringConcatenation2.append(string2, "\t\t");
                stringConcatenation2.append(":");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLine();
                EList eList = hdlr.getDetailCode().getLines();
                for (String command : eList) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append(command, "\t\t\t\t");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("break;");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("default:");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("getActor()->receiveEvent(this, msg->getEvtId(),\tmsg->getData());");
        stringConcatenation2.newLine();
        bl3 = this.roomExt.handlesReceive(pc, conj);
        if (bl3) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("break;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        boolean bl4 = bl3 = !Objects.equal((Object)pclass, null);
        if (bl3) {
            object2 = this.helpers.operationsImplementation((List)pclass.getOperations(), portClassName);
            stringConcatenation2.append(object2);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("// sent messages");
        stringConcatenation2.newLine();
        List list = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : list) {
            object = this.sendMessage(m, pc.getName(), portClassName, conj);
            stringConcatenation2.append(object);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.append("// ");
        if (conj) {
            stringConcatenation2.append("conjugated ");
        }
        stringConcatenation2.append("replicated port class");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("//------------------------------------------------------------------------------------------------------------");
        stringConcatenation2.newLine();
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append("::");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append("(IInterfaceItemOwner* actor, const String& name, int localId) :");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("ReplicatedPortBase(actor, name, localId)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        if (conj) {
            stringConcatenation2.append("// incoming messages");
            stringConcatenation2.newLine();
            list = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : list) {
                object = this.messageSignatureDefinition(m_1, replPortClassName, false);
                stringConcatenation2.append(object);
                stringConcatenation2.append("{");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (Vector<etRuntime::InterfaceItemBase*>::iterator it = getItems().begin(); it != getItems().end(); ++it) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("(dynamic_cast<");
                stringConcatenation2.append(portClassName, "\t\t");
                stringConcatenation2.append("*>(*it))->");
                charSequence = this.messageCall(m_1, false);
                stringConcatenation2.append((Object)charSequence, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        } else {
            stringConcatenation2.append("// outgoing messages");
            stringConcatenation2.newLine();
            list = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : list) {
                object = this.messageSignatureDefinition(m_2, replPortClassName, false);
                stringConcatenation2.append(object);
                stringConcatenation2.append("{");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (Vector<etRuntime::InterfaceItemBase*>::iterator it = getItems().begin(); it != getItems().end(); ++it) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("(dynamic_cast<");
                stringConcatenation2.append(portClassName, "\t\t");
                stringConcatenation2.append("*>(*it))->");
                charSequence = this.messageCall(m_2, false);
                stringConcatenation2.append((Object)charSequence, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateConstructorInitalizerList(PortClass pc, String index) {
        boolean bl;
        CharSequence charSequence = null;
        final Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList((Object[])new CharSequence[0]);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("PortBase(actor, name, localId, ");
        stringConcatenation.append(index);
        stringConcatenation.append(")");
        initList.add(stringConcatenation.toString());
        boolean bl2 = bl = !Objects.equal((Object)pc, null);
        if (bl) {
            Functions.Function1<Attribute, String> function1 = new Functions.Function1<Attribute, String>(){

                public String apply(Attribute it) {
                    StringConcatenation stringConcatenation = new StringConcatenation();
                    String string = it.getName();
                    stringConcatenation.append(string);
                    stringConcatenation.append("(");
                    String string2 = initHelper.getInitializerListValue(it);
                    stringConcatenation.append(string2);
                    stringConcatenation.append(")");
                    return stringConcatenation.toString();
                }
            };
            List list = ListExtensions.map((List)pc.getAttributes(), (Functions.Function1)function1);
            Iterables.addAll((Collection)initList, (Iterable)list);
        }
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    protected CharSequence messageCall(Message m, boolean impl) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = m.getName();
        stringConcatenation.append(string);
        if (impl) {
            stringConcatenation.append("_impl");
        }
        stringConcatenation.append("(");
        VarDecl varDecl = m.getData();
        boolean bl2 = bl = !Objects.equal((Object)varDecl, null);
        if (bl) {
            stringConcatenation.append(" ");
            String string2 = m.getData().getName();
            stringConcatenation.append(string2);
        }
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    protected CharSequence messageSignature(Message m, boolean impl) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        if (m.isPriv() || impl) {
            stringConcatenation.append("private:");
        } else {
            stringConcatenation.append("public:");
        }
        stringConcatenation.append(" void ");
        String string = m.getName();
        stringConcatenation.append(string);
        if (impl) {
            stringConcatenation.append("_impl");
        }
        stringConcatenation.append("(");
        VarDecl varDecl = m.getData();
        boolean bl2 = bl = !Objects.equal((Object)varDecl, null);
        if (bl) {
            String string2 = this.helpers.signatureString(m.getData().getRefType());
            stringConcatenation.append(string2);
            stringConcatenation.append(" ");
            String string3 = m.getData().getName();
            stringConcatenation.append(string3);
        }
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    protected CharSequence messageSignatureDefinition(Message m, String classPrefix, boolean impl) {
        boolean bl;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("void ");
        stringConcatenation.append(classPrefix);
        stringConcatenation.append("::");
        String string = m.getName();
        stringConcatenation.append(string);
        if (impl) {
            stringConcatenation.append("_impl");
        }
        stringConcatenation.append("(");
        VarDecl varDecl = m.getData();
        boolean bl2 = bl = !Objects.equal((Object)varDecl, null);
        if (bl) {
            String string2 = this.helpers.signatureString(m.getData().getRefType());
            stringConcatenation.append(string2);
            stringConcatenation.append(" ");
            String string3 = m.getData().getName();
            stringConcatenation.append(string3);
        }
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    protected CharSequence sendMessage(Message m, String portClassName, String classPrefix, boolean conj) {
        Object object;
        boolean bl;
        Object object2;
        StringConcatenation stringConcatenation;
        String string;
        boolean bl2;
        StringConcatenation stringConcatenation2 = null;
        String string2 = null;
        string2 = conj ? "IN" : "OUT";
        String dir = string2;
        MessageHandler hdlr = this.roomExt.getSendHandler(m, conj);
        String string3 = null;
        VarDecl varDecl = m.getData();
        boolean bl3 = bl2 = !Objects.equal((Object)varDecl, null);
        if (bl2) {
            StringConcatenation stringConcatenation3 = new StringConcatenation();
            stringConcatenation3.append(", ");
            string = m.getData().getName();
            stringConcatenation3.append(string);
            string3 = stringConcatenation3.toString();
        }
        String dataArg = string3;
        string = null;
        if (!Objects.equal((Object)m.getData(), null) && !m.getData().getRefType().isRef()) {
            stringConcatenation = new StringConcatenation();
            stringConcatenation.append("DataMessage<");
            object2 = this._typeHelpers.typeName(m.getData().getRefType().getType());
            stringConcatenation.append((String)object2);
            stringConcatenation.append(">");
            string = stringConcatenation.toString();
        } else {
            stringConcatenation = new StringConcatenation();
            stringConcatenation.append("Message");
            string = stringConcatenation.toString();
        }
        String messageType = string;
        object2 = new StringConcatenation();
        object2.append("new (buffer) ");
        object2.append(messageType);
        object2.append("(getPeerAddress(), ");
        object2.append(portClassName);
        object2.append("::");
        object2.append(dir);
        object2.append("_");
        String string4 = m.getName();
        object2.append(string4);
        String string5 = null;
        string5 = dataArg != null ? dataArg : "";
        object2.append(string5);
        object2.append(")");
        String message = object2.toString();
        StringConcatenation stringConcatenation4 = new StringConcatenation();
        CharSequence charSequence = this.messageSignatureDefinition(m, classPrefix, false);
        stringConcatenation4.append((Object)charSequence);
        stringConcatenation4.append(" {");
        stringConcatenation4.newLineIfNotEmpty();
        boolean bl4 = bl = !Objects.equal((Object)hdlr, null);
        if (bl) {
            stringConcatenation4.append("\t");
            object = hdlr.getDetailCode().getLines();
            for (String command : object) {
                stringConcatenation4.append("\t");
                stringConcatenation4.append(command, "\t");
                stringConcatenation4.newLineIfNotEmpty();
            }
        } else {
            stringConcatenation4.append("\t");
            object = this.messageCall(m, true);
            stringConcatenation4.append(object, "\t");
            stringConcatenation4.append(";");
            stringConcatenation4.newLineIfNotEmpty();
        }
        stringConcatenation4.append("}");
        stringConcatenation4.newLine();
        stringConcatenation4.newLine();
        CharSequence charSequence2 = this.messageSignatureDefinition(m, classPrefix, true);
        stringConcatenation4.append((Object)charSequence2);
        stringConcatenation4.append(" {");
        stringConcatenation4.newLineIfNotEmpty();
        boolean bl5 = Main.getSettings().isGenerateMSCInstrumentation();
        if (bl5) {
            stringConcatenation4.append("\t");
            stringConcatenation4.append("DebuggingService::getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(),");
            stringConcatenation4.newLine();
            stringConcatenation4.append("\t");
            stringConcatenation4.append("\t");
            stringConcatenation4.append(portClassName, "\t\t");
            stringConcatenation4.append("::getMessageString(");
            stringConcatenation4.append(portClassName, "\t\t");
            stringConcatenation4.append("::");
            stringConcatenation4.append(dir, "\t\t");
            stringConcatenation4.append("_");
            String string6 = m.getName();
            stringConcatenation4.append(string6, "\t\t");
            stringConcatenation4.append(").c_str());");
            stringConcatenation4.newLineIfNotEmpty();
        }
        stringConcatenation4.append("\t");
        stringConcatenation4.append("if (getPeerAddress().isValid()) {");
        stringConcatenation4.newLine();
        stringConcatenation4.append("\t\t");
        stringConcatenation4.append("Message* buffer = dynamic_cast<IMessageService*>(getPeerMsgReceiver())->getMessageBuffer(sizeof(");
        stringConcatenation4.append(messageType, "\t\t");
        stringConcatenation4.append("));");
        stringConcatenation4.newLineIfNotEmpty();
        stringConcatenation4.append("\t\t");
        stringConcatenation4.append("if (buffer) {");
        stringConcatenation4.newLine();
        stringConcatenation4.append("\t\t\t");
        stringConcatenation4.append("getPeerMsgReceiver()->receive(");
        stringConcatenation4.append(message, "\t\t\t");
        stringConcatenation4.append(");");
        stringConcatenation4.newLineIfNotEmpty();
        stringConcatenation4.append("\t\t");
        stringConcatenation4.append("}");
        stringConcatenation4.newLine();
        stringConcatenation4.append("\t");
        stringConcatenation4.append("}");
        stringConcatenation4.newLine();
        stringConcatenation4.append("}");
        stringConcatenation4.newLine();
        stringConcatenation2 = stringConcatenation4;
        return stringConcatenation2;
    }

    protected CharSequence generateDataDrivenHeaderFile(Root root, ProtocolClass pc) {
        String string;
        CharSequence charSequence;
        Object object;
        String string2;
        String string3;
        CharSequence charSequence2;
        StringConcatenation stringConcatenation = null;
        Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl varDecl = m.getData();
                return !Objects.equal((Object)varDecl, null);
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)function1);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Header File of ProtocolClass ");
        String string4 = pc.getName();
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence3 = this.stdExt.generateIncludeGuardBegin((RoomClass)pc, "");
        stringConcatenation2.append((Object)charSequence3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/etDatatypesCpp.hpp\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/DataPort.h\"");
        stringConcatenation2.newLine();
        Object object2 = root.getReferencedDataClasses((RoomClass)pc);
        for (DataClass dataClass : object2) {
            stringConcatenation2.append("#include \"");
            charSequence2 = this.roomExt.getPath((RoomClass)dataClass);
            stringConcatenation2.append(charSequence2);
            string3 = dataClass.getName();
            stringConcatenation2.append(string3);
            stringConcatenation2.append(".h\"");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object2 = this.helpers.userCode(pc.getUserCode1());
        stringConcatenation2.append(object2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        String string5 = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        stringConcatenation2.append(string5);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        String string6 = pc.getName();
        stringConcatenation2.append(string6);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        charSequence2 = this.helpers.userCode(pc.getUserCode2());
        stringConcatenation2.append((Object)charSequence2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// send port holds data");
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        string3 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string3);
        stringConcatenation2.append(" : public etRuntime::DataSendPort {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        String string7 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string7, "\t");
        stringConcatenation2.append("(etRuntime::IRTObject* parent, const etRuntime::String& name, int localId);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// getters and setters");
        stringConcatenation2.newLine();
        for (Message msg : sentMsgs) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("void ");
            string2 = msg.getName();
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append("(");
            object = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(" ");
            charSequence = msg.getName();
            stringConcatenation2.append(charSequence, "\t");
            stringConcatenation2.append(") {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("m_");
            string = msg.getName();
            stringConcatenation2.append(string, "\t\t");
            stringConcatenation2.append(" = ");
            String string8 = msg.getName();
            stringConcatenation2.append(string8, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            String string9 = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            stringConcatenation2.append(string9, "\t");
            stringConcatenation2.append(" ");
            String string10 = msg.getName();
            stringConcatenation2.append(string10, "\t");
            stringConcatenation2.append("() const {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return m_");
            String string11 = msg.getName();
            stringConcatenation2.append(string11, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("private:");
        stringConcatenation2.newLine();
        for (Message msg_1 : sentMsgs) {
            stringConcatenation2.append("\t");
            string2 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append(" m_");
            object = msg_1.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// receive port accesses send port");
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        String string12 = this.roomExt.getPortClassName(pc, false);
        stringConcatenation2.append(string12);
        stringConcatenation2.append(" : public etRuntime::DataReceivePort {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        String string13 = this.roomExt.getPortClassName(pc, false);
        stringConcatenation2.append(string13, "\t");
        stringConcatenation2.append("(etRuntime::IRTObject* parent, const etRuntime::String& name, int localId);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// getters");
        stringConcatenation2.newLine();
        for (Message msg_2 : sentMsgs) {
            stringConcatenation2.append("\t");
            charSequence = this._typeHelpers.typeName(msg_2.getData().getRefType().getType());
            stringConcatenation2.append(charSequence, "\t");
            stringConcatenation2.append(" ");
            string = msg_2.getName();
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.append("() const;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("protected:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("virtual void connect(etRuntime::DataSendPort* dataSendPort);");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("private:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        string2 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string2, "\t");
        stringConcatenation2.append("* m_peer;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        object = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        stringConcatenation2.append((String)object);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        charSequence = this.stdExt.generateIncludeGuardEnd((RoomClass)pc, "");
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    protected CharSequence generateDataDrivenSourceFile(Root root, ProtocolClass pc) {
        String string;
        String string2;
        StringConcatenation stringConcatenation = null;
        Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl varDecl = m.getData();
                return !Objects.equal((Object)varDecl, null);
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)function1);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Source File of ProtocolClass ");
        String string3 = pc.getName();
        stringConcatenation2.append(string3, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string4 = this.stdExt.getCppHeaderFileName((RoomClass)pc);
        stringConcatenation2.append(string4);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("using namespace etRuntime;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        String string5 = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        stringConcatenation2.append(string5);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence = this.helpers.userCode(pc.getUserCode3());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// send port holds data");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// constructor");
        stringConcatenation2.newLine();
        String string6 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string6);
        stringConcatenation2.append("::");
        String string7 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string7);
        stringConcatenation2.append("(IRTObject* parent, const String& name, int localId) :");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("DataSendPort(parent, name, localId)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// receive port accesses send port");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// constructor");
        stringConcatenation2.newLine();
        String string8 = this.roomExt.getPortClassName(pc, false);
        stringConcatenation2.append(string8);
        stringConcatenation2.append("::");
        String string9 = this.roomExt.getPortClassName(pc, false);
        stringConcatenation2.append(string9);
        stringConcatenation2.append("(IRTObject* parent, const String& name, int localId) :");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("DataReceivePort(parent, name, localId),");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("m_peer(0)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("// getters");
        stringConcatenation2.newLine();
        for (Message msg : sentMsgs) {
            string2 = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            stringConcatenation2.append(string2);
            stringConcatenation2.append(" ");
            string = this.roomExt.getPortClassName(pc, false);
            stringConcatenation2.append(string);
            stringConcatenation2.append("::");
            String string10 = msg.getName();
            stringConcatenation2.append(string10);
            stringConcatenation2.append("() const {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("// TODO needs default value");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("//if (m_peer == 0)");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/*\treturn ");
            String string11 = this.stdExt.defaultValue(msg.getData().getRefType().getType());
            stringConcatenation2.append(string11, "\t");
            stringConcatenation2.append("; */");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return m_peer->");
            String string12 = msg.getName();
            stringConcatenation2.append(string12, "\t");
            stringConcatenation2.append("();");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        String string13 = this.roomExt.getPortClassName(pc, false);
        stringConcatenation2.append(string13);
        stringConcatenation2.append("::connect(DataSendPort* dataSendPort) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        String string14 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string14, "\t");
        stringConcatenation2.append("* peer = dynamic_cast<");
        string2 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string2, "\t");
        stringConcatenation2.append("*>(dataSendPort);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("if (peer != 0)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("m_peer = peer;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        string = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        stringConcatenation2.append(string);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public String getMessageID(Message msg, InterfaceItem item) {
        if (item instanceof Port) {
            Port p = (Port)item;
            String string = null;
            boolean bl = p.isConjugated();
            string = bl ? "OUT_" : "IN_";
            String direction = string;
            String string2 = p.getProtocol().getName();
            String string3 = msg.getName();
            String string4 = String.valueOf(direction) + string3;
            return this.enumInUse(string2, string4);
        }
        if (item instanceof SAP) {
            SAP sap = (SAP)item;
            String string = sap.getProtocol().getName();
            String string5 = msg.getName();
            String string6 = "OUT_" + string5;
            return this.enumInUse(string, string6);
        }
        if (item instanceof SPP) {
            SPP spp = (SPP)item;
            String string = spp.getProtocol().getName();
            String string7 = msg.getName();
            String string8 = "IN_" + string7;
            return this.enumInUse(string, string8);
        }
        return "unknown interface item";
    }

    protected String enumInUse(String namespace, String member) {
        return String.valueOf(namespace) + "::" + member;
    }
}

