/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public CharSequence genExtra(ExpandedModelComponent xpac, boolean generateImplementation) {
        StringConcatenation stringConcatenation = null;
        ArrayList states = CollectionLiterals.newArrayList((Object[])new State[0]);
        ModelComponent ac = xpac.getModelComponent();
        String clsName = xpac.getModelComponent().getComponentName();
        while (!Objects.equal((Object)ac, null)) {
            states.addAll(0, this._roomExtensions.getLeafStatesLast(this._fSMHelpers.getAllBaseStates(ac)));
            ac = ac.getBase();
        }
        StringConcatenation stringConcatenation2 = null;
        if (generateImplementation) {
            int n;
            StringConcatenation stringConcatenation3 = new StringConcatenation();
            if (Main.getSettings().isGenerateMSCInstrumentation() || Main.getSettings().isGenerateWithVerboseOutput()) {
                stringConcatenation3.append("// state names");
                stringConcatenation3.newLine();
                stringConcatenation3.append("const String ");
                stringConcatenation3.append(clsName);
                stringConcatenation3.append("::s_stateStrings[] = {");
                stringConcatenation3.newLineIfNotEmpty();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("\"<no state>\",");
                stringConcatenation3.newLine();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("\"<top>\",");
                stringConcatenation3.newLine();
                n = 0;
                for (State state : states) {
                    if (n == 0) {
                        n = 1;
                    } else {
                        stringConcatenation3.appendImmediate((Object)",", "\t");
                    }
                    stringConcatenation3.append("\t");
                    stringConcatenation3.append("\"");
                    String string = this._codegenHelpers.getGenStatePathName(state);
                    stringConcatenation3.append(string, "\t");
                    stringConcatenation3.append("\"");
                    stringConcatenation3.newLineIfNotEmpty();
                }
                stringConcatenation3.append("};");
                stringConcatenation3.newLine();
            }
            stringConcatenation3.append("const int ");
            stringConcatenation3.append(clsName);
            stringConcatenation3.append("::s_numberOfStates = ");
            n = states.size();
            int n2 = 2 + n;
            stringConcatenation3.append((Object)n2);
            stringConcatenation3.append(";");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation3.newLine();
            stringConcatenation3.append("void ");
            stringConcatenation3.append(clsName);
            stringConcatenation3.append("::setState(int new_state) {");
            stringConcatenation3.newLineIfNotEmpty();
            boolean bl = Main.getSettings().isGenerateMSCInstrumentation();
            if (bl) {
                stringConcatenation3.append("\t");
                stringConcatenation3.append("DebuggingService::getInstance().addActorState(*this, s_stateStrings[new_state].c_str());");
                stringConcatenation3.newLine();
            }
            if (bl = Main.getSettings().isGenerateWithVerboseOutput()) {
                stringConcatenation3.append("\t");
                stringConcatenation3.append("if (s_stateStrings[new_state] != \"Idle\") {");
                stringConcatenation3.newLine();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("\t");
                stringConcatenation3.append("std::cout << getInstancePath().c_str() << \" -> \" << s_stateStrings[new_state].c_str() << std::endl;");
                stringConcatenation3.newLine();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("}");
                stringConcatenation3.newLine();
            }
            stringConcatenation3.append("\t");
            stringConcatenation3.append("m_state = new_state;");
            stringConcatenation3.newLine();
            stringConcatenation3.append("}");
            stringConcatenation3.newLine();
            stringConcatenation2 = stringConcatenation3;
        } else {
            StringConcatenation stringConcatenation4 = new StringConcatenation();
            if (Main.getSettings().isGenerateMSCInstrumentation() || Main.getSettings().isGenerateWithVerboseOutput()) {
                stringConcatenation4.append("static const String s_stateStrings[];");
                stringConcatenation4.newLine();
            }
            stringConcatenation4.append("static const int s_numberOfStates;");
            stringConcatenation4.newLine();
            stringConcatenation4.newLine();
            stringConcatenation4.append("int history[");
            int n = states.size();
            int n3 = 2 + n;
            stringConcatenation4.append((Object)n3);
            stringConcatenation4.append("];");
            stringConcatenation4.newLineIfNotEmpty();
            stringConcatenation4.newLine();
            stringConcatenation4.append("void setState(int new_state);");
            stringConcatenation4.newLine();
            stringConcatenation2 = stringConcatenation4;
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public String stateType() {
        return "etInt16";
    }

    public String boolType() {
        return "etBool";
    }
}

