/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support;

import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionChainStartTransition;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IFSMDialogFactory;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.ITransitionPropertyDialog;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMEditor;
import org.eclipse.etrice.ui.behavior.fsm.editor.DecoratorUtil;
import org.eclipse.etrice.ui.behavior.fsm.provider.IInjectorProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.FSMSupportUtil;
import org.eclipse.etrice.ui.behavior.fsm.support.QuickFixFeature;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.etrice.ui.common.base.support.CantRemoveFeature;
import org.eclipse.etrice.ui.common.base.support.ChangeAwareCreateConnectionFeature;
import org.eclipse.etrice.ui.common.base.support.ChangeAwareCustomFeature;
import org.eclipse.etrice.ui.common.base.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.common.base.support.RemoveBendpointsFeature;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveBendpointFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultAddBendpointFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveBendpointFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveBendpointFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pair;

public class TransitionSupport {
    private static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    private static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    private static final IColorConstant FILL_COLOR = new ColorConstant(255, 255, 255);
    private static final int LINE_WIDTH = 1;
    private static final String newLine = Strings.newLine();
    private static final int newLineLength = Strings.newLine().length();
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public TransitionSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            EObject bo;
            PictogramElement pe = context.getPictogramElements()[0];
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Transition) {
                Transition trans = (Transition)bo;
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagramTypeProvider().getDiagram());
                boolean editable = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)trans) == mc;
                return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider(), editable);
            }
            return null;
        }

        public Object getToolTip(GraphicsAlgorithm ga) {
            EObject bo;
            PictogramElement pe = ga.getPictogramElement();
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof Transition) {
                Transition tr = (Transition)bo;
                String label = FSMSupportUtil.getInstance().getFSMNameProvider().getTransitionLabelName(tr);
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagramTypeProvider().getDiagram());
                String code = FSMSupportUtil.getInstance().getFSMHelpers().getAllActionCode(tr, mc);
                if (code != null && !code.isEmpty()) {
                    if (label.length() > 0) {
                        label = String.valueOf(label) + "\n";
                    }
                    label = String.valueOf(label) + "action:\n" + code;
                }
                return label;
            }
            return super.getToolTip(ga);
        }

        public IDecorator[] getDecorators(PictogramElement pe) {
            if (pe.isVisible()) {
                int xOrigin = -20;
                int yOrigin = 0;
                int xGap = 0;
                int yGap = -10;
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)pe.eContainer());
                ArrayList<Diagnostic> diagnostics = ((AbstractFSMEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getDiagnosingModelObserver().getElementDiagonsticMap().get(bo);
                ArrayList<IDecorator> decorators = DecoratorUtil.getMarkersFromDiagnostics(diagnostics);
                if (!decorators.isEmpty()) {
                    int i = 0;
                    for (IDecorator decorator : decorators) {
                        ((ImageDecorator)decorator).setX(xOrigin + i * xGap);
                        ((ImageDecorator)decorator).setY(yOrigin + i * yGap);
                        ++i;
                    }
                    return decorators.toArray(new IDecorator[decorators.size()]);
                }
            }
            return super.getDecorators(pe);
        }
    }

    static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return new ICreateConnectionFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            return new ReconnectionFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new CantRemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public IAddBendpointFeature getAddBendpointFeature(IAddBendpointContext context) {
            return new DefaultAddBendpointFeature(this.fp){

                public boolean canAddBendpoint(IAddBendpointContext context) {
                    Transition trans = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                    return !FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                }
            };
        }

        public IRemoveBendpointFeature getRemoveBendpointFeature(IRemoveBendpointContext context) {
            return new DefaultRemoveBendpointFeature(this.fp){

                public boolean canRemoveBendpoint(IRemoveBendpointContext context) {
                    Transition trans = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                    return !FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                }
            };
        }

        public IMoveBendpointFeature getMoveBendpointFeature(IMoveBendpointContext context) {
            return new DefaultMoveBendpointFeature(this.fp){

                public boolean canMoveBendpoint(IMoveBendpointContext context) {
                    Transition trans = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                    return !FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                }
            };
        }

        public IMoveConnectionDecoratorFeature getMoveConnectionDecoratorFeature(IMoveConnectionDecoratorContext context) {
            return new DefaultMoveConnectionDecoratorFeature(this.fp){

                public boolean canMoveConnectionDecorator(IMoveConnectionDecoratorContext context) {
                    Transition trans = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnectionDecorator().getConnection());
                    return !FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                }
            };
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            ArrayList<Diagnostic> diagnostics;
            PictogramElement pe = context.getPictogramElements()[0];
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            ArrayList<Object> result = new ArrayList<Object>();
            if (bo instanceof Transition) {
                boolean editable;
                Transition trans = (Transition)bo;
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagramTypeProvider().getDiagram());
                boolean bl = editable = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)trans) == mc;
                if (!editable && mc.getStateMachine() != null) {
                    for (RefinedTransition rt : mc.getStateMachine().getRefinedTransitions()) {
                        if (rt.getTarget() != trans) continue;
                        editable = true;
                        break;
                    }
                }
                result.add((Object)new PropertyFeature(this.fp, editable));
                if (!editable) {
                    result.add((Object)new RefineTransitionFeature(this.fp));
                }
                RemoveBendpointsFeature removeAllBendpoints = new RemoveBendpointsFeature(this.fp){

                    public boolean canExecute(ICustomContext context) {
                        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
                        return !FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)((Transition)bo));
                    }
                };
                result.add(removeAllBendpoints);
            }
            if ((diagnostics = ((AbstractFSMEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getDiagnosingModelObserver().getElementDiagonsticMap().get(bo)) != null) {
                result.add((Object)new QuickFixFeature(this.fp));
            }
            ICustomFeature[] features = new ICustomFeature[result.size()];
            return result.toArray(features);
        }

        protected static void updateLabel(Transition trans, Connection conn, Color fillColor) {
            if (conn.getConnectionDecorators().size() < 2) {
                return;
            }
            ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(0);
            if (cd.getGraphicsAlgorithm() instanceof Polygon) {
                Polygon p = (Polygon)cd.getGraphicsAlgorithm();
                p.setBackground(fillColor);
            }
            if ((cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text) {
                Text label = (Text)cd.getGraphicsAlgorithm();
                label.setValue(FeatureProvider.getLabel(trans));
            }
        }

        protected static String getLabel(Transition trans) {
            IPreferenceStore store = UIBaseActivator.getDefault().getPreferenceStore();
            int MAX_LINE_LENGTH = store.getInt("MaxLabelLineLength");
            int MAX_LINES = store.getInt("MaxLabelLines");
            String label = FSMSupportUtil.getInstance().getFSMNameProvider().getTransitionLabelName(trans);
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i + MAX_LINE_LENGTH < label.length()) {
                result.append(String.valueOf(label.substring(i, i + MAX_LINE_LENGTH)) + newLine);
                i += MAX_LINE_LENGTH;
            }
            result.append(label.subSequence(i, label.length()));
            int maxLen = (MAX_LINE_LENGTH + newLineLength) * MAX_LINES - newLineLength;
            if (result.length() > maxLen) {
                return String.valueOf(result.substring(0, maxLen)) + "...";
            }
            return result.toString();
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context instanceof IAddConnectionContext && context.getNewObject() instanceof Transition;
            }

            public PictogramElement add(IAddContext context) {
                IAddConnectionContext addConContext = (IAddConnectionContext)context;
                Transition trans = (Transition)context.getNewObject();
                ContainerShape container = ((ContainerShape)addConContext.getTargetAnchor().getParent()).getContainer();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                if (!(bo instanceof StateGraph)) {
                    container = container.getContainer();
                }
                boolean inherited = FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
                connection.setStart(addConContext.getSourceAnchor());
                connection.setEnd(addConContext.getTargetAnchor());
                if (addConContext.getSourceAnchor() == addConContext.getTargetAnchor()) {
                    Point pt = this.createSelfTransitionBendPoint(connection);
                    connection.getBendpoints().add((Object)pt);
                }
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "obj-type", "trans");
                IGaService gaService = Graphiti.getGaService();
                Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
                Color lineColor = this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR);
                polyline.setForeground(lineColor);
                polyline.setLineWidth(Integer.valueOf(1));
                ConnectionDecorator cd = peCreateService.createConnectionDecorator((Connection)connection, false, 1.0, true);
                Color fillColor = FSMSupportUtil.getInstance().getFSMHelpers().hasDetailCode(trans.getAction()) ? lineColor : this.manageColor(FILL_COLOR);
                this.createArrow((GraphicsAlgorithmContainer)cd, lineColor, fillColor);
                ConnectionDecorator textDecorator = peCreateService.createConnectionDecorator((Connection)connection, true, 0.5, true);
                Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)textDecorator, FeatureProvider.getLabel(trans));
                text.setForeground(lineColor);
                gaService.setLocation((GraphicsAlgorithm)text, 10, 0);
                this.link((PictogramElement)connection, trans);
                return connection;
            }

            private Point createSelfTransitionBendPoint(FreeFormConnection connection) {
                ILocation begin = Graphiti.getPeService().getLocationRelativeToDiagram(connection.getStart());
                int deltaX = 0;
                int deltaY = 120;
                return Graphiti.getGaService().createPoint(begin.getX() + deltaX, begin.getY() + deltaY);
            }

            private Polyline createArrow(GraphicsAlgorithmContainer gaContainer, Color lineColor, Color fillColor) {
                IGaService gaService = Graphiti.getGaService();
                int[] nArray = new int[6];
                nArray[0] = -15;
                nArray[1] = 5;
                nArray[4] = -15;
                nArray[5] = -5;
                Polygon polygon = gaService.createPolygon(gaContainer, nArray);
                polygon.setForeground(lineColor);
                polygon.setBackground(fillColor);
                polygon.setLineWidth(Integer.valueOf(1));
                return polygon;
            }
        }

        private class CreateFeature
        extends ChangeAwareCreateConnectionFeature {
            public CreateFeature(IFeatureProvider fp) {
                super(fp, "Transition", "create Transition");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.behavior.transition";
            }

            public boolean canCreate(ICreateConnectionContext context) {
                return FSMSupportUtil.getInstance().canConnect(context.getSourceAnchor(), context.getTargetAnchor(), (ContainerShape)context.getSourcePictogramElement().eContainer(), FeatureProvider.this.fp);
            }

            public boolean canStartConnection(ICreateConnectionContext context) {
                TransitionTerminal src = FSMSupportUtil.getInstance().getTransitionTerminal(context.getSourceAnchor(), FeatureProvider.this.fp);
                if (src == null && !FSMSupportUtil.getInstance().isInitialPoint(context.getSourceAnchor(), FeatureProvider.this.fp)) {
                    return false;
                }
                StateGraph sg = FSMSupportUtil.getInstance().getStateGraph((ContainerShape)context.getSourcePictogramElement().eContainer(), FeatureProvider.this.fp);
                if (sg == null) {
                    return false;
                }
                return FSMSupportUtil.getInstance().getFSMValidationUtil().isConnectable(src, sg).isOk();
            }

            public Connection doCreate(ICreateConnectionContext context) {
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                TransitionTerminal src = FSMSupportUtil.getInstance().getTransitionTerminal(context.getSourceAnchor(), FeatureProvider.this.fp);
                TransitionTerminal dst = FSMSupportUtil.getInstance().getTransitionTerminal(context.getTargetAnchor(), FeatureProvider.this.fp);
                StateGraph sg = FSMSupportUtil.getInstance().getStateGraph((ContainerShape)context.getSourcePictogramElement().eContainer(), FeatureProvider.this.fp);
                if (dst != null && sg != null) {
                    boolean inherited;
                    InitialTransition trans = null;
                    if (src == null) {
                        InitialTransition t = FSMFactory.eINSTANCE.createInitialTransition();
                        t.setTo(dst);
                        trans = t;
                    } else if (src instanceof SubStateTrPointTerminal || src instanceof TrPointTerminal && ((TrPointTerminal)src).getTrPoint() instanceof EntryPoint) {
                        ContinuationTransition t = FSMFactory.eINSTANCE.createContinuationTransition();
                        t.setFrom(src);
                        t.setTo(dst);
                        trans = t;
                    } else if (src instanceof ChoicepointTerminal) {
                        ContinuationTransition t;
                        boolean dfltBranch = true;
                        for (Transition tr : FSMSupportUtil.getInstance().getFSMHelpers().getAllTransitions(sg)) {
                            TransitionTerminal from;
                            if (!(tr instanceof ContinuationTransition) || !((from = ((ContinuationTransition)tr).getFrom()) instanceof ChoicepointTerminal) || ((ChoicepointTerminal)from).getCp() != ((ChoicepointTerminal)src).getCp()) continue;
                            dfltBranch = false;
                        }
                        Object object = t = dfltBranch ? FSMFactory.eINSTANCE.createContinuationTransition() : FSMFactory.eINSTANCE.createCPBranchTransition();
                        if (t instanceof CPBranchTransition) {
                            DetailCode dc = FSMFactory.eINSTANCE.createDetailCode();
                            dc.setUsed(false);
                            ((CPBranchTransition)t).setCondition(dc);
                        }
                        t.setFrom(src);
                        t.setTo(dst);
                        trans = t;
                    } else {
                        GuardedTransition t = null;
                        switch (mc.getCommType()) {
                            case DATA_DRIVEN: {
                                t = FSMFactory.eINSTANCE.createGuardedTransition();
                                break;
                            }
                            case ASYNCHRONOUS: {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                MessageDialog dlg = new MessageDialog(shell, "Create new transition", null, "Select the kind of transition", 3, new String[]{"triggered", "guarded"}, 0);
                                switch (dlg.open()) {
                                    case 0: {
                                        t = FSMFactory.eINSTANCE.createTriggeredTransition();
                                        break;
                                    }
                                    case 1: {
                                        t = FSMFactory.eINSTANCE.createGuardedTransition();
                                    }
                                }
                                break;
                            }
                            case EVENT_DRIVEN: {
                                t = FSMFactory.eINSTANCE.createTriggeredTransition();
                                break;
                            }
                            case SYNCHRONOUS: {
                                break;
                            }
                        }
                        if (t == null) {
                            return null;
                        }
                        t.setFrom(src);
                        t.setTo(dst);
                        trans = t;
                    }
                    if (trans instanceof InitialTransition) {
                        trans.setName(FSMSupportUtil.getInstance().getFSMNewNamingUtil().getUniqueName("init", sg));
                    } else {
                        trans.setName(FSMSupportUtil.getInstance().getFSMNewNamingUtil().getUniqueName("tr", sg));
                    }
                    ContainerShape targetContainer = FSMSupportUtil.getInstance().getStateGraphContainer((ContainerShape)context.getSourcePictogramElement().eContainer());
                    boolean bl = inherited = !EcoreUtil.isAncestor((EObject)FSMSupportUtil.getInstance().getModelComponent(this.getDiagram()), (EObject)sg);
                    if (inherited) {
                        sg = FSMSupportUtil.getInstance().insertRefinedState(sg, mc, targetContainer, this.getFeatureProvider());
                    }
                    sg.getTransitions().add((Object)trans);
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Injector injector = ((IInjectorProvider)this.getFeatureProvider()).getInjector();
                    IFSMDialogFactory factory = (IFSMDialogFactory)injector.getInstance(IFSMDialogFactory.class);
                    ITransitionPropertyDialog dlg = factory.createTransitionPropertyDialog(shell, FSMSupportUtil.getInstance().getModelComponent(this.getDiagram()), (Transition)trans);
                    if (dlg.open() == 0) {
                        AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                        addContext.setNewObject((Object)trans);
                        return (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
                    }
                }
                return null;
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (pe instanceof ConnectionDecorator) {
                    pe = (PictogramElement)pe.eContainer();
                }
                if (!(pe instanceof Connection)) {
                    return false;
                }
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo instanceof Transition) {
                    boolean inherited = FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)((Transition)bo));
                    return !inherited;
                }
                return false;
            }
        }

        private static class PropertyFeature
        extends ChangeAwareCustomFeature {
            private boolean editable;

            public PropertyFeature(IFeatureProvider fp, boolean editable) {
                super(fp);
                this.editable = editable;
            }

            public String getName() {
                return this.editable ? "Edit Transition..." : "View Transition";
            }

            public String getDescription() {
                return this.editable ? "Edit Transition Properties" : "View Transition Properties";
            }

            private Pair<Connection, Transition> getTransition(ICustomContext context) {
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1) {
                    PictogramElement pe = pes[0];
                    if (pe instanceof ConnectionDecorator) {
                        pe = (PictogramElement)pe.eContainer();
                    }
                    if (!(pe instanceof Connection)) {
                        return null;
                    }
                    Object bo = this.getBusinessObjectForPictogramElement(pe);
                    if (bo instanceof Transition) {
                        return new Pair((Object)((Connection)pe), (Object)((Transition)bo));
                    }
                }
                return null;
            }

            public boolean canExecute(ICustomContext context) {
                return this.getTransition(context) != null;
            }

            public boolean doExecute(ICustomContext context) {
                ModelComponent mc;
                Pair<Connection, Transition> pair = this.getTransition(context);
                Transition trans = (Transition)pair.getValue();
                Connection conn = (Connection)pair.getKey();
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                Injector injector = ((IInjectorProvider)this.getFeatureProvider()).getInjector();
                IFSMDialogFactory factory = (IFSMDialogFactory)injector.getInstance(IFSMDialogFactory.class);
                ITransitionPropertyDialog dlg = factory.createTransitionPropertyDialog(shell, mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram()), trans);
                if (dlg.open() == 0) {
                    boolean inherited = FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                    Color lineColor = inherited ? this.manageColor(INHERITED_COLOR) : this.manageColor(LINE_COLOR);
                    Color fillColor = FSMSupportUtil.getInstance().getFSMHelpers().hasActionCode(trans, mc) ? lineColor : this.manageColor(FILL_COLOR);
                    FeatureProvider.updateLabel(trans, conn, fillColor);
                    return true;
                }
                return false;
            }
        }

        private class ReconnectionFeature
        extends DefaultReconnectionFeature {
            private boolean doneChanges;

            public ReconnectionFeature(IFeatureProvider fp) {
                super(fp);
                this.doneChanges = false;
            }

            public boolean canReconnect(IReconnectionContext context) {
                if (!super.canReconnect(context)) {
                    return false;
                }
                Transition trans = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                boolean inherited = FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                if (inherited) {
                    return false;
                }
                Anchor src = context.getConnection().getStart();
                Anchor tgt = context.getConnection().getEnd();
                if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                    src = context.getNewAnchor();
                } else {
                    tgt = context.getNewAnchor();
                }
                return FSMSupportUtil.getInstance().canConnect(src, tgt, trans, (ContainerShape)context.getTargetPictogramElement().eContainer(), FeatureProvider.this.fp);
            }

            public void postReconnect(IReconnectionContext context) {
                InitialTransition t;
                super.postReconnect(context);
                TransitionTerminal src = FSMSupportUtil.getInstance().getTransitionTerminal(context.getConnection().getStart(), FeatureProvider.this.fp);
                TransitionTerminal dst = FSMSupportUtil.getInstance().getTransitionTerminal(context.getConnection().getEnd(), FeatureProvider.this.fp);
                StateGraph sg = FSMSupportUtil.getInstance().getStateGraph((ContainerShape)context.getTargetPictogramElement().eContainer(), FeatureProvider.this.fp);
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                Transition orig = (Transition)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                InitialTransition trans = null;
                if (src == null) {
                    t = orig instanceof InitialTransition ? (InitialTransition)orig : FSMFactory.eINSTANCE.createInitialTransition();
                    t.setTo(dst);
                    trans = t;
                } else if (src instanceof SubStateTrPointTerminal || src instanceof TrPointTerminal && ((TrPointTerminal)src).getTrPoint() instanceof EntryPoint) {
                    t = orig instanceof ContinuationTransition ? (ContinuationTransition)orig : FSMFactory.eINSTANCE.createContinuationTransition();
                    t.setFrom(src);
                    t.setTo(dst);
                    trans = t;
                } else if (src instanceof ChoicepointTerminal) {
                    t = null;
                    if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                        boolean dfltBranch = true;
                        for (Transition tr : FSMSupportUtil.getInstance().getFSMHelpers().getAllTransitions(sg)) {
                            TransitionTerminal from;
                            if (!(tr instanceof ContinuationTransition) || !((from = ((ContinuationTransition)tr).getFrom()) instanceof ChoicepointTerminal) || ((ChoicepointTerminal)from).getCp() != ((ChoicepointTerminal)src).getCp()) continue;
                            dfltBranch = false;
                        }
                        t = dfltBranch ? FSMFactory.eINSTANCE.createContinuationTransition() : FSMFactory.eINSTANCE.createCPBranchTransition();
                    } else {
                        t = (NonInitialTransition)orig;
                    }
                    t.setFrom(src);
                    t.setTo(dst);
                    trans = t;
                } else {
                    t = null;
                    switch (mc.getCommType()) {
                        case EVENT_DRIVEN: {
                            if (orig instanceof TriggeredTransition) {
                                t = (TransitionChainStartTransition)orig;
                                break;
                            }
                            t = FSMFactory.eINSTANCE.createTriggeredTransition();
                            break;
                        }
                        case DATA_DRIVEN: {
                            if (orig instanceof GuardedTransition) {
                                t = (TransitionChainStartTransition)orig;
                                break;
                            }
                            t = FSMFactory.eINSTANCE.createGuardedTransition();
                            break;
                        }
                        case ASYNCHRONOUS: {
                            if (orig instanceof TriggeredTransition || orig instanceof GuardedTransition) {
                                t = (TransitionChainStartTransition)orig;
                                break;
                            }
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog dlg = new MessageDialog(shell, "Create new transition", null, "Select the kind of transition", 3, new String[]{"triggered", "guarded"}, 0);
                            switch (dlg.open()) {
                                case 0: {
                                    t = FSMFactory.eINSTANCE.createTriggeredTransition();
                                    break;
                                }
                                case 1: {
                                    t = FSMFactory.eINSTANCE.createGuardedTransition();
                                }
                            }
                            break;
                        }
                        case SYNCHRONOUS: {
                            break;
                        }
                    }
                    t.setFrom(src);
                    t.setTo(dst);
                    trans = t;
                }
                if (orig != trans) {
                    if (trans instanceof InitialTransition) {
                        trans.setName("init");
                    } else {
                        trans.setName(orig.getName());
                    }
                    trans.setAction(orig.getAction());
                    trans.setName(orig.getName());
                    sg.getTransitions().remove((Object)orig);
                    sg.getTransitions().add((Object)trans);
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Injector injector = ((IInjectorProvider)this.getFeatureProvider()).getInjector();
                    IFSMDialogFactory factory = (IFSMDialogFactory)injector.getInstance(IFSMDialogFactory.class);
                    ITransitionPropertyDialog dlg = factory.createTransitionPropertyDialog(shell, mc, (Transition)trans);
                    if (dlg.open() != 0) {
                        sg.getTransitions().add((Object)orig);
                        sg.getTransitions().remove((Object)trans);
                        if (context.getNewAnchor() == context.getConnection().getStart()) {
                            context.getConnection().setStart(context.getOldAnchor());
                        } else {
                            context.getConnection().setEnd(context.getOldAnchor());
                        }
                        return;
                    }
                    this.link((PictogramElement)context.getConnection(), trans);
                }
                this.doneChanges = true;
                Color fillColor = FSMSupportUtil.getInstance().getFSMHelpers().hasDetailCode(trans.getAction()) ? this.manageColor(LINE_COLOR) : this.manageColor(FILL_COLOR);
                FeatureProvider.updateLabel((Transition)trans, context.getConnection(), fillColor);
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private static class RefineTransitionFeature
        extends AbstractCustomFeature {
            public RefineTransitionFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Refine Transition";
            }

            public String getDescription() {
                return "Refine transition to add action code";
            }

            public boolean canExecute(ICustomContext context) {
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1) {
                    PictogramElement pe = pes[0];
                    if (pe instanceof ConnectionDecorator) {
                        pe = (PictogramElement)pe.eContainer();
                    }
                    if (!(pe instanceof Connection)) {
                        return false;
                    }
                    Object bo = this.getBusinessObjectForPictogramElement(pe);
                    if (bo instanceof Transition) {
                        return true;
                    }
                }
                return false;
            }

            public void execute(ICustomContext context) {
                ICustomFeature[] features;
                PictogramElement pe = context.getPictogramElements()[0];
                if (pe instanceof ConnectionDecorator) {
                    pe = (PictogramElement)pe.eContainer();
                }
                Transition trans = (Transition)this.getBusinessObjectForPictogramElement(pe);
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                if (mc.getStateMachine() == null) {
                    mc.setStateMachine(FSMFactory.eINSTANCE.createStateGraph());
                }
                RefinedTransition rt = FSMFactory.eINSTANCE.createRefinedTransition();
                rt.setTarget(trans);
                mc.getStateMachine().getRefinedTransitions().add((Object)rt);
                ICustomFeature[] iCustomFeatureArray = features = this.getFeatureProvider().getCustomFeatures(context);
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    ICustomFeature cf = iCustomFeatureArray[n2];
                    if (cf instanceof PropertyFeature) {
                        cf.execute(context);
                        break;
                    }
                    ++n2;
                }
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof Transition;
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"Transition deleted from model");
                }
                if (bo instanceof Transition) {
                    Transition t = (Transition)bo;
                    Connection conn = (Connection)context.getPictogramElement();
                    if (conn.getConnectionDecorators().size() >= 2) {
                        Text label;
                        ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(0);
                        if (cd.getGraphicsAlgorithm() instanceof Polygon) {
                            Color fillColor;
                            ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                            boolean inherited = FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)t);
                            Color lineColor = inherited ? this.manageColor(INHERITED_COLOR) : this.manageColor(LINE_COLOR);
                            boolean hasActionCode = FSMSupportUtil.getInstance().getFSMHelpers().hasActionCode(t, mc);
                            Color color = fillColor = hasActionCode ? lineColor : this.manageColor(FILL_COLOR);
                            if (!this.equal(cd.getGraphicsAlgorithm().getBackground(), fillColor)) {
                                return Reason.createTrueReason((String)"Arrow head needs update");
                            }
                        }
                        if ((cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text && !(label = (Text)cd.getGraphicsAlgorithm()).getValue().equals(FeatureProvider.getLabel(t))) {
                            return Reason.createTrueReason((String)"Label needs update");
                        }
                    }
                }
                return Reason.createFalseReason();
            }

            private boolean equal(Color c1, Color c2) {
                return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
            }

            public boolean update(IUpdateContext context) {
                Connection containerShape = (Connection)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                boolean updated = false;
                if (bo instanceof Transition) {
                    ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                    Transition trans = (Transition)bo;
                    Connection conn = (Connection)context.getPictogramElement();
                    boolean inherited = FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)trans);
                    Color lineColor = inherited ? this.manageColor(INHERITED_COLOR) : this.manageColor(LINE_COLOR);
                    boolean hasActionCode = FSMSupportUtil.getInstance().getFSMHelpers().hasActionCode(trans, mc);
                    Color fillColor = hasActionCode ? lineColor : this.manageColor(FILL_COLOR);
                    FeatureProvider.updateLabel(trans, conn, fillColor);
                    updated = true;
                    if (this.updateNeeded(context).toBoolean()) {
                        updated = false;
                    }
                }
                return updated;
            }
        }
    }
}

