/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.commands.RoomOpeningHelper;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.etrice.ui.common.base.support.BaseToolBehaviorProvider;
import org.eclipse.etrice.ui.common.base.support.CantRemoveFeature;
import org.eclipse.etrice.ui.common.base.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.common.commands.ChangeDiagramInputJob;
import org.eclipse.etrice.ui.structure.support.StructureClassUpdate;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StructureClassSupport {
    public static final int MARGIN = 40;
    private static final int LINE_WIDTH = 4;
    public static final int DEFAULT_SIZE_X = 800;
    public static final int DEFAULT_SIZE_Y = 500;
    private static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    private static final IColorConstant BACKGROUND = new ColorConstant(255, 255, 255);
    private FeatureProvider afp;
    private BehaviorProvider tbp;

    public StructureClassSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.afp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.afp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private class BehaviorProvider
    extends BaseToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(1);
            return rectangle;
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            IContextButtonPadData data = super.getContextButtonPad(context);
            CustomContext customContext = new CustomContext();
            ICustomFeature reconnectToModel = StructureClassSupport.this.afp.getCustomFeatures((ICustomContext)customContext)[1];
            if (reconnectToModel.isAvailable((IContext)customContext)) {
                ContextButtonEntry entry = new ContextButtonEntry((IFeature)reconnectToModel, (IContext)customContext);
                entry.setIconId("org.eclipse.graphiti.eclipse.quickassist");
                data.getDomainSpecificContextButtons().add(entry);
            }
            return data;
        }
    }

    private class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            return new LayoutFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new StructureClassUpdate(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new OpenBehaviorDiagram(this.fp), new ReconnectToModel(this.fp)};
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new ResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new CantRemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context.getNewObject() instanceof StructureClass && context.getTargetContainer() instanceof Diagram;
            }

            public PictogramElement add(IAddContext context) {
                StructureClass ac = (StructureClass)context.getNewObject();
                Diagram diag = (Diagram)context.getTargetContainer();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)diag, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "cls");
                int width = context.getWidth() <= 0 ? 800 : context.getWidth();
                int height = context.getHeight() <= 0 ? 500 : context.getHeight();
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width + 80, height + 80);
                Rectangle rect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
                rect.setForeground(this.manageColor(LINE_COLOR));
                rect.setBackground(this.manageColor(BACKGROUND));
                rect.setTransparency(Double.valueOf(0.5));
                rect.setLineVisible(Boolean.valueOf(false));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, 40, 40, width, height);
                rect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
                rect.setForeground(this.manageColor(LINE_COLOR));
                rect.setFilled(Boolean.valueOf(false));
                rect.setLineWidth(Integer.valueOf(4));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, 40, 40, width, height);
                this.link((PictogramElement)containerShape, ac);
                this.link((PictogramElement)this.getDiagram(), ac);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                return false;
            }
        }

        private class LayoutFeature
        extends AbstractLayoutFeature {
            private static final int MIN_HEIGHT = 100;
            private static final int MIN_WIDTH = 250;

            public LayoutFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canLayout(ILayoutContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (!(pe instanceof ContainerShape)) {
                    return false;
                }
                EList businessObjects = pe.getLink().getBusinessObjects();
                return businessObjects.size() == 1 && businessObjects.get(0) instanceof StructureClass;
            }

            public boolean layout(ILayoutContext context) {
                boolean anythingChanged = false;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
                if (containerGa.getHeight() < 100) {
                    containerGa.setHeight(100);
                    anythingChanged = true;
                }
                if (containerGa.getWidth() < 250) {
                    containerGa.setWidth(250);
                    anythingChanged = true;
                }
                int w = containerGa.getWidth();
                int h = containerGa.getHeight();
                if (containerGa.getGraphicsAlgorithmChildren().size() == 2) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    ga.setWidth(w - 80);
                    ga.setHeight(h - 80);
                    ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(1);
                    ga.setWidth(w - 80);
                    ga.setHeight(h - 80);
                    anythingChanged = true;
                }
                return anythingChanged;
            }
        }

        private class OpenBehaviorDiagram
        extends AbstractCustomFeature {
            public OpenBehaviorDiagram(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Open Class Behavior";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorClass;
            }

            public void execute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorClass) {
                    final ActorClass ac = (ActorClass)bo;
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RoomOpeningHelper.openBehavior((EObject)ac);
                        }
                    });
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private class ReconnectToModel
        extends AbstractCustomFeature {
            public ReconnectToModel(IFeatureProvider fp) {
                super(fp);
            }

            public void execute(ICustomContext context) {
                DiagramEditorBase editor = (DiagramEditorBase)this.getDiagramBehavior().getDiagramContainer();
                ChangeDiagramInputJob job = new ChangeDiagramInputJob("Change input for " + this.getDiagram().getName(), editor);
                job.setUser(true);
                job.schedule();
            }

            public boolean canExecute(ICustomContext context) {
                return true;
            }

            public String getName() {
                return "Reconnect Diagram to Model";
            }

            public boolean hasDoneChanges() {
                return false;
            }

            public boolean isAvailable(IContext context) {
                Object bo = FeatureProvider.this.fp.getBusinessObjectForPictogramElement((PictogramElement)this.getDiagram());
                return bo instanceof EObject && ((EObject)bo).eIsProxy();
            }
        }

        private class ResizeFeature
        extends DefaultResizeShapeFeature {
            public ResizeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canResizeShape(IResizeShapeContext context) {
                if (!super.canResizeShape(context)) {
                    return false;
                }
                int width = context.getWidth() - 40;
                int height = context.getHeight() - 40;
                int xmax = 0;
                int ymax = 0;
                ContainerShape containerShape = (ContainerShape)context.getShape();
                StructureClass sc = (StructureClass)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                for (Shape childShape : containerShape.getChildren()) {
                    if (this.isOnInterface(sc, this.getBusinessObjectForPictogramElement((PictogramElement)childShape))) continue;
                    GraphicsAlgorithm ga = childShape.getGraphicsAlgorithm();
                    int x = ga.getX() + ga.getWidth() - 30;
                    int y = ga.getY() + ga.getHeight() - 30;
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y <= ymax) continue;
                    ymax = y;
                }
                if (width > 0 && width < xmax) {
                    return false;
                }
                return height <= 0 || height >= ymax;
            }

            public void resizeShape(IResizeShapeContext context) {
                GraphicsAlgorithm containerGa;
                ContainerShape containerShape = (ContainerShape)context.getShape();
                StructureClass sc = (StructureClass)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (containerShape.getGraphicsAlgorithm() != null && (containerGa = containerShape.getGraphicsAlgorithm()).getGraphicsAlgorithmChildren().size() == 2) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    double sx = (double)(context.getWidth() - 80) / (double)ga.getWidth();
                    double sy = (double)(context.getHeight() - 80) / (double)ga.getHeight();
                    for (Shape childShape : containerShape.getChildren()) {
                        if (!this.isOnInterface(sc, this.getBusinessObjectForPictogramElement((PictogramElement)childShape))) continue;
                        ga = childShape.getGraphicsAlgorithm();
                        ga.setX((int)((double)ga.getX() * sx));
                        ga.setY((int)((double)ga.getY() * sy));
                    }
                }
                super.resizeShape(context);
            }

            private boolean isOnInterface(StructureClass sc, Object childBo) {
                boolean onInterface = false;
                if (childBo instanceof InterfaceItem) {
                    onInterface = true;
                    if (childBo instanceof Port && sc instanceof ActorClass && ((ActorClass)sc).getInternalPorts().contains(childBo)) {
                        onInterface = false;
                    }
                }
                return onInterface;
            }
        }
    }
}

