/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.etrice.ui.structure.support.context.ConnectionUpdateContext;
import org.eclipse.etrice.ui.structure.support.context.InitialAddConnectionContext;
import org.eclipse.etrice.ui.structure.support.context.PositionUpdateContext;
import org.eclipse.etrice.ui.structure.support.feature.ShapeUpdateFeature;
import org.eclipse.etrice.ui.structure.support.provider.ConnectionProvider;
import org.eclipse.etrice.ui.structure.support.provider.DefaultPositionProvider;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class StructureClassUpdate
extends ShapeUpdateFeature {
    public StructureClassUpdate(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected boolean canUpdate(EObject bo, PictogramElement pe) {
        return bo instanceof StructureClass && !(pe instanceof Diagram);
    }

    @Override
    protected boolean update(EObject bo, IUpdateContext context) {
        StructureClass sc = (StructureClass)bo;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        HashMap<EObject, Shape> newPes = new HashMap<EObject, Shape>();
        IPositionProvider positionProvider = null;
        if (context instanceof PositionUpdateContext) {
            positionProvider = ((PositionUpdateContext)context).getPositionProvider();
            GraphicsAlgorithm invRect = containerShape.getGraphicsAlgorithm();
            GraphicsAlgorithm innerRect = (GraphicsAlgorithm)containerShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            positionProvider = positionProvider.setNewParent((EObject)sc, DiagramUtil.getPosAndSize(invRect), DiagramUtil.getPosAndSize(innerRect));
        }
        ConnectionProvider connectionProvider = new ConnectionProvider(this.getFeatureProvider());
        Map<EObject, Shape> present = this.getChildrenShapesForBoClass(containerShape, RoomPackage.Literals.ACTOR_CONTAINER_REF);
        HashSet expected = Sets.newHashSet((Iterable)SupportUtil.getInstance().getRoomHelpers().getAllActorContainerRefs(sc));
        for (EObject obj : Sets.difference(present.keySet(), (Set)expected)) {
            this.removeGraphicalRepresentation((PictogramElement)present.get(obj));
        }
        Map<EObject, Shape> newShapes = this.addShapesInitial((Collection<? extends EObject>)Sets.difference((Set)expected, present.keySet()), containerShape);
        this.updateShapes(newShapes.values(), positionProvider);
        connectionProvider.insertAnchors(newShapes.values());
        newPes.putAll(newShapes);
        this.updateShapes(present.values(), positionProvider);
        connectionProvider.insertAnchors(present.values());
        present = this.getChildrenShapesForBoClass(containerShape, RoomPackage.Literals.INTERFACE_ITEM);
        expected = Sets.newHashSet((Iterable)SupportUtil.getInstance().getRoomHelpers().getInterfaceItems(sc, true));
        if (sc instanceof ActorClass) {
            ActorClass base = (ActorClass)sc;
            while (base != null) {
                expected.addAll(base.getInternalPorts());
                base = base.getActorBase();
            }
        }
        for (EObject obj : Sets.difference(present.keySet(), (Set)expected)) {
            this.removeGraphicalRepresentation((PictogramElement)present.get(obj));
        }
        newShapes = this.addShapesInitial((Collection<? extends EObject>)Sets.difference((Set)expected, present.keySet()), containerShape);
        connectionProvider.insertAnchors(newShapes.values());
        newPes.putAll(newShapes);
        this.updateShapes(present.values(), positionProvider);
        connectionProvider.insertAnchors(present.values());
        present = this.getAllConnectionsForBoClass(this.getDiagram(), RoomPackage.Literals.LAYER_CONNECTION);
        expected = Sets.newHashSet((Iterable)SupportUtil.getInstance().getRoomHelpers().getConnections(sc, true));
        for (EObject obj : Sets.difference(present.keySet(), (Set)expected)) {
            this.removeGraphicalRepresentation((PictogramElement)present.get(obj));
        }
        Map<EObject, Connection> newConns = this.addConnectionsInitial((Collection<? extends EObject>)Sets.difference((Set)expected, present.keySet()), connectionProvider);
        this.updateConnections(newConns.values(), null, positionProvider);
        this.updateConnections(present.values(), connectionProvider, positionProvider);
        present = this.getAllConnectionsForBoClass(this.getDiagram(), RoomPackage.Literals.BINDING);
        expected = Sets.newHashSet((Iterable)SupportUtil.getInstance().getRoomHelpers().getBindings(sc, true));
        for (EObject obj : Sets.difference(present.keySet(), (Set)expected)) {
            this.removeGraphicalRepresentation((PictogramElement)present.get(obj));
        }
        newConns = this.addConnectionsInitial((Collection<? extends EObject>)Sets.difference((Set)expected, present.keySet()), connectionProvider);
        this.updateConnections(newConns.values(), null, positionProvider);
        this.updateConnections(present.values(), connectionProvider, positionProvider);
        HashMap<EObject, PictogramElement> withPosition = new HashMap<EObject, PictogramElement>();
        HashMap<EObject, PictogramElement> withoutPosition = new HashMap<EObject, PictogramElement>();
        if (positionProvider == null) {
            withoutPosition = newPes;
        } else {
            for (EObject obj : newPes.keySet()) {
                if (positionProvider.contains(obj)) {
                    withPosition.put(obj, (PictogramElement)newPes.get(obj));
                    continue;
                }
                withoutPosition.put(obj, (PictogramElement)newPes.get(obj));
            }
        }
        this.updatePictogramElements(withPosition.values(), positionProvider);
        if (!withoutPosition.isEmpty()) {
            DefaultPositionProvider autoPositionsProvider = new DefaultPositionProvider(sc, containerShape, withoutPosition.keySet());
            this.updatePictogramElements(withoutPosition.values(), autoPositionsProvider);
        }
        return true;
    }

    private void updateShapes(Collection<Shape> toUpdate, IPositionProvider pp) {
        if (pp != null) {
            this.updatePictogramElements(toUpdate, pp);
        } else {
            this.updatePictogramElements(toUpdate);
        }
    }

    private void updateConnections(Collection<Connection> toUpdate, ConnectionProvider cp, IPositionProvider pp) {
        if (cp != null) {
            for (PictogramElement pictogramElement : toUpdate) {
                ConnectionUpdateContext context = new ConnectionUpdateContext(pictogramElement, cp);
                this.getFeatureProvider().updateIfPossibleAndNeeded((IUpdateContext)context);
            }
        }
        if (pp != null) {
            this.updatePictogramElements(toUpdate, pp);
        }
        if (cp == null && pp == null) {
            this.updatePictogramElements(toUpdate);
        }
    }

    @Override
    protected IReason updateNeeded(EObject bo, IUpdateContext context) {
        HashSet presentRefs;
        HashSet expectedRefs;
        StructureClass sc = (StructureClass)bo;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        String reason = "";
        HashSet expectedItems = Sets.newHashSet((Iterable)SupportUtil.getInstance().getRoomHelpers().getInterfaceItems(sc, true));
        HashSet presentItems = Sets.newHashSet(SupportUtil.getInstance().getInterfaceItems(containerShape, this.getFeatureProvider()));
        if (sc instanceof ActorClass) {
            ActorClass base = (ActorClass)sc;
            while (base != null) {
                expectedItems.addAll(base.getInternalPorts());
                base = base.getActorBase();
            }
        }
        if (!expectedItems.equals(presentItems)) {
            reason = String.valueOf(reason) + "interface item(s) missing or outdated\n";
        }
        if (!(expectedRefs = Sets.newHashSet((Iterable)SupportUtil.getInstance().getRoomHelpers().getAllActorContainerRefs(sc))).equals(presentRefs = Sets.newHashSet(SupportUtil.getInstance().getRefs(containerShape, this.getFeatureProvider())))) {
            reason = String.valueOf(reason) + "actor ref(s) missing or outdated\n";
        }
        if (!reason.isEmpty()) {
            return Reason.createTrueReason();
        }
        return Reason.createFalseReason();
    }

    private Map<EObject, Connection> addConnectionsInitial(Collection<? extends EObject> toAdd, ConnectionProvider cp) {
        HashMap<EObject, Connection> created = new HashMap<EObject, Connection>();
        for (EObject eObject : toAdd) {
            PictogramElement pe = this.getFeatureProvider().addIfPossible((IAddContext)new InitialAddConnectionContext(eObject, cp));
            if (pe == null) continue;
            assert (pe instanceof Connection) : "unexpected type";
            created.put(eObject, (Connection)pe);
        }
        return created;
    }
}

