/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.base.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;

public class ImportHelpers {
    public static Optional<List<IEObjectDescription>> getImportedObjectsFor(Import imp, ImportUriResolver importUriResolver, Predicate<IEObjectDescription> quickFixCandidateMatcher) {
        QualifiedName importedFQN = ImportHelpers.toFQN(imp);
        if (importedFQN == null) {
            return Optional.empty();
        }
        String uriString = importUriResolver.resolve((EObject)imp);
        if (uriString == null) {
            return Optional.empty();
        }
        URI uri = URI.createURI((String)uriString);
        Resource importedResource = null;
        try {
            importedResource = imp.eResource().getResourceSet().getResource(uri, true);
        }
        catch (RuntimeException runtimeException) {
            return Optional.empty();
        }
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (importedResource == null || resourceServiceProvider == null) {
            return Optional.empty();
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        IResourceDescription description = manager.getResourceDescription(importedResource);
        ArrayList candidates = Lists.newArrayList();
        if (description != null) {
            for (IEObjectDescription eObjDesc : description.getExportedObjects()) {
                if (importedFQN.equals((Object)eObjDesc.getQualifiedName())) {
                    if (quickFixCandidateMatcher.apply((Object)eObjDesc)) {
                        return Optional.of(Lists.newArrayList((Object[])new IEObjectDescription[]{eObjDesc}));
                    }
                    candidates.add(eObjDesc);
                    continue;
                }
                if (!quickFixCandidateMatcher.apply((Object)eObjDesc)) continue;
                candidates.add(eObjDesc);
            }
        }
        return Optional.of(candidates);
    }

    public static QualifiedName toFQN(Import imp) {
        IQualifiedNameConverter.DefaultImpl nameConverter = new IQualifiedNameConverter.DefaultImpl();
        boolean isWildcard = false;
        try {
            QualifiedName orig = nameConverter.toQualifiedName(imp.getImportedNamespace());
            isWildcard = orig.getLastSegment().equals("*");
            return isWildcard ? orig.skipLast(1) : orig;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

